/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smlrtype.h,v 1.2.16.1 2004/07/09 01:58:02 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef SMLRTYPE_H
#define SMLRTYPE_H

// Forward declarations
typedef _INTERFACE IHXSite           IHXSite;
typedef _INTERFACE IHXSiteManager    IHXSiteManager;
typedef _INTERFACE IHXRenderer       IHXRenderer;
typedef _INTERFACE IHXSiteTransition IHXSiteTransition;
typedef _INTERFACE IHXValues         IHXValues;
class CHXMapLongToObj;
class CHXString;
class CHXSimpleList;
class CSmilEventHook;
class CSmilTransition;

//
// struct that associates group,track,and playto property of a stream
//
struct SMILPlayToAssoc
{
    UINT16          m_uGroupIndex;
    UINT16          m_uTrackIndex;
    CHXMapLongToObj m_sourceMap;
    CHXString       m_playTo;
    CHXString       m_id;
    CHXString       m_repeatid;
    CHXString       m_tunerName;
    CHXString       m_childTunerName;
    CHXString       m_regionName;
    CHXString       m_beginTransition;
    CHXString       m_endTransition;
    UINT32          m_ulDelay;
    UINT32          m_ulDuration;
    CHXSimpleList*  m_pHyperlinks;
    CSmilEventHook* m_pRendererEventHook;
    CHXSimpleList*  m_pSiteInfoList;
    INT32           m_ulLexicalOrder;
    CHXString       m_URL;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD     m_bIsPersistentSource : 1;
    HX_BITFIELD     m_bDurationResolved : 1;
    HX_BITFIELD     m_bRemoveSite : 1;
    HX_BITFIELD     m_bRemovePending : 1;
    HX_BITFIELD     m_bLiveSource : 1;
    HX_BITFIELD     m_bXMMSource : 1;
    HX_BITFIELD     m_bTrackStopped : 1;
};

//
// site information - used
// to handle site show/hide
// behavior in seek and hyperlinking
//
struct SMILSiteInfo
{
    IHXSite*     m_pRendererSite;
    IHXSite*     m_pRegionSite;
    HXxSize       m_rendererSize;
    UINT16        m_uGroupIndex;
    UINT32        m_ulDelay;
    UINT32        m_ulDuration;
    UINT32        m_ulResumeTime;
    CHXString     m_regionID;
    IHXRenderer* m_pRenderer;
    UINT32        m_ulLexicalOrder;
    CHXString     m_MediaID;
    INT32         m_lZIndex;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD   m_bRemoveSite : 1;
    HX_BITFIELD   m_bNoRegion : 1;
};

// source information - contained
// in SMILPlayToAssoc.m_sourceMap
struct SMILSourceInfo
{
    IUnknown*       m_pStream;
    IHXRenderer*   m_pRenderer;
    CHXString       m_tunerName;
    CHXString       m_childTunerName;
    CSmilEventHook* m_pRendererEventHook;
    UINT32          m_ulDuration;
    UINT32          m_ulDelay;
};

struct SMILTransitionState
{
    UINT32              m_ulEndPercent;
    UINT32              m_ulStartPercent;
    UINT32              m_ulEndTime;
    UINT32              m_ulDuration;
    UINT16              m_uGroupIndex;
    BOOL                m_bBegin;
    IHXSiteTransition* m_pSiteTransition;
    CHXString           m_id;
};

//
// Renderer That Closed
//
struct SMILDelayedRendererClose
{
    UINT16        m_uGroup;
    IHXRenderer* m_pRenderer;
    IHXValues*   m_pInfo;
    SMILSiteInfo* m_pSiteInfo;
};

//
// group information
//
struct SMILGroupInfo
{
    int    m_nTracks;
    int    m_nTracksAdded;
    int    m_nTrackDurationsSet;
    UINT32 m_ulDuration;
    BOOL   m_bDurationSet;
};

//
// event source info (endsync in SMIL)
//
struct SMILDeferredSourceInfo
{
    UINT32 m_ulDuration;
    UINT32 m_ulDelay;
};

#if defined(BE_SITE_SUPPLIER_20010205)

class SMILChildSiteInfo
{
public:
    SMILChildSiteInfo(IHXSite*        pChildSite,
                      IHXSite*        pParentSite,
                      IHXSiteManager* pSiteMgr);
    ~SMILChildSiteInfo();

    IHXSite*        m_pChildSite;
    IHXSite*        m_pParentSite;
    IHXSiteManager* m_pSiteMgr;
private:
    SMILChildSiteInfo() {}; // /Don't allow default constructor.
};

#endif // defined(BE_SITE_SUPPLIER_20010205)

class CExternalMediaMarkerInfo
{
public:
    CExternalMediaMarkerInfo();
    virtual ~CExternalMediaMarkerInfo();

    char*          m_pszAddTrackURL;
    char*          m_pszRendererURL;
    CHXSimpleList* m_pIDList;
    UINT16         m_usGroupIndex;
    UINT16         m_usTrackIndex;
};

// /The CSmilDocumentRenderer's m_pPlayerResumeStack contains these:
class CSmilPlayerResumePos
{
public:
    CSmilPlayerResumePos(INT16 iGrp, UINT32 ulTime,
                         SMILLinkPlaystate linkPlaystate);
    ~CSmilPlayerResumePos() {};

    INT16             m_iCurrentGroupIndex;
    UINT32            m_ulCurrentTime;
    SMILLinkPlaystate m_kLinkPlaystate;
private:
    CSmilPlayerResumePos() {}; // /Don't allow default constructor..
};

#if defined(HELIX_FEATURE_SMIL2_TRANSITIONS)

class CSmilTransitionInfo
{
public:
    CSmilTransitionInfo(CSmilTransition* pTrans, IUnknown* pUnk);
    virtual ~CSmilTransitionInfo();

    CSmilTransition* m_pTrans;
    IUnknown*        m_pContext;
};

#endif /* #if defined(HELIX_FEATURE_SMIL2_TRANSITIONS) */

#endif
