/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pkt_list.h,v 1.1.2.1 2004/07/09 01:50:15 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  PKT_LIST.H
//
//  SavedPacketData and SavedPacketDataList class declarations.
//
//  SavedPacketData class:
//    - A class SavedPacketData object holds the IHXBuffer of a packet
//	along with the start and end times of the data in the buffer so
//	that the packet can be resent during a dry period in the stream
//	if it is still active, time-wise.  Its ID lets the renderer figure
//	out if it has seen the packet yet or not.
//
//  SavedPacketData class:
//    - A class SavedPacketDataList object holds all the SavedPacketData
//	objects created so far whose end times have not been exceeded.
//	A position pointer into the list is maintained and, every time the
//	stream runs dry for at least NUM_MSEC_OF_DEADTIME_BETWEEN_RESENDS
//	milliseconds, i.e., if the starttime of the latest-created packet
//	is more than that many milliseconds in the future (or, if live, no
//	data has been seen for that many milliseconds), resend the next
//	packet in this list whose (starttime < currenttime < endtime).
//	If the end of the list is reached or if the next SavedPacketData in
//	the list has a (starttime > currenttime), reset the position pointer
//	to the start of the list.  For each SavedPacketData encountered
//	whose (endtime < currenttime), delete it from the list.
//
//

#if !defined(_PKT_LIST_H_)
#define _PKT_LIST_H_

//<XXXEH- get rid of this and make a user-definable parameter in the
// header that specifies MAX_BANDWIDTH and then figure out when it's
// OK to resend during dry spells in the stream based on size of
// saved packets and time of dry spell:/>
//Resend old data that is still visible, time-wise, when there is a
// dry spell in the stream of at least this many milliseconds:
#define NUM_MSEC_OF_DEADTIME_BETWEEN_RESENDS    3000

class SavedPacketData
{
  public:
    SavedPacketData(IHXBuffer* pIHXBuffer,
	    ULONG32 ulStartTimeOfData,
	    ULONG32 ulEndTimeOfData,
	    ULONG32 ulTimeOfLastSend
	    );
    ~SavedPacketData();

    IHXBuffer* m_pIHXBuffer;

    ULONG32 getID() { return m_ulID; }
    ULONG32 getStartTimeOfData() { return m_ulStartTimeOfData; }
    ULONG32 getEndTimeOfData() { return m_ulEndTimeOfData; }
    ULONG32 getTimeOfLastSend() { return m_ulTimeOfLastSend; }

    void setID(ULONG32 ulID) { m_ulID=ulID; }
    void setStartTimeOfData(ULONG32 ulSTime) { m_ulStartTimeOfData=ulSTime; }
    void setEndTimeOfData(ULONG32 ulETime) { m_ulEndTimeOfData=ulETime; }
    void setTimeOfLastSend(ULONG32 ulTimeLS) { m_ulTimeOfLastSend=ulTimeLS; }

    //This gets called in response to a <CLEAR> tag being
    // encountered at time ulNewEndTime; if(m_ulStartTime < ulNewEndTime),
    // this function resets m_endTime to min(m_ulEndTime, ulNewEndTime);
    // returns TRUE if change is made to m_ulEndTime, else FALSE:
    BOOL MarkForClear(ULONG32 ulNewEndTime);

  private:
    SavedPacketData(); //private so this won't ever get called.

    //This is the unique ID of this *data*, not the packet number.  This data
    // may be sent in more than one packet with this ID embedded at the start
    // of its data so the renderer can decide whether or not it has seen the
    // data already:
    ULONG32 m_ulID;
    ULONG32 m_ulStartTimeOfData; //in milliseconds.
    ULONG32 m_ulEndTimeOfData; //in milliseconds.
    ULONG32 m_ulTimeOfLastSend; //in milliseconds.
};


class SavedPacketDataList : public CHXSimpleList
{
  public:
    SavedPacketDataList();
    ~SavedPacketDataList();

    //This is a position pointer into this's list that points to the last
    // node in the list to be resent:
    LISTPOSITION m_LISTPOSITIONofLastPacketDataSent;


    ULONG32 getLatestInsertedPacketDataID()
	    { return m_ulLatestInsertedPacketDataID;}
    ULONG32 getTimeOfLastResend() { return m_ulTimeOfLastResend; }

    void setLatestInsertedPacketDataID(ULONG32 ulID)
	    { m_ulLatestInsertedPacketDataID=ulID; }
    void incrementLatestInsertedPacketDataID()
	    { m_ulLatestInsertedPacketDataID++;}

    void setTimeOfLastResend(ULONG32 ulTimeLS)
	    { m_ulTimeOfLastResend=ulTimeLS; }


    ULONG32 size() { return (GetCount()<0? 0L : (ULONG32)GetCount()); }
    ULONG32 nodeCount() { return (GetCount()<0? 0L : (ULONG32)GetCount()); }

    LISTPOSITION GetStartPosition();
    LISTPOSITION GetEndPosition();
    
    SavedPacketData* start(); //returns NULL if list is empty.
    SavedPacketData* end(); //returns NULL if list is empty.

    BOOL insertAtEndOfList(SavedPacketData* pSPD);

    ULONG32 flush(); //Returns number of nodes deleted.

/*XXXEH- can't implement this function because you need to do ::PacketReady()
	 for each packet re-formed, and PacketReady() can be a member of
	 different objects depending on whether we're in the file format
	 or the live encoder:
    //This fills dry time in the stream with previously-sent packet(s)
    // starting with a time stamp of ulDrySpellStartTime, separated by
    // NUM_MSEC_OF_DEADTIME_BETWEEN_RESENDS, and ending with a time stamp
    // of (ulDrySpellEndTime-NUM_MSEC_OF_DEADTIME_BETWEEN_RESENDS) or less:
    BOOL resendPacketsDuringDryTime(ULONG32 ulDrySpellStartTime,
	    ULONG32 ulDrySpellEndTime);
*/	    
    //Returns the next-to-be-res ent SavedPacketData.  This function calls
    // deleteAllExpiredSPDs() and then bumps the 
    // m_LISTPOSITIONofLastPacketDataSent and returns the SavedPacketData
    // found there:
    SavedPacketData* getNextPacketDataToBeResent(ULONG32 ulCurrentTime);

    //If <CLEAR> tag is sent, effective at time t, then this function is
    // called to change all in this list whose m_endTime is > t;
    // Returns the num of nodes in the list whose endTimes were reduced to t:
    ULONG32 MarkAllForClear(ULONG32 ulTimeOfClear);

    //This function allows the file format or encoder to delete all in this
    // list whose end times are earlier than the current time;
    // Returns the number of nodes in the list that were deleted:
    ULONG32 deleteAllExpiredSPDs(ULONG32 ulCurrentTime);

  private:
    //This is the unique ID of the most-recently-inserted SavedPacketData
    // object, and has nothing to do with the concept of packet numbers.
    // Each node in this's list may be sent in more than one packet with this
    // ID embedded at the start of its data so the renderer can decide
    // whether or not it has seen the data already:
    ULONG32 m_ulLatestInsertedPacketDataID;
    //This is the last time a node from this's list was resent as a packet:
    ULONG32 m_ulTimeOfLastResend; //in milliseconds.
};

#endif //end of "#if !defined(_PKT_LIST_H_)".

