/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxstatisticsobserver.cpp,v 1.2.6.4.2.1 2004/08/26 19:45:19 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxstatisticsobserver.h"
#include "hxmarshal.h"

#include <string.h>

#include "HXClientCFuncs.h"
#include "HXClientConstants.h"


enum {
    STATISTIC_ADDED_SIGNAL,
    STATISTIC_MODIFIED_SIGNAL,
    STATISTIC_DELETED_SIGNAL,
    LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0 };

static void hx_statistics_observer_class_init (HXStatisticsObserverClass* klass);
static void hx_statistics_observer_init       (HXStatisticsObserver*      object,
                                               HXStatisticsObserverClass* klass);
static void hx_statistics_observer_finalize   (GObject*                   object);

static void
make_gvalue(GValue*              value,
            int                  valueType,
            const unsigned char* szBuf)
{
    gsize in;
    gsize out;
    gchar *utf8_val;
    const gchar* buf = (const gchar*)szBuf;    
    
    switch(valueType)
    {
        case kValueType32BitSignedInt:
            g_value_init(value, G_TYPE_INT);
            g_value_set_int(value, *(int*)buf);
            break;
            
        case kValueTypeString:
            if(g_utf8_validate(buf, -1, NULL))
            {
                utf8_val = g_strdup(buf);
            }
            else
            {
                in = strlen(buf) + 1;
                out = 0;
                utf8_val = g_convert(buf, in - 1, "UTF-8", "ISO-8859-1", &in, &out, NULL);
                g_assert(utf8_val);
            }
            
            g_value_init(value, G_TYPE_STRING);
            g_value_set_string_take_ownership(value, utf8_val);
            break;
            
        default:
            g_assert_not_reached();
            break;
    }
}

void
OnAddedStatistic(const char*          pStatisticName,
                 int                  valueType,
                 const unsigned char* pValue,
                 void*                observerInfo)
{
    GValue value;
    
    memset(&value, 0, sizeof(value));
    make_gvalue(&value, valueType, pValue);

    g_signal_emit(G_OBJECT(observerInfo), signals[STATISTIC_ADDED_SIGNAL], 0,
                  pStatisticName, (gpointer)&value);

    g_value_unset(&value);
}

void
OnModifiedStatistic(const char*          pStatisticName,
                    int                  valueType,
                    const unsigned char* pValue,
                    void*                observerInfo)
{
    GValue value;

    memset(&value, 0, sizeof(value));
    make_gvalue(&value, valueType, pValue);

    g_signal_emit(G_OBJECT(observerInfo), signals[STATISTIC_MODIFIED_SIGNAL], 0,
                  pStatisticName, (gpointer)&value);

    g_value_unset(&value);
}

void
OnDeletedStatistic(const char* pStatisticName,
                   void*       observerInfo)
{
    g_signal_emit(G_OBJECT(observerInfo), signals[STATISTIC_DELETED_SIGNAL], 0,
                  pStatisticName);
}

static const HXStatisticsCallbacks hx_statistics_callbacks =
{
    OnAddedStatistic,
    OnModifiedStatistic,
    OnDeletedStatistic
};

    
GType
hx_statistics_observer_get_type(void)
{
    static GType hxstatistics_observer_type = 0;

    if (!hxstatistics_observer_type)
    {
	static const GTypeInfo hxstatistics_observer_info =
	{
	    sizeof (HXStatisticsObserverClass),
            NULL,           /* base_init */
            NULL,           /* base_finalize */
	    (GClassInitFunc) hx_statistics_observer_class_init,
	    NULL,           /* class_finalize */
	    NULL,           /* class_data */
	    sizeof (HXStatisticsObserver),
	    0,             /* n_preallocs */
	    (GInstanceInitFunc) hx_statistics_observer_init,
	    NULL,           /* value_table */
	};

	hxstatistics_observer_type = g_type_register_static (G_TYPE_OBJECT, "HXStatisticsObserver",
						&hxstatistics_observer_info, (GTypeFlags)0);
    }
  
    return hxstatistics_observer_type;
}


static void
hx_statistics_observer_class_init(HXStatisticsObserverClass *klass)
{
    GObjectClass* gobject_class = G_OBJECT_CLASS(klass);

    gobject_class->finalize = hx_statistics_observer_finalize;

    signals[STATISTIC_ADDED_SIGNAL] =
	g_signal_new("statistic_added",
                     G_OBJECT_CLASS_TYPE(gobject_class),
                     (GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
                     G_STRUCT_OFFSET(HXStatisticsObserverClass, statistic_added),
                     NULL, NULL,
                     g_cclosure_user_marshal_VOID__STRING_POINTER,
                     G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_POINTER);

    signals[STATISTIC_MODIFIED_SIGNAL] =
	g_signal_new("statistic_modified",
                     G_OBJECT_CLASS_TYPE(gobject_class),
                     (GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
                     G_STRUCT_OFFSET(HXStatisticsObserverClass, statistic_added),
                     NULL, NULL,
                     g_cclosure_user_marshal_VOID__STRING_POINTER,
                     G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_POINTER);

    signals[STATISTIC_DELETED_SIGNAL] =
	g_signal_new("statistic_deleted",
                     G_OBJECT_CLASS_TYPE(gobject_class),
                     (GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
                     G_STRUCT_OFFSET(HXStatisticsObserverClass, statistic_added),
                     NULL, NULL,
                     g_cclosure_marshal_VOID__STRING,
                     G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
hx_statistics_observer_init(HXStatisticsObserver*      statistics_observer,
                            HXStatisticsObserverClass* /* klass */)
{
    statistics_observer->player = NULL;
    statistics_observer->name = NULL;
}

HXStatisticsObserver*
hx_statistics_observer_new(HXPlayer*    player,
                           const gchar* name)
{
    HXStatisticsObserver* statistics_observer;
    
    statistics_observer = (HXStatisticsObserver*)g_object_new(HX_TYPE_STATISTICS_OBSERVER, NULL);

    statistics_observer->player = player;
    statistics_observer->name = g_strdup(name);
    
    /* Add clip info callbacks for the usual suspects */
    if(!ClientPlayerAddStatisticObserver(statistics_observer->player->player,
                                         statistics_observer->name,
                                         &hx_statistics_callbacks,
                                         statistics_observer ))
    {
        g_warning("Error adding statistics observer\n");
    }
    
    return statistics_observer;
}    

static void
hx_statistics_observer_finalize(GObject* object)
{
    HXStatisticsObserver* statistics_observer;

    statistics_observer = HX_STATISTICS_OBSERVER(object);    
    
    ClientPlayerRemoveStatisticObserver(statistics_observer->player->player,
                                        statistics_observer->name,
                                        &hx_statistics_callbacks,
                                        statistics_observer);
    
    g_free(statistics_observer->name);    
}

