/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: minisymbiansite.cpp,v 1.14.2.4 2004/07/09 01:59:11 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "minisite.h"
#include "minisymbiansite.h"
#include "minisymbiansurf.h"
#include <e32std.h> 
#include <eikenv.h> 
#include <eikdef.h> 
#include <gdi.h> 
#include <fbs.h> 
#include "hxprefs.h"
#include "hxprefutil.h"

//Well, I hate to add this, but we really have to keep track of how
//many sites have been made so we can center and scale video only
//playback. Not the cleanest thing in the world.
const INT32 _zm_nSiteCount = 0;
#define zm_nSiteCount HXGlobalInt32::Get(&_zm_nSiteCount)

CHXSymbianSite::CHXSymbianSite( IUnknown* pContext,
                                IUnknown* pUnkOuter,
                                INT32     lZorder)
    :  CMiniBaseSite(pContext, pUnkOuter, lZorder),
       m_bAutoScale(TRUE)
{
    memset(&m_OrigSize, 0, sizeof(m_OrigSize));
    zm_nSiteCount++;
}

CHXSymbianSite::~CHXSymbianSite()
{
    zm_nSiteCount--;
}

void* CHXSymbianSite::_Create(void* pParentWindow, UINT32 style)
{
    //XXXGfw Don't use.
    HX_ASSERT("Not supported on Symbian"==NULL);
    
    return (void*)NULL;
}

void CHXSymbianSite::_Destroy(HXxWindow* pWindow)
{
}

void CHXSymbianSite::_ChildCreated()
{
    //If we have a child created, stop doing any of the
    //centering or scaling.
    if( m_pWindow && m_pWindow->window && m_bAutoScale )
    {
        SetSize(m_OrigSize);
    }
}

void CHXSymbianSite::_SetSize(HXxSize size)
{
}

void  CHXSymbianSite::_SetPosition(HXxPoint position)
{
}


void CHXSymbianSite::_AttachWindow()
{
}

BOOL CHXSymbianSite::_MoveWindow( void* window ,
                                   INT32 X, INT32 Y,
                                   INT32 nWidth, INT32 nHeight,
                                   BOOL bRepaint)
    
{
    return TRUE;
}

STDMETHODIMP CHXSymbianSite::SetSize(HXxSize size)
{
    //First, call the basesite's impl.
    HX_RESULT ret = CMiniBaseSite::SetSize(size);

    //Now do our scaling..

    //There is often a border around our display window and the edge
    //of the physical phone display. So, if you play back a 176x144
    //video on a 176x144 screen it won't quite fit. Instead of
    //shrinking this to 1/2, go ahead and just lose some pixels
    //around the edges and display it at 1:1.
    UINT32          nPixelWaste  = 2;

    IHXPreferences* pPreferences = NULL;
    if (HXR_OK == m_pContext->QueryInterface(IID_IHXPreferences, (void**)&pPreferences))
    {
        ReadPrefINT32(pPreferences, "PixelWaste", nPixelWaste );
        ReadPrefBOOL(pPreferences, "AutoScale", m_bAutoScale);
        HX_RELEASE(pPreferences);
    }

    
    //Only do the centering and scaling for the top level site.  If
    //CreateChild is ever called on this top level site, then we will
    //revert this site back to 0,0 and the size of the window. Until
    //then, we assume this is an single video playback only and center
    //scale it.
    if( m_pWindow && m_pWindow->window && 1==zm_nSiteCount )
    {
        //Get the size of the screen device.
        RDrawableWindow* pWin = (RDrawableWindow*)m_pWindow->window;
        TSize windowSize = pWin->Size();

        int nWidth  = windowSize.iWidth;
        int nHeight = windowSize.iHeight;
        int nRatio  = 1;
        if( m_bAutoScale )
        {
            m_OrigSize = m_size;
            
            //Now figure out what scale factor to play back at: .5, 1, 2.
            nRatio = min( (nWidth+nPixelWaste)/size.cx,
                          (nHeight+nPixelWaste)/size.cy
                          );
            if( 2 < nRatio )
                nRatio = 2;

            switch( nRatio )
            {
               case 0:
                   //Go to 1/2, its the best we can do.
                   //XXXGfw TODO: if its too big lets not even play this clip.
                   m_size.cx = size.cx/2;
                   m_size.cy = size.cy/2;
                   break;
               case 1:
                   //Just leave it alone.
                   break;
               case 2:
                   //Go to double size.
                   m_size.cx = size.cx*2;
                   m_size.cy = size.cy*2;
                   break;
               default:
                   break;
            }
        }
        
#ifndef HELIX_FEATURE_SMIL_SITE
        //There are no site-watchers in non-smil site cases. So,
        //the TLC has no chance to center the site. We will do
        //it here.
        HXxPoint point;
        point.x = (nWidth-m_size.cx)/2;
        point.y = (nHeight-m_size.cy)/2;
        SetPosition( point );
#else        
        //If we changed size, due to autoscaling, call the site
        //watchers and let them know. On symbian this lets the TLC
        //do auto centering.
        if( 1 != nRatio )
        {
            CHXSimpleList::Iterator i;
            for(i=m_PassiveSiteWatchers.Begin(); i!= m_PassiveSiteWatchers.End(); ++i)
            {
                ((IHXPassiveSiteWatcher*) *i)->SizeChanged(&m_size);
            }
        }
#endif 
    }
    return ret;
}
