/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: sm1rendr.h,v 1.3.2.1 2004/07/09 01:57:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SM1RENDR_H_
#define _SM1RENDR_H_

#include "hxwintyp.h"
#include "hxwin.h"
#include "baseobj.h"

#define STREAM_MAJOR_VERSION  0
#define STREAM_MINOR_VERSION  0

#define CONTENT_MAJOR_VERSION 0
#define CONTENT_MINOR_VERSION 0

class CSmilPacketParser;
class CSmil1SiteSupplier;
class CHXSimpleList;
class CSmil1DocumentRenderer;
class CSmilDocumentPacket;

/////////////////////////////////////////////////////////////////////////////
// 
//  Class:
//
//	CSmil1Renderer
//
//  Purpose:
//
//	SMIL implementation of a basic renderer.
//

class CSmil1Renderer :   public IHXPlugin
			, public IHXRenderer
			, public IHXStatistics
			, public IHXPersistentRenderer
                        , public CHXBaseCountingObject
{
private:

    LONG32		    m_lRefCount;
    IUnknown*		    m_pContext;
    IHXStream*		    m_pStream;
    IHXPlayer*		    m_pPlayer;
    IHXClientEngine*	    m_pEngine;
    IUnknown*		    m_pClientContext;
    ULONG32		    m_ulLastTime;
    UINT32		    m_ulGranularity;
    UINT16		    m_uLayoutRule;
    UINT16		    m_uSourceRule;
    CHXString		    m_urlPrefix;
    CHXString		    m_urlRoot;
    char*		    m_pURLFragment;
    CSmilPacketParser*	    m_pPacketParser;
    CSmil1DocumentRenderer*  m_pSmilDocRenderer;
    CHXString		    m_smilDocument;
    UINT32		    m_ulTotalSMILPackets;
    IHXCommonClassFactory* m_pCommonClassFactory;
    HX_RESULT		    m_lastOnPacketResult;

#if defined(HELIX_FEATURE_SMIL2)
    // /All of the following are needed for handling SMIL 2+ streams:
    CSmilRenderer*	    m_pNextGenSmilRenderer;
    BOOL		    m_bIsHigherVersionSmilStreamFromOldSMIL1FF;
    IHXValues*		    m_pHeader;
    IHXBuffer*		    m_pDefaultNamespace;
    BOOL		    m_bCSmil1StartStreamHasBeenCalled;
    BOOL		    m_bCSmil1EndStreamHasBeenCalled;
    BOOL		    m_bCSmil1GetDisplayTypeHasBeenCalled;
    BOOL		    m_bCSmil1InitializeStatisticsHasBeenCalled;
    BOOL		    m_bCSmil1InitPersistenHasBeenCalled;
    BOOL		    m_bCSmil1GetElementPropertiesHasBeenCalled;
    BOOL		    m_bCSmil1RemoveLayoutSiteGroupHasBeenCalled;
    UINT32		    m_ulRegistryID;
    UINT16		    m_uGroupID;
    UINT16		    m_uTrackID;
#endif /* defined(HELIX_FEATURE_SMIL2). */
    UINT32		    m_ulPersistentComponentID;
    UINT16		    m_uPersistentGroupID;
    UINT16		    m_uPersistentTrackID;
    IHXPersistentRenderer* m_pPersistentParent;
    // /End "...handling SMIL 2+ streams".

			     
    BOOL		    m_bUseNestedMeta;    
    UINT32		    m_ulPersistentVersion;
    PersistentType	    m_persistentType;
    IHXPersistentComponentManager* m_pPersistentComponentManager;

    static const char* const	zm_pName;
    static const char* const	zm_pDescription;
    static const char* const	zm_pCopyright;
    static const char* const	zm_pMoreInfoURL;
    static const char* const	zm_pStreamMimeTypes[];

    ~CSmil1Renderer		    ();
    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

    HX_RESULT handleSMILDocumentPacket	
				    (CSmilDocumentPacket* pPacket);
    HX_RESULT getErrorString	    (SMILErrorTag tag,
				    CHXString& str);

    HX_RESULT findValidDefaultNamespace(IHXBuffer* pStartOfFile);
    HX_RESULT findSmilTagAndVersion	(IHXBuffer* pFileChunk);
    HX_RESULT setUpNextGenSmilRenderer	();

    friend class CSmil1DocumentRenderer;

#ifdef _WINDOWS
    HDC m_hDC;
#endif

public:
    CSmil1Renderer			();

    // CSmil1Renderer methods
    static HX_RESULT STDAPICALLTYPE CanUnload2(void);
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);


    IHXCommonClassFactory* getFactory	()
					{ return m_pCommonClassFactory; }
    IHXClientEngine* getClientEngine	() 
					{ return m_pEngine; }
    IUnknown* getClientContext		() 	
					{ return m_pClientContext; }
    IHXPlayer* getPlayer		()
					{ return m_pPlayer; }
    CHXString& getURLPrefix		()
					{ return m_urlPrefix; }
    CHXString& getURLRoot		()
					{ return m_urlRoot; } 
    UINT32 getGranularity		()
					{ return m_ulGranularity; }

    HX_RESULT	HandleAddLayoutSiteGroup	(IUnknown* pLSG);
    HX_RESULT	HandleRemoveLayoutSiteGroup	(IUnknown* pLSG);
    HX_RESULT	HandleAttachElementLayout(IUnknown* pLSG, IHXValues* pProps);
    void	generatePreFix		(void);

#if defined(HELIX_FEATURE_SMIL2)
    BOOL	isHigherVersionSmilStreamFromOldSMIL1FF() {
			return m_bIsHigherVersionSmilStreamFromOldSMIL1FF;}
#endif /* defined(HELIX_FEATURE_SMIL2). */

    // *** IHXPlugin methods ***

    /************************************************************************
     *	Method:
     *	    IHXPlugin::GetPluginInfo
     *	Purpose:
     *	    Returns the basic information about this plugin. Including:
     *
     *	    bLoadMultiple	whether or not this plugin DLL can be loaded
     *				multiple times. All File Formats must set
     *				this value to TRUE.
     *	    pDescription	which is used in about UIs (can be NULL)
     *	    pCopyright		which is used in about UIs (can be NULL)
     *	    pMoreInfoURL	which is used in about UIs (can be NULL)
     */
    STDMETHOD(GetPluginInfo)	(THIS_
				REF(BOOL)	 /*OUT*/ bLoadMultiple,
				REF(const char*) /*OUT*/ pDescription,
				REF(const char*) /*OUT*/ pCopyright,
				REF(const char*) /*OUT*/ pMoreInfoURL,
				REF(ULONG32)	 /*OUT*/ ulVersionNumber
				);

    /************************************************************************
     *	Method:
     *	    IHXPlugin::InitPlugin
     *	Purpose:
     *	    Initializes the plugin for use. This interface must always be
     *	    called before any other method is called. This is primarily needed 
     *	    so that the plugin can have access to the context for creation of
     *	    IHXBuffers and IMalloc.
     */
    STDMETHOD(InitPlugin)   (THIS_
			    IUnknown*   /*IN*/  pContext);

    // *** IUnknown methods ***
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    // *** IHXRenderer methods ***

    /************************************************************************
     *	Method:
     *	    IHXRenderer::GetRendererInfo
     *	Purpose:
     *	    Returns information vital to the instantiation of rendering 
     *	    plugins.
     */
    STDMETHOD(GetRendererInfo)	(THIS_
				REF(const char**) /*OUT*/ pStreamMimeTypes,
				REF(UINT32)      /*OUT*/ unInitialGranularity
				);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::StartStream
    //	Purpose:
    //	    Called by client engine to inform the renderer of the stream it
    //	    will be rendering. The stream interface can provide access to
    //	    its source or player. This method also provides access to the 
    //	    primary client controller interface.
    //
    STDMETHOD (StartStream)	(THIS_
				IHXStream*	    pStream,
				IHXPlayer*	    pPlayer);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::EndStream
    //	Purpose:
    //	    Called by client engine to inform the renderer that the stream
    //	    is was rendering is closed.
    //
    STDMETHOD (EndStream)	(THIS);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::OnHeader
    //	Purpose:
    //		Called by client engine when a header for this renderer is 
    //		available. The header will arrive before any packets.
    //
    STDMETHOD (OnHeader)	(THIS_
				IHXValues*	    pHeader);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnPacket
    //	Purpose:
    //	    Called by client engine when a packet for this renderer is 
    //	    due.
    //
    STDMETHOD (OnPacket)	(THIS_
				IHXPacket*	    pPacket,
				LONG32 		    lTimeOffset);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnTimeSync
    //	Purpose:
    //	    Called by client engine to inform the renderer of the current
    //	    time relative to the streams synchronized time-line. The 
    //	    renderer should use this time value to update its display or
    //	    render it's stream data accordingly.
    //
    STDMETHOD (OnTimeSync)	(THIS_
				ULONG32		    ulTime);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //	    IHXRenderer::OnPreSeek
    //  Purpose:
    //	    Called by client engine to inform the renderer that a seek is
    //	    about to occur. The render is informed the last time for the 
    //	    stream's time line before the seek, as well as the first new
    //	    time for the stream's time line after the seek will be completed.
    //
    STDMETHOD (OnPreSeek)	(THIS_
				ULONG32		    ulOldTime,
				ULONG32		    ulNewTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnPostSeek
    //	Purpose:
    //	    Called by client engine to inform the renderer that a seek has
    //	    just occured. The render is informed the last time for the 
    //	    stream's time line before the seek, as well as the first new
    //	    time for the stream's time line after the seek.
    //
    STDMETHOD (OnPostSeek)	(THIS_
				ULONG32		    ulOldTime,
				ULONG32		    ulNewTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnPause
    //	Purpose:
    //	    Called by client engine to inform the renderer that a pause has
    //	    just occured. The render is informed the last time for the 
    //	    stream's time line before the pause.
    //
    STDMETHOD (OnPause)		(THIS_
				ULONG32		    ulTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::OnBegin
    //	Purpose:
    //		Called by client engine to inform the renderer that a begin or
    //		resume has just occured. The render is informed the first time 
    //		for the stream's time line after the resume.
    //
    STDMETHOD (OnBegin)		(THIS_
				ULONG32		    ulTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::OnBuffering
    //	Purpose:
    //		Called by client engine to inform the renderer that buffering
    //		of data is occuring. The render is informed of the reason for
    //		the buffering (start-up of stream, seek has occured, network
    //		congestion, etc.), as well as percentage complete of the 
    //		buffering process.
    //
    STDMETHOD (OnBuffering)	(THIS_
				ULONG32		    ulFlags,
				UINT16		    unPercentComplete);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::GetDisplayType
    //	Purpose:
    //		Called by client engine to ask the renderer for it's preferred
    //		display type. When layout information is not present, the 
    //		renderer will be asked for it's prefered display type. Depending
    //		on the display type a buffer of additional information may be 
    //		needed. This buffer could contain information about preferred
    //		window size.
    //
    STDMETHOD (GetDisplayType)	(THIS_
				REF(HX_DISPLAY_TYPE)	ulFlags,
				REF(IHXBuffer*)	pBuffer);

    /************************************************************************
     *	Method:
     *	    IHXRenderer::OnEndofPackets
     *	Purpose:
     *	    Called by client engine to inform the renderer that all the
     *	    packets have been delivered. However, if the user seeks before
     *	    EndStream() is called, renderer may start getting packets again
     *	    and the client engine will eventually call this function again.
     */
    STDMETHOD(OnEndofPackets)	(THIS);

    /************************************************************************
     *  Method:
     *      IHXStatistics::InitializeStatistics
     *  Purpose:
     *      Pass registry ID to the caller
     */
    STDMETHOD (InitializeStatistics)
				(THIS_
				UINT32		    /*IN*/ ulRegistryID);

    /************************************************************************
     *  Method:
     *      IHXStatistics::UpdateStatistics
     *  Purpose:
     *      Notify the client to update its statistics stored in the registry
     */
    STDMETHOD (UpdateStatistics)(THIS);

    // IHXPersistentRenderer methods
    STDMETHOD(InitPersistent)		(THIS_
					UINT32			ulPersistentComponentID,
					UINT16			uPersistentGroupID,
					UINT16			uPersistentTrackID,
					IHXPersistentRenderer*	pPersistentParent);

    STDMETHOD(GetPersistentID)		(THIS_
					REF(UINT32) ulPersistentComponentID);

    STDMETHOD(GetPersistentProperties)	(THIS_
                               		REF(IHXValues*)    pProperties);				

    STDMETHOD(GetElementProperties)	(THIS_
					UINT16		    uGroupID,
					UINT16		    uTrackID,
                               		REF(IHXValues*)    pProperties);

    STDMETHOD(AttachElementLayout)	(THIS_
					UINT16		    uGroupID,
					UINT16		    uTrackID,
					IHXRenderer*	    pRenderer,
					IHXStream*	    pStream,
					IHXValues*	    pProps);

    STDMETHOD(DetachElementLayout)	(THIS_
					IUnknown*	    pLSG);

    STDMETHOD(GetElementStatus)		(THIS_
					UINT16		    uGroupID,
					UINT16		    uTrackID,
					UINT32		    ulCurrentTime,
					REF(IHXValues*)    pStatus);
};


#endif // _SM1RENDR_H_

