/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OGG VORBIS PROJECT SOURCE CODE.         *
 *                                                                  *
 * THE OGG VORBIS PROJECT SOURCE CODE IS (C) COPYRIGHT 1994-2001    *
 * by the XIPHOPHORUS Company http://www.xiph.org/                  *

 ********************************************************************

 function: headers for the render plugin for RealSystem

 ********************************************************************/
/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rvorbis.h,v 1.6.2.4 2004/11/24 18:07:05 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer and/or licensor of the Original Code and owns the
 * copyrights in the portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */


#ifndef __RVORBIS_H__
#define __RVORBIS_H__

#include "vorbis_depack.h" // VorbisDepacketizer
#include "aud_strm_hlpr.h"
#include "hxslist.h"
#include "hxstring.h"

#define PLUGIN_VERSION_NUM 0
#define DESCRIPTION "Vorbis Renderer Plugin"
#define COPYRIGHT "(c) 2001 Xiphophorus, All Rights Reserved"
#define MORE_INFO_URL "http://www.xiph.org"
#define STREAM_MIME_TYPES { "application/x-ogg", "application/ogg", NULL }
#define TIME_SYNC_FREQ 100

#define DEFAULT_VORBIS_CHANNELS 2
#define DEFAULT_VORBIS_SAMPLE_RATE 44100

typedef enum
{
    VorbisInitialHeader,
    VorbisCommentHeader,
    VorbisCodebookHeader,
    VorbisWriteInitialPushdown,
    VorbisPlay
} VorbisState;

typedef VorbisDepacketizer* (*VorbisDepackCreateFunc)();

typedef struct {
    const char* m_pMimeType;
    VorbisDepackCreateFunc m_fpCreateFunc;
} VorbisDepackInfo;

typedef struct {
    char* m_pVorbisTag;
    const char* m_pPropName;
} VorbisTagMapping;

class CVorbisRenderer: public IHXRenderer,
                       public IHXPlugin,
                       public IHXDryNotification
{
public:
    CVorbisRenderer(void);

    STDMETHOD(StartStream) (THIS_ IHXStream *pStream, IHXPlayer *pPlayer);
    STDMETHOD(EndStream) (THIS);
    STDMETHOD(OnHeader) (THIS_ IHXValues *pStreamHeaderObj);
    STDMETHOD(OnPacket) (THIS_ IHXPacket *pPacketObj, INT32 timeOffset);
    STDMETHOD(OnTimeSync) (THIS_ UINT32 currentPlayBackTime);
    STDMETHOD(OnPreSeek) (THIS_ UINT32 timeBefore, UINT32 timeAfter);
    STDMETHOD(OnPostSeek) (THIS_ UINT32 timeBefore, UINT32 timeAfter);
    STDMETHOD(OnPause) (THIS_ UINT32 timeBeforePause);
    STDMETHOD(OnBegin) (THIS_ UINT32 timeAfterBegin);
    STDMETHOD(OnBuffering) (THIS_ UINT32 reason, UINT16 percentComplete);
    STDMETHOD(GetRendererInfo)
        (THIS_
         REF(const char **) pStreamMimeTypes,
         REF(UINT32) initialGranularity
            );
    STDMETHOD(GetDisplayType)
        (THIS_
         REF(HX_DISPLAY_TYPE) displayType,
         REF(IHXBuffer *) pDisplayInfo
            );
    STDMETHOD(OnEndofPackets) (THIS);

    STDMETHOD(GetPluginInfo)
        (THIS_
         REF(BOOL) bLoadMultiple,
         REF(const char *) pDescription,
         REF(const char *) pCopyright,
         REF(const char *) pMoreInfoURL,
         REF(UINT32) versionNumber
            );
    STDMETHOD(InitPlugin) (THIS_ IUnknown *pRMACore);

    // IHXDryNotification Interface
    STDMETHOD(OnDryNotification)
        (THIS_
         UINT32 ulCurrentStreamTime,
         UINT32 ulMinimumDurationRequired
            );

    STDMETHOD(QueryInterface) (THIS_ REFIID interfaceID, void **ppInterfaceObj);
    STDMETHOD_(UINT32, AddRef) (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

private:

    UINT32 CurrentTime() const;
    UINT32 BytesToMs(UINT32 ulNumBytes);
    UINT32 MsToBytes(UINT32 ulMs);

    ~CVorbisRenderer(void);

    HX_RESULT InitAudioStream(UINT32 ulSampleRate, UINT16 usChannels);
    COggAudioStreamHelper* findAudioStream(UINT32 ulSampleRate, 
                                           UINT16 usChannels);

    UINT32 DecodeAndRender(ogg_packet* pOp);
    void Shutdown();

    BOOL IsRebuffering() const { return m_bRebuffering;}
    void StartRebuffer();
    void EndRebuffer();

    static int DepackInfoCount();

    BOOL AdjustAudioData(REF(HXAudioData) audioData);

    void updateBitrateInfo(vorbis_info* vi);
    void updateTACInfo(vorbis_comment* vc);

    HX_RESULT getPropName(UINT32 uBaseID, const char* pChildPropName,
                          CHXString& propName);
    HX_RESULT getRegistryID(IUnknown* pUnk, REF(UINT32) uRegID);

    HX_RESULT handleInitialHeader(ogg_packet* pOp);
    void gotoInitialHeaderState();

    INT32 m_RefCount;
    IHXCommonClassFactory *m_pClassFactory;
    BOOL m_bInSeekMode;
    BOOL m_bIsGapInStreaming;
    BOOL m_bEndOfPackets;
    BOOL m_bRebuffering;
    BOOL m_bIsFirstPacket;
    INT32 m_lTimeOffset;
    ULONG32 m_ulTrackStartTime;
    ULONG32 m_ulTrackEndTime;
    UINT32 m_ulBytesPerSec;

    // vorbis decoding
    VorbisState m_VorbisState;
    vorbis_info m_vi;
    vorbis_comment m_vc;
    vorbis_dsp_state m_vd;
    vorbis_block m_vb;

    // more stuff
    ogg_int64_t m_totalSamples;
    UINT32 m_uAudioPushdownStartTS;
    IUnknown* m_pContext;
    IHXStream *m_pStream;
    IHXPlayer *m_pPlayer;
    IHXAudioPlayer* m_pAudioPlayer;
    IHXValues* m_pStreamHeaderObj;

    HXAudioFormat m_audioFmt;
    CHXSimpleList m_audioStreams;
    COggAudioStreamHelper* m_pCurrentStream;

    VorbisDepacketizer* m_pDepack;
    const char** m_pStreamMimeTypes;

    static const char *zm_pDescription;
    static const char *zm_pCopyright;
    static const char *zm_pMoreInfoURL;     
    static const VorbisDepackInfo zm_depackInfo[];
    static const VorbisTagMapping zm_tagInfo[];
};

#endif  // __RVORBIS_H__
