#
# spec file for package RealPlayer (Version 10.0.<F7>)
#
# Copyright (c) 2005 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://www.suse.de/feedback/
#

# norootforbuild
# neededforbuild  glib2 gnome-filesystem gnome-mime-data kdebase3-SuSE kdelibs3 libxml2 shared-mime-info update-desktop-files

BuildRequires: aaa_base acl attr bash bzip2 coreutils cpio cpp cracklib cvs cyrus-sasl db devs diffutils e2fsprogs file filesystem fillup findutils gawk glibc glibc-devel glibc-locale gpm grep groff gzip info insserv kbd less libacl libattr libgcc libselinux libstdc++ libxcrypt make man mktemp module-init-tools net-tools netcfg openldap2-client openssl pam pam-modules patch permissions popt procinfo procps psmisc pwdutils readline sed strace syslogd sysvinit tar tcpd timezone unzip util-linux vim binutils gcc gdbm gnome-filesystem gnome-icon-theme perl rpm update-desktop-files

Name:         RealPlayer
# Set RealPlayer as default player for this product (priority 10).
%define DEFAULT_PLAYER 1
# Set RealPlayer as default player for this product (priority 5).
%define PREFERRED_PLAYER 0
# Force Real icon branding for already branded non-Real MIME types.
%define FORCED_BRANDING 0
# Use Real icon branding for already defined non-Real MIME types using default media icon (GNOME only).
%define PREFERRED_BRANDING 0
# This spec file is tri-licensed as GPL, RCSL, and RPSL.
# There is a bug in the SuSE build system. It replaces the license
# block with a SuSE-specific copyright -- this header is not correct.
# Please submit all modifications back to dev@player.helixcommunity.org
# under the terms of the GPL/RPSL.
#
# ***** BEGIN LICENSE BLOCK *****
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s): Stanislav Brabec <sbrabec@suse.cz>
#                 Nicholas Hart <nhart@real.com>
#                 Ryan Gammon <rgammon@real.com>
# 
# ***** END LICENSE BLOCK *****
# 
%define _translations de es fr hi it ja ko pl pt_BR zh_CN zh_TW 
License:      Commercial, Other License(s), see package
Group:        Productivity/Multimedia/Video/Players
Provides:     rvplayer
Obsoletes:    rvplayer, G2player, RealOne
PreReq:       /bin/rm shared-mime-info
Requires:     gnome-icon-theme
Autoreqprov:  on
Version:      10.0.9
Release:      1
Summary:      RealPlayer 10 for Linux
URL:          http://www.real.com/linux
Source:       install.bz2
Patch1:       RealPlayer-desktop.patch
Patch2:       RealPlayer-helixlibs.patch
Patch3:       RealPlayer_nld9_desktop.patch
Patch4:       RealPlayer-kfmclient.patch
Requires:     gtk2
BuildRoot:    %{_tmppath}/%{name}-%{version}-build
# NoSource:     0

%description
RealPlayer is a media player providing solid media playback locally and
via streaming. It plays RealAudio, RealVideo, MP3, 3GPP Video, Flash,
SMIL 2.0, JPEG, GIF, PNG, RealPix and RealText and more. The RealPlayer
10 for Linux builds on top of the popular GPL/RPSL Helix Player 1.0.



%prep
%setup -c
%patch1 -p1 -b .desktop
%patch2 -p1 -b .helixlibs
%patch3 -p1
%patch4 -p1
%if %DEFAULT_PLAYER == 1
echo "InitialPreference=10" >>share/realplay.desktop
%else
%if %PREFERRED_PLAYER == 1
echo "InitialPreference=5" >>share/realplay.desktop
%endif
%endif

%build

%install
export NO_BRP_STRIP_DEBUG=true
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/%_lib/browser-plugins
mkdir -p $RPM_BUILD_ROOT{/opt/gnome/share/icons/hicolor,/etc/opt/kde3/share/icons/crystalsvg}/{16x16,32x32,48x48,192x192}/{apps,mimetypes}
mkdir -p $RPM_BUILD_ROOT/usr/share/mime/packages
mkdir -p $RPM_BUILD_ROOT/usr/share/applications
mkdir -p $RPM_BUILD_ROOT/opt/kde3/share/applications/kde
mkdir -p $RPM_BUILD_ROOT/usr/share/pixmaps
mkdir -p $RPM_BUILD_ROOT/opt/gnome/share/mime-info
mkdir -p $RPM_BUILD_ROOT/opt/gnome/share/application-registry
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
mkdir -p $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share
cp -a ./codecs $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp -a ./common $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp -a ./plugins $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp -a ./share/default $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share
cp -a ./share/realplay $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share
cp ./README $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp ./LICENSE $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
for LANGUAGE in %{_translations}; do
    mkdir -p $RPM_BUILD_ROOT/usr/share/locale/$LANGUAGE/LC_MESSAGES
    mkdir -p $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share/locale/$LANGUAGE
    cp "./share/locale/$LANGUAGE/player.mo" "$RPM_BUILD_ROOT/usr/share/locale/$LANGUAGE/LC_MESSAGES/realplay.mo"
    cp "./share/locale/$LANGUAGE/widget.mo" "$RPM_BUILD_ROOT/usr/share/locale/$LANGUAGE/LC_MESSAGES/libgtkhx.mo"
    cp "./share/locale/$LANGUAGE/README" "$RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share/locale/$LANGUAGE"
    cp "./share/locale/$LANGUAGE/LICENSE" "$RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share/locale/$LANGUAGE"
done
install -p -m644 ./share/realplay.png $RPM_BUILD_ROOT/usr/share/pixmaps
install -p -m644 ./share/realplay.desktop $RPM_BUILD_ROOT/usr/share/applications
install -p -m644 ./share/realplay.xml $RPM_BUILD_ROOT/usr/share/mime/packages/realplay.xml
install -p -m644 ./share/realplay.applications $RPM_BUILD_ROOT/opt/gnome/share/application-registry
%if %FORCED_BRANDING == 1
install -p -m644 ./share/realplay.keys $RPM_BUILD_ROOT/opt/gnome/share/mime-info
%else
%if %PREFERRED_BRANDING == 1
rm -rf gnome-mime-types
mkdir gnome-mime-types
FILE=dummy
(
    cd gnome-mime-types
    set +x
    export LC_ALL=C
    while read ; do
	if test "${REPLY#[a-zA-Z]}" != "$REPLY" ; then
	    FILE="$REPLY"
	    mkdir -p ${FILE%/*}
	fi
	echo >>"$FILE" "$REPLY"
    done </opt/gnome/share/mime-info/gnome-vfs.keys
    rm -f dummy
)
%endif
while read ; do
    if [ "${REPLY:0:1}" != $'\t' ] ; then
%if %PREFERRED_BRANDING == 1
	if fgrep -q "icon_filename=" gnome-mime-types/$REPLY ; then
%else
	if grep -q "^$REPLY\$" /opt/gnome/share/mime-info/gnome-vfs.keys ; then
%endif
	    if test "$REPLY" = "${REPLY/real/}" ; then
		KNOWN_BRANDING=true
	    else
		KNOWN_BRANDING=false
	    fi
	else
	    KNOWN_BRANDING=false
	fi
	echo "$REPLY"
    else
	if test "$REPLY" = "${REPLY/icon_filename=/}" -o "$KNOWN_BRANDING" = false ; then
	    echo "$REPLY"
	fi
    fi
done <./share/realplay.keys >$RPM_BUILD_ROOT/opt/gnome/share/mime-info/realplay.keys
rm -rf gnome-mime-types
%endif
install -p -m644 ./share/realplay.mime $RPM_BUILD_ROOT/opt/gnome/share/mime-info
cp ./mozilla/nphelix.so $RPM_BUILD_ROOT/usr/%_lib/browser-plugins
cp ./mozilla/nphelix.xpt $RPM_BUILD_ROOT/usr/%_lib/browser-plugins
cp ./realplay.bin $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp ./realplay $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
ln -s /usr/%_lib/RealPlayer10/realplay $RPM_BUILD_ROOT/usr/bin
install -m 0755 realplay-kde $RPM_BUILD_ROOT/usr/bin/
(
    cd share/mimelnk
    for MIME in */*.desktop ; do
        %if %FORCED_BRANDING == 0
            if test -f /opt/kde3/share/mimelnk/$MIME ; then
	        if test "$MIME" = "${MIME/real/}" ; then
                    continue
  	        fi
            fi
        %endif
        mkdir -p $RPM_BUILD_ROOT/etc/opt/kde3/share/mimelnk/${MIME%/*}
        cp $MIME $RPM_BUILD_ROOT/etc/opt/kde3/share/mimelnk/$MIME
    done
)
for SIZE in "48x48" ; do
    for MIME in $(cd share/icons ; ls -1 mime-* | sed 's/mime-//;s/_[0-9]*x[0-9]*.png//' | sort -u) ; do
        ICON="./share/icons/mime-${MIME}_$SIZE.png"
        cp "$ICON" "$RPM_BUILD_ROOT/opt/gnome/share/icons/hicolor/$SIZE/mimetypes/realplay-${MIME}.png"
        cp "share/icons/crystalsvg/mime-real_${SIZE}.png" "$RPM_BUILD_ROOT/etc/opt/kde3/share/icons/crystalsvg/$SIZE/apps/realplay-${MIME}.png"
    done
done
for SIZE in "16x16" "32x32" "48x48" "192x192" ; do
    cp ./share/icons/realplay_${SIZE}.png $RPM_BUILD_ROOT/opt/gnome/share/icons/hicolor/${SIZE}/apps/realplay.png
    cp ./share/icons/realplay_${SIZE}.png $RPM_BUILD_ROOT/etc/opt/kde3/share/icons/crystalsvg/${SIZE}/apps/realplay.png
done
sed 's/Exec=realplay/&-kde %U/;/Categories=/aOnlyShowIn=KDE;' <$RPM_BUILD_ROOT/usr/share/applications/realplay.desktop >$RPM_BUILD_ROOT/opt/kde3/share/applications/kde/realplay-kde.desktop
%suse_update_desktop_file -i realplay
%suse_update_desktop_file -i realplay-kde
sed -i '/Categories=/aNotShowIn=KDE' $RPM_BUILD_ROOT/usr/share/applications/realplay.desktop

%clean
rm -rf $RPM_BUILD_ROOT

%pre
# Remove obsolete file from old version (up to SuSE Linux 9.0).
rm -f /usr/%_lib/RealPlayer8/mimeinstall.log
rmdir /usr/%_lib/RealPlayer8 2>/dev/null || true

%post
/usr/bin/update-mime-database /usr/share/mime > /dev/null

%postun
/usr/bin/update-mime-database /usr/share/mime > /dev/null

%files
%defattr(-,root,root)
%doc README LICENSE
/usr/%_lib/RealPlayer10
/usr/%_lib/browser-plugins/*
/usr/share/applications/*.desktop
# own directories from gnome-icon-theme
/opt/gnome/share/icons/hicolor
/usr/share/mime/packages/*.*
/usr/share/pixmaps/*.png
/usr/share/locale/*/LC_MESSAGES/*
/usr/bin/realplay*
/opt/gnome/share/mime-info/*.*
/opt/gnome/share/application-registry/*.applications
# own directories from kdelibs3 and kdebase3-SuSE
/etc/opt/kde3
/opt/kde3

%changelog -n RealPlayer
* Thu Jul 26 2007 - dyek@real.com
- 10.0.9 update

* Mon Jun 28 2006 - bobclark@real.com
- 10.0.8 update

* Tue Feb 28 2006 - bobclark@real.com
- 10.0.7 update

* Fri Aug 19 2005 - rgammon@real.com
- 10.0.6 update
* Tue Apr 26 2005 - ro@suse.de
- mark install.bz2 as NoSource
* Wed Apr 06 2005 - sbrabec@suse.cz
- Security vulnerability update (#75907).
* Fri Mar 18 2005 - aj@suse.de
- Make it default.
* Mon Mar 14 2005 - sbrabec@suse.cz
- - Updated to version 10.0.3 (GOLD).
* Fri Feb 18 2005 - sbrabec@suse.cz
- Better configuration for default player / preferred player.
* Fri Feb 18 2005 - adrian@suse.de
- do not prefer RealPlayer over other players
* Tue Feb 15 2005 - sbrabec@suse.cz
- Updated to version 10.0.2 RC4.
* Thu Dec 09 2004 - rgammon@real.com
- Fixing mimelnk prefix for kde, adding 3gpp desktop file
* Fri Dec 03 2004 - rgammon@real.com
- Rolling the kde mimelnk configuration stuff into the player binary
  tarball
- Switching crystalsvg icon to Kenneth's version
* Mon Oct 25 2004 - schwab@suse.de
- Fix syntax in wrapper script and use EXIT trap.
* Mon Oct 25 2004 - adrian@suse.de
- add wrapper script to copy files first within KDE
  (realplayer does not understand most protocolls)
* Sun Oct 24 2004 - schwab@suse.de
- Fix syntax in wrapper script and use EXIT trap.
* Sun Oct 24 2004 - adrian@suse.de
- add wrapper script to copy files first within KDE
  (realplayer does not understand most protocolls)
* Mon Oct 18 2004 - clahey@suse.de
- Added desktop translations.
* Fri Oct 01 2004 - sbrabec@suse.cz
- Use NO_BRP_STRIP_DEBUG.
* Thu Sep 30 2004 - sbrabec@suse.cz
- Updated to version 10.0.1 (GOLD).
* Thu Sep 30 2004 - Ryan Gammon <rgammon@real.com>
- Removed /opt/mozilla/lib/plugin directory, it is empty, and
- handled by triggers in the browser packages
- Install realplay to /usr/lib/RealPlayer10, as mozilla helper
- configuration expects to find it there. Symlink it back to
- /usr/bin.
- Add realplay app icons to hicolor
* Sat Sep 25 2004 - Ryan Gammon <rgammon@real.com> 
- Add release notes and eula
* Fri Sep 24 2004 - Ryan Gammon <rgammon@real.com> 
- Remove icons that are covered in NLD's desktop
- Add icons for realtext and rm
* Tue Sep 21 2004 - Ryan Gammon <rgammon@real.com> 
- Merging in changes from Stanislav:
- The neededforbuild stuff
- A comment about the license block
- re-add application-registry
- x-realplay.xml -> realplay.xml
- uncomment %%clean section
- Use %%doc
- Remove the mime patch, as this stuff is getting merged in for 1.0.1
* Sat Sep 18 2004 - Ryan Gammon <rgammon@real.com> 
- Changing hicolor icon path to /opt/gnome/share/icons/hicolor
- Removed links in /opt/mozilla/lib/plugin
- Moved realplay.xml to /usr/share/mime/packages
- Added update-mime-database pre- and post-installs
- Added all available translated languages
- Added gnome-icon-theme to Requires
- Added .keys, .mime to /usr/share/mime-info
- Apply a patch to sanitize .mime, .xml
* Fri Sep 17 2004 - Ryan Gammon <rgammon@real.com> 
- Merging nhart's real.com spec file with sbrabec's SUSE/NLD spec file
- to create a spec file (hopefully) compatible with both our build
- systems.
* Wed Sep 08 2004 - sbrabec@suse.cz
- Generated shared mime info.
* Wed Sep 01 2004 - sbrabec@suse.cz
- Updated to version 10 GOLD.
* Tue Jul 27 2004 - clahey@suse.de
- Fixed directory name in script.
* Mon Jul 26 2004 - clahey@suse.de
- Updated to 9.9.0.76.
* Fri Apr 02 2004 - adrian@suse.de
- Martin wants the menu entry on second level
* Thu Apr 01 2004 - adrian@suse.de
- add Video category
* Tue Mar 30 2004 - adrian@suse.de
- do not install broken mimetypes
- use correct dir for desktop files below /usr
- raise priority, to be more important than kaffeine (#37471)
- use desktop files with translations
* Sat Jan 10 2004 - adrian@suse.de
- add %%defattr
* Mon Sep 08 2003 - sbrabec@suse.cz
- Updated to version 8.0.3.465.
* Tue Sep 02 2003 - sbrabec@suse.cz
- Proper version number.
- Removed %%post and moved all changes to aaa_base and package itself.
* Mon Aug 25 2003 - adrian@suse.de
- fix Categories
* Thu Aug 14 2003 - sbrabec@suse.cz
- Fixed GNOME path (#28791).
* Tue Aug 12 2003 - sbrabec@suse.cz
- Added RealVideo 9 patch.
- FHS fix (realplay moved to /usr/bin).
* Mon Aug 04 2003 - adrian@suse.de
- add Categories
* Mon Feb 24 2003 - ro@suse.de
- move to /usr/lib/browser-plugins
* Thu Dec 05 2002 - sbrabec@suse.cz
- Updated to revision cs2.
* Thu Sep 12 2002 - ro@suse.de
- disabled installing mime-hooks for "wav" and "au" types
* Thu Aug 29 2002 - uli@suse.de
- added /etc/mailcap, /etc/mime.types to PreReq (bug #18229)
- fixed paths to KDE3 and GNOME2
- don't install Netscape mime.types/mailcap (uses system files)
* Wed Aug 21 2002 - ro@suse.de
- added PreReqs
* Tue Apr 17 2001 - uli@suse.de
- update -> 8.0
* Fri Jan 05 2001 - uli@suse.de
- new package, version 7.0
