/*
 * Hexxagon board game.
 * Copyright (C) 2001 Erik Jonsson.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Email erik@nesqi.homeip.net
 * 
 */

#ifndef _RENDER_H
#define _RENDER_H

#include <hexxagonboard.h>
#include <gtk/gtk.h>

enum
{
	IMAGE_WIDTH = 569,
	IMAGE_HEIGHT = 638,
	
	THINK_WIDTH = 144,
	THINK_HEIGHT = 197,

	FONT_WIDTH = 340,
	FONT_HEIGHT = 49,
	FONT_CHAR_W = 34,
	FONT_CHAR_H = 49
};

struct point
{
	int x, y;
};

void apply_thinking();
void renderDigit(int x, int y, int number);
void renderScore(HexxagonBoard board, int turn);
void fill_cell(int no, int color);
void render_board(HexxagonBoard board, int turn);
guchar *loadRAW(char *filename, int size);
int initPictures();
int get_cell_from_cord(int x, int y);
void init_lookup();

#endif
