/*
 * Hexxagon board game.
 * Copyright (C) 2001 Erik Jonsson.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Email erik@nesqi.homeip.net
 * 
 */

char *ABOUT_TEXT[] = {"\nHexxagon v0.3.1\n",
					  "Copyright 2001 Erik Jonsson\n",
					  "\n",
					  "Contact me on:\n",
					  "erik@nesqi.homeip.net\n",
					  "\n",
					  "The latest version can always be found on:\n",
					  "http://nesqi.homeip.net/hexxagon\n",
					  "\n",
					  "The pieces was drawn by Stefan Phlson.\n",
					  "\n",
					  "This program is free software; you can redistribute it and/or\n",
					  "modify it under the terms of the GNU General Public License\n",
					  "as published by the Free Software Foundation; either version 2\n", 
					  "of the License, or (at your option) any later version.\n",
					  "\n",
					  "This program is distributed in the hope that it will be useful,\n",
					  "but WITHOUT ANY WARRANTY; without even the implied warranty of\n", 
					  "   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n",
					  "See the GNU General Public License for more details.\n", 
					  "\n",	
					  "You should have received a copy of the GNU General Public License\n",
					  "along with this program; if not, write to the Free Software\n",
					  "   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.   \n",
					  0};

char aboutStr[4096];

#include <gtk/gtk.h>
#include <iostream>
#include <strings.h>
#include <stdlib.h>

#include "gtk-options.h"
#include "gtk-navigation.h"
#include "rendering.h"
#include "game.h"

using namespace std;

static void menu_new();
static void menu_open();
static void menu_save();
static void menu_about();
static void menu_difficulty();
static void human_toggle();

static GtkItemFactoryEntry menu_items[] = 
{
	{ "/_File",                     0,               0, 0,     "<Branch>" },
	{ "/File/_New",      "<control>N",        menu_new, 0,              0 },
	{ "/File/_Open",     "<control>O",       menu_open, 0,              0 },
	{ "/File/_Save as",  "<control>S",       menu_save, 0,              0 },
	{ "/File/sep1",                 0,               0, 0,  "<Separator>" },
	{ "/File/Quit",      "<control>Q",   gtk_main_quit, 0,              0 },
	{ "/_Options",                  0,               0, 0,     "<Branch>" },
	{ "/Options/Human against human" ,0,  human_toggle, 0, "<ToggleItem>" },
	{ "/Options/Computer level",    0, menu_difficulty, 0,              0 },
	{ "/Help",                      0,               0, 0, "<LastBranch>" },
	{ "/Help/About",                0,      menu_about, 0,              0 }
};

extern guchar *window_rgb; /* The board pic. buffer. */

enum file_mode_type
{
	HEX_SAVE,
	HEX_LOAD
};

GtkWidget *file_selector;
gchar *selected_filename;
file_mode_type file_mode;

GtkWidget *darea; /* Drawing area */

int human_against_human = 0;

void human_toggle()
{
	human_against_human = !human_against_human;
}

static void menu_new()
{
	new_game();
}

static void menu_difficulty()
{
	options_dialog();
}

void action_filename(GtkFileSelection *selector, gpointer user_data)
{
	 selected_filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_selector));

	 if(file_mode == HEX_LOAD)
		 game_load_file(selected_filename);
	 else if(file_mode == HEX_SAVE)
		 game_save_file(selected_filename);
	 else
		 cout << "What !! This is a fuckup!!\n";
}

void open_file_dialog(gchar *caption)
{
	 /* Create the selector */
	 file_selector = gtk_file_selection_new(caption);
    
	 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button),
						"clicked", GTK_SIGNAL_FUNC(action_filename), NULL);
	 
	 /* Destroy the dialog when the user clicks a button. */
	 
	 gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button),
							   "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
							   GTK_OBJECT(file_selector));
	 
	 gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->cancel_button),
							   "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
							   GTK_OBJECT(file_selector));
	 
	 gtk_window_set_modal(GTK_WINDOW(file_selector), true);

	 gtk_widget_show(file_selector);
	
}

static void menu_open(  )
{
	file_mode = HEX_LOAD;
	open_file_dialog("Open a game...");
}

static void menu_save(  )
{
	file_mode = HEX_SAVE;
	open_file_dialog("Save game as...");
}

static void menu_about( )
{
	 GtkWidget *dialog, *label, *okay_button;
	 	 
	 /* Create the widgets */
	 dialog = gtk_dialog_new();
	 label = gtk_label_new(aboutStr);

	 okay_button = gtk_button_new_with_label("Okay");
	 
	 /* Add the label, and show everything we've added to the dialog. */
	 gtk_signal_connect_object(GTK_OBJECT(okay_button), "clicked",
							   GTK_SIGNAL_FUNC(gtk_widget_destroy), 
							   GTK_OBJECT(dialog));
	 
	 gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area), okay_button);
	 
	 gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), label);
	 
	 gtk_window_set_modal(GTK_WINDOW(dialog), true);

	 gtk_widget_show_all(dialog);
}

void update_gui(  )
{
	if(gtk_main_iteration_do(FALSE))
		exit(0);
}

/* Close the application. */
gint close_application(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gtk_main_quit();
	return FALSE;
}

void redraw_window(GtkWidget *darea)
{
	gdk_draw_rgb_image(darea->window, 
					   darea->style->fg_gc[GTK_STATE_NORMAL],
					   0, 0, BOARD_WIDTH, BOARD_HEIGHT,
					   GDK_RGB_DITHER_MAX, 
					   window_rgb,
					   BOARD_WIDTH * 3);
}

/* Call to draw the picture. */
gboolean on_darea_expose(GtkWidget *widget, 
						 GdkEventExpose *event, 
						 gpointer user_data)
{
	 redraw_window(widget);

	 return FALSE;
}

gboolean board_clicked(GtkWidget *widget,
					   GdkEventButton *event,
					   gpointer user_data)
{
	if(event->button == 1)
		game_board_clicked((int)event->x, (int)event->y);
	else if(event->button == 3)
		game_board_abort();
	
	return FALSE;
}

void get_main_menu(GtkWidget  *window, GtkWidget **menubar)
{
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	gint nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);
	
	accel_group = gtk_accel_group_new();
	item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);

	gtk_item_factory_create_items(item_factory, nmenu_items, menu_items, NULL);
	
	gtk_window_add_accel_group(GTK_WINDOW (window), accel_group);
	
	if(menubar)
		*menubar = gtk_item_factory_get_widget(item_factory, "<main>");
}

void initAboutText()
{
	char **from = ABOUT_TEXT;
	char *cp = aboutStr;

	while(*from)
	{
		strcpy(cp, *from);
		cp = cp + strlen(*from);
		from++;
	}
}

int main (int argc, char *argv[])
{
	initAboutText();

	GtkWidget *window;
	GtkWidget *main_vbox;
	GtkWidget *menubar;
 
	gtk_init(&argc, &argv);
	gdk_rgb_init();

	gtk_widget_set_default_colormap(gdk_rgb_get_cmap());
	gtk_widget_set_default_visual(gdk_rgb_get_visual());

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
					   GTK_SIGNAL_FUNC(close_application), NULL );
	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, TRUE);

	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(main_vbox), 0);
	gtk_container_add(GTK_CONTAINER(window), main_vbox);
	
	GtkWidget *menu_hbox = gtk_hbox_new(0, 0);
	get_main_menu(window, &menubar);
	gtk_container_add(GTK_CONTAINER(menu_hbox), menubar);
	
	gtk_widget_show(window);

	GtkWidget *nav = create_navigation_bar(window);
	gtk_box_pack_end(GTK_BOX(menu_hbox), nav, FALSE, TRUE, 0);
	
	gtk_box_pack_start(GTK_BOX(main_vbox), menu_hbox, FALSE, TRUE, 0);

	darea = gtk_drawing_area_new();
	gtk_widget_set_events(darea, GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK | 
						  GDK_BUTTON_RELEASE_MASK | GDK_POINTER_MOTION_MASK |
						  GDK_POINTER_MOTION_HINT_MASK);
	gtk_drawing_area_size(GTK_DRAWING_AREA(darea), BOARD_WIDTH, BOARD_HEIGHT);
	gtk_container_add(GTK_CONTAINER(main_vbox), darea);
	gtk_signal_connect(GTK_OBJECT(darea), "expose-event",
					   GTK_SIGNAL_FUNC(on_darea_expose), NULL);
	gtk_signal_connect(GTK_OBJECT(darea), "button-release-event",
					   GTK_SIGNAL_FUNC(board_clicked), NULL);

	init_board_graphics();

	gtk_widget_show_all(window);

	init_game();

	gtk_main();

	return 0;
}
