/*****************************************************************************/

/*
 *      main.c  --  simple HF terminal program.
 *
 *      Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *	modified 2000-2004 by Axel Krause & Gnther Montag (dl4mge@darc.de).
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*
 */

/*****************************************************************************/

#include "hft.h"

/*DEBUG*/
#ifndef DEBUG
#define DEBUG printf("%s: function %s still running at line %d...\n", \
__FILE__, __FUNCTION__,  __LINE__);

#define D DEBUG
#endif /*DEBUG*/

/* --------------------------------------------------------------------- */

#ifndef FREQ_SPACE
#define FREQ_SPACE 1275
#endif

#ifndef FREQ_MARK
#define FREQ_MARK  1475
#endif

#ifndef MYCALL
#define MYCALL "DL4MGE"
#endif

#ifndef PCT_CRC_0
#define PCT_CRC_0 "FFFF"
#endif

#ifndef PCT_CRC_1
#define PCT_CRC_1 "FFFF"
#endif

#ifndef PCT_CRC_2
#define PCT_CRC_2 "FFFF"
#endif

#ifndef PCT_CRC_3
#define PCT_CRC_3 "FFFF"
#endif

#ifndef MAXKEY
#define MAXKEY 2048
#endif

#ifndef MAXRX
#define MAXRX 200
#endif

/* --------------------------------------------------------------------- */

char versioninfo[128];

int rxfile_ready = 0, scope_on = 0, log_on = 0;
static int fd_krnl = -1;
static char *name_kernel = "hfapp";
char gmt[32];
char* mailbox_host = NULL;
int mailbox_port = 0;
GdkFont *radiofont = NULL;
struct par params;
struct personaledit brag;

/* --------------------------------------------------------------------- */
/*
 * Logging functions
 */

void errprintf(int severity, const char *fmt, ...)
{
        va_list args;
        va_start(args, fmt);
	display_status( "hfterm[%lu]: ", (unsigned long)getpid());
	vfprintf(stderr, fmt, args);
        va_end(args);
        if (severity <= SEV_FATAL)
                exit(1);
}

/* --------------------------------------------------------------------- */

void errstr(int severity, const char *st)
{
        errprintf(severity, "error: %s: %s\n", st, strerror(errno));
}

/* --------------------------------------------------------------- */
void display_status(const char *fmt, ... )
{
	GtkText *txt = NULL;
	unsigned int len;
        va_list args;
	char display[256];
	
	if (!fmt || !(len = strlen(fmt)))
		return;
	
	memset (display, 0, sizeof(display));
	txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), "textstatus"));
	// to prevent stack overflow while running loooooong
	while (gtk_text_get_length(txt) > MAXMON)
	{
	 gtk_text_freeze(txt);
	  gtk_text_set_point (txt, 0);
	  gtk_text_forward_delete (txt, MAXMON / 2);
	  gtk_text_set_point (txt, gtk_text_get_length(txt));
	 gtk_text_thaw(txt);
	}
        va_start(args, fmt);
	vsnprintf(display, sizeof(display), fmt, args);	
        va_end(args);
	gtk_text_insert(txt, radiofont, NULL, NULL, display, strlen(display));
	gtk_text_insert(txt, NULL, NULL, NULL, "\n", 2);
}

/* --------------------------------------------------------------------- */
// moved spectrum fns to spectrum.c
/* --------------------------------------------------------------------- */

//static 
void param_get(void)
{
	GtkEntry *entry;
	GtkToggleButton *tog;

	/* FSK parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "fskspacefreq"));
	params.fsk.freq[0] = strtoul(gtk_entry_get_text(entry), NULL, 0);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "fskmarkfreq"));
	params.fsk.freq[1] = strtoul(gtk_entry_get_text(entry), NULL, 0);
	/* RTTY parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "rttybaudrate"));
	params.rtty.baud = strtoul(gtk_entry_get_text(entry), NULL, 0);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "rttyinvert"));
	params.rtty.rxinvert = gtk_toggle_button_get_active(tog);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "rttyrxtxinvert"));
	params.rtty.txinvert = gtk_toggle_button_get_active(tog);
	if (params.rtty.rxinvert)
		params.rtty.txinvert = !params.rtty.txinvert;
	/* Amtor parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtordestcall"));
	strncpy(params.amtor.destcall, gtk_entry_get_text(entry), sizeof(params.amtor.destcall));
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtormycall"));
	strncpy(params.amtor.mycall, gtk_entry_get_text(entry), sizeof(params.amtor.mycall));
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtorselfeccall"));
	strncpy(params.amtor.selfeccall, gtk_entry_get_text(entry), sizeof(params.amtor.selfeccall));
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtortxdelay"));
	params.amtor.txdelay = strtoul(gtk_entry_get_text(entry), NULL, 0);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtorretry"));
	params.amtor.retry = strtoul(gtk_entry_get_text(entry), NULL, 0);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "amtorinvert"));
	params.amtor.rxinvert = gtk_toggle_button_get_active(tog);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "amtorrxtxinvert"));
	params.amtor.txinvert = gtk_toggle_button_get_active(tog);
	if (params.amtor.rxinvert)
		params.amtor.txinvert = !params.amtor.txinvert;
	/* Pactor parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcall"));
	strncpy(params.pactor.destcall, gtk_entry_get_text(entry), sizeof(params.pactor.destcall));
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactormycall"));
	strncpy(params.pactor.mycall, gtk_entry_get_text(entry), sizeof(params.pactor.mycall));
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorretry"));
	params.pactor.retry = strtoul(gtk_entry_get_text(entry), NULL, 0);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactortxdelay"));
	params.pactor.txdelay = strtoul(gtk_entry_get_text(entry), NULL, 0);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "pactorlongpath"));
	params.pactor.longpath = gtk_toggle_button_get_active(tog);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcrc0"));
	params.pactor.crcpreset[0] = strtoul(gtk_entry_get_text(entry), NULL, 16);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcrc1"));
	params.pactor.crcpreset[1] = strtoul(gtk_entry_get_text(entry), NULL, 16);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcrc2"));
	params.pactor.crcpreset[2] = strtoul(gtk_entry_get_text(entry), NULL, 16);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcrc3"));
	params.pactor.crcpreset[3] = strtoul(gtk_entry_get_text(entry), NULL, 16);
	/* GTOR parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "gtordestcall"));
	strncpy(params.gtor.destcall, gtk_entry_get_text(entry), sizeof(params.gtor.destcall));
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "gtormycall"));
	strncpy(params.gtor.mycall, gtk_entry_get_text(entry), sizeof(params.gtor.mycall));
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "gtorretry"));
	params.gtor.retry = strtoul(gtk_entry_get_text(entry), NULL, 0);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "gtortxdelay"));
	params.gtor.txdelay = strtoul(gtk_entry_get_text(entry), NULL, 0);
}
	
//static 
void param_set(void)
{
	GtkEntry *entry;
	GtkToggleButton *tog;
	char buf[16];

	/* FSK parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "fskspacefreq"));
	snprintf(buf, sizeof(buf), "%u", params.fsk.freq[0]);
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "fskmarkfreq"));
	snprintf(buf, sizeof(buf), "%u", params.fsk.freq[1]);
	gtk_entry_set_text(entry, buf);
	/* RTTY parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "rttybaudrate"));
	snprintf(buf, sizeof(buf), "%u", params.rtty.baud);
	gtk_entry_set_text(entry, buf);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "rttyinvert"));
	gtk_toggle_button_set_active(tog, params.rtty.rxinvert);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "rttyrxtxinvert"));
	gtk_toggle_button_set_active(tog, params.rtty.txinvert ^ params.rtty.rxinvert);
	/* Amtor parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtordestcall"));
	strncpy(buf, params.amtor.destcall, sizeof(params.amtor.destcall));
	buf[sizeof(params.amtor.destcall)] = 0;
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtormycall"));
	strncpy(buf, params.amtor.mycall, sizeof(params.amtor.mycall));
	buf[sizeof(params.amtor.mycall)] = 0;
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtorselfeccall"));
	strncpy(buf, params.amtor.selfeccall, sizeof(params.amtor.selfeccall));
	buf[sizeof(params.amtor.selfeccall)] = 0;
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtortxdelay"));
	snprintf(buf, sizeof(buf), "%u", params.amtor.txdelay);
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "amtorretry"));
	snprintf(buf, sizeof(buf), "%u", params.amtor.txdelay);
	gtk_entry_set_text(entry, buf);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "amtorinvert"));
	gtk_toggle_button_set_active(tog, params.amtor.rxinvert);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "amtorrxtxinvert"));
	gtk_toggle_button_set_active(tog, params.amtor.txinvert ^ params.amtor.rxinvert);
	/* Pactor parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcall"));
	strncpy(buf, params.pactor.destcall, sizeof(params.pactor.destcall));
	buf[sizeof(params.pactor.destcall)] = 0;
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactormycall"));
	strncpy(buf, params.pactor.mycall, sizeof(params.pactor.mycall));
	buf[sizeof(params.pactor.mycall)] = 0;
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorretry"));
	snprintf(buf, sizeof(buf), "%u", params.pactor.retry);
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactortxdelay"));
	snprintf(buf, sizeof(buf), "%u", params.pactor.txdelay);
	gtk_entry_set_text(entry, buf);
	tog = GTK_TOGGLE_BUTTON(gtk_object_get_data(GTK_OBJECT(wpar), "pactorlongpath"));
	gtk_toggle_button_set_active(tog, params.pactor.longpath);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcrc0"));
	snprintf(buf, sizeof(buf), "%04X", params.pactor.crcpreset[0]);
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcrc1"));
	snprintf(buf, sizeof(buf), "%04X", params.pactor.crcpreset[1]);
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcrc2"));
	snprintf(buf, sizeof(buf), "%04X", params.pactor.crcpreset[2]);
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "pactorcrc3"));
	snprintf(buf, sizeof(buf), "%04X", params.pactor.crcpreset[3]);
	gtk_entry_set_text(entry, buf);
	/* GTOR parameters */
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "gtordestcall"));
	strncpy(buf, params.gtor.destcall, sizeof(params.gtor.destcall));
	buf[sizeof(params.gtor.destcall)] = 0;
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "gtormycall"));
	strncpy(buf, params.gtor.mycall, sizeof(params.gtor.mycall));
	buf[sizeof(params.gtor.mycall)] = 0;
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "gtorretry"));
	snprintf(buf, sizeof(buf), "%u", params.gtor.retry);
	gtk_entry_set_text(entry, buf);
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpar), "gtortxdelay"));
	snprintf(buf, sizeof(buf), "%u", params.gtor.txdelay);
	gtk_entry_set_text(entry, buf);
}
	
//static 
void param_kernel(void)
{
	struct hfapp_msg msg;

	/* FSK parameters */
	set_fsk_freq(params.fsk.freq[1], params.fsk.freq[0]);
	/* RTTY parameters */
	msg.hdr.type = htonl(HFAPP_MSG_SET_RTTYPAR);
	msg.hdr.err = htonl(ERR_NOERR);
	msg.hdr.len = htonl(sizeof(msg.data.rpar));
	msg.data.rpar.baud = htons(params.rtty.baud);
	msg.data.rpar.rxinvert = params.rtty.rxinvert;
	msg.data.rpar.txinvert = params.rtty.txinvert;
	msg_send(&msg);
	/* Amtor parameters */
	msg.hdr.type = htonl(HFAPP_MSG_SET_AMTORPAR);
	msg.hdr.err = htonl(ERR_NOERR);
	msg.hdr.len = htonl(sizeof(msg.data.apar));
	strncpy(msg.data.apar.destcall, params.amtor.destcall, sizeof(msg.data.apar.destcall));
	strncpy(msg.data.apar.selfeccall, params.amtor.selfeccall, sizeof(msg.data.apar.selfeccall));
	strncpy(msg.data.apar.mycall, params.amtor.mycall, sizeof(msg.data.apar.mycall));
	msg.data.apar.txdelay = htons(params.amtor.txdelay);
	msg.data.apar.retry = htons(params.amtor.retry);
	msg.data.apar.rxinvert = params.amtor.rxinvert ;
	msg.data.apar.txinvert = params.amtor.txinvert;
	msg_send(&msg);
	/* Pactor parameters */
	msg.hdr.type = htonl(HFAPP_MSG_SET_PACTORPAR);
	msg.hdr.err = htonl(ERR_NOERR);
	msg.hdr.len = htonl(sizeof(msg.data.ppar));
	strncpy(msg.data.ppar.destcall, params.pactor.destcall, sizeof(msg.data.ppar.destcall));
	strncpy(msg.data.ppar.mycall, params.pactor.mycall, sizeof(msg.data.ppar.mycall));
	msg.data.ppar.txdelay = htons(params.pactor.txdelay);
	msg.data.ppar.retry = htons(params.pactor.retry);
	msg.data.ppar.longpath = params.pactor.longpath;
	msg.data.ppar.crcpreset[0] = htons(params.pactor.crcpreset[0]);
	msg.data.ppar.crcpreset[1] = htons(params.pactor.crcpreset[1]);
	msg.data.ppar.crcpreset[2] = htons(params.pactor.crcpreset[2]);
	msg.data.ppar.crcpreset[3] = htons(params.pactor.crcpreset[3]);
	msg_send(&msg);
	/* GTOR parameters */
	msg.hdr.type = htonl(HFAPP_MSG_SET_GTORPAR);
	msg.hdr.err = htonl(ERR_NOERR);
	msg.hdr.len = htonl(sizeof(msg.data.gpar));
	strncpy(msg.data.gpar.destcall, params.gtor.destcall, sizeof(msg.data.gpar.destcall));
	strncpy(msg.data.gpar.mycall, params.gtor.mycall, sizeof(msg.data.gpar.mycall));
	msg.data.gpar.txdelay = htons(params.gtor.txdelay);
	msg.data.gpar.retry = htons(params.gtor.retry);
	msg_send(&msg);
}

void param_read()
{
/* aus config-Datei gespeicherte params einlesen ------------------- */
	FILE *conf;
	conf = fopen("hf/hfterm.rc", "r");
	if(conf == NULL)
	{
	  display_status("Configuration File ~/hf/hfterm.rc can not be opened.");
	  return;
	}  
	else	
	display_status ("Configuration File ~/hf/hfterm.rc opened.");
	if(fread(&params, sizeof(params), 1, conf) != 1)
		display_status("Error while reading configuration file.");
	fclose(conf);	
} 

void param_store()
{
/* - Konfiguration speichern ----------------------------------------*/
	FILE *conf = fopen("hf/hfterm.rc", "w");
	if(conf == NULL)
	{
	  display_status
	      ("Configuration File ~/hf/hfterm.rc can not be opened.");
	  return;
	}
	else	
		display_status
		("Configuration File ~/hf/hfterm.rc opened.");
	if(fwrite(&params, sizeof(params), 1, conf) != 1)
	{
	  display_status
	      ("Error while writing configuration file ~/hfterm.rc.");
	  return;
	}
	else	
	//	display_status("Configuration stored in ~/hf/hfterm.rc.");
	fclose(conf);	
}

/* ------------------------------------------------------------------ */

void rx_window_keep_small()
{
	GtkText *txt = NULL;
	int length;

	txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), "textmain"));
	length = gtk_text_get_length(txt);
	// to prevent crashes from stack overflow with growing rx text
	while  (length > MAXRX) {
	  if (! rxfile_ready ) rx_routine_store_prepare();
	  gtk_text_freeze(txt);
	  rx_routine_store_part();
	  display_status("first half of rx text saved in ~/hf/hfrx.");
	  gtk_text_set_point (txt, 0);
	  gtk_text_forward_delete (txt, MAXRX / 2  ); // removed "-10"
	  length = gtk_text_get_length(txt);
	  gtk_text_set_point (txt, length);
	  gtk_text_thaw(txt);
	}
}

void write_input(unsigned char *data, int datalen)
{
	GtkText *txt;
	if (!data && datalen <= 0)
		return;
	fbbtest = 0;
	rx_window_keep_small();
	txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), "textmain"));
	gtk_text_insert(txt, radiofont, NULL, NULL, data, datalen);
	if (mailbox_on == 1) mailbox_input(data, datalen);
}

void write_output(unsigned char *data, int datalen)
{
    GtkText *txt;
    GdkColor txfg, txbg;

    	 txfg.pixel = 0;
	 txfg.red = 65535;	
	 txfg.green = 0;
	 txfg.blue = 65535;
	/* pink */

	 txbg.pixel = 0;
	 txbg.red = 55000;
	 txbg.green = 65535;
	 txbg.blue = 55000;
	/* light green */
	
    if (!data && datalen <= 0) {
	display_status ("hfterm/src/main.c: no data, len 0");
	return;
    }
    if (!data ) {
	display_status ("hfterm/src/main.c: no data");
	return;
    }
    if ( datalen <= 0) {
	display_status ("hfterm/src/main.c: len 0");
	return;
    }
    fbbtest = 0;
    rx_window_keep_small();
    txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), "textmain"));
    gtk_text_insert(txt, radiofont, 
//    &(GTK_WIDGET(txt)->style->fg[GTK_WIDGET_STATE(GTK_WIDGET(txt))]), 
    &txfg, &txbg, data, datalen);
}

void start_write_mailboxtest()
{
/* 
 * before start of mailbox-test
 * by writing to input window, 
 * set a color and 
 * go to end of input text 
 * and write a newline
 * 
 */
        GtkText *txt;
	int length;
	GdkColor boxtestfg, boxtestbg;

    	boxtestbg.pixel = 0;
	boxtestbg.red = 65535;	
	boxtestbg.green = 65535;
	boxtestbg.blue = 50000;
	/* light yellow */

	boxtestfg.pixel = 0;
	boxtestfg.red = 0;
	boxtestfg.green = 0;
	boxtestfg.blue = 65535;
	/* should be blue */
	
	txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), "textmain"));
	length = gtk_text_get_length(txt);
	gtk_text_set_point (txt, length);
	gtk_text_insert(txt, radiofont, 
//    &(GTK_WIDGET(txt)->style->fg[GTK_WIDGET_STATE(GTK_WIDGET(txt))]), 
        &boxtestfg, &boxtestbg, "\n", 1);
	rx_window_keep_small();
}

void write_monitor(unsigned char *data, int datalen)
{
	GtkText *txt = NULL;
	if (!data && datalen <= 0)
		return;
	txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmonitor), 
	    "textmonitor"));
	if (!GTK_WIDGET_DRAWABLE(GTK_WIDGET(txt)))
		return;
	while (gtk_text_get_length(txt) > MAXMON)
	{
	 // gtk_text_freeze(txt);
	  gtk_text_set_point (txt, 0);
	  gtk_text_forward_delete (txt, MAXMON / 2);
	  gtk_text_set_point (txt, gtk_text_get_length(txt));
	 // gtk_text_thaw(txt);
	}
	gtk_text_insert(txt, radiofont, NULL, NULL, data, datalen);
}

/* ------------------------------------------------------------------ */

void write_kernel(unsigned char *data, int datalen)
{
	int i;

	if (fd_krnl < 0) {
		display_status ("hfterm: can not write to hfkernel");
		return;
	}
	while (datalen > 0) {
		i = write(fd_krnl, data, datalen);
		if (i < 0) {
			if (errno != EAGAIN)
				errstr(SEV_FATAL, "write");
		} else {
			data += i;
			datalen -= i;
		}
	}
}

/* ------------------------------------------------------------------ */

//static 
void edit_newline(void)
{
        struct hfapp_msg msg;
//	GtkEntry *entry;
//	see below
//	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wmain), "textedit"));
//	gtk_entry_set_text(entry, "");
	msg.data.b[0] = '\r';
	msg.data.b[1] = '\n';
        msg.hdr.type = htonl(HFAPP_MSG_DATA_TRANSMIT);
        msg.hdr.len = htonl(2);
        msg.hdr.err = htonl(ERR_NOERR);
        msg_send(&msg);
}

//static 
void edit_backspace(void)
{
        struct hfapp_msg msg;
	GtkEditable *entry;
	gint pos;

	entry = GTK_EDITABLE(gtk_object_get_data(GTK_OBJECT(wmain), "textedit"));
	pos = gtk_editable_get_position(entry);
	if (pos > 0) {
//		gtk_editable_set_position(entry, pos-1);
		gtk_editable_delete_text(entry, pos, pos);
	}
	msg.data.b[0] = '\b';
        msg.hdr.type = htonl(HFAPP_MSG_DATA_TRANSMIT);
        msg.hdr.len = htonl(1);
        msg.hdr.err = htonl(ERR_NOERR);
        msg_send(&msg);
}

//static 
void edit_addchar(char v)
{
        struct hfapp_msg msg;
//	seit das alles auskommentiert ist, sind die Fehlermeldungen weg
//	the outcommented lines are not necessary, it makes errors.
//	GtkEntry *entry;
	char buf[2];
//	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wmain), "textedit"));
	buf[0] = v;
	buf[1] = 0;
//	gtk_entry_append_text(entry, buf);
	msg.data.b[0] = v;
        msg.hdr.type = htonl(HFAPP_MSG_DATA_TRANSMIT);
        msg.hdr.len = htonl(1);
        msg.hdr.err = htonl(ERR_NOERR);
        msg_send(&msg);
}

/* --------------------------------------------------------------------- */

//static 
gboolean poll_prepare(gpointer source_data, GTimeVal *current_time, gint *timeout, gpointer user_data)
{
	*timeout = -1;
        return FALSE;
}

//static 
gboolean poll_check(gpointer source_data, GTimeVal *current_time, gpointer user_data)
{
	if (msgpfd.revents & G_IO_IN)
		return TRUE;
        return FALSE;
}

//static 
gboolean poll_dispatch(gpointer source_data, GTimeVal *current_time, gpointer user_data)
{
	if (msgpfd.revents & G_IO_IN)
		msg_process(msgpfd.fd);
        return TRUE;
}

static GSourceFuncs poll_funcs =
{
        poll_prepare,
        poll_check,
        poll_dispatch,
        NULL
};

void brag_get()
{
	GtkEntry *entry;

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry27"));
	strncpy(brag.call, gtk_entry_get_text(entry), sizeof(brag.call));

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry28"));
	strncpy(brag.op, gtk_entry_get_text(entry), sizeof(brag.op));

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry29"));
	strncpy(brag.qth, gtk_entry_get_text(entry), sizeof(brag.qth));

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry30"));
	strncpy(brag.loc, gtk_entry_get_text(entry), sizeof(brag.loc));

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry31"));
	strncpy(brag.rig, gtk_entry_get_text(entry), sizeof(brag.rig));

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry32"));
	strncpy(brag.pwr, gtk_entry_get_text(entry), sizeof(brag.pwr));

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry33"));
	strncpy(brag.ant, gtk_entry_get_text(entry), sizeof(brag.ant));

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry34"));
	strncpy(brag.www, gtk_entry_get_text(entry), sizeof(brag.www));
}


void brag_set()
{
	GtkEntry *entry;
	unsigned char buf[129];

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry27"));
	strncpy(buf, brag.call, sizeof(brag.call));
	buf[sizeof(brag.call)] = 0;
	gtk_entry_set_text(entry, buf);

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry28"));
	strncpy(buf, brag.op, sizeof(brag.op));
	buf[sizeof(brag.op)] = 0;
	gtk_entry_set_text(entry, buf);
	
	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry29"));
	strncpy(buf, brag.qth, sizeof(brag.qth));
	buf[sizeof(brag.qth)] = 0;
	gtk_entry_set_text(entry, buf);

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry30"));
	strncpy(buf, brag.loc, sizeof(brag.loc));
	buf[sizeof(brag.loc)] = 0;
	gtk_entry_set_text(entry, buf);

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry31"));
	strncpy(buf, brag.rig, sizeof(brag.rig));
	buf[sizeof(brag.rig)] = 0;
	gtk_entry_set_text(entry, buf);

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry32"));
	strncpy(buf, brag.pwr, sizeof(brag.pwr));
	buf[sizeof(brag.pwr)] = 0;
	gtk_entry_set_text(entry, buf);

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry33"));
	strncpy(buf, brag.ant, sizeof(brag.ant));
	buf[sizeof(brag.ant)] = 0;
	gtk_entry_set_text(entry, buf);

	entry = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(wpersonal), "entry34"));
	strncpy(buf, brag.www, sizeof(brag.www));
	buf[sizeof(brag.www)] = 0;
	gtk_entry_set_text(entry, buf);

}

void brag_delete()
{
	memset(brag.call, 0, sizeof(brag.call));
	memset(brag.op, 0, sizeof(brag.op));
	memset(brag.qth, 0, sizeof(brag.qth));
	memset(brag.loc, 0, sizeof(brag.loc));
	memset(brag.rig, 0, sizeof(brag.rig));
	memset(brag.pwr, 0, sizeof(brag.pwr));
	memset(brag.ant, 0, sizeof(brag.ant));
	memset(brag.www, 0, sizeof(brag.www));
	
	return;
}

void brag_read()
{
/* aus brag-Datei gespeicherte pers. Werte einlesen ----------------- */
	FILE *bragfile = fopen("hf/hfterm.brag", "r");
	if(bragfile == NULL)
	{
	  display_status("bragfile ~/hf/hfterm.brag can not be opened.");
	  return;
	}  
	else	
	    display_status("bragfile ~/hf/hfterm.brag opened.");
	if(fread(&brag, sizeof(brag), 1, bragfile) != 1)
		display_status("Error while reading bragfile.");
	fclose(bragfile);	
	return;
}

void brag_store()
{
/* - Persnliche Daten speichern -------------------------------------*/
	FILE *bragfile;
	bragfile = fopen("hf/hfterm.brag", "w");
	if(bragfile == NULL)
		display_status(	"bragfile ~/hf/hfterm.brag can not be opened.\n");
	if(fwrite(&brag, sizeof(brag), 1, bragfile) != 1)
		display_status(	"Error while writing bragfile ~/hf/hfterm.brag !\n");
	fclose(bragfile);	
	return;
}

void timequery()
{
	/*Datum-Systemabfrage*/
	time_t now;
	time(&now);
	// "GENORMT":
	//sprintf(gmt, "%s", asctime(gmtime(&now)));	
	// MIR GEFLLT ES SO BESSER:
	// strftime(gmt, 31, "%a %d.%m.%y, %H:%M", gmtime(&now));
	// aber damit es cabrillo-kompatibel wird mach ich es so:
	strftime(gmt, 31, "%Y-%m-%d %H%M", gmtime(&now));
} 

//static 
void init(void)
{
	static char *mycall = MYCALL;
	struct sockaddr_un saddr;
	char buf[16];
	char *bp1;
	const char *bp2;
	int kernel_running = 0;
	struct hfapp_msg msg;

	system("cd");
	system("if ! [ -d hf ] ; then mkdir hf; cp -ruv /usr/share/hf/hf-examplefiles/* hf; fi");
	sprintf(versioninfo,  "hfterm %s by Tom Sailer, HB9JNX/AE4WA,\n"
		"Ralf-Axel Krause, DF3JRK,\nGnther Montag, DL4MGE", 
		VERSION);
	display_status(versioninfo);
	if ((fd_krnl = socket(PF_UNIX, SOCK_STREAM, 0)) < 0)
		errstr(SEV_FATAL, "socket");
	saddr.sun_family = AF_UNIX;
	strncpy(saddr.sun_path, name_kernel, sizeof(saddr.sun_path));
	if (connect(fd_krnl, (struct sockaddr *)&saddr, sizeof(saddr))) {
		errstr(SEV_WARNING, "connect");
		close(fd_krnl);
		msgpfd.fd = fd_krnl = -1;
		display_status("hfkernel not started!\n"
		    "May be You have to adapt script /usr/bin/hf or \n"
		    "the configuration file /etc/hf.conf fist. \n"
		    "e.g. correct the ttyS.. (serial port for PTT)  entry.\n"
		    "See F1 or /usr/share<doc/>(packages/)/hf/HF-HOWTO for help.");
	} else {
		kernel_running = 1;
		g_source_add(G_PRIORITY_HIGH, FALSE, &poll_funcs, NULL, NULL, NULL);
		msgpfd.fd = fd_krnl;
		msgpfd.events = G_IO_IN;
		msgpfd.revents = 0;
		g_main_add_poll(&msgpfd, G_PRIORITY_HIGH);
	}
	
/* Falls keine config-Datei gefunden wird: params vorbelegen------- */
	memset(&params, 0, sizeof(params));
	params.gtor.txdelay = 30;
	params.gtor.retry = 30;
	params.pactor.txdelay = 30;
	params.pactor.retry = 30;
	params.pactor.crcpreset[0] = strtoul(PCT_CRC_0, NULL, 16);
	params.pactor.crcpreset[1] = strtoul(PCT_CRC_1, NULL, 16);
	params.pactor.crcpreset[2] = strtoul(PCT_CRC_2, NULL, 16);
	params.pactor.crcpreset[3] = strtoul(PCT_CRC_3, NULL, 16);
	params.amtor.txdelay = 30;
	params.amtor.retry = 30;
	params.rtty.baud = 45;
	
	set_fsk_freq(FREQ_MARK, FREQ_SPACE);

	strncpy(params.gtor.mycall, mycall, sizeof(params.gtor.mycall));
	strncpy(params.pactor.mycall, mycall, sizeof(params.pactor.mycall));
	bp2 = mycall-1+strlen(mycall);
	buf[sizeof(buf)-1] = 0;
	bp1 = buf+4;
	*bp1 = 0;
	while (bp2 >= mycall) 
	{
		if (isalpha(*bp2))
			*--bp1 = *bp2;
		bp2--;
		if (bp1 <= buf)
			bp1 = buf+1;
	}
	strncpy(params.amtor.mycall, buf, sizeof(params.amtor.mycall));
	strncpy(params.amtor.selfeccall, buf, sizeof(params.amtor.selfeccall));
	
	param_read();	
	fixtext_read();
	brag_read();
	log_read();
	log_list();
	param_set();
	param_kernel();

	if ((radiofont = gdk_font_load("7x13")) == NULL)
	    display_status("simple font 7x13 could not be loaded.");
		
	if(kernel_running) {
	    msg.hdr.err = htonl(ERR_NOERR);
	    msg.hdr.len = htonl(0);
	    msg.hdr.type = htonl(HFAPP_MSG_START_STANDBY);
	    msg_send(&msg);
	    display_status("starting with STANDBY FOR PACTOR - AMTOR - GTOR ...");
	    lastrx = HFAPP_MSG_START_STANDBY;
	    userrx();
	}
}

/* ----------------------------------------------------------------- */

/* ------------------------------------------------------------------ */
void finit(void)
{
	errprintf (SEV_INFO,"hfterm: 73 & hpe cuagn sn !! \n");        
	display_status("\n73 !!! by hfterm !");        
	gtk_main_quit();
//	sleep(1);
//	D
/* - Rx-Text-Rest speichern ------------------------------------------*/
//	D
	rx_routine_store_rest();
/* - Fix - Text speichern --------------------------------------------*/
//	D
	fixtext_store();
/* - Config-Datei speichern ------------------------------------------*/
//	D
	param_store();
/* - Log-Datei speichern ---------------------------------------------*/
//	D
	log_store();
}


/* ------------------------------------------------------------------ */

int main(int argc, char *argv[])
{
        int c, err = 0;
//	auskommentiert weil laut compiler "statement with no effect"
//	bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
//	textdomain(PACKAGE);
//		
	gtk_set_locale();
	gtk_init(&argc, &argv);

        while ((c = getopt(argc, argv, "k:h:p:")) != -1) 
                switch (c) {
                case 'k':
                        name_kernel = optarg;
                        break;

                case 'h':
                        mailbox_host = optarg;
                        break;

                case 'p':
                        mailbox_port = atoi(optarg);
                        break;

                default:
                        err++;
                        break;
                }
        if (err) {
                errprintf 
		    (SEV_WARNING,"usage: hfterm -k [socket to hfkernel_user, e.g. /var/run/hfapp]"
		    "[-h <ip-adress of mailbox-host>] [-p <mailbox-port>]\n");
                exit(1);
        }

#if MAP 
//  same would be:
//  add_pixmap_directory("/usr/local/share/hfterm/pixmaps");
//  this is outcommented because it will hfterm on my old box slooow  !!

	add_pixmap_directory(PACKAGE_DATA_DIR "/pixmaps");
	add_pixmap_directory(PACKAGE_SOURCE_DIR "/pixmaps");
#endif
	/*
	 * The following code was added by Glade to create one of each component
	 * (except popup menus), just so that you see something after building
	 * the project. Delete any components that you don't want shown initially.
	 */
//	wrxfileselection = create_wrxfileselection();
	wmain = create_wmain();
	wspec = create_wspec();
	wpar = create_wpar();
	wabout = create_wabout();
	whilfe = create_whilfe();
	Wfixtext = create_Wfixtext();
	wpersonal = create_wpersonal();
	Wsearchlogentr = create_Wsearchlogentr();
	wlistalllog = create_wlistalllog();
	wqsoeditor = create_wqsoeditor();
//	whinweis = create_whinweis();
//	wmap = create_wmap();	
	wmonitor = create_wmonitor();
	gtk_widget_show(wmain);

 	init();
	gtk_main();
	//finit();
	exit(0);
}

/* --------------------------------------------------------------------- */
