

# Highlight PP-Macros Usage Example

# First Example

We import the PureBASIC example file "`example.pb`" without passing any extra options to Highlight:

<pre class="hl"><code class="purebasic"><span class="hl slc">; PureBASIC 5.60 Example</span>

<span class="hl kwa">For</span> i<span class="hl opt">=</span><span class="hl num">5</span> <span class="hl kwa">To</span> <span class="hl num">1</span> <span class="hl kwa">Step</span> <span class="hl opt">-</span><span class="hl num">1</span>
  TEXT$ <span class="hl opt">=</span> <span class="hl str">&quot;Iteration number: &quot;</span> <span class="hl opt">+</span> <span class="hl kwc">Str</span>(i) <span class="hl opt">+</span> <span class="hl kwd">~</span><span class="hl str">&quot;</span><span class="hl esc">\n\n</span><span class="hl str">Do you wish to continue?&quot;</span>
  UserChoice <span class="hl opt">=</span> <span class="hl kwc">MessageRequester</span>(<span class="hl str">&quot;Countdown Dialog&quot;</span>, TEXT$, <span class="hl kwb">#PB_MessageRequester_YesNo</span> <span class="hl opt">|</span> <span class="hl kwb">#PB_MessageRequester_Info</span>)
  <span class="hl kwa">If</span> UserChoice <span class="hl opt">=</span> <span class="hl kwb">#PB_MessageRequester_No</span>
    <span class="hl kwa">Break</span>
  <span class="hl kwa">EndIf</span>
<span class="hl kwa">Next</span></code></pre>

# Second Example

Now we import the same file, this time passing some extra options to Highlight in order to show line numbers:

<pre class="hl"><code class="purebasic"><span class="hl lin">    1 </span><span class="hl slc">; PureBASIC 5.60 Example</span>
<span class="hl lin">    2 </span>
<span class="hl lin">    3 </span><span class="hl kwa">For</span> i<span class="hl opt">=</span><span class="hl num">5</span> <span class="hl kwa">To</span> <span class="hl num">1</span> <span class="hl kwa">Step</span> <span class="hl opt">-</span><span class="hl num">1</span>
<span class="hl lin">    4 </span>  TEXT$ <span class="hl opt">=</span> <span class="hl str">&quot;Iteration number: &quot;</span> <span class="hl opt">+</span> <span class="hl kwc">Str</span>(i) <span class="hl opt">+</span> <span class="hl kwd">~</span><span class="hl str">&quot;</span><span class="hl esc">\n\n</span><span class="hl str">Do you wish to continue?&quot;</span>
<span class="hl lin">    5 </span>  UserChoice <span class="hl opt">=</span> <span class="hl kwc">MessageRequester</span>(<span class="hl str">&quot;Countdown Dialog&quot;</span>, TEXT$, <span class="hl kwb">#PB_MessageRequester_YesNo</span> <span class="hl opt">|</span> <span class="hl kwb">#PB_MessageRequester_Info</span>)
<span class="hl lin">    6 </span>  <span class="hl kwa">If</span> UserChoice <span class="hl opt">=</span> <span class="hl kwb">#PB_MessageRequester_No</span>
<span class="hl lin">    7 </span>    <span class="hl kwa">Break</span>
<span class="hl lin">    8 </span>  <span class="hl kwa">EndIf</span>
<span class="hl lin">    9 </span><span class="hl kwa">Next</span></code></pre>

# Add Color Theme

Now we import Highlight's `edit-purebasic` theme into the document:

<style type="text/css">
/* Style definition file generated by highlight 3.36, http://www.andre-simon.de/ */
/* highlight theme: PureBASIC */
body.hl	{ background-color:#ffffdf; }
pre.hl	{ color:#000000; background-color:#ffffdf; font-size:10pt; font-family:'Courier New',monospace;}
.hl.num { color:#000000; }
.hl.esc { color:#0080ff; }
.hl.str { color:#0080ff; }
.hl.pps { color:#0080ff; }
.hl.slc { color:#00aaaa; }
.hl.com { color:#00aaaa; }
.hl.ppc { color:#924b72; }
.hl.opt { color:#000000; }
.hl.ipl { color:#0080ff; }
.hl.lin { color:#808080; }
.hl.kwa { color:#006666; font-weight:bold; }
.hl.kwb { color:#924b72; }
.hl.kwc { color:#006666; }
.hl.kwd { color:#0080ff; }
</style>
