{- This module was generated from data in the Kate syntax
   highlighting file relaxngcompact.xml, version 0.2, by Rintze Zelle -}

module Text.Highlighting.Kate.Syntax.Relaxngcompact
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "RelaxNG-Compact"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.rnc"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "RelaxNG-Compact" }
  context <- currentContext <|> (pushContext "Normal Text" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("RelaxNG-Compact",["Normal Text"])], synStLanguage = "RelaxNG-Compact", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal Text" -> return ()
    "Comments" -> (popContext) >> pEndLine
    "String" -> return ()
    "Node Names" -> (popContext) >> pEndLine
    "Definitions" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_Keywords = Set.fromList $ words $ "default datatypes div empty external grammar include inherit list mixed namespace notAllowed parent start token"
list_Node_Names = Set.fromList $ words $ "attribute element"
list_Datatypes = Set.fromList $ words $ "string text xsd:anyURI xsd:base64Binary xsd:boolean xsd:byte xsd:date xsd:dateTime xsd:decimal xsd:double xsd:duration xsd:ENTITIES xsd:ENTITY xsd:float xsd:gDay xsd:gMonth xsd:gMonthDay xsd:gYear xsd:gYearMonth xsd:hexBinary xsd:ID xsd:IDREF xsd:IDREFS xsd:int xsd:integer xsd:language xsd:long xsd:Name xsd:NCName xsd:negativeInteger xsd:NMTOKEN xsd:NMTOKENS xsd:nonNegativeInteger xsd:nonPositiveInteger xsd:normalizedString xsd:NOTATION xsd:positiveInteger xsd:QName xsd:short xsd:string xsd:time xsd:token xsd:unsignedByte xsd:unsignedInt xsd:unsignedLong xsd:unsignedShort"

regex_'5b'5cw'5c'2e'2d'5d'2b'5b'5cs'5d'2b'3d = compileRegex "[\\w\\.-]+[\\s]+="

defaultAttributes = [("Normal Text",NormalTok),("Comments",CommentTok),("String",StringTok),("Node Names",OtherTok),("Definitions",FunctionTok)]

parseRules "Normal Text" =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "Comments")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\" list_Keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\" list_Node_Names >>= withAttribute KeywordTok) >>~ pushContext "Node Names")
   <|>
   ((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\" list_Datatypes >>= withAttribute DataTypeTok))
   <|>
   ((lookAhead (pRegExpr regex_'5b'5cw'5c'2e'2d'5d'2b'5b'5cs'5d'2b'3d) >> pushContext "Definitions" >> currentContext >>= parseRules)))

parseRules "Comments" =
  pzero

parseRules "String" =
  ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))

parseRules "Node Names" =
  ((lookAhead (pDetectChar False '{') >> (popContext) >> currentContext >>= parseRules))

parseRules "Definitions" =
  ((lookAhead (pDetectChar False '=') >> (popContext >> popContext) >> currentContext >>= parseRules))

parseRules "" = parseRules "Normal Text"

parseRules x = fail $ "Unknown context" ++ x
