{- This module was generated from data in the Kate syntax
   highlighting file diff.xml, version 1.11, by  -}

module Text.Highlighting.Kate.Syntax.Diff
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "Diff"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.diff;*patch"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Diff","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Diff","Normal") -> return ()
      ("Diff","FindDiff") -> return ()
      ("Diff","File") -> return ()
      ("Diff","Chunk") -> return ()
      ("Diff","ChunkInFile") -> return ()
      ("Diff","RFile") -> return ()
      ("Diff","RChunk") -> return ()
      ("Diff","RChunkInFile") -> return ()
      ("Diff","RChunkNew") -> return ()
      ("Diff","RChunkInFileNew") -> return ()
      ("Diff","File") -> (popContext) >> pEndLine
      ("Diff","Removed") -> (popContext) >> pEndLine
      ("Diff","Added") -> (popContext) >> pEndLine
      ("Diff","ChangedOld") -> (popContext) >> pEndLine
      ("Diff","ChangedNew") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'28'5c'40'5c'40'7c'5cd'29'2e'2a'24 = compileRegex "(\\@\\@|\\d).*$"
regex_'5c'2a'2b'24 = compileRegex "\\*+$"
regex_Only_in_'2e'2a'3a'2e'2a'24 = compileRegex "Only in .*:.*$"
regex_diff'2e'2a'24 = compileRegex "diff.*$"
regex_'3d'3d'3d'3d'2e'2a'24 = compileRegex "====.*$"
regex_'28'5c'2a'5c'2a'5c'2a'7c'5c'2d'5c'2d'5c'2d'29'2e'2a'24 = compileRegex "(\\*\\*\\*|\\-\\-\\-).*$"
regex_'5c'2d'5c'2d'5c'2d'2e'2a'24 = compileRegex "\\-\\-\\-.*$"
regex_'28'5c'2b'5c'2b'5c'2b'7c'5c'2d'5c'2d'5c'2d'29'2e'2a'24 = compileRegex "(\\+\\+\\+|\\-\\-\\-).*$"
regex_'28'3d'3d'3d'3d'7c'5c'2a'5c'2a'5c'2a'7c'5c'2d'5c'2d'5c'2d'7cdiff'7cOnly_in_'2e'2a'3a'29'2e'2a'24 = compileRegex "(====|\\*\\*\\*|\\-\\-\\-|diff|Only in .*:).*$"
regex_Index'3a'2e'2a = compileRegex "Index:.*"
regex_'28diff'7cOnly_in_'2e'2a'3a'29'2e'2a'24 = compileRegex "(diff|Only in .*:).*$"
regex_'5c'2a'5c'2a'5c'2a_'2e'2a_'5c'2a'5c'2a'5c'2a'5c'2a'24 = compileRegex "\\*\\*\\* .* \\*\\*\\*\\*$"
regex_'5c'2d'5c'2d'5c'2d_'2e'2a_'5c'2d'5c'2d'5c'2d'5c'2d'24 = compileRegex "\\-\\-\\- .* \\-\\-\\-\\-$"

parseRules ("Diff","Normal") =
  (((pColumn 0 >> pRegExpr regex_'28'5c'40'5c'40'7c'5cd'29'2e'2a'24 >>= withAttribute DataTypeTok) >>~ pushContext ("Diff","Chunk"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'2a'2b'24 >>= withAttribute DataTypeTok) >>~ pushContext ("Diff","RChunk"))
   <|>
   ((pColumn 0 >> pRegExpr regex_Only_in_'2e'2a'3a'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_diff'2e'2a'24 >>= withAttribute KeywordTok) >>~ pushContext ("Diff","RFile"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'3d'3d'3d'3d'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'5c'2a'5c'2a'5c'2a'7c'5c'2d'5c'2d'5c'2d'29'2e'2a'24 >>= withAttribute KeywordTok) >>~ pushContext ("Diff","File"))
   <|>
   ((parseRules ("Diff","FindDiff")))
   <|>
   ((pColumn 0 >> pDetectChar False '!' >>= withAttribute NormalTok) >>~ pushContext ("Diff","ChangedOld"))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","FindDiff") =
  (((pColumn 0 >> pRegExpr regex_'5c'2d'5c'2d'5c'2d'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'5c'2b'5c'2b'5c'2b'7c'5c'2d'5c'2d'5c'2d'29'2e'2a'24 >>= withAttribute DataTypeTok))
   <|>
   ((pColumn 0 >> pAnyChar "+>" >>= withAttribute OtherTok) >>~ pushContext ("Diff","Added"))
   <|>
   ((pColumn 0 >> pAnyChar "-<" >>= withAttribute StringTok) >>~ pushContext ("Diff","Removed"))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","FindDiff")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","File") =
  (((parseRules ("Diff","FindDiff")))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'5c'40'5c'40'7c'5cd'29'2e'2a'24 >>= withAttribute DataTypeTok) >>~ pushContext ("Diff","ChunkInFile"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'2a'2b'24 >>= withAttribute DataTypeTok) >>~ pushContext ("Diff","RChunkInFile"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'3d'3d'3d'3d'7c'5c'2a'5c'2a'5c'2a'7c'5c'2d'5c'2d'5c'2d'7cdiff'7cOnly_in_'2e'2a'3a'29'2e'2a'24 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pDetectChar False '!' >>= withAttribute StringTok) >>~ pushContext ("Diff","ChangedOld"))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","File")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","Chunk") =
  (((parseRules ("Diff","FindDiff")))
   <|>
   ((pColumn 0 >> lookAhead (pRegExpr regex_'28'5c'40'5c'40'7c'5cd'29'2e'2a'24) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pColumn 0 >> pDetectChar False '!' >>= withAttribute StringTok) >>~ pushContext ("Diff","ChangedOld"))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","Chunk")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","ChunkInFile") =
  (((parseRules ("Diff","FindDiff")))
   <|>
   ((pColumn 0 >> lookAhead (pRegExpr regex_'28'5c'40'5c'40'7c'5cd'29'2e'2a'24) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pColumn 0 >> pRegExpr regex_Index'3a'2e'2a >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> lookAhead (pRegExpr regex_'28'3d'3d'3d'3d'7c'5c'2a'5c'2a'5c'2a'7c'5c'2d'5c'2d'5c'2d'7cdiff'7cOnly_in_'2e'2a'3a'29'2e'2a'24) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pColumn 0 >> pDetectChar False '!' >>= withAttribute StringTok) >>~ pushContext ("Diff","ChangedOld"))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","ChunkInFile")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","RFile") =
  (((pColumn 0 >> lookAhead (pRegExpr regex_'28diff'7cOnly_in_'2e'2a'3a'29'2e'2a'24) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'3d'3d'3d'3d'7c'5c'2a'5c'2a'5c'2a'7c'5c'2d'5c'2d'5c'2d'7cdiff'7cOnly_in_'2e'2a'3a'29'2e'2a'24 >>= withAttribute DataTypeTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'2a'2b'24 >>= withAttribute DataTypeTok) >>~ pushContext ("Diff","RChunkInFile"))
   <|>
   ((parseRules ("Diff","File")))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","RFile")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","RChunk") =
  (((pColumn 0 >> pRegExpr regex_'5c'2a'5c'2a'5c'2a_'2e'2a_'5c'2a'5c'2a'5c'2a'5c'2a'24 >>= withAttribute DataTypeTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'2d'5c'2d'5c'2d_'2e'2a_'5c'2d'5c'2d'5c'2d'5c'2d'24 >>= withAttribute DataTypeTok) >>~ pushContext ("Diff","RChunkNew"))
   <|>
   ((parseRules ("Diff","Chunk")))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","RChunk")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","RChunkInFile") =
  (((pColumn 0 >> pRegExpr regex_'5c'2a'5c'2a'5c'2a_'2e'2a_'5c'2a'5c'2a'5c'2a'5c'2a'24 >>= withAttribute DataTypeTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'2d'5c'2d'5c'2d_'2e'2a_'5c'2d'5c'2d'5c'2d'5c'2d'24 >>= withAttribute DataTypeTok) >>~ pushContext ("Diff","RChunkInFileNew"))
   <|>
   ((parseRules ("Diff","ChunkInFile")))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","RChunkInFile")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","RChunkNew") =
  (((pColumn 0 >> lookAhead (pRegExpr regex_'28'5c'40'5c'40'7c'5cd'29'2e'2a'24) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((pColumn 0 >> pDetectChar False '!' >>= withAttribute OtherTok) >>~ pushContext ("Diff","ChangedNew"))
   <|>
   ((parseRules ("Diff","FindDiff")))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","RChunkNew")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","RChunkInFileNew") =
  (((pColumn 0 >> lookAhead (pRegExpr regex_'28'5c'40'5c'40'7c'5cd'29'2e'2a'24) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((pColumn 0 >> lookAhead (pRegExpr regex_'28'3d'3d'3d'3d'7c'5c'2a'5c'2a'5c'2a'7c'5c'2d'5c'2d'5c'2d'7cdiff'7cOnly_in_'2e'2a'3a'29'2e'2a'24) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((pColumn 0 >> pDetectChar False '!' >>= withAttribute OtherTok) >>~ pushContext ("Diff","ChangedNew"))
   <|>
   ((parseRules ("Diff","FindDiff")))
   <|>
   (currentContext >>= \x -> guard (x == ("Diff","RChunkInFileNew")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Diff","File") =
  (currentContext >>= \x -> guard (x == ("Diff","File")) >> pDefault >>= withAttribute KeywordTok)

parseRules ("Diff","Removed") =
  (currentContext >>= \x -> guard (x == ("Diff","Removed")) >> pDefault >>= withAttribute StringTok)

parseRules ("Diff","Added") =
  (currentContext >>= \x -> guard (x == ("Diff","Added")) >> pDefault >>= withAttribute OtherTok)

parseRules ("Diff","ChangedOld") =
  (currentContext >>= \x -> guard (x == ("Diff","ChangedOld")) >> pDefault >>= withAttribute StringTok)

parseRules ("Diff","ChangedNew") =
  (currentContext >>= \x -> guard (x == ("Diff","ChangedNew")) >> pDefault >>= withAttribute OtherTok)


parseRules x = parseRules ("Diff","Normal") <|> fail ("Unknown context" ++ show x)
