{- This module was generated from data in the Kate syntax
   highlighting file mandoc.xml, version 0.11, by Matthew Woehlke (mw_triad@users.sourceforge.net) -}

module Text.Highlighting.Kate.Syntax.Mandoc
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Troff Mandoc"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.1;*.2;*.3;*.4;*.5;*.6;*.7;*.8;*.1m;*.3x;*.tmac"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Troff Mandoc","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Troff Mandoc","Normal") -> return ()
      ("Troff Mandoc","DetectDirective") -> (popContext) >> pEndLine
      ("Troff Mandoc","Directive") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_headings = Set.fromList $ words $ "SH SS TH"
list_paragraph = Set.fromList $ words $ "HP IP LP P PD PP RE RS TP"
list_formatting = Set.fromList $ words $ "B BI BR I IB IR RB RI SM SB"
list_others = Set.fromList $ words $ "DT"


parseRules ("Troff Mandoc","Normal") =
  (((parseRules ("Troff Mandoc","DetectComments##Roff")))
   <|>
   ((pColumn 0 >> pDetectChar False '.' >>= withAttribute FunctionTok) >>~ pushContext ("Troff Mandoc","DetectDirective"))
   <|>
   ((parseRules ("Troff Mandoc","DetectOthers##Roff")))
   <|>
   (currentContext >>= \x -> guard (x == ("Troff Mandoc","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Troff Mandoc","DetectDirective") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_headings >>= withAttribute KeywordTok) >>~ pushContext ("Troff Mandoc","Directive"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_paragraph >>= withAttribute DataTypeTok) >>~ pushContext ("Troff Mandoc","Directive"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_formatting >>= withAttribute KeywordTok) >>~ pushContext ("Troff Mandoc","Directive"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_others >>= withAttribute FunctionTok) >>~ pushContext ("Troff Mandoc","Directive"))
   <|>
   ((parseRules ("Troff Mandoc","DetectDirective##Roff")))
   <|>
   (currentContext >>= \x -> guard (x == ("Troff Mandoc","DetectDirective")) >> pDefault >>= withAttribute FunctionTok))

parseRules ("Troff Mandoc","Directive") =
  (((parseRules ("Troff Mandoc","Directive##Roff")))
   <|>
   (currentContext >>= \x -> guard (x == ("Troff Mandoc","Directive")) >> pDefault >>= withAttribute StringTok))


parseRules x = parseRules ("Troff Mandoc","Normal") <|> fail ("Unknown context" ++ show x)
