{- This module was generated from data in the Kate syntax
   highlighting file modula-2.xml, version 1.03, by  -}

module Text.Highlighting.Kate.Syntax.Modula2
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Modula-2"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.mod;*.def;*.mi;*.md"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Modula-2","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Modula-2","Normal") -> return ()
      ("Modula-2","String1") -> (popContext) >> pEndLine
      ("Modula-2","String2") -> (popContext) >> pEndLine
      ("Modula-2","Comment2") -> return ()
      ("Modula-2","Comment3") -> (popContext) >> pEndLine
      ("Modula-2","Prep1") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_directives = Set.fromList $ words $ "ASSEMBLER ALLOCATE DEALLOCATE SIZE Write WriteString WriteCard WriteLn WriteBf WriteInt WriteReal WriteLongReal Read ReadString ReadCard ReadInt ReadReal ReadLongReal Open Close OpenInput OpenOutput Accessible Erase EOF Done EmptyString Assign Append Length StrEq Copy Concat pos Delete Insert compare CAPS PutBf GetArgs GetEnv ResetClock UserTime SystemTime GetChar GetInt GetCard GetString GetReal GetLongReal PutChar PutInt PutCard PutString PutReal PutLongReal PutLn"
list_keywords = Set.fromList $ words $ "AND ARRAY ASM BEGIN CASE CONST DIV DO ELSE ELSIF END FOR IF IMPLEMENTATION IN SET INCL EXCL ABS BITSET CAP CHR DEC HALT HIGH INC MAX MIN ODD ORD PROC TRUNC VAL MOD NIL NOT OF OR PROCEDURE MODULE DEFINITION RECORD REPEAT THEN TO TYPE UNTIL LOOP VAR WHILE WITH EXIT FALSE TRUE BY FROM IMPORT EXPORT QUALIFIED RETURN NEWPROCESS TRANSFER IOTRANSFER FOREIGN"
list_types = Set.fromList $ words $ "INTEGER CARDINAL SHORTINT SHORTCARD LONGINT LONGREAL CHAR BOOLEAN POINTER ADDRESS ADR REAL File"


parseRules ("Modula-2","Normal") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_directives >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pFloat >>= withAttribute DecValTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Modula-2","String1"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Modula-2","String2"))
   <|>
   ((pString False "(*$" >>= withAttribute OtherTok) >>~ pushContext ("Modula-2","Prep1"))
   <|>
   ((pDetect2Chars False '(' '*' >>= withAttribute CommentTok) >>~ pushContext ("Modula-2","Comment2"))
   <|>
   (currentContext >>= \x -> guard (x == ("Modula-2","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Modula-2","String1") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Modula-2","String1")) >> pDefault >>= withAttribute StringTok))

parseRules ("Modula-2","String2") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Modula-2","String2")) >> pDefault >>= withAttribute StringTok))

parseRules ("Modula-2","Comment2") =
  (((pDetect2Chars False '*' ')' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Modula-2","Comment2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Modula-2","Comment3") =
  (currentContext >>= \x -> guard (x == ("Modula-2","Comment3")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Modula-2","Prep1") =
  (((pString False "$*)" >>= withAttribute OtherTok) >>~ pushContext ("Modula-2","Prep1"))
   <|>
   (currentContext >>= \x -> guard (x == ("Modula-2","Prep1")) >> pDefault >>= withAttribute OtherTok))


parseRules x = parseRules ("Modula-2","Normal") <|> fail ("Unknown context" ++ show x)
