{- This module was generated from data in the Kate syntax
   highlighting file hamlet.xml, version 0.1, by Bastian Holst (bastianholst@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Hamlet
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Haskell
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "Hamlet"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.hamlet"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Hamlet","Normal Text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Hamlet","Normal Text") -> (popContext) >> pEndLine
      ("Hamlet","element") -> return ()
      ("Hamlet","Logic") -> (popContext) >> pEndLine
      ("Hamlet","Code") -> return ()
      ("Hamlet","Codeline") -> (popContext) >> pEndLine
      ("Hamlet","Assignment") -> (popContext) >> pEndLine
      ("Hamlet","Attribute") -> return ()
      ("Hamlet","Value") -> return ()
      ("Hamlet","Value DQ") -> return ()
      ("Hamlet","Value SQ") -> return ()
      ("Hamlet","Value Code") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'3c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'5cb = compileRegex True "<(?![0-9])[\\w_:][\\w.:_-]*\\b"
regex_'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "(?![0-9])[\\w_:][\\w.:_-]*"
regex_'5cs'2b'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "\\s+(?![0-9])[\\w_:][\\w.:_-]*"
regex_'5c'2e'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "\\.(?![0-9])[\\w_:][\\w.:_-]*"
regex_'5cS = compileRegex True "\\S"
regex_'5b'5e'22'27'3e'5cs'5d'2b = compileRegex True "[^\"'>\\s]+"

parseRules ("Hamlet","Normal Text") =
  (((pRegExpr regex_'3c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","element"))
   <|>
   ((pString False "^{" >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Code"))
   <|>
   ((pString False "#{" >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Code"))
   <|>
   ((pString False "@{" >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Code"))
   <|>
   ((pString False "_{" >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Code"))
   <|>
   ((pFirstNonSpace >> pDetectChar False '$' >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Logic"))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Normal Text")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Hamlet","element") =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext ("Hamlet","Attribute"))
   <|>
   ((pRegExpr regex_'5cs'2b'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext ("Hamlet","Attribute"))
   <|>
   ((pRegExpr regex_'5c'2e'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","element")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("Hamlet","Logic") =
  (((pRegExpr (compileRegex True "\\bif\\b") >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Codeline"))
   <|>
   ((pRegExpr (compileRegex True "\\belseif\\b") >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Codeline"))
   <|>
   ((pRegExpr (compileRegex True "\\bforall\\b") >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Assignment"))
   <|>
   ((pRegExpr (compileRegex True "\\bmaybe\\b") >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Assignment"))
   <|>
   ((pRegExpr (compileRegex True "\\belse\\b") >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr (compileRegex True "\\bnothing\\b") >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Logic")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Hamlet","Code") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Haskell.parseExpression (Just ("Haskell",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Code")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Hamlet","Codeline") =
  (((Text.Highlighting.Kate.Syntax.Haskell.parseExpression (Just ("Haskell",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Codeline")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Hamlet","Assignment") =
  (((pString False "<-" >>= withAttribute OtherTok) >>~ pushContext ("Hamlet","Codeline"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Haskell.parseExpression (Just ("Haskell",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Assignment")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Hamlet","Attribute") =
  (((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("Hamlet","Value"))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Attribute")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Hamlet","Value") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Hamlet","Value DQ"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Hamlet","Value SQ"))
   <|>
   ((pString False "@{" >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Value Code"))
   <|>
   ((pString False "#{" >>= withAttribute KeywordTok) >>~ pushContext ("Hamlet","Value Code"))
   <|>
   ((pRegExpr regex_'5b'5e'22'27'3e'5cs'5d'2b >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Value")) >> pDefault >>= withAttribute StringTok))

parseRules ("Hamlet","Value DQ") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Value DQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("Hamlet","Value SQ") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Value SQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("Hamlet","Value Code") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Haskell.parseExpression (Just ("Haskell",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Hamlet","Value Code")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Haskell", _) = Text.Highlighting.Kate.Syntax.Haskell.parseExpression Nothing

parseRules x = parseRules ("Hamlet","Normal Text") <|> fail ("Unknown context" ++ show x)
