#
# used by hinfo, normally indirectly through /etc/hinfo.conf or ~/.hinforc
#
# Current version can be gotten from http://www.blars.org/hinfo/whois.ins.pl
#
#	20 Jun 2003	Another ripe pattern for arin blocks
#	15 May 2003	another pattern for lacnic in arin blocks
#	12 Apr 2003	60/8 to apnic, 223/8 back to arin
#	27 Mar 2003	133/8 is .jp, 82/8 is ripe, 43/8 .jp, 214/7 .mil
#	20 Feb 2003	Add two new apnic blocks (222, 223)
#	18 Feb 2003	Extra pattern for ripe in arin block
#	26 Nov 2002	Ripe "%" only lines
#			KOREAN not always preceaded by #
#	24 Oct 2002	Add copyright notice
#	15 Oct 2002	Ignore BRST as well as BRT
#	02 Oct 2002	Added @version
#
#
## This program is free software; you can redistribute it and/or modify
## it under the terms of the version 2 of the GNU General Public License 
## as published by the Free Software Foundation.  The license should
## be included in the file COPYING distributed with the source.
##

@version = (@version, "whois.ins.pl 20 Jun 2003");

# which registry to contact for IPs in x.0.0.0/8
# default to whois.arin.net
# simple word used as whois.WORD.net
%registrys = (
	6	=>	"whois.nic.mil",
	7	=>	"whois.nic.mil",
	11	=>	"whois.nic.mil",
	21	=>	"whois.nic.mil",
	26	=>	"whois.nic.mil",
	28	=>	"whois.nic.mil",
	29	=>	"whois.nic.mil",
	30	=>	"whois.nic.mil",
	33	=>	"whois.nic.mil",
        43	=>	"whois.nic.ad.jp",
	55	=>	"whois.nic.mil",
	60	=>	"apnic",
	61	=>	"apnic",
	62	=>	"ripe",
	80	=>	"ripe",
	81	=>	"ripe",
	82	=>	"ripe",
        133	=>	"whois.nic.ad.jp",
	193	=>	"ripe",
	194	=>	"ripe",
	195	=>	"ripe",
	200	=>	"lacnic",
	201	=>	"lacnic",
	202	=>	"apnic",
	203	=>	"apnic",
	210	=>	"apnic",
	211	=>	"apnic",
	212	=>	"ripe",
	213	=>	"ripe",
	214	=>	"whois.nic.mil",
	215	=>	"whois.nic.mil",
	217	=>	"ripe",
	218	=>	"apnic",
	219	=>	"apnic",
	220	=>	"apnic",
	221	=>	"apnic",
        222	=>	"apnic",
);

# refer to another whois server
# 

%refer = (
	"whois.arin.net" => [
		['APNIC', 'apnic'],
		['NET[A-Z0-9\\-]*-RIPE', 'ripe'],
		['NET-LACNIC', 'lacnic'],
		['whois\\.ripe\\.net', 'ripe'],
		['Transferred to LACNIC', 'lacnic'],
		['www\\.ripe\\.net\\/whois', 'ripe'],
	],
	"whois.apnic.net" => [
		['whois\\.telstra', 'telstra'],
		['whois\\.twnic\\.net', 'twnic'],
		['(?:whois\\.nic\\.ad\\.jp|jpnic)', 'whois.nic.ad.jp','','/e'],
		['whois\\.nic\\.or\\.kr', 'whois.nic.or.kr'],
	],
	"whois.lacnic.net" => [
		['whois\\.registro\\.br', 'whois.registro.br'],
	],
);


# multiline patterns omitted from whois output
# perl regular-expression options xiosg

$whoismltrash = '(?:^[\\200-\\377].+\\n\\#\\sENGLISH\\n|
\\n\\#?\\sKOREAN.*\\nKorea\\sNetwork\\sInformation[^\\n]+\\n
)';

# lines in the whois output matching the following pattern are not displayed
# perl regular-expression options xiomg are used

$whoistrash = '^(?:access\\ to|
	           by\\ (?:submitting|this\\ policy)|
		   Comment\\:\\s+\\*\\sRwhois\\ (?:information\\ on|
						   reassignment)|
		   Fax\\s*\\:\\s+\\.\\s*$|
		   for\\ relevant\\ information|
		   get\\ your|
		   handle,\\ shown|
		   If\\ the\\ above\\ contacts|
	           in(?:formation\\ and\\ whois\\.nic\\.mil|
		        etrev\\:\\s)|
		   KRNIC\\ is\\ not\\ ISP|
      	           the\\ (?:arin|data\\ in|domain\\ council)|
	           to\\ (?:optimize\\ query|single)|
		   this\\ (?:policy|query)|
	           network(?:\\ information\\:|
			     \\:Auth-Area\\:0\\.0\\.0\\.0\\/0|
			     \\:Class-Name\\:network)|
		   ns(?:erver|stat|lastaa)\\:\\s+|
	           please\\ (?:use\\ the|
			       see\\ the\\ following)|
		   policy\\ |
		   query\\:\\s+\\d|
	           register\\ your|
		   remarks\\:\\s+(?:allocat(?:ed\\ to\\ KRNIC|
					      ions\\ made\\ from\\ within)|
				    at\\ whois\\.registro\\.br\\ and|
				    Authoritative\\ information\\ regarding|
				    Contact\\ information\\ can\\ be|
				    find\\ assignment\\ information|
				    For\\ more\\ information|
				    http\\:\\/\\/whois\\.nic\\.or\\.kr|
				    If\\ you\\ would\\ like\\ to|
				    in(?:formation\\ in\\ detail|
					 \\ Korea\\ under)|
				    Japanese\\ output\\,\\ use\\ the|
				    (?:JP|KR|TW)
				      NIC(?:\\ Allocation\\ Block|
				    	    \\ is\\ the|
					    \\ whois\\ server\\ at|
					    \\.\\ To\\ obtain\\ more)|
				    output\\ query\\ whois\\ -h\\ whois\\.|
				    please\\ refer\\ to\\ the\\ KRNIC|
				    queried\\ at\\ whois\\.nic\\.ad\\.jp\\.|
				    Th(?:ese\\ addresses\\ have\\ been\\ |
					 e\\ KRNIC\\ Whois\\ Database|
				         is\\ (?:information\\ has\\ been\\ |
				    	         IP\\ address\\ space))|
				    whois\\ \\-h\\ whois\\.nic\\.or\\.kr|
				    \\*+$|
				    \\#+$)|
	           whois\\ HELP\\@whois\\.corenic\\.net|
	           \\%(?:\\s*$|
			 ok\\s*$|
			 rwhois\\ V-|
		         \\s+(?:and\\ (?:AS\\ numbers|
				         to\\ assist)|
			        By\\ submitting\\ a|
			        Copyright\\ (?:LACNIC|
				              registro\\.br)|
			        How\\ to\\ use\\ |
			        IP\\ and\\ AS\\ |
			        only\\ for\\ lawful|
		                Please\\ visit\\ http|
			        related\\ to\\ (?:AS|
				    	          domain)|
		                Rights\\ restricted\\ by|
		                See\\ http:\\/\\/www\\.ripe\\.net|
			        Th(?:e\\ data\\ below|
	                             e\\ objects\\ are\\ in|
		                     is\\ is\\ the\\ RIPE)|
			        Types\\ of\\ queries\\ are|
		                Upgrade\\ to\\ Whois|
		                Whois(?:\\ data\\ copyright|
			                \\.(?:lacnic\\.net|
				              registro\\.br)\\ accepts\\ only)|
			        20\\d\\d\\-\\d\\d\\-\\d\\d\\ \\d\\d\\:\\d\\d\\:\\d\\d\\ \\(BRS?T|
 			        \\[whois\\.apnic\\.net))|
		   \\#\\s+(?:ARIN\\sWhois\\sdatabase|
			     Enter\\s\\?\\sfor)|
		   \\[(?:Return\\ Date\\]\\s*$|
			 \\s(?:add.\\/e.\\ at\\ the|
			       JPNIC\\ \\&\\ JPRS\\ database\\ provides|
			       mation\\,\\ use|
			       use\\ is\\ restricted))|
		   \\-+$|
		   \\s+(?:database\\ last\\ updated|
			  \\*\\s(?:available\\ from\\ )?rwhois\\.\\S+\\s4321\\s*$)).*$';

