#include "defstore.h"
#ifndef __htmlh__
  #include "html.h"
#endif

#include <algorithm>

static const string g_first("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_");
static const string g_rest("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_");

map<TokenMap::Token,HTMLStream> DEFStore::m_store;

bool DEFStore::IsValidName(const string& name){
  string::const_iterator pos=name.begin();
  if(pos==name.end()) return false;
  if(*pos=='/') ++pos;
  if(pos==name.end()) return false;
  if((pos==name.end())||(find(g_first.begin(),g_first.end(),*pos)==g_first.end())) return false;
  ++pos;
  while(pos!=name.end()){
    if(find(g_rest.begin(),g_rest.end(),*pos)==g_rest.end()) return false;
    ++pos;
  }
  return true;
}

bool DEFStore::Exists(TokenMap::Token token){
  return (m_store.find(token)!=m_store.end());
}

HTMLStream* DEFStore::Find(TokenMap::Token token){
  return &((*m_store.find(token)).second);
}

bool DEFStore::Set(TokenMap::Token token,HTMLStream::iterator first,HTMLStream::iterator last){
  m_store[token].SetContent(first,last);
  return true;
}

void DEFStore::Delete(TokenMap::Token token){
  if(Exists(token)){
    m_store.erase(token);
  }
}
