#include "calendar.h"
#ifndef __htmlh__
  #include "../html.h"
#endif
#ifndef __parammaph__
  #include "../parammap.h"
#endif
#ifndef __errorh__
  #include "../error.h"
#endif
#ifndef __hitopcommandsh__
  #include "../hitopcommands.h"
#endif

#include <iostream>
#include <ctime>

static string monthnames[] = {"January","February","March","April","May","June","July","August","September","October","November","December"};
static string daynames[] = {"Sun","Mon","Tue","Wed","Thur","Fri","Sat"};

static dsoCalMod initmodule;

dsoCalMod::dsoCalMod() {
  RegisterPlugin("calendar",1);
};

void dsoCalMod::Init() {
  Plugin::SetNamespace("CALENDAR");
  Plugin::RegisterCommand("MONTH",&MONTH);
}

HTMLStream::iterator dsoCalMod::MONTH(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag) {
  int month=0,year=0;
  if (!paramMap.RetrieveNum("MONTH",month)) Error(*Cur,"MONTH must be set");
  --month;
  if (!paramMap.RetrieveNum("YEAR",year)) Error(*Cur,"YEAR must be set");
  if ((year<1970)||(year>2038)||(month<0)||(month>11)) {
    Error(*Cur,"Invalid Date. Must be a real date between 1970 and 2038");
  }
  tm buildtime;
  buildtime.tm_sec=0;
  buildtime.tm_min=0;
  buildtime.tm_hour=12;
  buildtime.tm_mday=1;
  buildtime.tm_mon=month;
  buildtime.tm_year=year-1900;
  buildtime.tm_isdst=0;
  mktime(&buildtime);
  int dim=31,dom,dow,weeknum,blanks;
  if ((month==8)||(month==3)||(month==5)||(month==10)) dim=30;
  if (month==1) {
    dim=28;
    if (0==year%4) {
      dim=29;
      if (0==year%100) {
        dim=28;
        if (0==year%400) {
          dim=29;
        }
      }
    }
  }
  ParamMap pmonth(paramMap),pweek(paramMap),pday(paramMap);
  pmonth["MONTH"]=IToS(month+1);
  pmonth["YEAR"]=IToS(year);
  pweek=pmonth;
  dom=0;
  dow=0;
  weeknum=1;
  string premonthfn,preweekfn,dayfn,emptyfn,postweekfn,postmonthfn;
  paramMap.Retrieve("PREMONTH",premonthfn);
  paramMap.Retrieve("PREWEEK",preweekfn);
  paramMap.Retrieve("EMPTYDAY",emptyfn);
  paramMap.Retrieve("DAY",dayfn);
  paramMap.Retrieve("POSTWEEK",postweekfn);
  paramMap.Retrieve("POSTMONTH",postmonthfn);
  pweek=pmonth;
  pday=pmonth;

  // handle the beginning of the month
  if (!premonthfn.empty()) {
    HitopCommands::UserEngine(stream,Cur,pmonth,premonthfn);
  } else {
    DefaultMonPreMon(stream,Cur,month,year);
  }

  //handle the blanks at the start of the month
  blanks = buildtime.tm_wday;
  if (!preweekfn.empty()) {
    pweek["EMPTY"]=IToS(blanks);
    pweek["WEEKNUM"]="1";
    HitopCommands::UserEngine(stream,Cur,pmonth,preweekfn);
  } else {
    DefaultMonPreWeek(stream,Cur,month,year);
  }
  if (!emptyfn.empty()) {
    for (;blanks>dow;dow++) {
      pday["WEEKDAY"]=IToS(dow);
      HitopCommands::UserEngine(stream,Cur,pday,emptyfn);
    }
  } else {
    for (;blanks>dow;dow++) {
      DefaultMonBlank(stream,Cur,dow);
    }
  }

  pweek["EMPTY"]="0";

  //do the month
  if (!dayfn.empty()) {
    for(dom=1;dom<=dim;++dom,++dow) {
      if (dow==7) {
        if(!postweekfn.empty()) {
          HitopCommands::UserEngine(stream,Cur,pmonth,postweekfn);
        } else {
          DefaultMonPostWeek(stream,Cur,weeknum,0);
        }
        ++weeknum;
        if(!preweekfn.empty()) {
          pweek["WEEKNUM"]=IToS(weeknum);
          HitopCommands::UserEngine(stream,Cur,pmonth,preweekfn);
        } else {
          DefaultMonPreWeek(stream,Cur,weeknum,0);
        }
        dow=0;
      }
      pday["WEEKDAY"]=IToS(dow);
      pday["DAY"]=IToS(dom);
      HitopCommands::UserEngine(stream,Cur,pday,dayfn);
    }
  } else {
    for(dom=1;dom<=dim;++dom,++dow) {
      if (dow==7) {
        if(!postweekfn.empty()) {
          HitopCommands::UserEngine(stream,Cur,pmonth,postweekfn);
        } else {
          DefaultMonPostWeek(stream,Cur,weeknum,0);
        }
        ++weeknum;
        if(!preweekfn.empty()) {
          pweek["WEEKNUM"]=IToS(weeknum);
          HitopCommands::UserEngine(stream,Cur,pmonth,preweekfn);
        } else {
          DefaultMonPreWeek(stream,Cur,weeknum,0);
        }
        dow=0;
      }
      DefaultMonDay(stream,Cur,dow,dom);
    }
  }

  //handle the blanks at the end of the month
  blanks = 6-dow;
  pday.erase("DAY");
  if (!emptyfn.empty()) {
    for (;6>=dow;dow++) {
      pday["WEEKDAY"]=IToS(dow);
      HitopCommands::UserEngine(stream,Cur,pday,emptyfn);
    }
  } else {
    for (;6>=dow;dow++) {
      DefaultMonBlank(stream,Cur,dow);
    }
  }
  if (!postweekfn.empty()) {
    pweek["EMPTY"]=IToS(blanks);
    pweek["WEEKNUM"]="1";
    HitopCommands::UserEngine(stream,Cur,pmonth,postweekfn);
  } else {
    DefaultMonPostWeek(stream,Cur,month,year);
  }

  //handle the end of the month
  if (!postmonthfn.empty()) {
    HitopCommands::UserEngine(stream,Cur,pmonth,postmonthfn);
  } else {
    DefaultMonPostMon(stream,Cur,month,year);
  }
  
  HTMLStream::iterator Next =Cur;
  ++Next;
  stream.m_stream.erase(Cur);
  return Next;
}

void dsoCalMod::DefaultMonPreMon(HTMLStream& stream,HTMLStream::iterator Cur,int month,int year) {
  stream.m_stream.insert(Cur,HTML(true,"TABLE"));
  stream.m_stream.insert(Cur,HTML(true,"TR"));
  stream.m_stream.insert(Cur,HTML(true,"TD COLSPAN='7' ALIGN='CENTER'"));
  stream.m_stream.insert(Cur,HTML(true,"B"));
  stream.m_stream.insert(Cur,HTML(false,monthnames[month]+' '+IToS(year)));
  stream.m_stream.insert(Cur,HTML(true,"/B"));
  stream.m_stream.insert(Cur,HTML(true,"/TD"));
  stream.m_stream.insert(Cur,HTML(true,"/TR"));
  stream.m_stream.insert(Cur,HTML(true,"TR"));
  for (int day=0; day<7; ++day) {
    stream.m_stream.insert(Cur,HTML(true,"TD"));
    stream.m_stream.insert(Cur,HTML(true,"SMALL"));
    stream.m_stream.insert(Cur,HTML(false,daynames[day]));
    stream.m_stream.insert(Cur,HTML(true,"/SMALL"));
    stream.m_stream.insert(Cur,HTML(true,"/TD"));
  }
  stream.m_stream.insert(Cur,HTML(true,"/TR"));
}

void dsoCalMod::DefaultMonPreWeek(HTMLStream& stream,HTMLStream::iterator Cur,int weeknum,int blanks) {
  stream.m_stream.insert(Cur,HTML(true,"TR"));
}

void dsoCalMod::DefaultMonPostWeek(HTMLStream& stream,HTMLStream::iterator Cur,int weeknum,int blanks) {
  stream.m_stream.insert(Cur,HTML(true,"/TR"));
}

void dsoCalMod::DefaultMonPostMon(HTMLStream& stream,HTMLStream::iterator Cur,int month,int year) {
  stream.m_stream.insert(Cur,HTML(true,"/TABLE"));
}

void dsoCalMod::DefaultMonDay(HTMLStream& stream,HTMLStream::iterator Cur,int dow,int day) {
  stream.m_stream.insert(Cur,HTML(true,"TD ALIGN='CENTER'"));
  stream.m_stream.insert(Cur,HTML(false,IToS(day)));
  stream.m_stream.insert(Cur,HTML(true,"/TD"));
}

void dsoCalMod::DefaultMonBlank(HTMLStream& stream,HTMLStream::iterator Cur,int dow) {
  stream.m_stream.insert(Cur,HTML(true,"TD ALIGN='CENTER'"));
  stream.m_stream.insert(Cur,HTML(false,"&nbsp;"));
  stream.m_stream.insert(Cur,HTML(true,"/TD"));
}

