// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.44 $
#include "hk_class.h"
#include "hk_report.h"
#include "hk_dsdatavisible.h"
#include "hk_drivermanager.h"
#include "hk_font.h"
#include "hk_presentation.h"
#include "hk_interpreter.h"
#include <cassert>

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#define VERSION UNKNOWN
#endif

#include <termios.h>
#include <sys/stat.h>
#include <locale.h>




hk_string hk_class::p_begintag_begin="<";
hk_string hk_class::p_begintag_end=">";
hk_string hk_class::p_endtag_begin="</";
hk_string hk_class::p_endtag_end=">";
hk_string hk_class::p_begintag="";
hk_string hk_class::p_endtag="";
hk_string hk_class::p_defaulttimeformat="h:m:s";
hk_string hk_class::p_defaultdateformat="D.M.Y";
hk_string hk_class::p_defaultdatetimeformat="D.M.Y h:m:s";
hk_string hk_class::p_locale="";
hk_string hk_class::p_defaultdriver="";
hk_string hk_class::p_emptytag="";
hk_string hk_class::p_emptytag_begin="<";
hk_string hk_class::p_emptytag_end="/>";
hk_class::enum_measuresystem hk_class::p_defaultmeasuresystem=hk_class::cm;

messagewindowtype* hk_class::p_warning=NULL;
yesno_dialogtype* hk_class::p_yesno=NULL;
translatefunctiontype* hk_class::p_translate=NULL;

bool    hk_class::p_showpedantic=true;
bool    hk_class::p_generaldebug=false;
bool    hk_class::p_runtime_only=false;

stringvalue_dialogtype* hk_class::p_stringvalue=NULL;

unsigned int hk_class::p_taglevel=0;

const char* line="========================================\n";

hk_class::hk_class()
{
#ifdef HK_DEBUG
    p_debug=false;
#endif
}


hk_class::~hk_class()
{
#ifdef HK_DEBUG
    hkdebug("hk_class::destructor");
#endif
}


#ifdef HK_DEBUG
void hk_class::hkclassname(const hk_string& n)
{
#ifdef HK_DEBUG
    hkdebug("hk_class::classname");
#endif

    p_classname=n;
}


hk_string hk_class::hkclassname(void)const
{
    return p_classname;

}


void hk_class::wanna_debug(bool d)
{
    p_debug=d;
}


bool hk_class::wanna_debug(void)const
{
    return p_debug;
}


void hk_class::hkdebug(const hk_string& d)const
{
    if (p_debug||p_generaldebug)
    {
        cerr <<"HKDebug: ";
        if (p_classname.size()>0) cerr<<p_classname;
        else cerr<<"Unknown classname";
        cerr<<" "<<d<<endl;
    }

}


void hk_class::hkdebug(const hk_string& d, const hk_string& e)const
{
    if (p_debug||p_generaldebug)
    {
        cerr <<"HKDebug: ";
        if (p_classname.size()>0) cerr<<p_classname;
        else cerr<<"Unknown classname";
        cerr<<" "<<d<<e<<endl;
    }

}


void hk_class::hkdebug(const hk_string& d,int i)const
{
    if (p_debug||p_generaldebug)
    {
        cerr <<"HKDebug: ";
        if (p_classname.size()>0) cerr<<p_classname;
        else cerr<<"Unknown classname";
        cerr<<" "<<d<<i<<endl;
    }

}


void hk_class::hkdebug(const hk_string& d,double i)const
{
    if (p_debug||p_generaldebug)
    {
        cerr <<"HKDebug: ";
        if (p_classname.size()>0) cerr<<p_classname;
        else cerr<<"Unknown classname";
        cerr<<" "<<d<<i<<endl;
    }

}
#endif

void hk_class::show_warningmessage(const hk_string& m)
{
    //cerr <<"m: lnge: "<<m.size()<<" wert: "<<m<<endl;
    if (m.size()==0 ||m=="\n"||m==" "||m=="\t") return;
    if (p_warning!=NULL)p_warning(m);
    else cerr <<m<<endl;
}


void hk_class::set_warningmessage(messagewindowtype* m)
{
    hk_class::p_warning=m;
}


void hk_class::set_translatefunction(translatefunctiontype* t)
{
    hk_class::p_translate=t;
}


bool hk_class::show_yesnodialog(const hk_string& m, bool default_value)
{
    if (!p_showpedantic)return default_value;
    if (p_yesno!=NULL) return p_yesno(m,default_value);
    cerr <<"\n"<<line<<hk_translate("Question:")<<endl<<line;
    cerr <<m<<endl;
    cerr <<hk_translate("n=No            all other keys = yes")<<endl<<line;

    hk_string i;
    cin >>i;
    if (i=="n"||i=="N") return false;
    else return true;

}


void hk_class::set_yesnodialog(yesno_dialogtype* d)
{

    p_yesno=d;
}


void hk_class::set_showpedantic(bool s)
{
    p_showpedantic=s;
}


#ifdef HK_DEBUG
void hk_class::set_generaldebug(bool d)
{

    p_generaldebug=d;
}
#endif

hk_string hk_class::hk_translate(const hk_string& t)
{
    if (p_translate==NULL) return t;
    else return p_translate(t);

}


hk_string  hk_class::show_stringvaluedialog(const hk_string& t)
{

    if (p_stringvalue!=NULL) return p_stringvalue(t);

    cerr <<endl<< t<<endl;
    hk_string i;
    getline(cin,i);
    return i;
}


void hk_class::set_stringvaluedialog(stringvalue_dialogtype* t)
{

    p_stringvalue=t;
}


void  hk_class::savedata(ostream& s)
{
}


void  hk_class::loaddata(const hk_string& definition)
{

}


bool hk_class::get_tagvalue(const hk_string &where,const hk_string &tag, hk_string &value, int position,enum_tagtype tagtype)
{
    unsigned long beginposition=0;
    unsigned long endposition=0;
    int counter=0;
    if (position<1)
    {
     assert(position>0);
     position=1;
    }
    set_tag(tag);
    while(counter<position)
    {
       unsigned long tagposition=where.find(p_begintag,beginposition);
       unsigned long emptytagposition=where.find(p_emptytag,beginposition);
       if (emptytagposition<tagposition)
       {//handle emptytag
	beginposition=emptytagposition+p_emptytag.size();
	if (counter==position-1)
	{
	  value="";
	  return true;
	}
       }
       else
       {//handle normal tag
	beginposition=tagposition;
        if (beginposition>where.size())return false;
        beginposition+=p_begintag.size();
       }
	counter++;
    }
    bool res=true;
    endposition=where.find(p_endtag,beginposition);
    if (endposition>where.size())res=false;
    value.assign(where,beginposition,endposition-beginposition);
    if (tagtype==normaltag)
    {
     value=replace_all("&lt;",value,"<");
     value=replace_all("&amp;",value,"&");
    }
    return res;

}


bool hk_class::get_tagvalue(const hk_string &where, const hk_string &tag, unsigned long &value, int position)
{
    hk_string v;
    bool r=get_tagvalue(where,tag,v,position);
    if (r) value=atoi(v.c_str());
    return r;
}


bool hk_class::get_tagvalue(const hk_string &where, const hk_string &tag, unsigned int &value, int position)
{
    hk_string v;
    bool r=get_tagvalue(where,tag,v,position);
    if (r) value=atoi(v.c_str());
    return r;
}


bool hk_class::get_tagvalue(const hk_string &where, const hk_string &tag, long &value, int position)
{
    hk_string v;
    bool r=get_tagvalue(where,tag,v,position);
    if (r) value=atoi(v.c_str());
    return r;
}


bool hk_class::get_tagvalue(const hk_string &where, const hk_string &tag, int &value, int position)
{
    hk_string v;
    bool r=get_tagvalue(where,tag,v,position);
    if (r) value=atoi(v.c_str());
    return r;
}


bool hk_class::get_tagvalue(const hk_string &where, const hk_string &tag, bool &value, int position)
{
    hk_string v;
    bool r=get_tagvalue(where,tag,v,position);
    if (r) value=(v=="YES");

    return r;

}


void hk_class::set_tagvalue(ostream& stream,const hk_string& tag,const hk_string& value)
{
#ifdef HK_DEBUG
//  cout <<"hk_class::set_tagvalue "<<tag<<endl;
//  p_generaldebug=true;
#endif

    set_tag(tag);
    set_levelspace(stream);
    if (value.size()==0)
    {//emptytag
	stream <<l2u(p_emptytag)<<endl;
	return;
    }
    hk_string v=replace_all("&",value,"&amp;");
    v=replace_all("<",v,"&lt;");
    stream << l2u(p_begintag)<<l2u(v)<<l2u(p_endtag)<<endl;
}


void hk_class::set_tagvalue(ostream& stream,const hk_string& tag,unsigned long value)
{
    set_tag(tag);
    set_levelspace(stream);
    stream << l2u(p_begintag)<<value<<l2u(p_endtag)<<endl;
}


void hk_class::set_tagvalue(ostream& stream,const hk_string& tag,unsigned int value)
{
    set_tag(tag);
    set_levelspace(stream);
    stream << l2u(p_begintag)<<value<<l2u(p_endtag)<<endl;
}


void hk_class::set_tagvalue(ostream& stream,const hk_string& tag,long value)
{
    set_tag(tag);
    set_levelspace(stream);
    stream << l2u(p_begintag)<<value<<l2u(p_endtag)<<endl;
}


void hk_class::set_tagvalue(ostream& stream,const hk_string& tag,int value)
{
    set_tag(tag);
    set_levelspace(stream);
    stream << l2u(p_begintag)<<value<<l2u(p_endtag)<<endl;
}


void hk_class::set_tagvalue(ostream& stream,const hk_string& tag,bool value)
{
    set_tag(tag);
    set_levelspace(stream);
    stream << l2u(p_begintag)<<l2u((value ?"YES":"NO"))<<l2u(p_endtag)<<endl;
}


void hk_class::set_tag(const hk_string& tag)
{
    p_begintag=p_begintag_begin+tag+p_begintag_end;
    p_endtag=p_endtag_begin+tag+p_endtag_end;
    p_emptytag=p_emptytag_begin+tag+p_emptytag_end;
}


void hk_class::start_mastertag(ostream& stream,const hk_string& tag)
{
    if (tag.size()>0)
    {
        set_levelspace(stream);
        stream <<p_begintag_begin<<tag<<p_begintag_end<<endl;
        p_taglevel++;
    }

}


void hk_class::end_mastertag(ostream& stream,const hk_string & tag)
{
    if (tag.size()>0)
    {
        if (p_taglevel>0)p_taglevel--;
        set_levelspace(stream);
        stream <<p_endtag_begin<<tag<<p_endtag_end<<endl;

    }
}


hk_string hk_class::defaultdateformat(void)
{
    return   p_defaultdateformat;
}


hk_string hk_class::defaulttimeformat(void)
{
    return p_defaulttimeformat;
}


hk_string hk_class::defaultdatetimeformat(void)
{
    return p_defaultdatetimeformat;
}


void hk_class::set_defaultdatetimeformat(const hk_string& tformat,const hk_string& dformat,const hk_string&dtformat)
{
    p_defaulttimeformat=tformat;
    p_defaultdateformat=dformat;
    p_defaultdatetimeformat=dtformat;

}


hk_string align2text(hk_visible::alignmenttype t)
{
    switch (t)
    {
        case hk_visible::alignright: return "RIGHT";
        case hk_visible::aligncenter: return "CENTER";
        default: return "LEFT";

    }

}


void hk_class::save_preferences(void)
{
    char* h= getenv("HOME");
    hk_string  p_classespath=(h==NULL?"/tmp":h);

    p_classespath +="/.hk_classes";
    mkdir (p_classespath.c_str(),S_IRUSR|S_IWUSR|S_IXUSR);
    hk_string p_filename =p_classespath+"/preferences";
    ofstream* s= new ofstream(p_filename.c_str());
    if (s==NULL)return;
    *s<<"<?xml version=\"1.0\" ?>\n"<<endl;
    start_mastertag(*s,"PREFERENCES");
    set_tagvalue(*s,"HK_VERSION",(hk_string)VERSION);
    start_mastertag(*s,"GENERAL");
    set_tagvalue(*s,"SHOWPEDANTIC",p_showpedantic);
    set_tagvalue(*s,"DRIVERPATH",hk_drivermanager::path());
    set_tagvalue(*s,"DEFAULTFONT",hk_font::defaultfontname());
    set_tagvalue(*s,"DEFAULTFONTSIZE",hk_font::defaultfontsize());
    set_tagvalue(*s,"DEFAULTTEXTALIGNMENT",align2text(hk_visible::defaulttextalignment()));
    set_tagvalue(*s,"DEFAULTNUMBERALIGNMENT",align2text(hk_visible::defaultnumberalignment()));
    set_tagvalue(*s,"MAXIMIZEDWINDOWS",hk_visible::open_maximized_windows());
    set_tagvalue(*s,"DEFAULTPRECISION",(long)hk_dsdatavisible::defaultprecision());
    set_tagvalue(*s,"DEFAULTTHOUSANDSSEPARATOR",hk_dsdatavisible::defaultuse_numberseparator());
    set_tagvalue(*s,"DEFAULTDRIVER",p_defaultdriver);
    set_tagvalue(*s,"DEFAULTSIZETYPE",(hk_string)(hk_presentation::defaultsizetype()==hk_presentation::relative?"RELATIVE":"ABSOLUTE"));
    set_tagvalue(*s,"MEASURESYSTEM",(hk_string)(p_defaultmeasuresystem==hk_class::cm?"CM":"INCH"));
    set_tagvalue(*s,"SNAP2GRIDX",hk_presentation::snap2gridx());
    set_tagvalue(*s,"SNAP2GRIDY",hk_presentation::snap2gridy());
    end_mastertag(*s,"GENERAL");

    start_mastertag(*s,"HK_REGIONAL");
    set_tagvalue(*s,"DEFAULTTIMEFORMAT",p_defaulttimeformat);
    set_tagvalue(*s,"DEFAULTDATETIMEFORMAT",p_defaultdatetimeformat);
    set_tagvalue(*s,"DEFAULTDATEFORMAT",p_defaultdateformat);
    set_tagvalue(*s,"LOCALE",p_locale);
    end_mastertag(*s,"HK_REGIONAL");
    start_mastertag(*s,"REPORT");
    set_tagvalue(*s,"PRINTERCOMMAND",hk_report::printcommand());
    set_tagvalue(*s,"REPORTFONTENCODING",hk_report::fontencodingstring());
    end_mastertag(*s,"REPORT");
    end_mastertag(*s,"PREFERENCES");
    s->close();

}


bool hk_class::runtime_only(void)
{
    return p_runtime_only;
}


void hk_class::set_levelspace(ostream& stream)
{
    if (stream==NULL) return;

    unsigned int l=p_taglevel;

    while (l>0)
    {
        stream <<"  ";
        l--;
    }

}


void hk_class::set_locale(const hk_string& locale)
{
    if (!setlocale(LC_ALL,locale.c_str()))
    {
        show_warningmessage(hk_translate("Warning! Your local charset could not be set!"));
    }
    else
{
            setlocale(LC_NUMERIC,"C");
            setlocale(LC_MONETARY,"C");
      	    p_locale=locale;
}
}


hk_string hk_class::locale(void)
{
    return p_locale;
}


void hk_class::set_defaultdriver(const hk_string& d)
{
    p_defaultdriver=d;
}


hk_string hk_class::defaultdriver(void)
{
    return p_defaultdriver;

}


void hk_class::set_measuresystem(enum_measuresystem m)
{
p_defaultmeasuresystem=m;
}


hk_class::enum_measuresystem hk_class::measuresystem(void)
{

return p_defaultmeasuresystem;
}

hk_interpreter* hk_class::new_interpreter(const hk_string& interpreter,hk_presentation* p)
{
hk_string i=string2lower(interpreter);
  #ifdef HAVE_PYTHON
if (i=="python")return new hk_pythoninterpreter(p);
#endif //HAVE_PYTHON
return new hk_no_interpreter(p);

}
