// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// Edited by Anirban Biswas <utpal@cal2.vsnl.net.in>
// This file is part of the hk_postgresqlclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include <hk_postgresqldatabase.h>
#include <hk_postgresqlconnection.h>
#include <hk_postgresqltable.h>
#include <hk_postgresqlresultquery.h>
#include <hk_postgresqlactionquery.h>
hk_postgresqldatabase::hk_postgresqldatabase(hk_postgresqlconnection* c):hk_database(c)
{
    p_postgresqlconnection=c;
}


hk_postgresqlconnection* hk_postgresqldatabase::connection(void)
{
    return p_postgresqlconnection;
}


void hk_postgresqldatabase::driver_specific_tablelist(void)
{
    unsigned int i;
    p_tablelist.erase(p_tablelist.begin(),p_tablelist.end());
    if (p_postgresqlconnection!=NULL)
    {

        if ( p_postgresqlconnection->connect())
        {
//pg_table where postgresql stores name of all the relations of a DB.
            PGresult* Res = PQexec(p_postgresqlconnection->dbhandler() , "SELECT tablename FROM pg_tables WHERE tablename!~'^pg_' ORDER BY tablename" );
            if (PQresultStatus(Res) == PGRES_TUPLES_OK)
            {
                for (i=0; i<PQntuples(Res);i++)
                {
                    p_tablelist.insert(p_tablelist.end(), PQgetvalue(Res ,i ,  0));
                }
            }
            PQclear(Res);
        }
    }
    sort(p_tablelist.begin(),p_tablelist.end());

}


hk_datasource* hk_postgresqldatabase::driver_specific_new_table(hk_presentation* p)
{
    return new hk_postgresqltable(this,p);
}


hk_datasource* hk_postgresqldatabase::driver_specific_new_resultquery(hk_presentation* p)
{
    hk_postgresqlresultquery *x;
    x = new hk_postgresqlresultquery(this , p);
    return x ;

}


hk_actionquery * hk_postgresqldatabase::driver_specific_new_actionquery(void)
{
    hk_postgresqlactionquery *a;
    a = new hk_postgresqlactionquery(this);
    return a;
}


bool hk_postgresqldatabase::driver_specific_select_db(void)
{

    PGconn *newconn;
    if (p_postgresqlconnection!=NULL)
    {
        p_postgresqlconnection->set_postgresdatabase(name());
        p_postgresqlconnection->driver_specific_disconnect();
        return p_postgresqlconnection->driver_specific_connect();
    }
    return false;

}


bool    hk_postgresqldatabase::driver_specific_rename_table(const hk_string& oldname,const hk_string& newname)
{
   hk_postgresqlactionquery* query=new hk_postgresqlactionquery(this);
  hk_string sql="ALTER TABLE "+query->identifierdelimiter()+oldname+query->identifierdelimiter()+" RENAME TO "+query->identifierdelimiter()+newname+query->identifierdelimiter();
   query->set_sql(sql.c_str(),sql.size());
   bool res=query->execute();
   delete query;
   return res;

}




