// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_sqliteclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_sqlitedatasource.h"
#include "hk_sqlitedatabase.h"
#include "hk_sqliteconnection.h"
#include "hk_sqlitecolumn.h"
#include "hk_sqliteactionquery.h"
#include <sqlite.h>
#include <exception>
#include <new>

hk_sqlitedatasource::hk_sqlitedatasource(hk_sqlitedatabase* d,hk_presentation* p):hk_storagedatasource(d,p)
{
#ifdef HK_DEBUG
//wanna_debug(true);
    hkdebug("hk_sqlitedatasource::constructor");
#endif
   vm=0;
   data=0;
   colnums=0;
   colnames=0;
    p_sqlitedatabase=d;
    p_actionquery=new hk_sqliteactionquery(d);
    p_enabled=false;
}


hk_sqlitedatasource::~hk_sqlitedatasource()
{
#ifdef HK_DEBUG
    hkdebug("hk_sqlitedatasource::destructor");
#endif
    if (accessmode()!=standard &&is_enabled()) driver_specific_batch_disable();
}


list<hk_column*>* hk_sqlitedatasource::driver_specific_columns(void)
{
#ifdef HK_DEBUG
                                                  //cout <<"hk_sqlitedatasource::driver_specific_columns"<<endl;
    hkdebug("hk_sqlitedatasource::driver_specific_columns");
#endif
    if (p_columns==NULL&&type()==ds_table&&p_name.size()>0&&p_sqlitedatabase->dbhandler())
    {
	char* errormsg=0;
        hk_string s="SELECT * FROM '"  +p_name+"' WHERE 0=1"; 
	vm=0;
	int result= sqlite_compile(p_sqlitedatabase->dbhandler() ,s.c_str(),0,&vm,&errormsg );
	if (result!=SQLITE_OK)
	{ //cerr <<"type="<<type()<<endl;
          p_sqlitedatabase->sqliteconnection()->servermessage(errormsg);
	  sqlite_freemem(errormsg);
	  errormsg=0;
	  cerr<< "driver_specific_columns compile problem"<<s<<endl;
	  return p_columns;
	}
            
	colnums=0;
	data=0;
	colnames=0;
	if (vm)
	{
	result=sqlite_step(vm,&colnums,&data,&colnames);
	}
	
	
        driver_specific_create_columns();
	sqlite_finalize(vm,&errormsg);
	vm=0;
	if (result==SQLITE_ERROR) 
        {
	  p_sqlitedatabase->sqliteconnection()->servermessage(errormsg);
	  sqlite_freemem(errormsg);
	  errormsg=0;
  	}  

    }
    return p_columns;

}


bool hk_sqlitedatasource::driver_specific_create_columns(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_sqlitedatasource::driver_specific_create_columns");
#endif
  clear_columnlist();
  p_columns=new list<hk_column*>;

if (!colnames) return false;
        int z = 0;                                //counting the fieldnumbers
   for(int i=0;i<colnums;++i)
   {
    hk_sqlitecolumn *col= new hk_sqlitecolumn(this,p_true,p_false);
    col->set_fieldnumber(z++);
    col->set_name(colnames[i]);
    //cerr <<colnames[i]<<"("<<colnames[colnums+i]<<")"<<endl;
    hk_string coltype=string2lower(colnames[colnums+i]);
    hk_column::enum_columntype ct=hk_column::textcolumn;
    int cs=255;
    
    if (coltype.find("smallint")!=hk_string::npos)
    {
      ct=hk_column::smallintegercolumn;
    }
    else
    if (coltype.find("int")!=hk_string::npos)
    {
      ct=hk_column::integercolumn;
      
      if (internal_is_autoinc_column(col->name()))
      {
        ct=hk_column::auto_inccolumn;
	col->set_primary(true);
	p_primary_key_used=true;
      }
     } 
  //   delete r;

    //}
    else
    if (coltype.find("smallfloat")!=hk_string::npos)
    {
      ct=hk_column::smallfloatingcolumn;
    }
    else
    if (coltype.find("float")!=hk_string::npos)
    {
      ct=hk_column::floatingcolumn;
    }
    else
    if (coltype.find("real")!=hk_string::npos)
    {
      ct=hk_column::floatingcolumn;
    }
    else
    if (coltype.find("numeric")!=hk_string::npos)
    {
      ct=hk_column::floatingcolumn;
    }
    else
    if (coltype.find("decimal")!=hk_string::npos)
    {
      ct=hk_column::floatingcolumn;
    }
    else
    if (coltype.find("memo")!=hk_string::npos)
    {
       ct=hk_column::memocolumn;
       cs=100000;
    }
    else
    if (coltype.find("blob")!=hk_string::npos)
    {
       ct=hk_column::binarycolumn;
       cs=100000;
    }
    else
    if (coltype.find("binary")!=hk_string::npos)
    {
       ct=hk_column::binarycolumn;
       cs=100000;
    }
    else
    if (coltype.find("bool")!=hk_string::npos)
    {
       ct=hk_column::boolcolumn;
       cs=1;
    }
    else
    if (coltype.find("datetime")!=hk_string::npos)
    {
       ct=hk_column::datetimecolumn;
    }
    else
    if (coltype.find("time")!=hk_string::npos)
    {
       ct=hk_column::timecolumn;
    
    }
    else
    if (coltype.find("date")!=hk_string::npos)
    {
       ct=hk_column::datecolumn;
    
    }
    
    
    
    
    p_columns->insert(p_columns->end(),col);
    col->set_columntype(ct);
    col->set_size(cs);
 

   }
   return true;
}




bool hk_sqlitedatasource::driver_specific_enable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_sqlitedatasource::driver_specific_enable");
#endif
   if (p_print_sqlstatements)   print_sql();
    if (!p_enabled)
    {
        if  (!p_sqlitedatabase||!p_sqlitedatabase->dbhandler()) 
	 {
	  cerr <<"error p_sqlitedatabase==NULL||p_sqlitedatabase->dbhandler()"<<endl;
	  cerr <<"db="<<p_sqlitedatabase<<" handler="<<p_sqlitedatabase->dbhandler()<<endl;
	  return false;
	 } 
        vm=0;
        if (accessmode()==batchwrite)
        {
            clear_columnlist();
            driver_specific_create_columns();
            return true;
        }
	char* errormsg=0;
	int result= sqlite_compile(p_sqlitedatabase->dbhandler() ,p_sql.c_str(),0,&vm,&errormsg );
	if (result!=SQLITE_OK)
	{
          p_sqlitedatabase->sqliteconnection()->servermessage(errormsg);
	  sqlite_freemem(errormsg);
	  errormsg=0;
	  cerr<< "driver_specific_enable compile problem"<<endl;print_sql();
	  return false;
	}
            
	colnums=0;
	data=0;
	colnames=0;
	if (vm)
	{
	while ((result=sqlite_step(vm,&colnums,&data,&colnames))==SQLITE_ROW)
	{ 
          struct_raw_data* datarow=new struct_raw_data[colnums];
	   for (int col=0;col<colnums;++col)
	   {
            //neue Datenzeile erzeugen
              datarow[col].length=(data[col]?strlen(data[col])+1:0); 
              char* dt=NULL;
              //leave NULL pointer if there is no data
              if (data[col])
	       {
	       dt=new char[datarow[col].length];
               strcpy(dt,data[col]);
	       }
		
//	       for (unsigned int tk=0;tk<datarow[col].length;tk++) dt[tk]=data[col][tk];
              datarow[col].data=dt;
	   }
//Daten speichern
	insert_data(datarow);
        }
       driver_specific_create_columns();
	
	sqlite_finalize(vm,&errormsg);
	vm=0;
	if (result==SQLITE_ERROR) 
        {
	  p_sqlitedatabase->sqliteconnection()->servermessage(errormsg);
	  sqlite_freemem(errormsg);
	  errormsg=0;
         return false;
	}  
	}
	    
   }
   return true;	    
}




hk_column* hk_sqlitedatasource::driver_specific_new_column(void)
{
#ifdef HK_DEBUG
    hkdebug("driver_specific_new_column");
#endif
    hk_column* col=new hk_sqlitecolumn(this,p_true,p_false);

    return col;
}


bool hk_sqlitedatasource::driver_specific_insert_data(void)
{
    
    hk_string new_autoinc;

    struct_raw_data* datarow=new struct_raw_data[p_columns->size()];
    list<hk_column*>::iterator col_it;
    col_it=p_columns->begin();
    unsigned int spalte=0;
    while (spalte<p_columns->size())
    {
        const struct_raw_data* changed_data=(*col_it)->changed_data();
        if ((*col_it)->columntype()==hk_column::auto_inccolumn)
        {
            new_autoinc=format_number(sqlite_last_insert_rowid(p_sqlitedatabase->dbhandler()),false);
            const int bsize=new_autoinc.size()+1;
            char* data=new char[bsize];
            strcpy(data,new_autoinc.c_str());
            datarow[spalte].data=data;
            datarow[spalte].length=strlen(data);
        }
        else
        {                                         //not a autoinc column
            datarow[spalte].length=changed_data->length;;
            char* data=NULL;
            if (changed_data->data)
            {
                data=new char[datarow[spalte].length];
                for (unsigned int tk=0;tk<datarow[spalte].length;tk++) data[tk]=changed_data->data[tk];
            }
            datarow[spalte].data=data;
        }
        spalte++;
        col_it++;
    }
    insert_data(datarow);
    return true;
}


hk_sqliteconnection* hk_sqlitedatasource::sqliteconnection(void)
{
    return p_sqlitedatabase->connection();

}


bool hk_sqlitedatasource::driver_specific_batch_enable(void)
{
   p_counter=0;
   if (p_print_sqlstatements)   print_sql();
    if (!p_enabled)
    {
        if  (!p_sqlitedatabase||!p_sqlitedatabase->dbhandler()) 
	 {
	  cerr <<"error p_sqlitedatabase==NULL||p_sqlitedatabase->dbhandler()"<<endl;
	  cerr <<"db="<<p_sqlitedatabase<<" handler="<<p_sqlitedatabase->dbhandler()<<endl;
	  return false;
	 } 
        vm=0;
	char* errormsg=0;
	int result= sqlite_compile(p_sqlitedatabase->dbhandler() ,p_sql.c_str(),0,&vm,&errormsg );
	if (result!=SQLITE_OK)
	{
          p_sqlitedatabase->sqliteconnection()->servermessage(errormsg);
	  sqlite_freemem(errormsg);
	  errormsg=0;
	  cerr<< "driver_specific_enable compile problem"<<endl;print_sql();
	  return false;
	}
            
	colnums=0;
	data=0;
	colnames=0;
	if (vm)
	{
	result=sqlite_step(vm,&colnums,&data,&colnames);
       driver_specific_create_columns();
	if(result==SQLITE_ROW&& colnums>0)
	{
          struct_raw_data* datarow=new struct_raw_data[colnums];
	   for (int col=0;col<colnums;++col)
	   {
            //neue Datenzeile erzeugen
              datarow[col].length=(data[col]?strlen(data[col])+1:0); 
              char* dt=NULL;
              //leave NULL pointer if there is no data
              if (data[col])
	       {
	       dt=new char[datarow[col].length];
               strcpy(dt,data[col]);
	       }
		
//	       for (unsigned int tk=0;tk<datarow[col].length;tk++) dt[tk]=data[col][tk];
              datarow[col].data=dt;
	   }
//Daten speichern
        
	insert_data(datarow);
	set_maxrows(1);
	
       } 
	return true;
	}
	    
   }
   set_maxrows(0);
   return false;	    
}


bool hk_sqlitedatasource::driver_specific_batch_disable(void)
{
    delete_data();
    if (accessmode()==batchwrite) return true;
    char* errormsg=0;
    if (vm)
    {
    int result=	sqlite_finalize(vm,&errormsg);
	vm=0;
	if (result==SQLITE_ERROR) 
        {
	  p_sqlitedatabase->sqliteconnection()->servermessage(errormsg);
	  sqlite_freemem(errormsg);
	  errormsg=0;
         return false;
	}  
     }	
     data=0;
     colnames=0;
     colnums=0;
     vm=0;
    return true;
 }


bool hk_sqlitedatasource::driver_specific_batch_goto_next(void)
{
    if (hk_storagedatasource::driver_specific_batch_goto_next()) return true;
  	if (vm)
	{
	if (sqlite_step(vm,&colnums,&data,&colnames)==SQLITE_ROW)
	{ 
	  set_maxrows(max_rows()+1);
          struct_raw_data* datarow=new struct_raw_data[colnums];
 
	   for (int col=0;col<colnums;++col)
	   {
            //neue Datenzeile erzeugen
              datarow[col].length=(data[col]?strlen(data[col])+1:0); 
              char* dt=NULL;
              //leave NULL pointer if there is no data
              if (data[col])
	       {
	       dt=new char[datarow[col].length];
               strcpy(dt,data[col]);
	       }
		
              datarow[col].data=dt;
	   }
//Daten speichern
	insert_data(datarow);
 	  ++p_counter;
	return true;
        }
	else
	 {
           char* errormsg=0;
           int result=	sqlite_finalize(vm,&errormsg);
	   vm=0;
	   if (result==SQLITE_ERROR) 
            {
	    p_sqlitedatabase->sqliteconnection()->servermessage(errormsg);
	    sqlite_freemem(errormsg);
	    errormsg=0;
            return false;
	   }  
	 }
       
       }
    return false;
}


bool hk_sqlitedatasource::internal_is_autoinc_column(const hk_string& column)
{
//cerr<< "hk_sqlitedatasource::internal_is_autoinc_column: "<<column<<endl;
sqlite_vm* tmpvm=0;
char* errormsg=0;
hk_string s="SELECT sql FROM sqlite_master WHERE type='table' AND name='"+name()+"'";
int result= sqlite_compile(p_sqlitedatabase->dbhandler() ,s.c_str(),0,&tmpvm,&errormsg );
if (result!=SQLITE_OK)
{
  p_sqlitedatabase->sqliteconnection()->servermessage(errormsg);
  sqlite_freemem(errormsg);
  errormsg=0;
  cerr<< "internal_is_autoinc_column compile problem"<<endl;print_sql();
  return false;
}
            
int tmpcolnums=0;
const char** tmpdata=0;
const char** tmpcolnames=0;
bool r=false;
if (vm)
{//cerr <<"vor sqlite_step"<<endl;
result=sqlite_step(tmpvm,&tmpcolnums,&tmpdata,&tmpcolnames);
//cerr<<"sqlite_step result="<<result<<endl;
hk_string createsql;
if (tmpcolnums==1&&result==SQLITE_ROW)
{
createsql=tmpdata[0];
//cerr <<"createsql="<<createsql<<endl;
list<hk_string> tokens;
tokenize(tokens,createsql);
list<hk_string>::iterator it=tokens.begin();
int count=0;
hk_string field;
bool fieldset=false;
//cerr <<"jetzt werden die tokens gezhlt..."<<endl;
while (it!=tokens.end()&&!r)
{
//cerr<<"    token:"<<*it<<endl;
if (!fieldset && count==0) 
  {
   field=*it;
   fieldset=true;
//   cerr <<"Feldset="<<field;
  } 
else
 {
   if (count==0 && string2lower(*it)=="integer") { ++count;/*cerr<<"integer"<<endl;*/}
   else
   if (count==1 && string2lower(*it)=="primary") {++count;/*cerr<<"primary"<<endl;*/}
   else
   if (count==2 && string2lower(*it)=="key")
      {
         r=(field==column);
	 //cerr <<"key "<<field<<"=="<<column<<" r:"<<r<<endl;
      }
   else
   {
   field=*it;
   fieldset=true;
   //cerr <<"Feldset2="<<field;
      count=0;
   }
 }

++it;
}
}
sqlite_finalize(tmpvm,&errormsg);
tmpvm=0;
if (result==SQLITE_ERROR) 
       {
	  p_sqlitedatabase->sqliteconnection()->servermessage(errormsg);
	  sqlite_freemem(errormsg);
	  errormsg=0;
         return false;
	}  



}

return r;


}


void hk_sqlitedatasource::tokenize (list<hk_string> &container, hk_string const &in,
           const char * const delimiters)
{
    hk_string quotedtype;
    enum
    {
	S_START,S_IN_TEXT,S_IN_QUOTED
    } state=S_START;


    list<int> sizelist;

//parser begin
hk_string tag;
hk_string::size_type offset=0;

while (offset<=in.size())
{
	hk_string x(1,in[offset]);//cerr<<"x:"<<x<<endl;
	switch (state)
	{
	case S_START:   
//			cerr <<"S_START"<<endl;
			if (isspace(x[0])||x==","||x==";")
				{
				  //eat whitespaces
//				  cerr <<"EAT_WHITESPACE"<<endl;
				  break;
				}
			if (x==p_identifierdelimiter || x==p_sqltextdelimiter)
			{
				quotedtype=x;
				state=S_IN_QUOTED;
//				cerr<<"IS_DELIMITER CHANGE to S_IN_QUOTED"<<endl;
			}
			else 
			{
//			 cerr<<"CHANGE to S_IN_TEXT"<<endl;
			 state=S_IN_TEXT;
			} 
			if (tag.size()>0) 
			{
			    container.push_back(tag);
			    //cerr <<"add tag="<<x<<endl;
			}    
			if (state==S_IN_QUOTED) tag="";
			else
			tag=x;
			//cerr <<"tag="<<tag<<endl;
			break;

	case S_IN_TEXT:  //cerr <<"S_IN_TEXT"<<endl;
	                   {
			if (isspace(x[0])||x==","||x==";")
			{//cerr <<"IS_SPACE"<<endl;
				state=S_START;
			}
			else
			if (x==p_identifierdelimiter || x==p_sqltextdelimiter)
			{//cerr <<"IS delimiter change to S_IN_QUOTED";
				quotedtype=x;
				state=S_IN_QUOTED;
			}
			
			if (state!=S_IN_TEXT)
			{
    		        container.push_back(tag);
			    //cerr <<"add tag="<<x<<endl;
			
			if (state==S_IN_QUOTED)
			   { 
			    tag="";
			   } 
			if (state==S_START)
			{
			 tag="";
			}
			}

			else //state==S_IN_TEXT
			{
   			  tag+=x;//cerr<<"tag="<<tag<<endl;
			 }
			break;
			}
	case S_IN_QUOTED://cerr <<"S_IN_QUOTED"<<endl;
			if (x==quotedtype)
			   {//cerr <<"end QUOTED"<<endl;
				state=S_START;
				container.push_back(tag);
			    //cerr <<"add tag="<<x<<endl;
				tag="";
			   }
			else 
			{
			 tag+=x;
			 //cerr <<"tag="<<tag<<endl;
			} 
			break;
	}
	++offset;
}

/*cerr <<"tokenize ENDE: "<<in<<endl;
list<hk_string>::iterator it=container.begin();
while (it!=container.end())
 {
   cerr <<"token='"<<*it<<"'"<<endl;
   ++it;
 }
cerr <<"tokenize ENDE"<<endl;
*/ 
}	   
