// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_paradoxclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.5 $
#include "hk_paradoxtable.h"
#include "hk_paradoxdatabase.h"
#include "hk_actionquery.h"
#include "hk_datetime.h"
#include "hk_paradoxconnection.h"
#include "hk_paradoxdatabase.h"
#include "hk_url.h"
//#include <pxversion.h>

hk_paradoxtable::hk_paradoxtable(hk_paradoxdatabase* db,hk_presentation* p):hk_paradoxdatasource(db,p)

{
p_currow=0;
data=NULL;
cerr <<"PXLIB_MINOR_VERSION="<<PXLIB_MINOR_VERSION<<endl;
 p_readonly=true;//(PXLIB_MINOR_VERSION < 6);
cerr <<"p_readonly="<<p_readonly<<endl;

file=NULL;
}


hk_paradoxtable::~hk_paradoxtable()
{
if ( p_paradoxhandle )
{
if (data)p_paradoxhandle->free(p_paradoxhandle,data);
data=NULL;
        PX_close(p_paradoxhandle);
       	PX_delete(p_paradoxhandle);
       	p_paradoxhandle=NULL;
}
if (file) fclose(file);
file=NULL;

}


hk_datasource::enum_datasourcetypes hk_paradoxtable::type() const
{
    return ds_table;
}

bool hk_paradoxtable::driver_specific_enable(void)
{
     if (!datasource_open())
      {
       cerr<<"hk_paradoxtable::driver_specific_enable !datasource_open() !!!"<<endl;
       return false;
      }


        try
       {
 	 while (datasource_fetch_next_row())
	 {
	 }
       }
       catch (std::bad_alloc errormessage)
       {
         return true;
       }

      //dump_data();
      datasource_close();

return true;
}


bool hk_paradoxtable::driver_specific_disable()
{

if ( p_paradoxhandle )
{
if (data)p_paradoxhandle->free(p_paradoxhandle,data);
data=NULL;
        PX_close(p_paradoxhandle);
       	PX_delete(p_paradoxhandle);
       	p_paradoxhandle=NULL;
}
if (file) fclose(file);
file=NULL;
return hk_paradoxdatasource::driver_specific_disable();
}


bool hk_paradoxtable::datasource_open(void)
{
   if (p_print_sqlstatements)   print_sql();
   if (p_enabled) return true;
   if  (!p_paradoxdatabase->connection()->is_connected()) return false;
   p_currow=0;
   hk_url p_url=name();
   hk_url durl=p_paradoxdatabase->name();
   cerr <<"databasepath="<<durl.directory()<<endl;
   if (durl.directory().size()==0) durl=p_paradoxdatabase->database_path()+"/"+p_paradoxdatabase->name();
   hk_string n= p_url.directory().size()>0? p_url.directory(): durl.directory()+"/"+name()+".db";
   cerr <<"open: #"<<n<<"#"<<endl;
if ( p_paradoxhandle )
{
        PX_close(p_paradoxhandle);
       	PX_delete(p_paradoxhandle);
       	p_paradoxhandle=NULL;
}
   file=fopen(n.c_str(),"r+");
    p_paradoxhandle=PX_new2(errorhandler,NULL,NULL,NULL);
   if (PX_open_fp(p_paradoxhandle,file)<0)
   {
     show_warningmessage("Could not open file'"+n+"'");
     return false;
   }
   p_paradoxheader=p_paradoxhandle->px_head;
   if (p_paradoxheader)
   {
     //set_maxrows(p_paradoxheader->px_numrecords);
     p_codepage="CP"+longint2string(p_paradoxheader->px_doscodepage);
   }
   PX_set_tablename(p_paradoxhandle,smallstringconversion(name(),"",p_codepage).c_str());
   if (accessmode()==batchwrite)
        {
            clear_columnlist();
            driver_specific_create_columns();
            return true;
        }

  driver_specific_create_columns();


  return true;
}
bool hk_paradoxtable::datasource_fetch_next_row(void)
{
   if (!p_paradoxheader) return false;
   if (p_currow>=p_paradoxheader->px_numrecords)
 {
  return false;
 }
//  if (data) p_paradoxhandle->free(p_paradoxhandle,data);
 if (!data)
 data=(char*)p_paradoxhandle->malloc(p_paradoxhandle,p_paradoxheader->px_recordsize,"Allocate memory");
 if (!data) return false;
 int isdeleted=0;
 pxdatablockinfo_t pxdbinfo;
 if (!PX_get_record2(p_paradoxhandle,p_currow,data,&isdeleted,&pxdbinfo))
 {
  cerr <<"PX_get_record2 gibt NULL zurck"<<endl;
  return false;
 }
 int nf=p_paradoxheader->px_numfields;
 struct_raw_data* datarow=new struct_raw_data[nf];
   pxfield_t*pxf=p_paradoxheader->px_fields;
   int offset=0;
   bool binary=false;
   int binarysize=0;
   for (int f=0;f<nf;++f)
   {

               //create new data row
              char* value=NULL;
	      hk_string txt;
    switch(pxf->px_ftype)
    {
     case pxfLogical :
     		{char v;
     		if (PX_get_data_byte(p_paradoxhandle,&data[offset],pxf->px_flen,&v)<0)
	      {
	        cerr <<"booldata <0!"<<endl;
	        return false;
	      }

	       txt=v?"1":"0";
	       value=(char*)txt.c_str();//just as a dummy
	      break;}
     case pxfShort :
     		{short int v;
     		if (PX_get_data_short(p_paradoxhandle,&data[offset],pxf->px_flen,&v)<0)
	      {
	        cerr <<"short <0!"<<endl;
	        return false;
	      }

	       txt=longint2string(v);
	       value=(char*)txt.c_str();
	      break;}

     case pxfAutoInc :
     case pxfLong:
     		{long v;
     		if (PX_get_data_long(p_paradoxhandle,&data[offset],pxf->px_flen,&v)<0)
	      {
	        cerr <<"long <0!"<<endl;
	        return false;
	      }

	       txt=longint2string(v);
	       value=(char*)txt.c_str();
	      break;}

     case pxfCurrency:
     case pxfNumber:
     		{double v;
     		if (PX_get_data_double(p_paradoxhandle,&data[offset],pxf->px_flen,&v)<0)
	      {
	        cerr <<"long <0!"<<endl;
	        return false;
	      }

	       txt=format_standard_number(v);
	       value=(char*)txt.c_str();
	      break;}

     case pxfDate:
     		{long v;
     		  int year,month,day;
     		if (PX_get_data_long(p_paradoxhandle,&data[offset],pxf->px_flen,&v)<0)
	      {
	        cerr <<"long <0!"<<endl;
	        return false;
	      }
               PX_SdnToGregorian(v+1721425,&year,&month,&day);
	       hk_datetime dt;
	       dt.set_date(day,month,year);
	       txt=dt.date_asstring();
	       value=(char*)txt.c_str();
	      break;}

     case pxfTimestamp:
     		{double v;
     		if (PX_get_data_double(p_paradoxhandle,&data[offset],pxf->px_flen,&v)<0)
	      {
	        cerr <<"timestamp <0!"<<endl;
	        return false;
	      }

	       txt=PX_timestamp2string(p_paradoxhandle,v,"H:i:s d.m.Y");
	       value=(char*)txt.c_str();
	      break;}

     case pxfTime:
     		{long v;
     		  int h,m,s;
     		if (PX_get_data_long(p_paradoxhandle,&data[offset],pxf->px_flen,&v)<0)
	      {
	        cerr <<"long <0!"<<endl;
	        return false;
	      }
	       hk_datetime dt;
               h=v/3600000;
               m=v/60000%60;
               s=v%60000/1000;
	       dt.set_time(h,m,s);
	       txt=dt.time_asstring();
	       value=(char*)txt.c_str();
	      break;}
     case pxfBLOb:
     case pxfGraphic:
     case pxfOLE:
     case pxfMemoBLOb:
     case pxfFmtMemoBLOb:
     		{
     		binary=true;
     		int mod_nr,ret;
     		if (pxf->px_ftype==pxfGraphic)
     		 ret=PX_get_data_graphic(p_paradoxhandle,&data[offset],pxf->px_flen,&mod_nr,&binarysize,&value);
     		else
     		 ret=PX_get_data_blob(p_paradoxhandle,&data[offset],pxf->px_flen,&mod_nr,&binarysize,&value);

	      break;}

     default:
	      if (PX_get_data_alpha(p_paradoxhandle,&data[offset],pxf->px_flen,&value)<0)
	      {
	        cerr <<"alphadata <0!"<<endl;
	        return false;
	      }
	      if (value)
	      {
	        txt=smallstringconversion(value,p_codepage,"");
	      }
    }
    //cerr <<pxf->px_fname<<"="<<txt<<endl;
    datarow[f].length=(binary?binarysize:(value?txt.size()+1:0));
    char* dt=NULL;
    if (value )
	 {
	   if (binary)
	   {
	    dt=new char[datarow[f].length];
                for (unsigned int tk=0;tk<datarow[f].length;tk++) dt[tk]=value[tk];
            p_paradoxhandle->free(p_paradoxhandle,value);
            value=NULL;

	   }
	   else
	   {
	    dt=new char[datarow[f].length];
            strcpy(dt,txt.c_str());
	   }
	  }

    datarow[f].data=dt;

    offset+=pxf->px_flen;
    ++pxf;
   }
//store data
insert_data(datarow);
++p_currow;
 return true;

}

bool hk_paradoxtable::datasource_close(void)
{
  p_paradoxheader=NULL;
  if (data)p_paradoxhandle->free(p_paradoxhandle,data);
/* if ( p_paradoxhandle )
{
        PX_close(p_paradoxhandle);
       	PX_delete(p_paradoxhandle);
       	p_paradoxhandle=NULL;
}*/

 data = NULL;
  return true;
}


list<hk_column*>* hk_paradoxtable::driver_specific_columns(void)
{
if (p_columns==NULL&&p_name.size()>0)
 {
   if (!p_paradoxheader)
   {
   hk_url p_url=name();
   hk_url durl=p_paradoxdatabase->name();
   cerr <<"databasepath="<<durl.directory()<<endl;
   if (durl.directory().size()==0) durl=p_paradoxdatabase->database_path()+"/"+p_paradoxdatabase->name();
   hk_string n= p_url.directory().size()>0? p_url.directory(): durl.directory()+"/"+name()+".db";
   cerr <<"open: #"<<n<<"#"<<endl;
    if (!p_paradoxhandle)p_paradoxhandle=PX_new2(errorhandler,NULL,NULL,NULL);
      file=fopen(n.c_str(),"r+");

   if (PX_open_fp(p_paradoxhandle,file)<0)
   {
     show_warningmessage("Could not open file'"+n+"'");
     return false;
   }
   p_paradoxheader=p_paradoxhandle->px_head;
   if (p_paradoxheader)
   {
     //set_maxrows(p_paradoxheader->px_numrecords);
     p_codepage="CP"+longint2string(p_paradoxheader->px_doscodepage);
     driver_specific_create_columns();
   }
   else p_columns=new list<hk_column*>;
 }
 }
return p_columns;
}


bool hk_paradoxtable::driver_specific_create_columns(void)
{
  if (!p_paradoxheader) return false;
  clear_columnlist();
  p_columns=new list<hk_column*>;
   int z = 0;//counting the fieldnumbers
   int nf=p_paradoxheader->px_numfields;
   pxfield_t*pxf=p_paradoxheader->px_fields;
   for (int f=0;f<nf;++f)
   {
    hk_paradoxcolumn *col= new hk_paradoxcolumn(this,p_true,p_false);
    col->set_fieldnumber(z++);
    col->set_name(smallstringconversion(pxf->px_fname,p_codepage,""));
    int size=pxf->px_flen;
    hk_column::enum_columntype coltype=hk_column::othercolumn;
    switch(pxf->px_ftype)
    {
	case pxfAlpha: coltype=hk_column::textcolumn;break;
        case pxfLogical:  coltype=hk_column::boolcolumn;break;
	case pxfLong:  coltype=hk_column::integercolumn;break;
	case pxfShort:  coltype=hk_column::smallintegercolumn;break;
	case pxfDate:  coltype=hk_column::datecolumn;break;
	case pxfMemoBLOb:  coltype=hk_column::memocolumn;break;
	case pxfBLOb:  coltype=hk_column::binarycolumn;break;
	case pxfNumber:  coltype=hk_column::floatingcolumn;break;
	case pxfTime:    coltype=hk_column::timecolumn;break;
	case pxfAutoInc:    coltype=hk_column::auto_inccolumn;break;
    }
    col->set_columntype(coltype);
    col->set_size(size);
    p_columns->insert(p_columns->end(),col);
    ++pxf;
    }
return true;
}

bool hk_paradoxtable::driver_specific_create_table_now(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_paradoxtable::driver_specific_create_table_now");
#endif
cerr <<"paradox create_table_now"<<endl;
if (!p_paradoxhandle)
   p_paradoxhandle=PX_new2(errorhandler,NULL,NULL,NULL);

    cerr <<"p_paradoxhandle"<<p_paradoxhandle<<endl;
        p_paradoxheader=p_paradoxhandle->px_head;
     p_codepage="CP1252";
    pxfield_t* schema= (pxfield_t *) p_paradoxhandle->malloc(p_paradoxhandle, p_newcolumns.size()*sizeof(pxfield_t), "Could not get memory for field definitions.");
    if (!schema)
    {
      return false;

    }
    list<hk_column*>::iterator it=p_newcolumns.begin();
    int i=0;
    while (it!=p_newcolumns.end())
    {
        char t=pxfAlpha;
	int size=(*it)->size();
	int s2=0;
	switch ((*it)->columntype())
	{

	 case hk_column::auto_inccolumn: 	t=pxfAutoInc;
	 					break;
	 case hk_column::integercolumn: 	t=pxfLong;
	 					break;
	 case hk_column::smallintegercolumn: 	t=pxfShort;
	 					break;
	 case hk_column::floatingcolumn: 	t=pxfNumber;
	 					break;
	 case hk_column::smallfloatingcolumn: 	t=pxfNumber;
	 					break;
	 case hk_column::datecolumn: 		t=pxfDate;
	 					break;
	 case hk_column::timecolumn: 		t=pxfTime;
	 					break;
	 case hk_column::boolcolumn: 		t=pxfLogical;
	 					size=1;
	 					break;
	 case hk_column::memocolumn: 		t=pxfMemoBLOb;
	 					break;
	 case hk_column::binarycolumn: 		t=pxfBLOb;
	 					break;
         default:;
	}
	cerr <<"create p_codepage="<<p_codepage<<endl;
	schema[i].px_fname=PX_strdup(p_paradoxhandle,smallstringconversion((*it)->name(),"",p_codepage).c_str());
	schema[i].px_ftype=t;
	schema[i].px_flen=size;
	schema[i].px_fdc=s2;
	//cerr <<"add col="<<schema[i].px_fname<<" type:"<<schema[i].px_ftype<<endl;
	++it;++i;
    }


   hk_string tname=database()->database_path()+"/"+name()+".db";
   cerr<<"tname="<<tname<<endl;
   if (PX_create_file(p_paradoxhandle,schema,p_newcolumns.size(),tname.c_str(),pxfFileTypNonIndexDB)<0)
   {  show_warningmessage("Error creating table");
      p_paradoxhandle->free(p_paradoxhandle,schema);

        PX_close(p_paradoxhandle);
       	PX_delete(p_paradoxhandle);
       	p_paradoxhandle=NULL;

     return false;
   }
  p_paradoxhandle->free(p_paradoxhandle,schema);
        PX_close(p_paradoxhandle);
       	PX_delete(p_paradoxhandle);
       	p_paradoxhandle=NULL;
p_paradoxheader=NULL;
  cerr<<"table #"<<tname<<"# created"<<endl;

    return true;

}
#if PXLIB_MINOR_VERSION > 5
/*bool    hk_paradoxtable::insert_row(enum_interaction interaction)
{
  cerr <<"hk_paradoxtable::insert_row"<<endl;
  //datasource_open();
    inform_visible_objects_before_insert_row();
   p_paradoxheader=p_paradoxhandle->px_head;
      if (p_paradoxheader)
   {
     //set_maxrows(p_paradoxheader->px_numrecords);
     p_codepage="CP"+longint2string(p_paradoxheader->px_doscodepage);
   }

  if (!p_paradoxheader)
  {
  cerr <<"hk_paradoxtable::insert_row no header!"<<endl;
   return false;
  }
  int offset=0;
  if (data) p_paradoxhandle->free(p_paradoxhandle,data);
  data=(char*) p_paradoxhandle->malloc(p_paradoxhandle,p_paradoxheader->px_recordsize,"allocate memory");
  if (!data)
  {
    cerr <<"hk_paradoxtable::insert_row memory allocation failed"<<endl;
    return false;
  }
   pxfield_t*pxf=p_paradoxheader->px_fields;
  list<hk_column*>::iterator it=p_columns->begin();
  int i=0;
        while ( it!=p_columns->end() )
        {
          hk_column* x=*it;cerr <<x->name()<<": #"<<x->changed_data_asstring()<<"#"<<endl;
    cerr <<" pxf="<<pxf[i].px_fname<<endl;
          cerr<<" Offset="<<offset<<endl;
            switch (pxf[i].px_ftype)
            {
                 case pxfLogical :
     		{  cerr<<"l"<<endl;
                  PX_put_data_byte(p_paradoxhandle,&data[offset],1,x->changed_data_asbool()?1:0);
		  break;
		}
                 case pxfShort :
     		{cerr<<"s"<<endl;
                  PX_put_data_short(p_paradoxhandle,&data[offset],2,(short int)x->changed_data_asinteger());
		  break;
		}
                 case pxfLong :
     		{cerr<<"L"<<endl;
                  PX_put_data_long(p_paradoxhandle,&data[offset],4,x->changed_data_asinteger());
		  break;
		}
                 case pxfNumber :
     		{cerr<<"N"<<endl;
                  PX_put_data_double(p_paradoxhandle,&data[offset],8,x->changed_data_asdouble());
		  break;
		}
                 case pxfAlpha :
     		{cerr<<"a"<<endl;
                  PX_put_data_alpha(p_paradoxhandle,&data[offset],pxf[i].px_flen,(char*)smallstringconversion(x->changed_data_asstring(),"",p_codepage).c_str());
		  break;
		}
		}



          offset+=pxf[i].px_flen;
          ++i;
          ++it;
        }
        cerr <<"vor put"<<endl;
        for (int k=0;k<p_paradoxheader->px_recordsize;++k)
        {
          cerr<<"k="<<k<<"#"<<data[k]<<"#"<<endl;
        }
        cerr <<endl;
   int result=PX_insert_record(p_paradoxhandle,data);
        cerr <<"nach insert_record:"<<result<<endl;
   //datasource_close();
   p_paradoxhandle->free(p_paradoxhandle,data);
   data=NULL;
   p_paradoxheader=NULL;
   bool ret=(result>=0);
   if (ret)
   {
     ret=driver_specific_insert_data();
     if (ret)
     {
     set_has_not_changed();
     transaction_commit();
     goto_last();
     inform_visible_objects_row_add();
     setmode_normal();
     execute_visible_object_after_insert();
     setmode_normal();
     set_has_not_changed();
     }

   }
   if (!ret)
   {
   p_paradoxdatabase->paradoxconnection()->servermessage(lasterror());
   hk_string reason=replace_all("%NAME%",hk_translate("Table %NAME%: Row could NOT be inserted!"),name())+"\n"+hk_translate("Servermessage: ")+database()->connection()->last_servermessage();
   if (interaction==interactive) show_warningmessage(reason);
   }
   cerr <<"result:"<<((result>=0)?"TRUE":"FALSE")<<endl;
   return ret;

}
*/
#endif

bool hk_paradoxtable::driver_specific_insert_data(void)
{

cerr <<"hk_paradoxtable::driver_specific_insert_data"<<endl;
    hk_string new_autoinc;

    struct_raw_data* datarow=new struct_raw_data[p_columns->size()];
    list<hk_column*>::iterator col_it;
    col_it=p_columns->begin();
    unsigned int spalte=0;
    while (spalte<p_columns->size())
    {
        const struct_raw_data* changed_data=(*col_it)->changed_data();
/*        if ((*col_it)->columntype()==hk_column::auto_inccolumn)
        {
            new_autoinc=format_number(sqlite3_last_insert_rowid(p_sqlitedatabase->dbhandler()),false,0);
            const int bsize=new_autoinc.size()+1;
            char* data=new char[bsize];
            strcpy(data,new_autoinc.c_str());
            datarow[spalte].data=data;
            datarow[spalte].length=strlen(data);
        }
        else*/
        {                                         //not a autoinc column
            datarow[spalte].length=changed_data->length;;
            char* data=NULL;
            if (changed_data->data)
            {
                data=new char[datarow[spalte].length];
                for (unsigned int tk=0;tk<datarow[spalte].length;tk++) data[tk]=changed_data->data[tk];
            }
            datarow[spalte].data=data;
        }
        spalte++;
        col_it++;
    }
    insert_data(datarow);
    return true;

}

#if PXLIB_MINOR_VERSION > 5

/*bool hk_paradoxtable::delete_row(enum_interaction interaction)
{
#ifdef HK_DEBUG
    hkdebug("hk_paradoxtable::delete_row()");
#endif
    unsigned long oldp_counter =p_counter;
    if(interaction==interactive &&!show_yesnodialog(hk_translate("Delete this record?"),true))
    {
#ifdef HK_DEBUG
        hkdebug("don't delete");
#endif
        p_mode=mode_normal;
        set_has_not_changed();
        return true;
    }

#ifdef HK_DEBUG
    hkdebug("delete");
#endif

    inform_before_row_change();
    list<hk_datasource*>::iterator dep_it;
    dep_it=p_dependinglist.begin();
    bool dep_bool=true;
    if (dependingmode()!=depending_nohandle)
        while (dep_it!=p_dependinglist.end())
    {
        if(!(*dep_it)->depending_on_datasource_deleterow_ok()) dep_bool=false;
        dep_it++;
    }

    if (!dep_bool)
    {
        if (interaction==interactive) show_warningmessage(hk_translate("Row could not be deleted due to depending datasource(s)"));
        p_mode=mode_normal;
        set_has_not_changed();

        return false;
    }
    execute_visible_object_before_delete();
    transaction_begin();
    dep_it=p_dependinglist.begin();
    bool subbool=true;
    while (dep_it!=p_dependinglist.end())
    {
        if (!(*dep_it)->depending_on_datasource_before_delete_row())
            subbool=false;
        dep_it++;
    }

    bool exec_ok=false;

    if (!blockserversignals())
    {
        if (subbool)
        {   cerr <<"loesche Zeile:"<<row_position()<<endl;
            int r=PX_delete_record(p_paradoxhandle,row_position());
            cerr <<"result loeschen:"<<r<<endl;
            exec_ok=(r>-1);
            if (exec_ok)
            {
#ifdef HK_DEBUG
                hkdebug("Lschen hat funktioniert");
#endif
                driver_specific_delete_data_at(p_counter);
                inform_visible_objects_row_delete();
                transaction_commit();
                if ((max_rows()<=p_counter)&&(p_counter>0))p_counter=max_rows()-1;
            }
        }
        if (!subbool ||!exec_ok)
        {
#ifdef HK_DEBUG
            hkdebug("FEHLER kein Lschen");
#endif
            p_paradoxdatabase->paradoxconnection()->servermessage(lasterror());
            transaction_rollback();
            hk_string reason=replace_all("%NAME%",hk_translate("Table %NAME%: Row was NOT deleted!"),name())+"\n"+hk_translate("Servermessage: ")+database()->connection()->last_servermessage();
            if (interaction==interactive) show_warningmessage(reason);
        }
    }
    execute_visible_object_after_delete();
    set_has_not_changed();
    cerr <<"p_counter:"<<p_counter<<endl;
    if (p_counter>0)
    {
        p_mode=mode_normal;
        goto_row(p_counter);
        if (p_counter==oldp_counter)
            inform_depending_ds_goto_row();

    }
    else setmode_insertrow();
    return exec_ok;

}




bool hk_paradoxtable::update_row(enum_interaction interaction)
{
#ifdef HK_DEBUG
    hkdebug( "hk_paradoxtable::update_row()");
#endif
   p_paradoxheader=p_paradoxhandle->px_head;
   if (p_paradoxheader)
   {
     //set_maxrows(p_paradoxheader->px_numrecords);
     p_codepage="CP"+longint2string(p_paradoxheader->px_doscodepage);
   }

    if(p_actual_row_where.size()==0)
    {
        if (interaction==interactive)show_warningmessage("Internal Error: update_row() p_actual_row_where is empty");
        return false ;
    }
    bool dep_bool=true;
    list<hk_datasource*>::iterator dep_it=p_dependinglist.begin();

    while (dep_it!=p_dependinglist.end())
    {
        if(!(*dep_it)->depending_on_datasource_updaterow_ok()) dep_bool=false;
        dep_it++;
    }

    if (!dep_bool)
    {
        if (interaction==interactive)show_warningmessage(replace_all("%1",hk_translate("Row in datasource '%1' could not be changed due to depending datasource(s)"),name()));

        p_mode=mode_normal;
        set_has_not_changed();

        return false;
    }
    transaction_begin();
 inform_depending_ds_before_update_row();

   int offset=0;
  if (data) p_paradoxhandle->free(p_paradoxhandle,data);
  data=(char*) p_paradoxhandle->malloc(p_paradoxhandle,p_paradoxheader->px_recordsize,"allocate memory");
  if (!data)
  {
    cerr <<"hk_paradoxtable::update_row memory allocation failed"<<endl;
    return false;
  }
   pxfield_t*pxf=p_paradoxheader->px_fields;
  list<hk_column*>::iterator it=p_columns->begin();
  int i=0;
        while ( it!=p_columns->end() )
        {
          hk_column* x=*it;cerr <<x->name()<<": #"<<x->changed_data_asstring()<<"#"<<endl;
    cerr <<" pxf="<<pxf[i].px_fname<<endl;
          cerr<<" Offset="<<offset<<endl;
            switch (pxf[i].px_ftype)
            {
                 case pxfLogical :
     		{  cerr<<"l"<<endl;
                  PX_put_data_byte(p_paradoxhandle,&data[offset],1,x->curval_asbool()?1:0);
		  break;
		}
                 case pxfShort :
     		{cerr<<"s"<<endl;
                  PX_put_data_short(p_paradoxhandle,&data[offset],2,(short int)x->curval_asinteger());
		  break;
		}
                 case pxfLong :
     		{cerr<<"L"<<endl;
                  PX_put_data_long(p_paradoxhandle,&data[offset],4,x->curval_asinteger());
		  break;
		}
                 case pxfNumber :
     		{cerr<<"N"<<endl;
                  PX_put_data_double(p_paradoxhandle,&data[offset],8,x->curval_asdouble());
		  break;
		}
                 case pxfAlpha :
     		{cerr<<"a"<<endl;
                  PX_put_data_alpha(p_paradoxhandle,&data[offset],pxf[i].px_flen,(char*)smallstringconversion(x->curval_asstring(),"",p_codepage).c_str());
		  break;
		}
		}



          offset+=pxf[i].px_flen;
          ++i;
          ++it;
        }




    set_has_not_changed();

	bool r=true;
         if (!blockserversignals())
        {

   int result=PX_update_record(p_paradoxhandle,data,row_position());
        cerr <<"nach update_record:"<<result<<endl;
   //datasource_close();
   p_paradoxhandle->free(p_paradoxhandle,data);
   data=NULL;
   p_paradoxheader=NULL;
                if (result>-1)
                {
#ifdef HK_DEBUG
                    hkdebug("ndern hat funktioniert");
#endif
                driver_specific_update_data();
                transaction_commit();
		r=true;
                }
                else
                {
#ifdef HK_DEBUG
                    hkdebug("FEHLER keine Datenspeicherung");
#endif
                    transaction_rollback();
	            p_paradoxdatabase->paradoxconnection()->servermessage(lasterror());
                hk_string reason=replace_all("%NAME%",hk_translate("Table %NAME%: Row could NOT be changed!"),name())+"\n"+hk_translate("Servermessage: ")+database()->connection()->last_servermessage();
                    if (interaction==interactive) show_warningmessage(reason);
		    r=false;
                }

        }

inform_depending_ds_after_update_row();
return r;
}
*/
#endif

