<?php
/**
 * $Horde: sam/spam.php,v 1.21 2007/08/03 19:53:53 chuck Exp $
 * Copyright 2002-2007 Chris Bowlby <excalibur@hub.org>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/* Determine base directory. */
@define('SAM_BASE', dirname(__FILE__));
require_once SAM_BASE . '/lib/base.php';
require_once SAM_BASE . '/lib/Forms/Options.php';

if (!$conf['enable']['rules']) {
    $notification->push(_("The Spam Rules page is not enabled."), 'horde.error');
    header('Location: ' . Horde::applicationUrl('index.php'));
    exit;
}

/* Request retrieval of related user data. */
$result = $sam_driver->retrieve();
if (is_a($result, 'PEAR_Error')) {
    $notification->push(sprintf(_("Cannot get options: %s"), $result->getMessage()), 'horde.error');
}

/* Initialize the form. */
$vars = Variables::getDefaultVariables();
$form = new OptionsForm($vars);
$renderer = new Horde_Form_Renderer();
$defaults = false;

/* Page variables. */
$title = _("Spam Options");

if ($form->isSubmitted() &&
    $vars->exists('global_defaults') && $vars->get('global_defaults')) {
    if (!Auth::isAdmin()) {
        $notification->push(_("Only an administrator may change the global defaults."), 'horde.error');
        $vars->remove('global_defaults');
        $form->setSubmitted(false);
    } elseif (!$sam_driver->hasCapability('global_defaults')) {
        $notification->push(_("The configured backend does not support global defaults."), 'horde.error');
        $vars->remove('global_defaults');
        $form->setSubmitted(false);
    } else {
        $defaults = true;
    }
}

if ($form->validate($vars)) {
    $stackedOptions = array();

    foreach (Sam::getAttributes() as $key => $attribute) {
        if ($sam_driver->hasCapability($key) && $vars->exists($key)) {
            $data = $vars->get($key);

            if (isset($attribute['basepref'])) {
               /* SA docs claim that a null value for a rewrite string merely
                * removes any previous changes to the specified header.  This
                * should be harmless, and saves needing to add a DELETE
                * preference call in the backend when the user doesn't use
                * header rewrites. */

                /* Build string with all basepref entries, separated by
                 * newlines */
                if (!isset($stackedOptions[$attribute['basepref']])) {
                    $stackedOptions[$attribute['basepref']] = $attribute['subtype'] . " " . $data;
                } else {
                    $stackedOptions[$attribute['basepref']] .= "\n" . $attribute['subtype'] . " " . $data;
                }
            } elseif ($attribute['type'] == 'boolean') {
                $sam_driver->setOption($key, $sam_driver->booleanToOption($data), $defaults);
            } else {
                $sam_driver->setOption($key, $data, $defaults);
            }
        }
    }

    /* All form fields have been processed, so push the resulting strings to
     * the backend. */
    foreach ($stackedOptions as $key => $data) {
        $sam_driver->setStackedOption($key, $data);
    }

    $result = $sam_driver->store($defaults);
    if (is_a($result, 'PEAR_Error')) {
        $notification->push(sprintf(_("Cannot set options: %s"), $result->getMessage()), 'horde.error');
    } elseif ($defaults) {
        $notification->push(_("Updated global default rules"), 'horde.success');
    } else {
        $notification->push(_("Updated user spam rules"), 'horde.success');
    }
}

require SAM_TEMPLATES . '/common-header.inc';
require SAM_TEMPLATES . '/menu.inc';
$form->renderActive($renderer, $vars, 'spam.php', 'post');
require $registry->get('templates', 'horde') . '/common-footer.inc';
