#!/usr/local/bin/php
<?php
/**
 * The main Horde setup script which allows for a step by step setup
 * or reconfiguration of a Horde installation.
 *
 * $Horde: horde/scripts/setup.php,v 1.25.10.7 2006/01/01 21:29:09 jan Exp $
 *
 * Copyright 2003-2006 Marko Djukic <marko@oblo.com>
 * Copyright 2003-2006 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Marko Djukic <marko@oblo.com>
 * @author  Charles J. Hagenbuch <chuck@horde.org>
 * @since   Horde 3.0
 */

@define('AUTH_HANDLER', true);
@define('HORDE_BASE', dirname(__FILE__) . '/..');
require_once HORDE_BASE . '/lib/core.php';

$setup = &Setup::singleton();
/* Checking for registry. */
$files = array('conf.php', 'mime_drivers.php', 'nls.php', 'prefs.php',
              'registry.php');
foreach ($files as $filename) {
    $file = HORDE_BASE . '/config/' . $filename;
    if (file_exists($file)) {
        $setup->log(sprintf(_("File \"%s\" is available."), $filename), 'message');
        continue;
    }

    $setup->log(sprintf(_("File \"%s\" is missing."), $filename), 'warning');
    $distfile = $file . '.dist';

    if (file_exists($distfile)) {
        $create_config = $setup->cli->prompt(sprintf(_("Create \"%s\" from defaults now?"), $filename), array('y' => _("Yes"), 'n' => _("No")));
    } else {
        $setup->cli->fatal(sprintf(_("Can not find \"%s\", check your installation."), $distfile));
    }

    if ($create_config == 'y') {
        if (!copy($distfile, $file)) {
            $setup->cli->fatal(sprintf(_("Copying \"%1$s.dist\" to \"%1$s\" failed. Check your installation."), $filename));
        }
        $setup->log(sprintf(_("File %s created."), $filename), 'success');
    } else {
        $setup->cli->fatal(sprintf(_("You need the \"%s\" file to continue setup and to use Horde."), $filename));
    }
}

$setup->log(_("Initial setup completed. Now continue the setup with your browser, go to: http://<Your Horde install URL>/admin/"), 'success');
exit;

/**
 * The Setup:: class provides a set of functions to set up a Horde
 * installation.
 *
 * $Horde: horde/scripts/setup.php,v 1.25.10.7 2006/01/01 21:29:09 jan Exp $
 *
 * Copyright 2003-2006 Marko Djukic <marko@oblo.com>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Marko Djukic <marko@oblo.com>
 * @since   Horde 3.0
 * @package Horde_Setup
 */
class Setup {

    function &factory($interface)
    {
        $class = 'Setup_' . $interface;
        if (class_exists($class)) {
            $setup = &new $class();
            return $setup;
        } else {
            exit(sprintf(_("Setup is not available through the %s interface."), $interface));
        }
    }

    function &singleton()
    {
        static $instance;

        if (!isset($instance)) {
            require_once 'Horde/CLI.php';
            if (Horde_CLI::runningFromCLI()) {
                $interface = 'cli';
            } else {
                $interface = 'web';
            }
            $instance = &Setup::factory($interface);
        }

        return $instance;
    }

}

/**
 * The Setup_cli:: class provides a CLI interface to the Horde setup
 * script.
 *
 * $Horde: horde/scripts/setup.php,v 1.25.10.7 2006/01/01 21:29:09 jan Exp $
 *
 * Copyright 2003-2006 Marko Djukic <marko@oblo.com>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Marko Djukic <marko@oblo.com>
 * @since   Horde 3.0
 * @package Horde_Setup
 */
class Setup_cli extends Setup {

    var $cli = null;

    /**
     * Constructs a new Setup object using the CLI interface.
     */
    function Setup_cli()
    {
        require_once 'Horde/CLI.php';
        $this->cli = &new Horde_CLI();

    }

    function log($message, $type = 'message')
    {
        /* Wrap the messages with an indent, neater screen display. */
        $message = wordwrap($message, 69, "\n           ");
        $this->cli->message($message, 'cli.' . $type);
    }

}
