/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "hrn.h"

static ClutterColor black = { 0, 0, 0, 0x22 };
static ClutterColor normal_color = { 0xff, 0xff, 0xff, 0xff };


ClutterActor *
mm_label (const gchar *font, const gchar *utf8, gint wrap)
{
  ClutterActor *group;
  ClutterActor *label;
  gint          i, j;

  group = clutter_group_new ();


  for (i = -2; i <= 2; i++)
    for (j = -2; j <= 2; j++)
      if (i != 0 && j != 0)
        {
          label = clutter_text_new_with_text (font, utf8);
          clutter_group_add (CLUTTER_GROUP (group), label);
          clutter_text_set_color (CLUTTER_TEXT (label), &black);
          clutter_actor_set_position (label, i, j);
          clutter_text_set_line_wrap (CLUTTER_TEXT (label), TRUE);
          clutter_actor_set_width (label, wrap);
        }

  label = clutter_text_new_with_text (font, utf8);
  clutter_group_add (CLUTTER_GROUP (group), label);
  clutter_text_set_color (CLUTTER_TEXT (label), &normal_color);
  clutter_actor_set_position (label, 0, 0);
  clutter_text_set_line_wrap (CLUTTER_TEXT (label), TRUE);
  clutter_actor_set_width (label, wrap);

  return group;
}

static void
destroy_when_done (ClutterAnimation *animation, gpointer data)
{
  clutter_actor_destroy (data);
}

static gboolean
clear_disclaimer (gpointer group)
{
  ClutterAnimation *animation;

  animation = clutter_actor_animate (group, CLUTTER_LINEAR, 1000, "opacity", 0,
                                     NULL);
  g_signal_connect (animation, "completed", G_CALLBACK (
                      destroy_when_done), group);
  return FALSE;
}

static gboolean
build_disclaimer (gpointer message)
{
  ClutterActor *layer;
  ClutterActor *stage;

  stage = clutter_stage_get_default ();
  layer = mm_label ("Sans 50px", message, clutter_actor_get_width (stage) * 0.8);
  clutter_actor_set_x (layer, clutter_actor_get_width (stage) * 0.1);
  clutter_actor_set_y (layer, clutter_actor_get_height (stage) * 0.1);
  clutter_group_add (CLUTTER_GROUP (stage), layer);
  clutter_actor_set_opacity (layer, 0);
  clutter_actor_animate (layer, CLUTTER_LINEAR, 1000, "opacity", 255, NULL);
  g_timeout_add (5000, clear_disclaimer, layer);
  return FALSE;
}

void
hrn_disclaimer (const gchar *message)
{
  g_timeout_add (600, build_disclaimer, (void*) message);
}
