/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <gnome.h>
#include <panel-applet.h>

#define STR_SIZE 255

#define GNOMELOCALEDIR PACKAGE_LOCALE_DIR

#define KEY_H_SPELLER		 "h_speller"
#define KEY_L_SPELLER		 "l_speller"
#define KEY_FIRST		 "first"

typedef struct _HspellData
{
	/* widgets */
	GtkWidget *applet;
	GtkWidget *entry;
	GtkWidget *button;
	GtkWidget *hbox;

	/* preferences */

	char hebrew_speller[20];
	char latin_speller[20];

	gint first;
	PanelAppletOrient orient;
	int size;

} HspellData;

GtkWidget *entry1;
GtkWidget *entry2;
GtkWidget *window1;

void
display_about_dialog (BonoboUIComponent * uic,
		      HspellData * cd, const gchar * verbname)
{
	const gchar *authors[] = {
		"kobi zamir <kzamir@walla.co.il>",
		NULL
	};
	const gchar *documenters[] = { NULL };
	/* TRANSLATORS: Replace this string with your names, one name per line. */
	gchar *translators = _("translator_credits");
	GtkWidget *about_hspell;

	if (!strcmp (translators, "translator_credits"))
		translators = NULL;
	about_hspell = gnome_about_new (PACKAGE, VERSION,
					_("(c) 2004"),
					_
					("The Hspell applet"),
					authors, documenters,
					translators, NULL);

	gtk_widget_show (about_hspell);
}

void
setting_clicked (GtkButton * button, gpointer cd)
{
	g_stpcpy (((HspellData *) cd)->hebrew_speller,
		  gtk_entry_get_text (GTK_ENTRY (entry1)));
	g_stpcpy (((HspellData *) cd)->latin_speller,
		  gtk_entry_get_text (GTK_ENTRY (entry2)));

	gtk_widget_destroy (window1);
}

void
display_properties_dialog (BonoboUIComponent * uic,
			   HspellData * cd, const gchar * verbname)
{

	GtkWidget *vbox1;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *button1;

	window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window1), _("properties"));

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (window1), vbox1);

	label1 = gtk_label_new (_("hebrew speller"));
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

	entry1 = gtk_entry_new ();
	gtk_widget_show (entry1);
	gtk_box_pack_start (GTK_BOX (vbox1), entry1, FALSE, FALSE, 0);

	label2 = gtk_label_new (_("latin speller"));
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);

	entry2 = gtk_entry_new ();
	gtk_widget_show (entry2);
	gtk_box_pack_start (GTK_BOX (vbox1), entry2, FALSE, FALSE, 0);

	button1 = gtk_button_new_from_stock ("gtk-apply");
	gtk_widget_show (button1);
	gtk_box_pack_start (GTK_BOX (vbox1), button1, FALSE, FALSE, 0);

	gtk_entry_set_text (GTK_ENTRY (entry1),
			    ((HspellData *) cd)->hebrew_speller);
	gtk_entry_set_text (GTK_ENTRY (entry2),
			    ((HspellData *) cd)->latin_speller);

	g_signal_connect (G_OBJECT (button1), "clicked",
			  G_CALLBACK (setting_clicked), cd);

	gtk_widget_show (window1);
}

static const char hspell_menu_xml[] =
	"<popup name=\"button3\">\n"
	"   <menuitem name=\"Properties Item\" verb=\"HspellProperties\" _label=\"Properties ...\"\n"
	"             pixtype=\"stock\" pixname=\"gtk-properties\"/>\n"
	"   <menuitem name=\"About Item\" verb=\"HspellAbout\" _label=\"About ...\"\n"
	"             pixtype=\"stock\" pixname=\"gnome-stock-about\"/>\n"
	"</popup>\n";

static const BonoboUIVerb hspell_menu_verbs[] = {
	BONOBO_UI_VERB ("HspellProperties", display_properties_dialog),
	BONOBO_UI_VERB ("HspellAbout", display_about_dialog),
	BONOBO_UI_VERB_END
};

static gboolean
button_event (GtkWidget * w, GdkEventButton * event, gpointer cd)
{
	if (event->button == 3 || event->button == 2)
		{
			gtk_propagate_event (((HspellData *) cd)->applet,
					     (GdkEvent *) event);
			return TRUE;
		}

	return FALSE;

}

void
button_clicked (GtkButton * button, gpointer cd)
{
	gchar word_local[STR_SIZE];

	g_stpcpy (word_local,
		  gtk_entry_get_text (GTK_ENTRY
				      (((HspellData *) cd)->entry)));

	if (word_local[0] < 'A')
		{
			g_stpcpy (word_local,
				  ((HspellData *) cd)->hebrew_speller);
		}
	else
		{
			g_stpcpy (word_local,
				  ((HspellData *) cd)->latin_speller);
		}

        g_strlcat (word_local,
		   " ",
		   STR_SIZE);
                
	g_strlcat (word_local,
		   gtk_entry_get_text (GTK_ENTRY
				       (((HspellData *) cd)->entry)),
		   STR_SIZE);
	gtk_entry_set_text (GTK_ENTRY (((HspellData *) cd)->entry), "");

	g_spawn_command_line_async (word_local, NULL);
}

static gboolean
hspell_applet_fill (PanelApplet * applet, const gchar * iid, gpointer data)
{
	HspellData *cd;

	if (strcmp (iid, "OAFIID:HspellApplet") != 0)
		return FALSE;

	cd = g_new0 (HspellData, 1);

	cd->applet = GTK_WIDGET (applet);

	cd->hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (cd->applet), cd->hbox);

	cd->entry = gtk_entry_new ();
	gtk_container_add (GTK_CONTAINER (cd->hbox), cd->entry);
	gtk_widget_set_size_request (cd->entry, 100, -1);

	cd->button = gtk_button_new_with_label (_("Lookup"));
	gtk_container_add (GTK_CONTAINER (cd->hbox), cd->button);

	g_signal_connect (G_OBJECT (cd->button), "button_press_event",
			  G_CALLBACK (button_event), cd);
	g_signal_connect (G_OBJECT (cd->button), "clicked",
			  G_CALLBACK (button_clicked), cd);
	g_signal_connect (G_OBJECT (cd->entry), "activate",
			  G_CALLBACK (button_clicked), cd);

	panel_applet_setup_menu (PANEL_APPLET (cd->applet),
				 hspell_menu_xml, hspell_menu_verbs, cd);


	cd->first = panel_applet_gconf_get_int (PANEL_APPLET (cd->applet),
						KEY_FIRST, NULL);
	if (cd->first == FALSE)
		{
			panel_applet_gconf_set_int (PANEL_APPLET (cd->applet),
						    KEY_FIRST, TRUE, NULL);

			g_stpcpy (cd->hebrew_speller, "hspell-gui-heb");
			panel_applet_gconf_set_string (PANEL_APPLET
						       (cd->applet),
						       KEY_H_SPELLER,
						       cd->hebrew_speller,
						       NULL);

			g_stpcpy (cd->latin_speller, "gnome-dictionary");
			panel_applet_gconf_set_string (PANEL_APPLET
						       (cd->applet),
						       KEY_L_SPELLER,
						       cd->latin_speller,
						       NULL);

		}
	else
		{
			g_stpcpy (cd->hebrew_speller, (gchar *)
				  panel_applet_gconf_get_string (PANEL_APPLET
								 (cd->applet),
								 KEY_H_SPELLER,
								 NULL));
			g_stpcpy (cd->latin_speller, (gchar *)
				  panel_applet_gconf_get_string (PANEL_APPLET
								 (cd->applet),
								 KEY_L_SPELLER,
								 NULL));
		}

	gtk_widget_show_all (GTK_WIDGET (cd->applet));

	return TRUE;
}


PANEL_APPLET_BONOBO_FACTORY ("OAFIID:HspellApplet_Factory",
			     PANEL_TYPE_APPLET,
			     "Hspell Applet", "0", hspell_applet_fill, NULL);
