/* Do not edit this file. It was automatically genarated. */

#ifndef HEADER_ProcessList
#define HEADER_ProcessList
/*
htop
(C) 2004 Hisham H. Muhammad
Released under the GNU GPL, see the COPYING file
in the source distribution for its full text.
*/

#include "Process.h"
#include "TypedVector.h"
#include "UsersTable.h"
#include "Hashtable.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <stdbool.h>
#include <sys/utsname.h>

#include "debug.h"
#include <assert.h>

#ifndef PROCDIR
#define PROCDIR "/proc"
#endif

#ifndef PROCSTATFILE
#define PROCSTATFILE "/proc/stat"
#endif

#ifndef PROCMEMINFOFILE
#define PROCMEMINFOFILE "/proc/meminfo"
#endif


typedef struct ProcessList_ {
   TypedVector* processes;
   TypedVector* processes2;
   Hashtable* processTable;
   Process* prototype;
   UsersTable* usersTable;

   int processorCount;
   int totalTasks;
   int runningTasks;

   long int* totalTime;
   long int* userTime;
   long int* systemTime;
   long int* idleTime;
   long int* niceTime;
   long int* totalPeriod;
   long int* userPeriod;
   long int* systemPeriod;
   long int* idlePeriod;
   long int* nicePeriod;

   long int totalMem;
   long int usedMem;
   long int freeMem;
   long int sharedMem;
   long int buffersMem;
   long int cachedMem;
   long int totalSwap;
   long int usedSwap;
   long int freeSwap;

   int kernelMajor;
   int kernelMiddle;
   int kernelMinor;
   int kernelTiny;

   ProcessField* fields;
   ProcessField sortKey;
   int direction;
   bool hideThreads;
   bool shadowOtherUsers;
   bool hideKernelThreads;
   bool treeView;
   bool highlightBaseName;
   bool highlightMegabytes;

} ProcessList;



ProcessList* ProcessList_new(UsersTable* usersTable);

void ProcessList_delete(ProcessList* this);

void ProcessList_invertSortOrder(ProcessList* this);

void ProcessList_sortKey(ProcessList* this, int delta);

RichString ProcessList_printHeader(ProcessList* this);


void ProcessList_prune(ProcessList* this);

void ProcessList_add(ProcessList* this, Process* p);

void ProcessList_remove(ProcessList* this, Process* p);

Process* ProcessList_get(ProcessList* this, int index);

int ProcessList_size(ProcessList* this);


void ProcessList_sort(ProcessList* this);


void ProcessList_scan(ProcessList* this);

void ProcessList_dontCrash(int signal);

#endif
