package lib::plugin::node;

use strict;

# Constructors

sub new {
  my($class, %init) = @_;

  my $self;

  $self = bless {
#    'read' => undef,
#    'write' => undef,
    'io' => undef,
    'exec' => undef,
    'name' => undef,
    'description' => undef,
    'version' => lib::plugin::Version,
    'events' => undef,
    'noise' => 100,
    'intrusive' => 100
  }, $class;

  foreach (keys %init) {
    if(exists $self->{$_}) {
      $self->{$_}=$init{$_};
    }
  }

  lib::debug("Created new node, with name $self->{'name'}");

  return $self;
}

sub send_message {
  my ($self, $message) = @_;

  $self->{'io'}->push($message);
  return 1;
}

sub recv_message {
  my ($self, $expected) = @_;

  my $message=$self->{'io'}->pop();

  if(defined $message) {
    lib::debug("recv message $message ".$message->{'method'});
    return $message;
  } else {
    return undef;
  }
}

return 1;

