/****************************************************************************
 *
 * Copyright (c) 2004-2005 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#if defined(WIN32)
#include <config.h>

#include "hula-mgrp.h"

#include <windows.h>
#include <stdio.h>
#include <direct.h>
#include <process.h>
#include <xpl.h>
#include <mdb.h>
#include <msgapi.h>

HANDLE						IMSTerminateEvent = NULL;
SERVICE_STATUS				IMSServiceStatus;
SERVICE_STATUS_HANDLE	IMSServiceStatusHandle;
unsigned char				BinDir[_MAX_PATH]="c:/nims/bin/windows";
BOOL							FakeLoad=FALSE;
BOOL							Verbose=FALSE;
BOOL							FailedShutdown=FALSE;
SC_HANDLE					Manager;

BOOL 
HulaManagerAgentPrep(HulaManagerAgent *Agent)
{
    return TRUE;
}

void 
HulaManagerAgentRelease(HulaManagerAgent *Agent)
{
}

BOOL
HulaManagerLoadAgent(HulaManagerAgent *agent)
{
	unsigned char			AppPath[_MAX_PATH];
	PROCESS_INFORMATION	ProcInfo;
	STARTUPINFO				StartInfo;													     

	strcpy(agent->name+strlen(agent->name)-3, "exe");
	memset(&StartInfo, 0, sizeof(StartInfo));
	StartInfo.cb=sizeof(STARTUPINFO);
	StartInfo.lpDesktop="WinSta0\\Default";
    MsgGetBinDir(BinDir);
    sprintf(AppPath, "%s/%s", BinDir, agent->name);
	if (Verbose) {
		if (!FakeLoad) {
			printf("Starting %s\n", AppPath);
		}
	}
	if (!FakeLoad) {
		if (CreateProcess(AppPath, "agent -s", NULL, NULL, FALSE, CREATE_NEW_PROCESS_GROUP, NULL, BinDir, &StartInfo, &ProcInfo)==0) {
			return(FALSE);
		} else {
			CloseHandle(ProcInfo.hProcess);
			CloseHandle(ProcInfo.hThread);
			agent->data=ProcInfo.hProcess;
			return(TRUE);
		}
	} else {
		return(TRUE);
	}
}


BOOL
HulaManagerUnloadAgent(HulaManagerAgent *agent)
{
	HWINSTA	Station;
	HDESK		Desk;

	if (agent->data) {
#if 0
		if (GenerateConsoleCtrlEvent(CTRL_BREAK_EVENT, Module->ThreadID)==0) {
			MessageBox(NULL, "Could not stop process", Module->Name, MB_OK);
		}
#else
		HWND				hwnd;
		unsigned char	AppName[128];
		unsigned char	*ptr;

		strcpy(AppName, agent->name);
		ptr=AppName;
		while (ptr[0] && ptr[0]!='.') {
			ptr[0]=tolower(ptr[0]);
			ptr++;
		}
		if (ptr[0]=='.') {
			ptr[0]='\0';
		}
		Station=OpenWindowStation("WinSta0", FALSE, WINSTA_READATTRIBUTES);
		SetProcessWindowStation(Station);
		Desk=OpenDesktop("default", 0, FALSE, DESKTOP_ENUMERATE | DESKTOP_READOBJECTS);
		SetThreadDesktop(Desk);
		
		hwnd=FindWindow("XplServiceClass", AppName);
		if (hwnd) {
			if (Verbose) {
				printf("Stopping %s\n", AppName);
			}
			SendMessage(hwnd, WM_USER+4321, 0, 0);
		}
		CloseDesktop(Desk);
		CloseWindowStation(Station);
#endif
	}
	return(TRUE);
}


VOID WINAPI
IMSServiceCtrlHandler(DWORD Opcode)
{
	switch(Opcode) {
		case SERVICE_CONTROL_STOP:
			/* Signal or main routine to stop waiting */
			SetEvent(IMSTerminateEvent);
			IMSServiceStatus.dwWin32ExitCode = 0;
			IMSServiceStatus.dwCurrentState  = SERVICE_STOPPED;
			IMSServiceStatus.dwCheckPoint    = 0;
			IMSServiceStatus.dwWaitHint      = 10000;

			SetServiceStatus(IMSServiceStatusHandle, &IMSServiceStatus);
			return;

		case SERVICE_CONTROL_INTERROGATE:
		case SERVICE_CONTROL_PAUSE:		/* We don't handle pause or continue */
		case SERVICE_CONTROL_CONTINUE:
		default:
			break;
	}

	/* Send current status. */
	SetServiceStatus(IMSServiceStatusHandle,  &IMSServiceStatus);
	return;
}

void WINAPI
IMSServiceStart(DWORD argc, LPTSTR *argv)
{
        
	IMSServiceStatus.dwServiceType        = SERVICE_WIN32;
	IMSServiceStatus.dwCurrentState       = SERVICE_START_PENDING;
	IMSServiceStatus.dwControlsAccepted   = SERVICE_ACCEPT_STOP;
	IMSServiceStatus.dwWin32ExitCode      = 0;
	IMSServiceStatus.dwServiceSpecificExitCode = 0;
	IMSServiceStatus.dwCheckPoint         = 0;
	IMSServiceStatus.dwWaitHint           = 10000;

	IMSServiceStatusHandle = RegisterServiceCtrlHandler("IMSStart", IMSServiceCtrlHandler);

	if (IMSServiceStatusHandle == (SERVICE_STATUS_HANDLE)0) {
		return;
	}

	SetServiceStatus(IMSServiceStatusHandle, &IMSServiceStatus);

	Manager=OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	HulaManagerStartAgents();
	CloseServiceHandle(Manager);

	/* Initialization complete - report running status. */
	IMSServiceStatus.dwCurrentState       = SERVICE_RUNNING;
	IMSServiceStatus.dwCheckPoint         = 0;
	IMSServiceStatus.dwWaitHint           = 0;

	SetServiceStatus(IMSServiceStatusHandle, &IMSServiceStatus);

	WaitForSingleObject(IMSTerminateEvent, INFINITE);
	
	return;
}

BOOL WINAPI
WinTerminateHandler(int Ctrl)
{
	//MessageBox(NULL, "Got called", "IMS TerminateHandler", MB_OK);
	return(FALSE);
}

int
main(int argc, char *argv[])
{
	SERVICE_TABLE_ENTRY	DispatchTable[] = {{"IMSStart", IMSServiceStart}, { NULL, NULL}};
	BOOL						Standalone	= FALSE;
	BOOL						Shutdown		= FALSE;
    BOOL result;

    FILE *f =  fopen ("c:\\foo.txt", "w");
    fwrite ("blah\n", 1, 5, f);
    fclose (f);


	//DebugBreak();

    result = HulaManagerLoad(0);
    if (result) {
    	if (argc>1) {
	    	int	i;
    
	    	for (i=1; i<argc; i++)  {
		    	if (stricmp(argv[i],"-s")==0) {
			    	Standalone=TRUE;
			    }       
			    if (stricmp(argv[i],"-u")==0) {
				    Shutdown=TRUE;
                }
    			if (stricmp(argv[i],"-v")==0) {
	    			Verbose=TRUE;
                }
    			if ((stricmp(argv[i],"-?")==0) || (stricmp(argv[i],"-h")==0)) {
	    			printf("hulamanager [[-s] [-u]] [-v] [-? | -h]\n");
		        	printf("-s : standalone\n");
				    printf("-u : unload\n");
				    printf("-v : verbose\n");
                    HulaManagerUnload();
                    exit(0);
                }
			}
        }

		if (Standalone) {
			if (Shutdown) {
				FakeLoad=TRUE;
				HulaManagerStartAgents();
			} else {
				FakeLoad=FALSE;
				HulaManagerStartAgents();
			}

            HulaManagerUnload();
            exit(0);
        }
        
    	IMSTerminateEvent = CreateEvent (0, TRUE, FALSE,0);

	    if (!StartServiceCtrlDispatcher(DispatchTable)) {
	    	return(-1);
	    }
	    Manager=OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);

        HulaManagerStopAgents();
	    HulaManagerUnload();
	    CloseServiceHandle(Manager);
	    CloseHandle(IMSTerminateEvent);
    }
    
    return(0);
}

#endif
