/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>

#include <openssl/ssl.h>
#include <openssl/err.h>

#include <msgapi.h>
#include <nmap.h>

#include "modwebp.h"

unsigned char	*ModWebPVersion = "$Revision: 1.2 $";

BOOL
HandlePublicImage(ConnectionStruct *Client, unsigned long Language, unsigned long ImageID)
{
	unsigned char	*Image;
	unsigned long	Length;

	Client->KeepAlive=TRUE;
	if (ImageID>=PublicTemplate->ImageCount || Language>=PublicTemplate->LanguageCount) {
		Client->KeepAlive=FALSE;
		return(FALSE);
	}

	Image=PublicTemplateImages[Language][ImageID];

	Length=*(unsigned long *)Image;
	Image+=sizeof(unsigned long);

	if (Image[0]=='G') {
		MWSendHTTPHeader(Client, "image/gif", Length, NULL, TRUE);
	} else {
		MWSendHTTPHeader(Client, "image/jpeg", Length, NULL, TRUE);
	}
	MWSendClient(Client, Image, Length);

	return(TRUE);
}


BOOL
MWHandlePublicTemplate(ConnectionStruct *Client, SessionStruct *Session, unsigned long TemplateID)
{
	unsigned char				URL[256];
	unsigned long				ReplyInt;
	unsigned char				*Template;
	TokenOverlayStruct		*Token;
	register unsigned char	*ptr;

	MWDebug("MWHandlePublicTemplate(Sesson:%x TemplateID:%d) called\n", (unsigned int)Session, (int)TemplateID);

	if (!Session->Pages) {
		Client->KeepAlive=FALSE;
		return(FALSE);
	}

	SendHTTPHeaderDynamic(Client, Session->Pages[TemplateID]->ContentType, Session->Pages[TemplateID]->ContentTypeLen);

	Template = Session->Pages[TemplateID]->Object;
	Token=(TokenOverlayStruct *)Template;

NextToken:
	while (Token->TokenID!=0) {
		switch(Token->TokenID) {
			case T_TEXT: {
				MWSendClient(Client, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				break;
			}

			case T_QSTRING:
			case T_STRING: {
				ptr=Session->Strings[Token->ArgumentOffsetOrID[0]];
				MWSendClient(Client, ptr, strlen(ptr));
				break;
			}

			case T_IMAGE: {
				MWEncodeURL(Session, URL, URL_TYPE_PUBLIC, DISPLAY_IMAGE, Session->Language, Token->ArgumentOffsetOrID[0], 0, 0);
				MWSendClient(Client, URL, strlen(URL));
				break;
			}

			case T_PAGEID:
			case T_PAGE: {
				MWEncodeURL(Session, URL, URL_TYPE_PUBLIC, DISPLAY_TEMPLATE, Token->ArgumentOffsetOrID[0], 0, 0, 0);
				MWSendClient(Client, URL, strlen(URL));
				break;
			}

			case T_APP_TITLE: {
				if (DefaultTitle) {
					MWSendClient(Client, DefaultTitle, strlen(DefaultTitle));
				} else {
					MWSendClient(Client, PublicTemplate->Name, strlen(Templates[Session->TemplateID]->Name));
				}
				break;
			}

			case T_COLOR: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_PAGEFG: {
						MWSendClient(Client, Session->Colors[COLOR_PAGE_FG], 6);
						break;
					}

					case AA_PAGEBG: {
						MWSendClient(Client, Session->Colors[COLOR_PAGE_BG], 6);
						break;
					}

					case AA_BORDERFG: {
						MWSendClient(Client, Session->Colors[COLOR_BORDER_FG], 6);
						break;
					}

					case AA_BORDERBG: {
						MWSendClient(Client, Session->Colors[COLOR_BORDER_BG], 6);
						break;
					}

					case AA_SECTIONFG: {
						MWSendClient(Client, Session->Colors[COLOR_SECTION_FG], 6);
						break;
					}

					case AA_SECTIONBG: {
						MWSendClient(Client, Session->Colors[COLOR_SECTION_BG], 6);
						break;
					}

					case AA_FIELDNAMEFG: {
						MWSendClient(Client, Session->Colors[COLOR_FIELDNAME_FG], 6);
						break;
					}

					case AA_FIELDNAMEBG: {
						MWSendClient(Client, Session->Colors[COLOR_FIELDNAME_BG], 6);
						break;
					}

					case AA_FIELDBODYFG: {
						MWSendClient(Client, Session->Colors[COLOR_FIELDBODY_FG], 6);
						break;
					}

					case AA_FIELDBODYBG: {
						MWSendClient(Client, Session->Colors[COLOR_FIELDBODY_BG], 6);
						break;
					}
				}
				break;
			}


			default: {
				unsigned long	i;
				unsigned long	GotoToken;

				for (i=0; i<TModuleCount; i++) {
				    if (TModules[i].TokenRangeStart<=Token->TokenID && Token->TokenID<=TModules[i].TokenRangeEnd) {
					ReplyInt=TModules[i].HandleTemplate(Client, Session, TemplateID, Token, &GotoToken, NULL);

					if (ReplyInt == TOKEN_DONE) {
					    if (Token->TokenID != 0) {
						Template += Token->Length;
						Token = (TokenOverlayStruct *)Template;
					    }

					    goto NextToken;
					} else if (ReplyInt == TOKEN_MOVE_FORWARD) {
					    do {
						if (Token->TokenID != 0) {
						    Template += Token->Length;
						    Token = (TokenOverlayStruct *)Template;
						    continue;
						}
						break;
					    } while (Token->TokenID != GotoToken);
						    
					    goto NextToken;
					} else if (ReplyInt == TOKEN_MOVE_BACKWARD) {
					    do {
						if (Token != (TokenOverlayStruct *)(Session->Pages[TemplateID]->Object)) {
						    Template -= Token->PrevSize;
						    Token = (TokenOverlayStruct *)Template;
						    continue;
						}
						break;
					    } while (Token->TokenID != GotoToken);
						    
					    goto NextToken;
					}
				    }
				}

				MWDebug("Have unknown token %x\n", (unsigned int)Token->TokenID);
				break;
			}
		}
		Template += Token->Length;
		Token=(TokenOverlayStruct *)Template;
	} 
	return(TRUE);
}

BOOL
HandlePublicURL(ConnectionStruct *Client, URLStruct *URL)
{
	SessionStruct	Session;

 	MWDebug("HandleURL(Sesson:%x URL->Request:%d) called\n", (unsigned int)&Session, (int)URL->Request);

	memset(&Session, 0, sizeof(Session));

	/* note: Needs to change if NMAP ever starts using SSL */
	Session.Read = SessionFuncTbl->read;
	Session.Write = SessionFuncTbl->write;

	SetPublicSessionTemplate(Client, &Session);

	switch(URL->Request) {
		case DISPLAY_TEMPLATE: {
			Client->KeepAlive=FALSE;
			MWHandlePublicTemplate(Client, &Session, URL->Argument[0]);
			return(TRUE);
		}

		case DISPLAY_IMAGE: {
			HandlePublicImage(Client, URL->Argument[0], URL->Argument[1]);
			return(TRUE);
		}

		case DISPLAY_LOGO: {
			HandleLogo(Client, URL->Argument[0]);
			return(TRUE);
		}

		case REQUEST_LOGIN: {
			MWDebug("Have logout request\n");
			Client->KeepAlive=FALSE;
			MWHandleTemplate(Client, &Session, URL->Argument[0]);
			Client->Session=NULL;
			return(TRUE);
		}

		default: {
			unsigned long	i;

			Client->KeepAlive=FALSE;
			for (i=0; i<TModuleCount; i++) {
				if (TModules[i].TokenRangeStart<=URL->Request && URL->Request<=TModules[i].TokenRangeEnd) {
					if (TModules[i].HandleURL(Client, &Session, URL, NULL)) {
						break;
					}
				}
			}
			break;
		}
	}

	return(TRUE);
}
