/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <mdb.h>

#include <mwtempl.h>
#include <msgapi.h>
#include <streamio.h>
#include <connio.h>

#include <logger.h>

#include <modweb.tok>
#include <modweb.ary>
#include "ctype.h"


/* Generic */
#define	PRODUCT_SHORT_NAME		"modwebd.nlm"

#define  BUFSIZE						1023  
#define  MTU							(1480*3)
#define	SERVER_NAME					"Hula-ModWeb-Agent/1.0"
#define	MAX_SESSION_ENTRIES		5000
#define	MAX_TSESSION_ENTRIES		500
#define	MAX_LANGUAGES				100
#define	CONNECTION_CACHE_SIZE	100
#define	POST_ALLOC_BLOCK			20
#define	TEMPLATE_EXTENSION		".ctp"
#define	MODULE_EXTENSION			XPL_DLL_EXTENSION
#define	PUBLIC_TEMPLATE_NAME		"public"

#define	MODWEB_STACK_SPACE	48*1024

#define	ChopNL(String)		{ char *pTr; pTr=strrchr((String), 0x0a);	if (pTr)	*pTr='\0'; pTr=strrchr((String), 0x0d); if (pTr) *pTr='\0'; }

/** Request definitions (submitted via URL) **/

/* Request type */
#define	DISPLAY_LOGO	6
#define	REQUEST_RELOGIN	7
#define	DISPLAY_STATIC_OBJECT	8

/* Device type */
#define	DEVICE_HTML		0
#define	DEVICE_WML		1

extern unsigned char	*ModWebDVersion;
extern unsigned char	*ModWebMVersion;
extern unsigned char	*ModWebPVersion;
extern unsigned char	*ModWebRVersion;
extern unsigned char	*ModWebSVersion;
extern unsigned char	*ModWebTVersion;
extern unsigned char	*ModWebUVersion;

typedef struct _MODWEB_STATISTICS_STRUCT {
	struct {
		XplAtomic	Incoming;
		XplAtomic	Serviced;
	} Clients;

	XplAtomic		WrongPassword;
} ModWebStatistics;

extern ModWebStatistics	ModWebStats;

/* To remember form data for timed-out sessions */
typedef struct _TSessionStruct {
	/* A unique session identifier */
	unsigned long	SessionID;
	unsigned long	SessionUID;
	time_t			Timestamp;
} TSessionStruct;

typedef struct _UserValue {
    struct _UserValue *next;
    struct _UserValue *prev;
    unsigned long id;
    unsigned char *value;
} UserValue;

typedef struct _SessionStruct {
	/* User data, public */
	unsigned char	*User;
	unsigned char	*UserDN;
	unsigned long	Language;
	unsigned char	Colors[10][7];
	unsigned char	*Charset;
	unsigned char	*EMailAddress;
	unsigned char	*DisplayName;
	unsigned char	*OfficialDomain;

	BOOL				ReadOnly;

	unsigned long	MailBoxIcon;
	unsigned long	MailBoxSharedIcon;
	unsigned long	MailBoxSharingIcon;
	unsigned long	CalendarIcon;
	unsigned long	CalendarSharedIcon;
	unsigned long	CalendarSharingIcon;
	unsigned long	HierarchicalElementIcon;

	/* User preferences; time & date */
	long				TimezoneOffset;
	unsigned long	TimezoneID;
	unsigned long	StartWeekday;
	unsigned char	*DateFormatShort;
	unsigned char	*DateFormatLong;
	unsigned char	*TimeFormat;
	MsgDateFormat	DateFormat;

	/* Mailstore address */
	struct in_addr	NMAPAddress;

	/* Folder Structure */
	MDBValueStruct	*FolderList;
	MDBValueStruct	*FolderDisplayNames;
	unsigned long	*FolderUnreadCount;
	unsigned long	*FolderTotalCount;

	unsigned long	CurrentFolder;
	unsigned long	CurrentCalendar;
	unsigned long	CurrentDisplayFolder;
	BOOL				ShowUnsubscribedFolders;
	unsigned char	*SentFolder;

	/* Allow modules to reset mailbox and calendar cache */
	BOOL				FolderListIsDirty;
	BOOL				DirtyMessage;
	unsigned long	DirtyMessageFolder;
	unsigned long	DirtyMessageID;

	/* Message data */
	unsigned long	*IDList;
	unsigned long	*UIDList;
	unsigned long	NumOfMessages;
	unsigned long	MessagesPerPage;
	BOOL				NMAPChanged;

	/* Calendar data */
	signed long		CurrentDay;
	signed long		CurrentMonth;
	signed long		CurrentYear;
	unsigned long	CurrentRataDie;

	/* Calendar entries */
	unsigned long	NumOfEvents;
	unsigned long	CurrentEvent;

	/* Template data */
	long				TemplateID;
	unsigned char	**Strings;
	unsigned char	**Images;
	TemplateObjectOverlay **Pages;
	TemplateObjectOverlay **StaticObjects;

	/* NMAP Connection */
	int				NMAPs;					/* NMAP Socket					*/
	int				NBufferPtr;				/* Current NMAP pointer		*/
	unsigned char	NBuffer[BUFSIZE+1];	/* NMAP Input buffer			*/

	/* Time Stamps */
	unsigned long	ConnectionTimeout;
	time_t			Timestamp;
	time_t			NMAPTimestamp;

	/* A unique session identifier */
	unsigned long	SessionID;

    UserValue *UserValues;
	/** 
		Here starts the private part of the structure
		Do not alter the order of above entries without
		simultaneously updating the published modweb.h
		header file
	**/

	/* NMAP Connection; private part */
	SSL				*NSSL;					/* SSL connection info		*/
	unsigned char	NMAPSSL;
  

	/* User data, private */
	unsigned long	LogoID;
	unsigned char	*Title;

	/* Session internals */
	unsigned long	SessionUID;
	unsigned char	*RealUser;
	BOOL				MailboxChanged;
	void				**ModuleData;
	unsigned long	Counter;

	StreamStruct	*HTMLCodec;

	unsigned long	CookieID;

	BOOL				NMAPTraceReadPrefix;
	BOOL				NMAPTraceWritePrefix;

  /* Generic IP read and write functions */
  /* Overloaded with NON-SSL,SSL,And Traceable recv and write functions*/
  GenericReadFunc  Read;
  GenericWriteFunc Write;
  void *sktCtx; /* either a socket, or SSL context used as first parameter */
} SessionStruct;

typedef struct _ConnectionStruct {
    unsigned long Flags;
	int						s;							/* Socket						*/
	SessionStruct			*Session;				/* Current session			*/
	unsigned char			Temp[BUFSIZE+1];		/* Temp work buffer			*/
	struct sockaddr_in	cs;						/* Client info					*/
	BOOL						KeepAlive;				/* Keep connection?			*/
	unsigned char			Command[BUFSIZE+1];	/* Current command			*/
	unsigned char			*URLExtra;				/* Addtl. URL info			*/
	BOOL						NMAPProtected;			/* NMAP Transaction active	*/
	unsigned char			ClientSSL;				/* Doing SSL?					*/
	unsigned long			DeviceType;				/* Current Device Type		*/
    unsigned char *URLHost;

	/** 
		Here starts the private part of the structure
		Do not alter the order of above entries without
		simultaneously updating the published modweb.h
		header file
	**/

	BOOL						State;					/* State							*/
	SSL						*CSSL;					/* SSL connection info		*/
	int						BufferPtr;				/* Current input pointer	*/
	unsigned char			Buffer[BUFSIZE+1];	/* Input buffer				*/
	int						SBufferPtr;				/* Send Buffer Pointer		*/
	unsigned char			SBuffer[MTU+1];		/* Send Buffer [speedup]	*/
	unsigned char			Credentials[MAXEMAILNAMESIZE*2+1];	/* HTTP Auth*/
	unsigned long			ContentLength;			/* Length of form data		*/
	int						FormState;				/* Formprocessing state		*/
	int						EncodingType;			/* How is formdata encoded?*/
	unsigned char			*FormSeparator;		/* Separation character		*/
	BOOL						SentHeader;				/* Sent HTTP header alrdy?	*/
	unsigned long			SessionUID[10];		/* Cookie Session UID		*/
	unsigned char			Language[20];			/* Browser language Preferece String */
	unsigned char			*URL;						/* To remember our URL		*/
	TSessionStruct			*TSession;				/* Hand	*/
	FILE						*PostData;				/* Handle to fake postdata	*/
	unsigned long			Cookie;					/* Non-zero to send cookie	*/
	unsigned long			CookieID;				/* The next free slot		*/
	BOOL						ClearCookie;			/* Set to TRUE to clear		*/
	BOOL						TrustCredentials;		/* Credentials contain ID validated by third party */

  /* Generic IP read and write functions */
  /* Overloaded with NON-SSL,SSL,And Traceable recv and write functions*/
  GenericReadFunc  Read;
  GenericWriteFunc Write;
  void *sktCtx; /* either a socket, or SSL context used as first parameter */

} ConnectionStruct;


typedef struct _URLStruct {
	unsigned long	Request;
	unsigned long	Argument[5];

	/** 
		Here starts the private part of the structure
		Do not alter the order of above entries without
		simultaneously updating the published modweb.h
		header file
	**/

	unsigned long	Checksum;
	unsigned long	ReloginOK;
	unsigned long	SessionID;
	unsigned long	SessionUID;
	unsigned long	Template;
	unsigned long	Language;
} URLStruct;

#include <modweb.h>

/* the other two are defined in the public modweb.h */
#define	FORMFIELD_NAME			FORMFIELD_NEXT

#define	FORM_URL_ENCODED		1
#define	FORM_DATA_ENCODED		2

typedef struct {
	char				*Name;
	char				*Value;
} FormDataStruct;

/* modweb.c */
extern XplAtomic		ModWebConnThreads;
extern XplAtomic		ModWebServerThreads;
extern SessionStruct		*SessionDB[MAX_SESSION_ENTRIES];
extern XplSemaphore		SessionDBSemaphore;
extern XplSemaphore		SessionMutex[MAX_SESSION_ENTRIES];
extern XplSemaphore		TSessionMutex[MAX_TSESSION_ENTRIES];
extern XplSemaphore		TSessionDBSemaphore;
extern ConnectionStruct	*ConnectionCache[CONNECTION_CACHE_SIZE];
extern unsigned char		NLSDir[];
extern unsigned char		LogoDir[];
extern unsigned char		WorkDir[];
extern BOOL CheckDiskForTemplateUpdates;
extern BOOL					*MWExiting;
extern BOOL					Exiting;
extern unsigned char		*DefaultTitle;
extern unsigned char		NMAPHash[];
extern unsigned char		OfficialDomain[MAXEMAILNAMESIZE+1];
extern unsigned char		FormLogoutRedirectURL[];
extern BOOL					UseFormLogoutRedirectURL;
extern void					*LogHandle;
extern MDBHandle			ModWebDirectoryHandle;
extern unsigned long		MIMEParamEncodingforHTTP;

/* modwebu.c */
extern unsigned long		CCTop;
extern XplSemaphore		CacheSemaphore;

/* modwebs.c */
extern unsigned long		DefaultConnectionTimeout;
extern unsigned long		DefaultLogoID;
extern unsigned long		DefaultLanguage;
extern unsigned long		DefaultTemplate;
extern long					DefaultTimezoneOffset;
extern unsigned long		DefaultTimezoneID;
extern unsigned char		*DefaultMonthShort[12];
extern unsigned char		*DefaultMonthLong[12];
extern unsigned char		*DefaultWDayShort[7];
extern unsigned char		*DefaultWDayLong[7];
extern unsigned char		*DefaultAMPM[2];
extern time_t				ModwebTimeStamp;

/* modwebt.c */
extern TemplateStruct	*PublicTemplate;
extern unsigned char		***PublicTemplateImages;
extern TemplateStruct	**Templates;
extern int					TemplateCount;
extern unsigned char		***TemplateImages;
extern int					TemplateMaxLanguages;

/* modwebm.c */
extern TemplateModuleStruct	*TModules;
extern StreamModuleStruct		*SModules;
extern ComposeModuleStruct		*CModules;
extern unsigned long				TModuleCount;
extern unsigned long				SModuleCount;
extern unsigned long				CModuleCount;


/* Internal stuff */
#define	STATE_FRESH		0
#define	STATE_ENDING	1

#define	MSGERRBADREQUEST		"HTTP/1.1 400 Bad request\r\nContent-type: text/html\r\nConnection: close\r\n\r\n<H1>Document doesn't exist</H1>"
#define	MSGERRBADREQUEST_LEN	103

#define	MSGERRNOMEMORY			"HTTP/1.1 500 Server out of memory\r\nContent-type: text/html\r\nConnection: close\r\n\r\n<H1>Server out of memory</H1>"
#define	MSGERRNOMEMORY_LEN	70

#define	MSGERRRECEIVERDOWN	"HTTP/1.1 500 ModWeb access to this server currently disabled\r\nContent-type: text/html\r\nConnection: close\r\n\r\n<H1>Access to this server currently disabled</H1>Please try again in a few minutes."
#define	MSGERRRECEIVERDOWN_LEN	191

#define	MSGERRNOCONNECTIONS	"HTTP/1.1 500 ModWeb connection limit for this server reached\r\nContent-type: text/html\r\nConnection: close\r\n\r\n<H1>Access to this server currently disabled</H1>Please try again in a few minutes."
#define	MSGERRNOCONNECTIONS_LEN	191

#define	MSGERRBADFORM			"HTTP/1.1 500 Server too many form fields\r\nContent-type: text/html\r\nConnection: close\r\n\r\n<H1>Too many form fields</H1>"
#define	MSGERRBADFORM_LEN	77


/** Prototypes **/
/* Debugging */
#if defined(MODWEB_DEBUG_BUILD)
extern int	MWScreen;
extern int	SessionScreen;
extern int	TemplateScreen;
extern int	MWModuleScreen;
#define	MWDebugInit()		MWScreen=XplCreateScreen("MW General Debug Screen", 0)
#define	MWDebug				XplSetCurrentScreen(MWScreen); printf("[%d] ", __LINE__); printf
#define	SessionDebug		XplSetCurrentScreen(SessionScreen); printf("[%d] ", __LINE__); printf
#define	TemplateDebug		XplSetCurrentScreen(TemplateScreen); printf("[%d] ", __LINE__); printf
#define	ModuleDebug			XplSetCurrentScreen(MWModuleScreen); printf("[%d] ", __LINE__); printf
#else
#define	MWDebugInit()
#define	MWDebug				if (0) printf
#define	SessionDebug		if (0) printf
#define	TemplateDebug		if (0) printf
#define	ModuleDebug			if (0) printf
#endif




// typedef	int 	(*SessnReadFunc)(int socket, unsigned char *Buf, int Len, int timeout, int exiting);
// typedef	int 	(*SessnReadSSLFunc)(int socket, unsigned char *Buf, int Len);
// typedef	int 	(*SessnWriteFunc)(int socket, unsigned char *Buf, int Len);
// typedef	int 	(*ConnReadFunc)(int socket, unsigned char *Buf, int Len, int timeout, int exiting);
// typedef	int 	(*ConnReadSSLFunc)(int socket, unsigned char *Buf, int Len);
// typedef	int 	(*ConnWriteFunc)(int socket, unsigned char *Buf, int Len);

// Minutes * 60 (1 second granularity)
#define	CONNECTION_TIMEOUT	(15*60)


typedef struct sessionfuncs
{
  GenericWriteFunc   write; // ssl, non-ssl
  GenericWriteFunc   writeSSL;
  GenericReadFunc    read;
  GenericReadFunc readSSL;
 
}SessionFuncs;

typedef struct connectionfuncs
{
  GenericWriteFunc write;
  GenericWriteFunc writeSSL;
  GenericReadFunc  read; 
  GenericReadFunc  readSSL;
  
}ConnectionFuncs;

extern	ConnectionFuncs	   *ConnectionFuncTbl;
extern	SessionFuncs			*SessionFuncTbl;

/* needs updating if SSL is to be used with NMAP session */
#define	DoNMAPWrite(Session, Buf, Len)                  Session->Write((void *)Session->NMAPs, Buf, Len)
#define	DoNMAPRead(Session, Buf, Len, timeout)		Session->Read((void *)Session->NMAPs, Buf, Len, timeout)
#define	DoClientWrite(Client, Buf, Len)			Client->Write(Client->sktCtx, Buf, Len)
#define	DoClientRead(Client, Buf, Len, timeout)	        Client->Read(Client->sktCtx, Buf, Len, timeout)

/* modweb.c - main & basic functions; private */
BOOL					HandleLogo(ConnectionStruct *Client, unsigned long LogoID);
BOOL					EndClientConnection(ConnectionStruct *Client);
BOOL					MWSendClientInline(ConnectionStruct *Client, unsigned char *Data, int Len);
BOOL					ModWebConnectionAllocCB(void *Buffer, void *ClientData);
void					ReturnModWebConnection(ConnectionStruct *Client);

extern void			*ModWebConnectionPool;

#if !defined(DEBUG)
#define	GetModWebConnection()			MemPrivatePoolGetEntry(ModWebConnectionPool)
#else
#define	GetModWebConnection()			MemPrivatePoolGetEntryDebug(ModWebConnectionPool, __FILE__, __LINE__)
#endif

/* modwebu.c - utilities; private */
int					    MWDecodeBase64(unsigned char *Data, int Size, int *Remainder);
BOOL					RedirectAfterLogin(ConnectionStruct *Client, unsigned char *URL);
BOOL					ClearConnectionCache(void);
BOOL					SendTimeoutPage(ConnectionStruct *Client, URLStruct *URLData);
BOOL					SendReloginPage(ConnectionStruct *Client, URLStruct *URLData);
BOOL					DecodeURL(unsigned char *URL, URLStruct *URLData);
unsigned char		*GetURLFormName(unsigned char *URL, unsigned char *Name, unsigned long NameSize);
unsigned char		*GetURLFormValue(unsigned char *URL, unsigned char *Value, unsigned long *ValueSize);


/* modwebd.c - display handling; private */
BOOL					SendHTTPHeaderDynamic(ConnectionStruct *Client, unsigned char *contentType, unsigned long contentTypeLen);

/* modwebs.c - session management; private */
void					SessionMonitor(void);
BOOL					DestroyAllSessions(void);
BOOL					CreateSession(ConnectionStruct *Client, unsigned char *Username, unsigned char *Password, BOOL *Disabled);
SessionStruct		*RetrieveSession(unsigned long SessionID, unsigned long SessionUID);

#if !defined(MODWEB_DEBUG_BUILD)

#define				ReleaseSession(Session) {																																			\
		if (Session){																																											\
			Session->Timestamp = ModwebTimeStamp;																																		\
																																																	\
			if ((signed long)(NMAP_CONNECTION_TIMEOUT - (ModwebTimeStamp - Session->NMAPTimestamp)) < (signed long)(Session->ConnectionTimeout)) {		\
				unsigned char			buffer[BUFSIZE + 1];																																\
																																																	\
				MWSendNMAPServer(Session, "NOOP\r\n", 6);																																\
				if (MWGetNMAPAnswer(Session, buffer, BUFSIZE, TRUE) != -1) {																									\
					XplSignalLocalSemaphore(SessionMutex[Session->SessionID]);																									\
				} else {																																											\
					MWDestroySession(Session);																																				\
				}																																													\
			} else {																																												\
				XplSignalLocalSemaphore(SessionMutex[Session->SessionID]);																										\
			}																																														\
		}																																															\
	}

#else

#define				ReleaseSession(Session) {																																			\
		if (Session){																																											\
			Session->Timestamp = ModwebTimeStamp;																																		\
																																																	\
			if (Session->NBufferPtr != 0 && !Exiting) {																																\
				XplConsolePrintf("MODWEB: Connection is out of sync with NMAP for user: %s\r\n", Session->User);														\
				/*EnterDebugger();*/			\
			}																																														\
																																																	\
			if ((signed long)(NMAP_CONNECTION_TIMEOUT - (ModwebTimeStamp - Session->NMAPTimestamp)) < (signed long)(Session->ConnectionTimeout)) {		\
				unsigned char			buffer[BUFSIZE + 1];																																\
																																																	\
				XplConsolePrintf("\nMODWEBD: ReleaseSession() found NMAP time remaining less than modweb time remaining.\r\n");									\
				XplConsolePrintf("         User:                       %s\r\n", Session->User);																				\
				XplConsolePrintf("         ModwebTimeStamp:            %lu\r\n", ModwebTimeStamp);																			\
				XplConsolePrintf("         Session->NMAPTimestamp:     %lu\r\n", Session->NMAPTimestamp);																	\
				XplConsolePrintf("         Session->ConnectionTimeout: %lu\r\n", Session->ConnectionTimeout);															\
																																																	\
				MWSendNMAPServer(Session, "NOOP\r\n", 6);																																\
				if (MWGetNMAPAnswer(Session, buffer, BUFSIZE, TRUE) != -1) {																									\
					XplSignalLocalSemaphore(SessionMutex[Session->SessionID]);																									\
				} else {																																											\
					MWDestroySession(Session);																																				\
				}																																													\
			} else {																																												\
				XplSignalLocalSemaphore(SessionMutex[Session->SessionID]);																										\
			}																																														\
		}																																															\
	}

#endif

BOOL					DestroyTSession(TSessionStruct *TSession);
#define				ReleaseTSession(TSession)		if (TSession) {	SessionDebug("Releasing tsession %x mutex\n", TSession); XplSignalLocalSemaphore(TSessionMutex[TSession->SessionID]); }
TSessionStruct		*RetrieveTSession(unsigned long SessionID, unsigned long SessionUID);
TSessionStruct		*CreateTSession(void);
BOOL					SessionDBInit(void);
BOOL					SessionDBShutdown(void);


/* modwebt.c - template & preference management; private */
BOOL					SetPublicSessionTemplate(ConnectionStruct *Client, SessionStruct *Session);
unsigned long		FindLanguage(unsigned long LanguageID, long Tempate);
long					FindTemplate(unsigned char *TemplateName);
void					FreeTemplates(void);
BOOL					LoadTemplates(unsigned char *TemplatePath);


/* modwebp.c - page display and processing; private */
BOOL					HandleURL(ConnectionStruct *Client, SessionStruct *Session, URLStruct *URL);


/* modwebm.c - module management; private */
void					AddModule(unsigned char *Name, XplPluginHandle Handle, MWModuleShutdownFunc Shutdown);
void					FreeModules(void);
BOOL					LoadModules(unsigned char *ModulePath, BOOL ScanDir);

/* modwebp.c - portal display; private */
BOOL					HandlePublicURL(ConnectionStruct *Client, URLStruct *URL);

/* Browser Language Detection */

#define FindLanguage(LanguageString, Language)																						\
{																																					\
	switch ((LanguageString)[0]) {																										\
		case 'a': {																																\
			if ((LanguageString)[1] == 'r') {																							\
				(Language) = 61;						/* ar - Arabic		*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'c': {																																\
			if ((LanguageString)[1] == 's') {																							\
				(Language) = 21;						/* cs - Czech		*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'd': {																																\
			if ((LanguageString)[1] == 'a') {																							\
				(Language) = 2;						/* da - Danish		*/																\
			} else if ((LanguageString)[1] == 'e') {																					\
				(Language) = 7;						/* de - German		*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'e': {																																\
			if ((LanguageString)[1] == 'n') {																							\
				(Language) = 4;						/* en - English	*/																\
			} else if ((LanguageString)[1] == 'l') {																					\
				(Language) = 26;						/* el - Greek		*/																\
			} else if ((LanguageString)[1] == 's') {																					\
				(Language) = 14;						/* es - Spanish	*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'f': {																																\
			if ((LanguageString)[1] == 'i') {																							\
				(Language) = 5;						/* fi - Fininish	*/																\
			} else if ((LanguageString)[1] == 'r') {																					\
				if ((LanguageString)[2] == '-' && (LanguageString)[3] == 'c' && (LanguageString)[4] == 'a') {		\
					(Language) = 0;					/* fr-ca - French-Canadian */													\
				} else {																															\
					(Language) = 6;					/* fr - French		*/																\
				}																																	\
			}																																		\
			break;																																\
		}																																			\
		case 'h': {																																\
			if ((LanguageString)[1] == 'u') {																							\
				(Language) = 20;						/* hu - Hungarian	*/																\
			} else if ((LanguageString)[1] == 'e') {																					\
				(Language) = 60;						/* he - Hebrew		*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'i': {																																\
			if ((LanguageString)[1] == 't') {																							\
				(Language) = 8;						/* it - Italian	*/																\
			} else if ((LanguageString)[1] == 'w') {																					\
				(Language) = 60;						/* iw - Hebrew		*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'j': {																																\
			if ((LanguageString)[1] == 'a') {																							\
				(Language) = 9;						/* ja - Japanese	*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'k': {																																\
			if ((LanguageString)[1] == 'o') {																							\
				(Language) = 10;						/* ko - Korean		*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'n': {																																\
			if ((LanguageString)[1] == 'l') {																							\
				(Language) = 3;						/* nl - Dutch		*/																\
			} else if ((LanguageString)[1] == 'o') {																					\
				(Language) = 11;						/* no - Norwegian	*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'p': {																																\
			if ((LanguageString)[1] == 'l') {																							\
				(Language) = 17;						/* pl - Polish		*/																\
			} else if ((LanguageString)[1] == 't') {																					\
				(Language) = 12;						/* pt - Portuguese*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'r': {																																\
			if ((LanguageString)[1] == 'u') {																							\
				(Language) = 13;						/* ru - Russian	*/																\
			}																																		\
			break;																																\
		}																																			\
		case 's': {																																\
			if ((LanguageString)[1] == 'v') {																							\
				(Language) = 15;						/* sv - Swedish	*/																\
			}																																		\
			break;																																\
		}																																			\
		case 't': {																																\
			if ((LanguageString)[1] == 'h') {																							\
				(Language) = 22;						/* th - Thai		*/																\
			} else if ((LanguageString)[1] == 'r') {																					\
				(Language) = 41;						/* tr - Turkish	*/																\
			}																																		\
			break;																																\
		}																																			\
		case 'z': {																																\
			if (((LanguageString)[1] == 'h') && ((LanguageString)[2] == '-')) {												\
				if (((LanguageString)[3] == 's') && ((LanguageString)[4] == 'g')) {											\
					(Language) = 1;						/* zh-sg - Chinese (Singapore)	*/										\
					break;																														\
				}																																	\
				if ((LanguageString)[3] == 'c') {																						\
					if ((LanguageString)[4] == 'n') {																					\
						(Language) = 1;					/* zh-cn - Chinese (Peoples Republic)	*/								\
						break;																													\
					} else if (((LanguageString)[4] == 'h') && ((LanguageString)[5] == 's')) {								\
						(Language) = 1;					/* zh-chs - Chinese (Simplified)	*/										\
						break;																													\
					}																																\
				}																																	\
				(Language) = 16;							/* zh-*  - Chinese (other)	*/												\
			}																																		\
			break;																																\
		}																																			\
	}																																				\
}
