/****************************************************************************
 *
 * Copyright (c) 1997-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _NMAPDP_H
#define _NMAPDP_H
#define PRODUCT_SHORT_NAME "nmapd.nlm"
#define NMAPDPVersion "$Revision: 1.8 $"

#include <xpl.h>
#include <errno.h>
#include <hulautil.h>
#include <connio.h>
#include <msgapi.h>
#include <nmap.h>
#include <management.h>
#include <sqlite3.h>
#include <openssl/sha.h>
#include <libical2.h>

#if defined(OPENSSL_NO_SHA) || (defined(OPENSSL_NO_SHA0) && defined(OPENSSL_NO_SHA1))
#error SHA is disabled.
#endif

#include "mime.h"
#include "lock.h"

/* Message Definitions */
#define MSG1000READY "Hula NMAP server ready"
#define MSG1000BYE "Hula NMAP signing off"
#define MSG1000LOGINOK "1000 Login ok\r\n"
#define MSG1000FLAGSET "Flags set"
#define MSG1000FLAGINFO "Current Flags"
#define MSG1000OK "1000 OK\r\n"
#define MSG1000DELETED "Deleted message"
#define MSG1000ENTRYRMVD "1000 Queue entry removed\r\n"
#define MSG1000ENTRYMADE "1000 Queue entry created\r\n"
#define MSG1000SPACE_AVAIL "1000 %lu bytes free\r\n"
#define MSG1000USER "1000 User selected\r\n"
#define MSG1000MBOX "Mailbox selected [Read-Write]"
#define MSG1020MBOX "Mailbox selected [Read-Only]"
#define MSG1000MBOXMADE "1000 Mailbox created\r\n"
#define MSG1000CALENDARMADE "1000 Calendar created\r\n"
#define MSG1000EQUE "1000 Queue state entered\r\n"
#define MSG1000NOTIMP "1000 Command not implemented\r\n"
#define MSG1000PARAMSET "1000 Parameters set\r\n"
#define MSG1000FEATUREAVAIL "1000 Feature available\r\n"
#define MSG1000PURGED "Message(s) purged"
#define MSG1000SALVAGED "Message(s) salvaged"
#define MSG1000QWATCHMODE "1000 Entering queue watch mode\r\n"
#define MSG1000RQWATCHMODE "1000 Returning to queue watch mode\r\n"
#define MSG1000STARTTLS "1000 Begin TLS negotiations\r\n"
#define MSG1000STORED "1000 %s Created\r\n"
#define MSG2001CAPA "2001-NMAP1 NMAP Protocol Version 1\r\n2001-NMAP2 NMAP Protocol Version 2\r\n2001-ULIST Novonyx Userlist Extension\r\n2001-SLIST Novonyx Serverlist Extension\r\n2001-ADBK Address Book Extension\r\n2001-FEAT Feature Lookup Extension\r\n"
#define MSG2001CAPATLS "2001-TLS Encryption Extension\r\n"
#define MSG2001HELP "2001-------------------------------------------------------------------------\r\n" \
                    "2001-Open Client Commands                                                    \r\n" \
                    "2001-CAPA      ERRO      HELP      NOOP      NVER      OPER      QUIT        \r\n2001-\r\n" \
                    "2001-Authentication Commands                                                 \r\n" \
                    "2001-AUTH      PASS                                                          \r\n2001-\r\n" \
                    "2001-Client Commands - Any Session State                                     \r\n" \
                    "2001-FLAG      RSET                                                          \r\n2001-\r\n" \
                    "2001-Client Commands - Authenticated State                                   \r\n" \
                    "2001-CLR       FDUMP     NAMESPACE QABRT     QCREA     QDSPC     QRUN        \r\n" \
                    "2001-QSTOR     QWAIT     USER      VRFY                                      \r\n2001-\r\n" \
                    "2001-Client Commands - User State                                            \r\n" \
                    "2001-ADBK      CAL       CHECK     CREA      FEAT      MBOX      PROXY       \r\n" \
                    "2001-RESOURCE  RMOV      RNAM      RIGHTS    SHARE     SHOW      SHOWPROXY   \r\n" \
                    "2001-SHOWSH    SHOWSUB   SINFO     SPACE     STOR      STRAW     SUBS        \r\n" \
                    "2001-UNSUBS                                                                  \r\n2001-\r\n" \
                    "2001-Client Commands - Mailbox State                                         \r\n" \
                    "2001-AFLG      AINFO     BODY      BRAW      COPY      DELE      DFLG        \r\n" \
                    "2001-GFLG      GINFO     HEAD      INFO      LIST      MIME      PRGV        \r\n" \
                    "2001-PRGM      PURG      REPAIR    SALV      SEARCH    SFLG      STAT        \r\n" \
                    "2001-UPDA                                                                    \r\n2001-\r\n" \
                    "2001-Client Commands - Calendar State                                        \r\n" \
                    "2001-CSAFLG    CSATND    CSCOMP    CSCREA    CSDELE    CSDFLG    CSFILT      \r\n" \
                    "2001-CSFIND    CSGFLG    CSINFO    CSLIST    CSPRGV    CSPURG    CSRMOV      \r\n" \
                    "2001-CSRNAM    CSSALV    CSSFLG    CSSHOW    CSSTAT    CSSTOR    CSUPDA      \r\n" \
                    "2001-CSOPEN    CSORG     CSFIND    CSCHECK   CSCOPY    CSUNSUBS  CSSHOWSUB   \r\n" \
                    "2001-CSSUBS    CSSINFO   CSSTRAW   CSPRGM                                    \r\n2001-\r\n" \
                    "2001-Client Commands - Callback State                                        \r\n" \
                    "2001-QADDM     QADDQ     QBODY     QBRAW     QCOPY     QDONE     QGREP       \r\n" \
                    "2001-QHEAD     QINFO     QMIME     QMOD      QMOVE     QRCP      QRETR       \r\n" \
                    "2001-QRTS      QSRCH     QDELE     QEND                                      \r\n2001-\r\n" \
                    "2001-Extension Commands                                                      \r\n" \
                    "2001-CONF      ULIST                                                         \r\n" \
                    "2001-------------------------------------------------------------------------\r\n\r\n"
#define MSG2002DELETED "Message(s) have been marked deleted"
#define MSG2002PURGEC "Message(s) to purge"
#define MSG2003MULTIEND "2003-Multipart End\r\n"
#define MSG2004RFC822END "2004-RFC822 End\r\n"
#define MSG2005FEATURENOTAVAIL "2005-Feature not available\r\n"
#define MSG3000UNKNOWN "3000 Unknown command\r\n"
#define MSG3010BADARGC "3010 Wrong number of arguments\r\n"
#define MSG3012BADQSTATE "3012 Wrong state; not waiting on queues\r\n"
#define MSG3013BADQSTATE "3013 Wrong state; waiting on queues\r\n"
#define MSG3014REQNOTALLOWED "3014 Request not allowed!%s\r\n"
#define MSG3240NOAUTH "3240 I don't know you you are. AUTH first!\r\n"
#define MSG3240BADSTATE "3240 Command issued in wrong state\r\n"
#define MSG3241NOUSER "3241 No user selected. USER first!\r\n"
#define MSG3242BADAUTH "3242 Bad authentication!\r\n"
#define MSG4000OUTOFRANGE "4000 Number out of range\r\n"
#define MSG4000CANTUNLOCKENTRY "4000 Queue entry unknown or already being processed\r\n"
#define MSG4120BOXLOCKED "4120 Mailbox currently locked, try later!\r\n"
#define MSG4120CALLOCKED "4120 Calendar currently locked, try later!\r\n"
#define MSG4220NOMSG "4220 No message with that ID\r\n"
#define MSG4220NOENTRY "4220 No entry with that ID\r\n"
#define MSG4220USERSHARES "4220 User owns shared resources.\r\n"
#define MSG4221MBOXDONE "4221 Mailbox already selected. RSET first!\r\n"
#define MSG4221CALDONE "4221 Calendar already selected. RSET first!\r\n"
#define MSG4221USERDONE "4221 User already selected. RSET first!\r\n"
#define MSG4221MBOXLOCKED "4221 Mailbox currently locked - try later!\r\n"
#define MSG4221MBOXSHARED "4221 Mailbox is shared\r\n"
#define MSG4221CALSHARED "4221 Calendar is shared\r\n"
#define MSG4222MSGDELETED "4222 Message marked deleted\r\n"
#define MSG4223MSGDELETED "4223 Message not marked deleted\r\n"
#define MSG4224NOENTRY "4224 Queue entry does not exist\r\n"
#define MSG4224CANTREAD "4224 Can't read queue data\r\n"
#define MSG4224CANTWRITE "4224 Can't write queue data\r\n"
#define MSG4224NOSTORE "4224 User store doesn't exist\r\n"
#define MSG4224NOMBOX "4224 Mailbox doesn't exist\r\n"
#define MSG4224NOCSTORE "4224 Calendar doesn't exist\r\n"
#define MSG4224CANTREADMBOX "4224 Can't read mailbox\r\n"
#define MSG4224CANTREADCAL "4224 Can't read calendar\r\n"
#define MSG4224NOUSER "4224 User does not exist\r\n"
#define MSG4225NOCALENDAR "4225 No calendar selected. CSOPEN first!\r\n"
#define MSG4225NOMBOX "4225 No mailbox selected. MBOX first!\r\n"
#define MSG4226MBOXEXISTS "4226 Mailbox already exists\r\n"
#define MSG4226CALEXISTS "4226 Calendar already exists\r\n"
#define MSG4226QUEUEOPEN "4226 Queue entry still open\r\n"
#define MSG4227TGTMBOXSELECTED "4227 Target mailbox currently selected\r\n"
#define MSG4227TGTCALSELECTED "4227 Target calendar currently selected\r\n"
#define MSG4228CANTWRITEMBOX "4228 Can't write to mailbox\r\n"
#define MSG4228CANTWRITECAL "4228 Can't write to calendar\r\n"
#define MSG4229CANTWRITEMBOX "4229 Can't write to message store\r\n"
#define MSG4230PATHTOOLONG "4230 Path exceeds allowed length\r\n"
#define MSG4240NOPERMISSION "4240 Permission denied\r\n"
#define MSG4241AUTHDONE "4241 Already authenticated\r\n"
#define MSG4242AUTHREQUIRED "4242 NMAP <%s>\r\n"
#define MSG4260NOQENTRY "4260 No queue entry open, try QCREA\r\n"
#define MSG4261NODOMAIN "4261 No queue entry with that domain\r\n"
#define MSG4262NOTFOUND "4262 Field/Content not found\r\n"
#define MSG4242NOTALLOWED "4242 Not allowed via FLAG\r\n"
#define MSG4243READONLY "4243 Read-only message store\r\n"
#define MSG4244NOTSUPPORTED "4244 Not supported\r\n"
#define MSG5244USERLOOKUPFAILURE "5244 Failed looking up User %s\r\n"
#define MSG5000ERROR "5000 Error requested\r\n"
#define MSG5001NOMEMORY "5001 Out of memory\r\n"
#define MSG5002SHUTDOWN "5002 Server shutting down\r\n"
#define MSG5003OVERFLOW "5003 Input too long, shutting down\r\n"
#define MSG5004NOCONNECTIONS "5004 Too many connections; try later\r\n"
#define MSG5201FILEREADERR "5201 Error Reading File\r\n"
#define MSG5220QUOTAERR "5220 User Quota exceeded\r\n"
#define MSG5230NOMEMORYERR "5230 Out of memory\r\n"
#define MSG5004INTERNALERR "5004 Internal error\r\n"
#define MSG5221SPACELOW "5221 Free disk space too low\r\n"

#define NMAP_HELP_NOT_DEFINED "Help not available.\r\n"

#define NMAP_ADBK_COMMAND "ADBK"

#define NMAP_AFLG_COMMAND "AFLG"
#define NMAP_AFLG_HELP "AFLG <Sequence Number> <Flags> - Add message Flags to designated message.\r\n"

#define NMAP_AINFO_COMMAND "AINFO"
#define NMAP_AINFO_HELP "AINFO [<Sequence Number>] - Returns information for designated message.\r\n"

#define NMAP_AUTH_COMMAND "AUTH"
#define NMAP_AUTH_HELP "AUTH <Hash> - Authenticates un-trusted hosts using an MD5 hash of the NMAP password.\r\n"

#define NMAP_BRAW_COMMAND "BRAW"
#define NMAP_BRAW_HELP "BRAW <Sequence Number> <Start> <Length> - Return portion at Start, for Length, of the body of the designated message.\r\n"

#define NMAP_BODY_COMMAND "BODY"
#define NMAP_BODY_HELP "BODY <Sequence Number>- Returns body of designated message.\r\n"

#define NMAP_CAL_COMMAND "CAL"
#define NMAP_CAL_HELP "CAL <Calendar> - Selects Calendar.\r\n"

#define NMAP_CAPA_COMMAND "CAPA"
#define NMAP_CAPA_HELP "CAPA - List the NMAP version and extensions.\r\n"

#define NMAP_CHECK_COMMAND "CHECK"
#define NMAP_CHECK_HELP "CHECK <Mailbox> - Returns information for Mailbox.\r\n"

#define NMAP_CLR_COMMAND "CLR"
#define NMAP_CLR_HELP "CLR <Username> - Remove the mailstore for username.\r\n"

#define NMAP_CONF_COMMAND "CONF"

#define NMAP_COPY_COMMAND "COPY"
#define NMAP_COPY_HELP "COPY <Sequence Number> <Mailbox> - Copy the designated message to mailbox in the current user's account.\r\n"

#define NMAP_CREA_COMMAND "CREA"
#define NMAP_CREA_HELP "CREA <Mailbox> - Create new Mailbox.\r\n"

#define NMAP_CSCREA_COMMAND "CSCREA"

#define NMAP_CSOPEN_COMMAND "CSOPEN"

#define NMAP_CSORG_COMMAND "CSORG"
#define NMAP_CSORG_HELP "CSORG <Sequence Number> - Returns the event organizer for the designated iCal Object.\r\n"

#define NMAP_CSINFO_COMMAND "CSINFO"
#define NMAP_CSINFO_HELP "CSINFO [<Sequence Number>] - Returns information on the optional desginated iCal Object; otherwise, returns information on all iCal Objects.\r\n"

#define NMAP_CSFILT_COMMAND "CSFILT"

#define NMAP_CSGFLG_COMMAND "CSGFLG"

#define NMAP_CSLIST_COMMAND "CSLIST"
#define NMAP_CSLIST_HELP "CSLIST <Sequence Number> [ICAL | META] - Returns the defining data for the designated iCal Object.\r\n"

#define NMAP_CSCHECK_COMMAND "CSCHECK"

#define NMAP_CSCOMP_COMMAND "CSCOMP"

#define NMAP_CSCOPY_COMMAND "CSCOPY"

#define NMAP_CSDELE_COMMAND "CSDELE"

#define NMAP_CSDFLG_COMMAND "CSDFLG"

#define NMAP_CSAFLG_COMMAND "CSAFLG"
#define NMAP_CSAFLG_HELP "CSAFLG <Sequence Number> <Flags> - Add message Flags to designated iCal object.\r\n"

#define NMAP_CSFIND_COMMAND "CSFIND"

#define NMAP_CSATND_COMMAND "CSATND"
#define NMAP_CSATND_HELP "CSATND <Sequence Number> [<Status> <Attendee Address>] - Returns attendee information for the designated iCal object; optionally, set Status for Attendee Address.\r\n"

#define NMAP_CSUPDA_COMMAND "CSUPDA"
#define NMAP_CSUPDA_HELP "CSUPDA - Returns changes to the current calendar since connecting or last CSUPDA.\r\n"

#define NMAP_CSUNSUBS_COMMAND "CSUNSUBS"

#define NMAP_CSRMOV_COMMAND "CSRMOV"
#define NMAP_CSRMOV_HELP "CSRMOV <Calendar> - Remove Calendar.\r\n"

#define NMAP_CSRNAM_COMMAND "CSRNAM"
#define NMAP_CSRNAM_HELP "CSRNAM <Calendar> <New Calendar> - Rename Calendar to New Calendar.\r\n"

#define NMAP_CSSTOR_COMMAND "CSSTOR"
#define NMAP_CSSTOR_HELP "CSSTOR <Calendar> [<iCal Object Size>] - Append iCal Object to Calendar, iCal Object should be sent after successful response from server.\r\n"

#define NMAP_CSSTAT_COMMAND "CSSTAT"
#define NMAP_CSSTAT_HELP "CSSTAT - Returns exisiting, new and purged iCal Object counts, and cumulative sizes, for the currently selected calendar.\r\n"

#define NMAP_CSSHOW_COMMAND "CSSHOW"
#define NMAP_CSSHOW_HELP "CSSHOW [<Pattern>] - Returns the current user's calendars, filtered by optional Pattern.\r\n"

#define NMAP_CSSHOWSUB_COMMAND "CSSHOWSUB"

#define NMAP_CSSUBS_COMMAND "CSSUBS"

#define NMAP_CSSALV_COMMAND "CSSALV"
#define NMAP_CSSALV_HELP "CSSALV [<Sequence Number>] - Removes the deleted flag from the optional designated iCal Object; otherwise, removes the deleted flag from all iCal Objects in the current calendar.\r\n"

#define NMAP_CSSFLG_COMMAND "CSSFLG"

#define NMAP_CSSINFO_COMMAND "CSSINFO"

#define NMAP_CSSTRAW_COMMAND "CSSTRAW"

#define NMAP_CSSQL_COMMAND "CSSQL"

#define NMAP_CSPURG_COMMAND "CSPURG"
#define NMAP_CSPURG_HELP "CSPURG [<Sequence Number>] - Remove optional designated iCal Object if flagged as deleted; otherwise, removes all iCal Objects flagged as deleted in the current calendar.\r\n"

#define NMAP_CSPRGV_COMMAND "CSPRGV"
#define NMAP_CSPRGV_HELP "CSPRGV [<Sequence Number>] - Equivalent to the CSPURG command, except more verbose.\r\n"

#define NMAP_CSPRGM_COMMAND "CSPRGM"

#define NMAP_DELE_COMMAND "DELE"
#define NMAP_DELE_HELP "DELE [<Sequence Number>] - Set the delete flag on the optional designated message; otherwise, returns all messages flagged deleted.\r\n"

#define NMAP_DFLG_COMMAND "DFLG"
#define NMAP_DFLG_HELP "DFLG <Sequence Number> <Flags> - Remove Flags from the designated message.\r\n"

#define NMAP_ERRO_COMMAND "ERRO"
#define NMAP_ERRO_HELP "ERRO - Force the server to issue error code 5000.\r\n"

#define NMAP_FDUMP_COMMAND "FDUMP"

#define NMAP_FEAT_COMMAND "FEAT"

#define NMAP_FLAG_COMMAND "FLAG"
#define NMAP_FLAG_HELP "FLAG - Sets parameters for the current NMAP connection.\r\n"

#define NMAP_GFLG_COMMAND "GFLG"
#define NMAP_GFLG_HELP "GFLG <Sequence Number> - Returns the message flags for the designated message.\r\n"

#define NMAP_GINFO_COMMAND "GINFO"
#define NMAP_GINFO_HELP "GINFO [<Sequence Number>] <Header Item> - Returns same information as INFO along with the contents of Header Item for the optional designated message; otherwise, returns Header Item for all messages in the current mailbox.\r\n"

#define NMAP_GUID_COMMAND "GUID"
#define NMAP_GUID_COMMAND_HELP "GUID - Returns a globally unique identifier."

#define NMAP_HEAD_COMMAND "HEAD"
#define NMAP_HEAD_HELP "HEAD <Sequence Number> - Returns the header of the designated message.\r\n"

#define NMAP_HELP_COMMAND "HELP"
#define NMAP_HELP_HELP "HELP [Command] - Without an argument, lists all NMAP Commands, otherwise lists basic description of Command\r\n"

#define NMAP_INFO_COMMAND "INFO"
#define NMAP_INFO_HELP "INFO [<Sequence Number>] - Returns information on the optional designated message; otherwise, returns information on all messages in the current mailbox.\r\n"

#define NMAP_LIST_COMMAND "LIST"
#define NMAP_LIST_HELP "LIST <Sequence Number> - Returns the designated message's header and body.\r\n"

#define NMAP_MBOX_COMMAND "MBOX"
#define NMAP_MBOX_HELP "MBOX <Mailbox> - Selects Mailbox.\r\n"

#define NMAP_MIME_COMMAND "MIME"
#define NMAP_MIME_HELP "MIME <Sequence Number> - Returns the designated messages structure in multiple 2002/2003/2004 responses.\r\n"

#define NMAP_MIMED_COMMAND "MIMED"
#define NMAP_MIMED_HELP "MIMED <Sequence Number> - Returns the designated messages structure in multiple 2002/2003/2004 responses.\r\n"

#define NMAP_NAMESPACE_COMMAND "NAMESPACE"
#define NMAP_NAMESPACE_HELP "NAMESPACE - returns the heirarchical delimiter and the folder prefixes for personal, shared and public folders.\r\n"

#define NMAP_NOOP_COMMAND "NOOP"

#define NMAP_NVER_COMMAND "NVER"
#define NMAP_NVER_HELP "NVER - Returns the client's NMAP version with an optional comment.\r\n"

#define NMAP_OPER_COMMAND "OPER"

#define NMAP_PURG_COMMAND "PURG"
#define NMAP_PURG_HELP "PURG [<Sequence Number>] - Remove optional designated message if flagged as deleted; otherwise, removes all messages flagged as deleted in the current mailbox.\r\n"

#define NMAP_PRGM_COMMAND "PRGM"

#define NMAP_PRGV_COMMAND "PRGV"
#define NMAP_PRGV_HELP "PRGV [<Sequence Number>] - Equivalent to the PURG command, except more verbose.\r\n"

#define NMAP_PASS_COMMAND "PASS"
#define NMAP_PASS_HELP "PASS {SYS | <USER <Username>} <Password> - Authenticate as NMAP or Username with cleartext Password.\r\n"

#define NMAP_PROXY_COMMAND "PROXY"

#define NMAP_QADDM_COMMAND "QADDM"

#define NMAP_QADDQ_COMMAND "QADDQ"

#define NMAP_QABRT_COMMAND "QABRT"
#define NMAP_QABRT_HELP "QABRT - Removes the current message before processing.\r\n"

#define NMAP_QBODY_COMMAND "QBODY"

#define NMAP_QBRAW_COMMAND "QBRAW"

#define NMAP_QCOPY_COMMAND "QCOPY"

#define NMAP_QCREA_COMMAND "QCREA"
#define NMAP_QCREA_HELP "QCREA [<Queue>] - Creates a new queue entry.\r\n"

#define NMAP_QDELE_COMMAND "QDELE"

#define NMAP_QDONE_COMMAND "QDONE"

#define NMAP_QDSPC_COMMAND "QDSPC"
#define NMAP_QDSPC_HELP "QDSPC - Returns the amount of MemFree disk space, in bytes, in the message queue.\r\n"

#define NMAP_QEND_COMMAND "QEND"

#define NMAP_QGREP_COMMAND "QGREP"

#define NMAP_QHEAD_COMMAND "QHEAD"

#define NMAP_QINFO_COMMAND "QINFO"

#define NMAP_QMOD_FROM_COMMAND "QMOD FROM"

#define NMAP_QMOD_FLAGS_COMMAND "QMOD FLAGS"

#define NMAP_QMOD_LOCAL_COMMAND "QMOD LOCAL"

#define NMAP_QMOD_MAILBOX_COMMAND "QMOD MAILBOX"

#define NMAP_QMOD_RAW_COMMAND "QMOD RAW"

#define NMAP_QMOD_TO_COMMAND "QMOD TO"

#define NMAP_QMIME_COMMAND "QMIME"

#define NMAP_QMOVE_COMMAND "QMOVE"

#define NMAP_QRCP_COMMAND "QRCP"

#define NMAP_QRETR_COMMAND "QRETR"

#define NMAP_QRTS_COMMAND "QRTS"

#define NMAP_QRUN_COMMAND "QRUN"
#define NMAP_QRUN_HELP "QRUN [<Queue ID>] - Places a queue entry in the message queue for immediate processing.\r\n"

#define NMAP_QSQL_COMMAND "QSQL"

#define NMAP_QSRCH_DOMAIN_COMMAND "QSRCH DOMAIN"

#define NMAP_QSRCH_HEADER_COMMAND "QSRCH HEADER"

#define NMAP_QSRCH_BODY_COMMAND "QSRCH BODY"

#define NMAP_QSRCH_BRAW_COMMAND "QSRCH BRAW"

#define NMAP_QSTOR_ADDRESS_COMMAND "QSTOR ADDRESS"

#define NMAP_QSTOR_CAL_COMMAND "QSTOR CAL"

#define NMAP_QSTOR_FLAGS_COMMAND "QSTOR FLAGS"

#define NMAP_QSTOR_FROM_COMMAND "QSTOR FROM"

#define NMAP_QSTOR_LOCAL_COMMAND "QSTOR LOCAL"

#define NMAP_QSTOR_MESSAGE_COMMAND "QSTOR MESSAGE"

#define NMAP_QSTOR_RAW_COMMAND "QSTOR RAW"

#define NMAP_QSTOR_TO_COMMAND "QSTOR TO"

#define NMAP_QUIT_COMMAND "QUIT"
#define NMAP_QUIT_HELP "QUIT - Closes the client's NMAP connection.\r\n"

#define NMAP_QWAIT_COMMAND "QWAIT"
#define NMAP_QWAIT_HELP "QWAIT <Queue> <Port> <Identifier> - Register for NMAP message queue.\r\n"

#define NMAP_RNAM_COMMAND "RNAM"
#define NMAP_RNAM_HELP "RNAM <Mailbox> <New Mailbox> - Rename Mailbox to New Mailbox.\r\n"

#define NMAP_RSET_COMMAND "RSET"
#define NMAP_RSET_HELP "RSET [CAL | MBOX] - Resets the current session to it's previous state.\r\n"

#define NMAP_RIGHTS_COMMAND "RIGHTS"

#define NMAP_RMOV_COMMAND "RMOV"
#define NMAP_RMOV_HELP "RMOV <Mailbox> - Remove Mailbox.\r\n"

#define NMAP_REPAIR_COMMAND "REPAIR"

#define NMAP_RESOURCE_COMMAND "RESOURCE"

#define NMAP_SALV_COMMAND "SALV"
#define NMAP_SALV_HELP "SALV [<Sequence Number>] - Removes the deleted flag from the optional designated message; otherwise, rmoves the deleted flag from all messages in the current mailbox.\r\n"

#define NMAP_SEARCH_COMMAND "SEARCH"
#define NMAP_SEARCH_HELP "SEARCH {FLAG | BODY | TEXT | HDR | SIZE | RECEIVED | SENT} <Value> - Searches all messages in the current mailbox matching the specified parameters.\r\n"

#define NMAP_SFLG_COMMAND "SFLG"
#define NMAP_SFLG_HELP "SFLG <Sequence Number> <Flags> - Replaces all existing flags on the designated message with Flags.\r\n"

#define NMAP_SHOW_COMMAND "SHOW"
#define NMAP_SHOW_HELP "SHOW [<Pattern>] - Returns the current user's mailboxes, filtered by optional Pattern.\r\n"

#define NMAP_SHARE_ADBK_COMMAND "SHARE ADBK"

#define NMAP_SHARE_CAL_COMMAND "SHARE CAL"

#define NMAP_SHARE_MBOX_COMMAND "SHARE MBOX"

#define NMAP_SHOWPROXY_COMMAND "SHOWPROXY"

#define NMAP_SHOWSH_COMMAND "SHOWSH"
#define NMAP_SHOWSH_HELP "SHOWSH [<Pattern>] - Returns the current user's mailboxes from shares, filtered by optional Pattern.\r\n"

#define NMAP_SHOWSUB_COMMAND "SHOWSUB"
#define NMAP_SHOWSUB_HELP "SHOWSUB [<Pattern>] - Returns the current user's subscribed mailboxes, filtered by optional Pattern.\r\n"

#define NMAP_SINFO_COMMAND "SINFO"

#define NMAP_SPACE_COMMAND "SPACE"
#define NMAP_SPACE_HELP "SPACE - Returns the current user's used mailbox space and quota.\r\n"

#define NMAP_STAT_COMMAND "STAT"
#define NMAP_STAT_HELP "STAT - Returns exisiting, new and purged message counts, and cumulative sizes, for the currently selected mailbox.\r\n"

#define NMAP_STOR_COMMAND "STOR"
#define NMAP_STOR_HELP "STOR <Mailbox> [D<Date>] <Flags> [NOAUTH] [<Size>] - Append message to Mailbox, message should be sent after successful response from server.\r\n"

#define NMAP_STRAW_COMMAND "STRAW"

#define NMAP_SUBS_COMMAND "SUBS"

#define NMAP_TLS_COMMAND "TLS"
#define NMAP_TLS_HELP "TLS - Performs a TLS negotiation to encrypt the transport.\r\n"

#define NMAP_ULIST_COMMAND "ULIST"

#define NMAP_UNSUBS_COMMAND "UNSUBS"

#define NMAP_UPDA_COMMAND "UPDA"
#define NMAP_UPDA_HELP "UPDA - Returns changes to the current mailbox since connecting or last UPDA.\r\n"

#define NMAP_USER_COMMAND "USER"
#define NMAP_USER_HELP "USER <Username> - Selects the account for Username.\r\n"

#define NMAP_VRFY_COMMAND "VRFY"
#define NMAP_VRFY_HELP "VRFY <Username> - Verify existence of Username.\r\n"

#define NMAP_QDB_SQLITE_CREATE "CREATE TABLE DOMAINS (DOMAIN VARCHAR(256) NOT NULL, ENTRYID INTEGER CHECK (VALUE BETWEEN 0 AND 268435455) UNIQUE NOT NULL, ENTRYQ INTEGER DEFAULT 0, PRIMARY KEY (ENTRYID));"
#define NMAP_QDB_SQLITE_INDEX "CREATE INDEX DOMAINS_INDEX ON DOMAINS (DOMAIN, ENTRYID);"

#define CR 0x0D
#define LF 0x0A

#define MBOX_LOCK_ARRAY_SIZE 1023
#define MBOX_LOCK_SEM_ARRAY_SIZE 127
#define CSTORE_LOCK_ARRAY_SIZE 1023
#define CSTORE_LOCK_SEM_ARRAY_SIZE 127

#define STATE_EXITING 6

#define RTS_RETURN (1<<0)
#define RTS_CC_POSTMASTER (1<<1)

#define REPAIR_VERBOSE (1<<0)

#define QLIMIT_CONCURRENT 250
#define QLIMIT_SEQUENTIAL 500

#define STACKSPACE_Q (1024*80)
#define STACKSPACE_S (1024*80)

#define DEFAULT_QUOTA_WARNING "Your mailbox is almost full. Please delete some messages!\r\nOnce it is full, your messages will be returned to the sender.\r\n"
#define DEFAULT_QUOTA_MESSAGE "  \tThe user has exceeded the allowable disk quota.\r\n"
#define DEFAULT_NEW_SHARE_MESSAGE "A shared resource has been made available for your use."

#define MAILBOX_TIMEOUT 45

#define DOMAIN_KEYLENGTH 128

/* Must always be 1 more than SPOOL_LOCK_ARRAY_MASK */
#define SPOOL_LOCK_ARRAY_SIZE 256
#define SPOOL_LOCK_IDARRAY_SIZE 64

#define TAKE_PURGES 0 /* Used to read all changed flags from disk */
#define CHANGE_PURGES 1 /* Used to read all changed flags from disk, converting purges to deletes */ 
#define IGNORE_PURGES 2 /* Used to read changed flags from disk while hiding purges from the client */

#define SILENT 0 /* Used to update memory flags with out informing client                                                                    */
#define NOTIFY_CLIENT_SYNC 1  /* Used to update memory flags and inform client synchronously                                                            */
#define NOTIFY_CLIENT_ASYNC 2 /* Used to update memory flags and inform client asynchronously                                                        */

#define NMAP_GUID_PREFIX_LENGTH (SHA_DIGEST_LENGTH * 2)
#define NMAP_GUID_SUFFIX_LENGTH 6
#define NMAP_GUID_LENGTH (NMAP_GUID_PREFIX_LENGTH + NMAP_GUID_SUFFIX_LENGTH)

#define GENERATE_FROM_DELIMITER(t, a, b, l) \
        { \
            register unsigned char *d = (unsigned char *)(b); \
            register const unsigned char *s = (const unsigned char *)(a); \
            memcpy(d, "From ", 5); \
            d += 5; \
            while ((*d++ = *s++) != '\0') ; \
            d[-1] = ' '; \
            s = (const unsigned char *)(t); \
            if ((t)[3] == ' ') { \
                while ((*d++ = *s++) != '\0') ; \
            } else { \
                *d++ = *s++; \
                *d++ = *s++; \
                *d++ = *s++; \
                s++; \
                while ((*d++ = *s++) != '\0') ; \
            } \
            d[-1] = '\r'; \
            *d++ = '\n'; \
            *d = '\0'; \
            (l) = (d) - (b); \
        }

#define GET_STRING_HASH(s, v) \
        { \
            register unsigned long b = 1; \
            register unsigned long h = 0; \
            register unsigned char *c; \
            c = (s); \
            while (*c != '\0') { \
                h += ((tolower(*c)) * b); \
                b = (b << 5) - b; \
                c++; \
            } \
            (v) = h; \
        }

#define UPDATE_QUEUE_CLIENTS_REGISTERED \
        { \
            register unsigned long count; \
            NMAP.queue.clients.registered[0] = TRUE; \
            NMAP.queue.clients.registered[1] = TRUE; \
            NMAP.queue.clients.registered[2] = FALSE; \
            NMAP.queue.clients.registered[3] = FALSE; \
            NMAP.queue.clients.registered[4] = FALSE; \
            NMAP.queue.clients.registered[5] = FALSE; \
            NMAP.queue.clients.registered[6] = TRUE; \
            NMAP.queue.clients.registered[7] = TRUE; \
            for (count = 0; count < NMAP.queue.clients.count; count++) { \
                if (NMAP.queue.clients.array[count].queue < 8) { \
                    NMAP.queue.clients.registered[NMAP.queue.clients.array[count].queue] = TRUE; \
                } \
            } \
        }

/* fixme - adjust implementation and usage for returning ccode */
#define GET_CHANGED_FLAGS(INDEX_PATH, PURGE_HANDLING, NOTIFICATION) \
        { \
            unsigned long i; \
            unsigned long state; \
            unsigned long *msgInfoState; \
            unsigned long msgUsed; \
            FILE *indexFH; \
            if (((((PURGE_HANDLING) == TAKE_PURGES) || ((PURGE_HANDLING) == CHANGE_PURGES)) && client->mailbox.unseenPurge) \
                    || ((stat((INDEX_PATH), &sb) == 0) && (client->mailbox.indexTime != sb.st_mtime))) { \
                indexFH = fopen((INDEX_PATH),"rb"); \
                if (indexFH) { \
                    msgUsed = client->mailbox.message.used; \
                    for (i = 0; i < msgUsed; i++) { \
                        if (fseek(indexFH, NMAP_IDX_HEADERSIZE + (i * sizeof(MessageInfoStruct)) + offsetof(MessageInfoStruct, State), SEEK_SET) == 0) { \
                            fread(&state, sizeof(unsigned long), 1, indexFH); \
                            msgInfoState = &(client->mailbox.message.info[i].State); \
                            if ((*msgInfoState & ~MSG_STATE_RECENT) != state) { \
                                if (state & MSG_STATE_PURGED) { \
                                    if (!(*msgInfoState & MSG_STATE_PURGED)) { \
                                        if ((PURGE_HANDLING) == TAKE_PURGES) { \
                                            client->mailbox.changed = TRUE; \
                                            if ((NOTIFICATION) == NOTIFY_CLIENT_SYNC) { \
                                                ConnWriteF(client->conn, "6001-%lu %lu\r\n", i + 1, state); \
                                            } \
                                        } \
                                        if ((PURGE_HANDLING) == IGNORE_PURGES) { \
                                            if (!client->mailbox.unseenPurge) { \
                                                client->mailbox.unseenPurge = TRUE; \
                                                if ((NOTIFICATION) == NOTIFY_CLIENT_ASYNC) { \
                                                    ConnWriteF(client->conn, "6000 %d %lu %lu Unseen Purge\r\n", EVENT_MBOX_UNSEEN_PURGES, i + 1, state); \
                                                } \
                                            } \
                                            state &= ~MSG_STATE_PURGED; \
                                            if (*msgInfoState & MSG_STATE_DELETED) { \
                                                state |= MSG_STATE_DELETED; \
                                            } \
                                        } \
                                        if ((PURGE_HANDLING) == CHANGE_PURGES) { \
                                            state &= ~MSG_STATE_PURGED; \
                                            state |= MSG_STATE_DELETED; \
                                        } \
                                    } \
                                } else { \
                                    if ((NOTIFICATION) == NOTIFY_CLIENT_SYNC) { \
                                        ConnWriteF(client->conn, "6001-%lu %lu\r\n", i + 1, state); \
                                    } \
                                    if ((NOTIFICATION) == NOTIFY_CLIENT_ASYNC) { \
                                        ConnWriteF(client->conn, "6000 %lu %lu %lu\r\n", (long unsigned int)EVENT_MBOX_FLAGS_CHANGED, i + 1, state); \
                                    } \
                                } \
                                *msgInfoState = state; \
                            } \
                        } \
                    } \
                    fclose(indexFH); \
                    client->mailbox.indexTime = (unsigned long)sb.st_mtime; \
                    if ((PURGE_HANDLING) != IGNORE_PURGES) { \
                        client->mailbox.unseenPurge = FALSE; \
                    } \
                } \
            } \
        }

typedef enum _NMAPShareFlags {
    NMAP_SHARE_MAILBOX = (1 << 0), 
    NMAP_SHARE_CALENDAR = (1 << 1), 
    NMAP_SHARE_ADDRESS_BOOK = (1 << 2), 
    NMAP_SHARE_PUBLIC = (1 << 3), 
    NMAP_SHARE_SEND_MESSAGE = (1 << 4), 
    NMAP_SHARE_RESOURCE = (1 << 5), 
    NMAP_SHARE_MAILBOX_DENIED = (1 << 6), 
    NMAP_SHARE_CALENDAR_DENIED = (1 << 7)
} NMAPShareFlags;

typedef enum _NMAPStates {
    NMAP_STARTING = 0, 
    NMAP_INITIALIZING, 
    NMAP_LOADING, 
    NMAP_RUNNING, 
    NMAP_RELOADING, 
    NMAP_UNLOADING, 
    NMAP_STOPPING, 
    NMAP_DONE, 

    NMAP_MAX_STATES
} NMAPStates;

typedef enum _NMAPFlags {
    NMAP_FLAG_DISK_SPACE_LOW = (1 << 0), 
    NMAP_FLAG_DEBUG = (1 << 1), 
} NMAPFlags;

typedef enum _NMAPReceiverStates {
    NMAP_RECEIVER_SHUTTING_DOWN = 1, 
    NMAP_RECEIVER_DISABLED, 
    NMAP_RECEIVER_CONNECTION_LIMIT, 
    NMAP_RECEIVER_OUT_OF_MEMORY, 

    NMAP_RECEIVER_MAX_STATES
} NMAPReceiverStates;

#define	NMAP_CLIENT_EXITING (1 << 0)
#define	NMAP_CLIENT_AUTHORIZED (1 << 1)
#define	NMAP_CLIENT_USER (1 << 2)
#define	NMAP_CLIENT_MBOX (1 << 3)
#define	NMAP_CLIENT_CAL (1 << 4)
#define	NMAP_CLIENT_QUEUE (1 << 5)
#define NMAP_CLIENT_CALSEL (1 << 6)

typedef enum _ShareAction {
    NMAP_CREATE_SHARE = 0, 
    NMAP_MODIFY_SHARE, 
    NMAP_DELETE_SHARE, 
    NMAP_DUPLICATE_SHARE, 

    NMAP_MAX_SHARE_ACTIONS
} ShareAction;

typedef struct _QueryResults {
    struct {
        unsigned long count;
        MDBValueStruct *names;
    } column;

    struct {
        unsigned long count;
        MDBValueStruct *values;
    } row;
} QueryResults;

typedef struct _NmapSqlCalComp {
    NmapCalID compID;
    NmapCalID objID;

    NmapCalID parentID;
    int position;

    enum ICal2ComponentType type;

    unsigned int length;

    unsigned long flags;

    double start;
    double end;
    double modified;

    unsigned char *organizer;
    unsigned char *summary;
} NmapSqlCalComp;

typedef struct _NmapSqlCalCompInfo {
    unsigned int allocated;
    unsigned int used;

    NmapSqlCalComp list[1];
} NmapSqlCalCompInfo;

typedef struct _NMAPClientSQLStatements {
    /*
        The begin and end statement pointers are position sensitive
        and should not be moved.

        Additional statement pointers should be added between the 
        begin and end statement pointers.
    */
    sqlite3_stmt *begin;

    struct {
        sqlite3_stmt *cal;
        sqlite3_stmt *object;
        sqlite3_stmt *comp;
        sqlite3_stmt *prop;
        sqlite3_stmt *param;
        sqlite3_stmt *altName;
    } ins;

    struct {
        sqlite3_stmt *calIDGuidName;
        sqlite3_stmt *calIDByName;
        sqlite3_stmt *objIDByGuid;
        sqlite3_stmt *objIDByAltName;
        sqlite3_stmt *lastCompIDByObj;
        sqlite3_stmt *lastPropIDByComp;
    } sel;

    struct {
        sqlite3_stmt *renCal;
    } upd;

    struct {
        sqlite3_stmt *onObj;
        sqlite3_stmt *onComp;
        sqlite3_stmt *onProp;
    } info;

    struct {
        sqlite3_stmt *onObj;
        sqlite3_stmt *onComp;
        sqlite3_stmt *onProp;
        sqlite3_stmt *onParam;
    } list;

    sqlite3_stmt *abort;
    sqlite3_stmt *end;
} NMAPClientSQLStatements;

typedef struct _NMAPClient {
    unsigned long states;
    BOOL systemAuth;

    Connection *conn;

    /* Connection variables */
    unsigned long flags;
    unsigned long userHash;

    unsigned char user[MAXEMAILNAMESIZE + 1];
    unsigned char dn[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char buffer[CONN_BUFSIZE + 1];
    unsigned char line[CONN_BUFSIZE + 1];
    unsigned char path[XPL_MAX_PATH + 1];

    const unsigned char *store;

    struct {
        unsigned long flags;

        struct {
            unsigned long permissions;
            Connection *conn;
        } mailbox;

        struct {
            unsigned long permissions;
            Connection *conn;
        } calendar;
    } share;

    ProtocolCommand *command;

    void *object;

    struct {
        FILE *control;
        FILE *data;
        FILE *work;

        unsigned char workQueue[12];

        unsigned long id;
        unsigned long target;

        MIMEReportStruct *report;
    } queue;

    struct {
        BOOL newline;
        BOOL changed;
        BOOL unseenPurge;

        unsigned long flags;
        unsigned long newCount;
        unsigned long size;
        unsigned long newSize;
        unsigned long id;
        unsigned long nextUID;
        time_t indexTime;
        unsigned long *unseenFlags;

        unsigned char name[XPL_MAX_PATH + 1];

        FILE *fh;

        NLockStruct *lock;

        struct {
            unsigned long count;
            unsigned long used;
            unsigned long allocated;

            MessageInfoStruct *info;
        } message;
    } mailbox;

    /* Calendar variables */
#if defined(NMAP_SQL_CALENDARS)
    struct {
        unsigned long flags;

        NmapCalID id;

        unsigned char name[XPL_MAX_PATH + 1];

        NMAPClientSQLStatements sql;

        sqlite3 *handle;

        NmapSqlCalCompInfo *objects;
    } cal;
#else
    struct {
        unsigned long flags;
        unsigned long size;
        unsigned long changed;
        unsigned long id;
        unsigned long nextUID;
        time_t indexTime;
        unsigned long indexChanged;

        unsigned char name[XPL_MAX_PATH + 1];

        FILE *fh;

        NLockStruct *lock;

        struct {
            unsigned long count;
            unsigned long used;
            unsigned long allocated;

            CalendarInfoStruct *info;
        } entries;
    } calendar;
#endif
} NMAPClient;

typedef struct _NMAPQueueClient {
    int port;
    int queue;

    unsigned long address;
    unsigned long usageCount;
    unsigned long errorCount;

    unsigned char identifier[MDB_MAX_OBJECT_CHARS + 1];
} NMAPQueueClient;

typedef struct _NMAPGlobals {
    NMAPStates state;
    NMAPFlags flags;

    NMAPReceiverStates receiver;

    unsigned long flushFlags;
    unsigned long universalCounter;

    unsigned char *newShareMessage;
    unsigned char postMaster[MAXEMAILNAMESIZE + 1];
    unsigned char officialName[MAXEMAILNAMESIZE + 1];

    ProtocolCommandTree commands;

    struct {
        struct {
            XplAtomic toNMAP;/* MSGSRV_NMAP_TO_NMAP_AGENT */
            XplAtomic servicedNMAP;
        } nmap;

        struct {
            XplAtomic count; /* MSGSRV_MSG_STORED_LOCAL */
            XplAtomic recipients; /* MSGSRV_RCPT_STORED_LOCAL */
            XplAtomic bytes; /* MSGSRV_BYTE_STORED_LOCAL */
        } storedLocal;

        struct {
            XplAtomic messages; /* MSGSRV_MSG_QUEUED_LOCAL */
        } queuedLocal;

        XplAtomic spam; /* MSGSRV_SPAM_QUEUESPAM */

        struct {
            XplAtomic local; /* MSGSRV_DELIVERY_FAILED_LOCAL */
            XplAtomic remote; /* MSGSRV_DELIVERY_FAILED_REMOTE */
        } deliveryFailed;

        XplAtomic servicedAgents;
    } stats;

    struct {
        XplSemaphore semaphore;

        struct {
            XplSemaphore todo;

            XplAtomic maximum;
            XplAtomic active;
            XplAtomic idle;

            Connection *head;
            Connection *tail;
        } worker;

        void *pool;

        time_t sleepTime;
    } client;

    struct {
        MDBHandle directory;

        void *logging;
    } handle;

    struct {
        BOOL enabled;
        unsigned char start[7];
        unsigned char end[7];
    } defer;

    struct {
        XplThreadID main;
        XplThreadID group;
        XplThreadID load;
    } id;

    struct {
        BOOL disabled;

        unsigned long interval;
        unsigned long low;
        unsigned long high;
    } loadMonitor;

    struct {
        struct {
            XplSemaphore sems[128];
            unsigned char array[CSTORE_LOCK_ARRAY_SIZE + 1];
        } calendar;

        struct {
            XplSemaphore sems[128];

            unsigned char array[MBOX_LOCK_ARRAY_SIZE + 1];
        } mailbox;

        struct {
            XplSemaphore semaphores[SPOOL_LOCK_ARRAY_SIZE];

            unsigned long *entryIDs;
        } spool;

        XplRWLock config;
    } lock;

    struct {
        unsigned char delimiter;
        unsigned char userPrefix[XPL_MAX_PATH + 1];
        unsigned char publicPrefix[XPL_MAX_PATH + 1];
    } nameSpace;

    struct {
        unsigned char mail[XPL_MAX_PATH + 1];
        unsigned char scms[XPL_MAX_PATH + 1];
        unsigned char spool[XPL_MAX_PATH + 1];
        unsigned char dbf[XPL_MAX_PATH + 1];
        unsigned char qClients[XPL_MAX_PATH + 1];
        unsigned char qDomains[XPL_MAX_PATH + 1];
    } path;

    struct {
        BOOL restartNeeded;
        BOOL inhibitSpam;

        long id;
        unsigned long sleep;
        unsigned long minimumFree;

        time_t maxLinger;

        XplSemaphore semaphore;

        struct {
            unsigned long count;
            unsigned long maxCount;

            time_t last;
            time_t interval;
        } bounce;

        struct {
            BOOL registered[8];

            unsigned long count;
            unsigned long allocated;

            NMAPQueueClient *array;
        } clients;

        struct {
            BOOL enabled;
            unsigned char address[MAXEMAILNAMESIZE + 1];
        } forwardUndeliverable;

        struct {
            long concurrent;
            long sequential;
            long defaultConcurrent;
            long defaultSequential;
            long trigger;
        } limit;

        struct {
            XplSemaphore todo;

            XplAtomic maximum;
            XplAtomic active;
        } worker;
    } queue;

    struct {
        XplSemaphore semaphore;

        unsigned char next[NMAP_GUID_LENGTH];
    } guid;

    struct {
        BOOL useSystem;
        BOOL useUser;

        unsigned long defaultValue;
        unsigned char *message;
        unsigned char *warning;
    } quota;

    struct {
        BOOL blockSpam;
        unsigned long handling;
        unsigned long maxBodySize;
    } rts;

    struct {
        int userThreshold;
        unsigned long sizeThreshold;
    } scms;

    struct {
        XplSemaphore main;
        XplSemaphore shutdown;
    } sem;

    struct {
        struct {
            BOOL enable;

            ConnSSLConfiguration config;

            SSL_CTX *context;

            Connection *conn;
        } ssl;

        BOOL bound;

        Connection *conn;   /*  NMAPServerSocket */

        XplAtomic active;

        unsigned long ipAddress;
        unsigned long bytesPerBlock;

        unsigned char dn[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char host[MAXEMAILNAMESIZE + 1];
        unsigned char hash[NMAP_HASH_SIZE];
    } server;

    struct {
        time_t startup;
        time_t global;
    } time;

    struct {
        unsigned long count;

        unsigned long *hosts;
    } trusted;
} NMAPGlobals;

/* nmapd.c */
extern NMAPGlobals NMAP;
extern unsigned char *MonthsOfTheYear[];

#if !defined(DEBUG)
#define NMAPClientAlloc() MemPrivatePoolGetEntry(NMAP.client.pool)
#else
#define NMAPClientAlloc() MemPrivatePoolGetEntryDebug(NMAP.client.pool, __FILE__, __LINE__)
#endif

/* client.c */
void FreeClientData(NMAPClient *client);
int NmapCommandAuth(void *param);
int NmapCommandPass(void *param);
int NmapCommandUlist(void *param);
int NmapCommandUser(void *param);

/* management.c */
ManagementVariables *GetNMAPManagementVariables(void);
ManagementCommands *GetNMAPManagementCommands(void);
int GetNMAPManagementVariablesCount(void);
int GetNMAPManagementCommandsCount(void);

/* calendar.c */
#if !defined(NMAP_SQL_CALENDARS)
CalendarInfoStruct *AddCalendarInfo(NMAPClient *client, unsigned long increment);
int WaitforAndLockCalendar(const unsigned char *store, unsigned char *user, unsigned char *calendar);
void UnlockCalendar(const unsigned char *store, unsigned char *user, unsigned char *calendar);
BOOL StoreCalendar(NMAPClient *client);
int ParseCalendar(NMAPClient *client);
int StoreCalendarEvent(unsigned char *sender, unsigned char *authenticatedSender, unsigned char *recipient, unsigned char *calendarName, FILE *data, unsigned long eventSize, BOOL storeRaw);
int NmapCommandCsopen(void *param);
int NmapCommandCal(void *param);
int NmapCommandCsorg(void *param);
int NmapCommandCsinfo(void *param);
int NmapCommandCsfilt(void *param);
int NmapCommandCsfind(void *param);
int NmapCommandCsgflg(void *param);
int NmapCommandCslist(void *param);
int NmapCommandCscrea(void *param);
int NmapCommandCscheck(void *param);
int NmapCommandCscomp(void *param);
int NmapCommandCscopy(void *param);
int NmapCommandCsdele(void *param);
int NmapCommandCsdflg(void *param);
int NmapCommandCsaflg(void *param);
int NmapCommandCsatnd(void *param);
int NmapCommandCsupda(void *param);
int NmapCommandCsunsubs(void *param);
int NmapCommandCsrmov(void *param);
int NmapCommandCsrnam(void *param);
int NmapCommandCsstraw(void *param);
int NmapCommandCsstor(void *param);
int NmapCommandCsstat(void *param);
int NmapCommandCsshow(void *param);
int NmapCommandCsshowsub(void *param);
int NmapCommandCssubs(void *param);
int NmapCommandCssalv(void *param);
int NmapCommandCssflg(void *param);
int NmapCommandCssinfo(void *param);
int NmapCommandCspurg(void *param);
int NmapCommandShareCal(void *param);
#endif

/* nmapd.c */
void NMAPClientFree(NMAPClient *CC);
BOOL SetLongName(unsigned char *path, unsigned char *scratch);
BOOL SetLongPathName(unsigned char *path);
unsigned long CalcUsedSpace(unsigned char *path, int pathLen, unsigned char *scratch);
void CollapseSubTree(const unsigned char *storePath, unsigned char *user, unsigned char *mailbox, unsigned char *buffer, unsigned int bufferLength);
int NmapCommandCapa(void *param);
int NmapCommandConf(void *param);
int NmapCommandErro(void *param);
int NmapCommandFdump(void *param);
int NmapCommandFeat(void *param);
int NmapCommandHelp(void *param);
int NmapCommandNamespace(void *param);
int NmapCommandNoop(void *param);
int NmapCommandNver(void *param);
int NmapCommandOper(void *param);
int NmapCommandProxy(void *param);
int NmapCommandQuit(void *param);
int NmapCommandRset(void *param);
int NmapCommandTls(void *param);
int NmapCommandSpace(void *param);
int NmapCommandUpda(void *param);
int NmapCommandVrfy(void *param);
int HandleCommand(NMAPClient *client);

/* domain.c */
int QDBStartup(int minimum, int maximum);
void QDBShutdown(void);
void *QDBHandleAlloc(void);
void QDBHandleRelease(void *handle);
int QDBAdd(void *handle, unsigned char *domain, unsigned long queueID, int queue);
int QDBRemoveID(void *handle, unsigned long queueID);
int QDBRemoveDomain(void *handle, unsigned char *domain);
int QDBSearchID(void *handle, unsigned long queueID, MDBValueStruct *vs);
int QDBSearchDomain(void *handle, unsigned char *domain, MDBValueStruct *vs);
int QDBQuery(void *handle, unsigned char *query, QueryResults *results);
int QDBDump(unsigned char *domain);
void QDBSummarizeQueue(void);

/* mailbox.c */
BOOL AddMsgInfo(NMAPClient *client, unsigned long increment);
BOOL StoreMaildrop(NMAPClient *client);
BOOL ParseMaildrop(NMAPClient *client);
int StoreMessageInMailbox(unsigned char *sender, unsigned char *authSender, unsigned char *recipient, unsigned char *mBoxName, FILE *messageFH, unsigned long scmsID, unsigned long messageSize, unsigned long flags);
int NmapCommandAflg(void *param);
int NmapCommandAinfo(void *param);
int NmapCommandBody(void *param);
int NmapCommandBraw(void *param);
int NmapCommandCheck(void *param);
int NmapCommandClr(void *param);
int NmapCommandCopy(void *param);
int NmapCommandCrea(void *param);
int NmapCommandDele(void *param);
int NmapCommandDflg(void *param);
int NmapCommandFlag(void *param);
int NmapCommandGflg(void *param);
int NmapCommandGinfo(void *param);
int NmapCommandHead(void *param);
int NmapCommandInfo(void *param);
int NmapCommandList(void *param);
int NmapCommandMbox(void *param);
int NmapCommandMime(void *param);
int NmapCommandMimeD(void *param);
int NmapCommandPurg(void *param);
int NmapCommandRnam(void *param);
int NmapCommandRights(void *param);
int NmapCommandRmov(void *param);
int NmapCommandRepair(void *param);
int NmapCommandResource(void *param);
int NmapCommandSalv(void *param);
int NmapCommandSearch(void *param);
int NmapCommandSflg(void *param);
int NmapCommandShow(void *param);
int NmapCommandShowsub(void *param);
int NmapCommandSinfo(void *param);
int NmapCommandStat(void *param);
int NmapCommandStor(void *param);
int NmapCommandStraw(void *param);
int NmapCommandSubs(void *param);
int NmapCommandUnsubs(void *param);

/* queue.c */
BOOL InitSpoolEntryIDLocks(void);
void DeInitSpoolEntryIDLocks(void);
unsigned long *SpoolEntryIDLock(unsigned long id);
void SpoolEntryIDUnlock(unsigned long *idLock);
BOOL RemovePushClientIndex(unsigned long index, BOOL force);
void RemoveAllPushClients(void);
void FreeQueueClientData(NMAPClient *client);
int CreateQueueThreads(BOOL failed);

int NmapCommandQaddm(void *param);
int NmapCommandQaddq(void *param);
int NmapCommandQabrt(void *param);
int NmapCommandQbody(void *param);
int NmapCommandQbraw(void *param);
int NmapCommandQcopy(void *param);
int NmapCommandQcrea(void *param);
int NmapCommandQdele(void *param);
int NmapCommandQdone(void *param);
int NmapCommandQdspc(void *param);
int NmapCommandQend(void *param);
int NmapCommandQgrep(void *param);
int NmapCommandQhead(void *param);
int NmapCommandQinfo(void *param);
int NmapCommandQmodFrom(void *param);
int NmapCommandQmodFlags(void *param);
int NmapCommandQmodLocal(void *param);
int NmapCommandQmodMailbox(void *param);
int NmapCommandQmodRaw(void *param);
int NmapCommandQmodTo(void *param);
int NmapCommandQmime(void *param);
int NmapCommandQmove(void *param);
int NmapCommandQrcp(void *param);
int NmapCommandQretr(void *param);
int NmapCommandQrts(void *param);
int NmapCommandQrun(void *param);
int NmapCommandQsql(void *param);
int NmapCommandQsrchDomain(void *param);
int NmapCommandQsrchHeader(void *param);
int NmapCommandQsrchBody(void *param);
int NmapCommandQsrchBraw(void *param);
int NmapCommandQstorAddress(void *param);
int NmapCommandQstorCal(void *param);
int NmapCommandQstorFlags(void *param);
int NmapCommandQstorFrom(void *param);
int NmapCommandQstorLocal(void *param);
int NmapCommandQstorMessage(void *param);
int NmapCommandQstorRaw(void *param);
int NmapCommandQstorTo(void *param);
int NmapCommandQwait(void *param);

/* addrbook.c */
int NmapCommandShareAdbk(void *param);
int NmapCommandAdbk(void *param);

/* share.c */
int ConnectToNMAPShare(NMAPClient *client, unsigned char *owner, unsigned char *name, unsigned long type, unsigned long *permissions);
BOOL SelectNMAPShare(NMAPClient *client, unsigned char *owner, unsigned char *name, unsigned long type);
BOOL IsAvailableShare(unsigned char *user, unsigned char *name, unsigned long type, unsigned char **owner, unsigned char **trueName);
BOOL SetShareSubscription(const unsigned char *store, unsigned char *user, unsigned long hash, unsigned char *resource, unsigned long type, BOOL subscribed);
BOOL RemoveAvailableShare(NMAPClient *client, unsigned long type, unsigned char *resource);
BOOL RemoveAvailableShares(NMAPClient *client);
BOOL SyncSharedMaildrop(NMAPClient *client, BOOL *changed);
BOOL SyncSharedCalendar(NMAPClient *client, BOOL *FlagsChanged, BOOL Locked);
int HandleShareStor(NMAPClient *client, unsigned char *mailbox, unsigned long date, unsigned long flags, BOOL noAuth, unsigned long size, unsigned char *owner, unsigned char *name);
int HandleShareCsstor(NMAPClient *client, unsigned char *calendar, unsigned char *sender, unsigned char *authenticatedSender, unsigned long size, unsigned char *owner, unsigned char *resource);
BOOL HandleShareStraw(NMAPClient *client, unsigned char *mailbox, unsigned long size, unsigned char *owner, unsigned char *resource);
int HandleShareCreate(NMAPClient *client, unsigned long request, unsigned char *resource, unsigned char *command);
int HandleProxyCreate(NMAPClient *client);
BOOL StoreSharedMaildrop(NMAPClient *client);
BOOL StoreSharedCalendar(NMAPClient *client);
int NmapCommandShareMbox(void *param);
int NmapCommandShowproxy(void *param);
int NmapCommandShowsh(void *param);

/* search.c */
int NmapSearch(NMAPClient *client);
int PDBSearch(char *Doc, char *SearchString);
void InitSearchModule(void);

/* scms.c */
BOOL SCMSWaitforAndLockMessage(unsigned long id);
void SCMSUnlockMessage(unsigned long id);
unsigned long SCMSStoreMessage(FILE *data, unsigned long size, unsigned char *sender, unsigned char *authSender);
unsigned long SCMSGetMessageSize(unsigned long id);
BOOL SCMSStoreMessageReference(unsigned long id);
BOOL SCMSDeleteMessage(unsigned long id);

/* sql-cal.c */
#if defined(NMAP_SQL_CALENDARS)
int OpenSQLCalendar(NMAPClient *client);

CalendarInfoStruct *AddCalendarInfo(NMAPClient *client, unsigned long increment);
int WaitforAndLockCalendar(const unsigned char *store, unsigned char *user, unsigned char *calendar);
void UnlockCalendar(const unsigned char *store, unsigned char *user, unsigned char *calendar);
BOOL StoreCalendar(NMAPClient *client);
int ParseCalendar(NMAPClient *client);
int StoreCalendarEvent(unsigned char *sender, unsigned char *authenticatedSender, unsigned char *recipient, unsigned char *calendarName, FILE *data, unsigned long eventSize, BOOL storeRaw);
int NmapCommandCsopen(void *param);
int NmapCommandCal(void *param);
int NmapCommandCsorg(void *param);
int NmapCommandCsinfo(void *param);
int NmapCommandCsfilt(void *param);
int NmapCommandCsfind(void *param);
int NmapCommandCsgflg(void *param);
int NmapCommandCslist(void *param);
int NmapCommandCscrea(void *param);
int NmapCommandCscheck(void *param);
int NmapCommandCscomp(void *param);
int NmapCommandCscopy(void *param);
int NmapCommandCsdele(void *param);
int NmapCommandCsdflg(void *param);
int NmapCommandCsaflg(void *param);
int NmapCommandCsatnd(void *param);
int NmapCommandCsupda(void *param);
int NmapCommandCsunsubs(void *param);
int NmapCommandCsrmov(void *param);
int NmapCommandCsrnam(void *param);
int NmapCommandCsstraw(void *param);
int NmapCommandCsstor(void *param);
int NmapCommandCsstat(void *param);
int NmapCommandCsshow(void *param);
int NmapCommandCsshowsub(void *param);
int NmapCommandCssubs(void *param);
int NmapCommandCssalv(void *param);
int NmapCommandCssflg(void *param);
int NmapCommandCssinfo(void *param);
int NmapCommandCssql(void *param);
int NmapCommandCspurg(void *param);
int NmapCommandShareCal(void *param);

#if defined(DEBUG)
int NmapCommandCsfill(void *param);
#endif
#endif /* NMAP_SQL_CALENDARS */

/* quid.c */
#define GuidFree MemFree

void GuidReset(void);
unsigned char *GuidAlloc(void);
int NmapCommandGuid(void *param);

#endif /* _NMAPDP_H */
