/****************************************************************************
 *
 * Copyright (c) 2005 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _NMAP_SQL_LOCK_H
#define _NMAP_SQL_LOCK_H

/*********************** Structures ***********************/
typedef enum {
    NMAP_SQL_LOCK_OK = 0, 
    NMAP_SQL_LOCK_OUT_OF_MEMORY, 
    NMAP_SQL_LOCK_UNKNOWN_TYPE
} NmapSqlLockErr;

typedef enum {
    NMAP_SQL_FLAG_USER_ALLOCATED = (1 << 0)
} NmapSqlLockFlag;

typedef enum {
    NMAP_SQL_LOCK_OPEN = 1, 
    NMAP_SQL_LOCK_READ, 
    NMAP_SQL_LOCK_WRITE, 
    NMAP_SQL_LOCK_PURGE
} NmapSqlLockType;

typedef struct _NmapSqlLockChain {
    XplSemaphore sem;

    struct _NmapSqlLock *head;
    struct _NmapSqlLock *tail;
} NmapSqlLockChain;

typedef struct _NmapSqlLock {
    struct {
        struct _NmapSqlLock *next;
        struct _NmapSqlLock *prev;
    } list;

    struct {
        struct _NmapSqlLock *next;
        struct _NmapSqlLock *prev;
    } uid;

    NmapSqlLockFlag flags;

    unsigned long hash;
    unsigned long opened;
    unsigned long readers;
    unsigned long writers;

    unsigned char *user;
    unsigned char data[64];

    NmapSqlLockChain *chain;
} NmapSqlLock;

NmapSqlLockErr NmapSqlLocksInit(unsigned long maxCached);
void NmapSqlLocksDestroy(void);

#endif /* _NMAP_SQL_LOCK_H */
