#include <license.hunspell>
#include <license.myspell>

#include <cstdlib>
#include <cctype>
#include <cstring>
#include <cstdio>

#include "suggestmgr.hxx"

#ifndef W32
using namespace std;
#endif


SuggestMgr::SuggestMgr(const char * tryme, int maxn, 
                       AffixMgr * aptr)
{

  // register affix manager and check in string of chars to 
  // try when building candidate suggestions
  pAMgr = aptr;

  ctryl = 0;
  ctry = NULL;
  ctry_utf = NULL;

  if (pAMgr && pAMgr->is_utf8()) {
    w_char t[MAXSWL];
    if (tryme) {
        ctryl = u8_u16(t, MAXSWL, tryme);
        ctry_utf = (w_char *) malloc(ctryl * sizeof(w_char));
        memcpy(ctry_utf, t, ctryl * sizeof(w_char));
    }
  } else {
    ctry = mystrdup(tryme);
    if (ctry) ctryl = strlen(ctry);
  }
  maxSug = maxn;
  nosplitsugs = 0;
  nomapsugs = 0;

  if (pAMgr) {
        char * enc = pAMgr->get_encoding();
        csconv = get_current_cs(enc);
        free(enc);
	nosplitsugs = pAMgr->get_nosplitsugs();
	nomapsugs = pAMgr->get_nomapsugs();
  }
}


SuggestMgr::~SuggestMgr()
{
  pAMgr = NULL;
  if (ctry) free(ctry);
  ctry = NULL;
  if (ctry_utf) free(ctry_utf);
  ctry_utf = NULL;
  ctryl = 0;
  maxSug = 0;
}



// generate suggestions for a mispelled word
//    pass in address of array of char * pointers

int SuggestMgr::suggest(char*** slst, const char * word, int nsug)
{
    int nocompoundtwowords = 0;
    char ** wlst;    
    w_char word_utf[MAXSWL];
    int wl;
    checknum=0;
    

    if (*slst) {
	wlst = *slst;
    } else {
	wlst = (char **) calloc(maxSug, sizeof(char *));
	if (wlst == NULL) return -1;
    }
    
    if (pAMgr->is_utf8()) {
        wl = u8_u16(word_utf, MAXSWL, word);
    }

    for (cpdsuggest=0; (cpdsuggest<2) && (nocompoundtwowords==0); cpdsuggest++) {

    // perhaps we made chose the wrong char from a related set
    if ((!nomapsugs) && (nsug < maxSug) && (nsug > -1))
      nsug = mapchars(wlst, word, nsug);

    // perhaps we made a typical fault of spelling
    if ((nsug < maxSug) && (nsug > -1))
    nsug = replchars(wlst, word, nsug);

    // perhaps we made a special pattern mistake (HU)
    if ((nsug < maxSug) && (nsug > -1))
///    nsug = doubledsyllable(wlst, word, nsug);

    // perhaps we wrote without accents (typical in e-mails) (HU)
    if ((cpdsuggest == 0) && (nsug < maxSug) && (nsug > -1))
///    nsug = forgotaccent(wlst, word, nsug);

    // did we forget to add a char
//    if ((cpdsuggest == 0) && (nsug < maxSug) && (nsug > -1))
    if ((nsug < maxSug) && (nsug > -1)) {
        nsug = (pAMgr->is_utf8()) ? forgotchar_utf(wlst, word_utf, wl, nsug) :
                    forgotchar(wlst, word, nsug);
    }


    // did we swap the order of chars by mistake
    if ((nsug < maxSug) && (nsug > -1)) {
        nsug = (pAMgr->is_utf8()) ? swapchar_utf(wlst, word_utf, wl, nsug) :
                    swapchar(wlst, word, nsug);
    }

    // did we add a char that should not be there
    if ((nsug < maxSug) && (nsug > -1)) {
        nsug = (pAMgr->is_utf8()) ? extrachar_utf(wlst, word_utf, wl, nsug) :
                    extrachar(wlst, word, nsug);
    }

    // did we just hit the wrong key in place of a good char
    if ((nsug < maxSug) && (nsug > -1)) {
        nsug = (pAMgr->is_utf8()) ? badchar_utf(wlst, word_utf, wl, nsug) :
                    badchar(wlst, word, nsug);
    }

    if ((cpdsuggest==0) && (nsug>0)) nocompoundtwowords=1;

    // perhaps we forgot to hit space and two words ran together
    if ((!nosplitsugs) && (nsug < maxSug) && (nsug > -1)) {
		int rchecknum = checknum;
		checknum = 0;
   		nsug = twowords(wlst, word, nsug);
		checknum = rchecknum;
	}
    
    } // repeating ``for'' statement compounding support

    if (nsug < 0) {
       for (int i=0;i<maxSug; i++)
	 if (wlst[i] != NULL) free(wlst[i]);
       free(wlst);
       return -1;
    }

    *slst = wlst;
    return nsug;
}

// generate suggestions for a word with typical mistake
//    pass in address of array of char * pointers

int SuggestMgr::suggest_auto(char*** slst, const char * word, int nsug)
{
    int nocompoundtwowords = 0;
    char ** wlst;    
    checknum=0;

    if (*slst) {
	wlst = *slst;
    } else {
	wlst = (char **) calloc(maxSug, sizeof(char *));
	if (wlst == NULL) return -1;
    }

    for (cpdsuggest=0; (cpdsuggest<2) && (nocompoundtwowords==0); cpdsuggest++) {

    // perhaps we made a typical fault of spelling
    if ((nsug < maxSug) && (nsug > -1))
    nsug = replchars(wlst, word, nsug);

    // perhaps we made a special pattern mistake (HU)
    if ((nsug < maxSug) && (nsug > -1))
///    nsug = doubledsyllable(wlst, word, nsug);

/*
    // perhaps we wrote without accents (typical in e-mails) (HU)
    if ((nsug < maxSug) && (nsug > -1))
    nsug = forgotaccent(wlst, word, nsug);

    // did we forget to add a char
    if ((nsug < maxSug) && (nsug > -1))
    nsug = forgotchar(wlst, word, nsug);

    // did we swap the order of chars by mistake
    if ((nsug < maxSug) && (nsug > -1))
      nsug = swapchar(wlst, word, nsug);

    // did we add a char that should not be there
    if ((nsug < maxSug) && (nsug > -1))
      nsug = extrachar(wlst, word, nsug);
   
    // did we just hit the wrong key in place of a good char
    if ((nsug < maxSug) && (nsug > -1))
      nsug = badchar(wlst, word, nsug);

*/

    if ((cpdsuggest==0) && (nsug>0)) nocompoundtwowords=1;

    // diszhal, disz hal, 
    // perhaps we forgot to hit space and two words ran together

    if (//( (cpdsuggest==0) || (nsug==0)) &&
	(nsug < maxSug) && (nsug > -1) && check_forbidden(word, strlen(word))) {
		int rchecknum = checknum;
		checknum = 0;
    		nsug = twowords(wlst, word, nsug);
		checknum = rchecknum;
	}
    
    } // repeating ``for'' statement compounding support

    if (nsug < 0) {
       for (int i=0;i<maxSug; i++)
	 if (wlst[i] != NULL) free(wlst[i]);
       free(wlst);
       return -1;
    }

    *slst = wlst;
    return nsug;
}


// suggestions for when chose the wrong char out of a related set
int SuggestMgr::mapchars(char** wlst, const char * word, int ns)
{
  int wl = strlen(word);
  if (wl < 2 || ! pAMgr) return ns;

  int nummap = pAMgr->get_nummap();
  struct mapentry* maptable = pAMgr->get_maptable();
  if (maptable==NULL) return ns;
  ns = map_related(word, 0, wlst, ns, maptable, nummap);
  return ns;
}


int SuggestMgr::map_related(const char * word, int i, char** wlst, int ns, const mapentry* maptable, int nummap) 
{
  char c = *(word + i);
  if (c == 0) {
      int cwrd = 1;
      for (int m=0; m < ns; m++)
	  if (strcmp(word,wlst[m]) == 0) cwrd = 0;
      if ((cwrd) && check(word,strlen(word))) {
	  if (ns < maxSug) {
	      wlst[ns] = mystrdup(word);
	      if (wlst[ns] == NULL) return -1;
	      ns++;
	  }
      }
      return ns;
  } 
  int in_map = 0;
  for (int j = 0; j < nummap; j++) {
    if (strchr(maptable[j].set,c) != 0) {
      in_map = 1;
      char * newword = strdup(word);
      for (int k = 0; k < maptable[j].len; k++) {
	*(newword + i) = *(maptable[j].set + k);
	ns = map_related(newword, (i+1), wlst, ns, maptable, nummap);
      }
      free(newword);
    }
  }
  if (!in_map) {
     i++;
     ns = map_related(word, i, wlst, ns, maptable, nummap);
  }
  return ns;
}




// suggestions for a typical fault of spelling, that
// differs with more, than 1 letter from the right form.
int SuggestMgr::replchars(char** wlst, const char * word, int ns)
{
  char candidate[MAXSWL];
  const char * r;
  int lenr, lenp;
  int cwrd;

  int wl = strlen(word);
  if (wl < 2 || ! pAMgr) return 0;

  int numrep = pAMgr->get_numrep();
  struct replentry* reptable = pAMgr->get_reptable();
  if (reptable==NULL) return 0;

  for (int i=0; i < numrep; i++ ) {
      r = word;
      lenr = strlen(reptable[i].replacement);
      lenp = strlen(reptable[i].pattern);
      // search every occurence of the pattern in the word
      while ((r=strstr(r, reptable[i].pattern)) != NULL) {
	  strcpy(candidate, word);
	  if (r-word + lenr + strlen(r+lenp) >= MAXSWL) break;
	  strcpy(candidate+(r-word),reptable[i].replacement);
	  strcpy(candidate+(r-word)+lenr, r+lenp);
          cwrd = 1;
          for (int k=0; k < ns; k++)
	      if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
          if ((cwrd) && check(candidate,strlen(candidate))) {
	      if (ns < maxSug) {
		  wlst[ns] = mystrdup(candidate);
		  if (wlst[ns] == NULL) {
		      for (int j=0; j<ns; j++) free(wlst[j]);
		      return -1;
		  }
		  ns++;
	      } else return ns;
	  }
          r++; // search for the next letter
      }
   }
   return ns;
}

// perhaps we made a special pattern mistake (HU)
// for example: iktats -> iktatats (doubled `ta')
// The doubled syllables have a special neural background
// for example: i k t a t [reactivated `ta' pattern, very similar to `t'] a t  s
int SuggestMgr::doubledsyllable(char** wlst, const char * word, int ns)
{
  char candidate[MAXSWL];
  int state=0;
  int cwrd;

  int wl = strlen(word);
  if (wl < 5 || ! pAMgr) return ns;

  for (int i=2; i < wl; i++ ) {
      if (word[i]==word[i-2]) {
	  state++;
	  if (state==3) {
	    strcpy(candidate,word);
	    strcpy(candidate+i-1,word+i+1);
            cwrd = 1;
            for (int k=0; k < ns; k++)
	        if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
            if ((cwrd) && check(candidate,strlen(candidate))) {
	        if (ns < maxSug) {
	  	    wlst[ns] = mystrdup(candidate);
		    if (wlst[ns] == NULL) {
		        for (int j=0; j<ns; j++) free(wlst[j]);
		        return -1;
		    }
		    ns++;
	        } else return ns;
	    }
	    state=0;
	  }
      } else {
    	    state=0;
      }
  }
  return ns;
}

int SuggestMgr::permuteaccent(char ** wlst, char * word, int ns, int i,
	int wl, replentry * rep, int depth) {

  int cwrd;
//  int accentlen = strlen(rep->pattern);  

  while ((word[i]!='\0') &&
    (! strchr(rep->replacement, word[i]))) i++;
  
  if ((word[i]=='\0') || (depth==MAXACCENT)) {
    cwrd = 1;

    for (int k=0; k < ns; k++)
      if (strcmp(word,wlst[k]) == 0) cwrd = 0;

    if ((cwrd) && check(word,wl)) {
      if (ns < maxSug) {
        wlst[ns] = mystrdup(word);
        if (wlst[ns] == NULL) return -1;
        ns++;
      } else return ns;
    }
  } else {
    if ((ns=permuteaccent(wlst, word, ns, i+1, wl, rep, depth+1))==-1) return -1;
    char tmpc=word[i];
    char * accentpos = rep->replacement - 1;
    for (;;) {
//      accentpos = (char *) TESTAFF(accentpos+1, tmpc, accentlen - (accentpos - rep->replacement));
      accentpos = strchr(accentpos+1, tmpc);
      if (accentpos==NULL) {
         word[i]=tmpc;
         return ns;
      }
      word[i]=(rep->pattern)[accentpos-(rep->replacement)];
      if ((ns=permuteaccent(wlst, word, ns, i+1, wl, rep, depth+1))==-1) return -1;
    }
  }
  return ns;
}

// forgot accents
int SuggestMgr::forgotaccent(char ** wlst, const char * word, int ns)
{
  char	candidate[MAXSWL];
  replentry * rep;
//  int accpos[MAXACCENT];
    
  int wl = strlen(word);
  strcpy (candidate, word);

  if ((pAMgr==NULL) || (rep=pAMgr->get_accent())==NULL) return ns;

/*
  int accentlen = strlen(rep->pattern);
  int j=0;
  for (int i=0; i<wl && n<MAXACCENT ; i++) {
      if (TESTAFF(replentry->replacement, candidate[i], accentlen) {
          accpos[j]=i;
	  j++;
      }
  }
*/

  if ((ns=permuteaccent(wlst, candidate, ns, 0, wl, rep, 0))==-1) return -1;
    
  return ns;
}


// error is wrong char in place of correct one
int SuggestMgr::badchar(char ** wlst, const char * word, int ns)
{
  char	tmpc;
  char	candidate[MAXSWL];

  int wl = strlen(word);
  int cwrd;
  strcpy(candidate, word);

  // swap out each char one by one and try all the tryme
  // chars in its place to see if that makes a good word
  for (int i=0; i < wl; i++) {
    tmpc = candidate[i];
    for (int j=0; j < ctryl; j++) {
       if (ctry[j] == tmpc) continue;
       candidate[i] = ctry[j];
       cwrd = 1;
       for (int k=0; k < ns; k++)
	 if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
       if ((cwrd) && check(candidate,wl)) {
	 if (ns < maxSug) {
            wlst[ns] = mystrdup(candidate);
            if (wlst[ns] == NULL) return -1;
            ns++;
         } else return ns;
       }
       candidate[i] = tmpc;
    }
  }
  return ns;
}

// error is wrong char in place of correct one
int SuggestMgr::badchar_utf(char ** wlst, const w_char * word, int wl, int ns)
{
  w_char	tmpc;
  w_char	candidate_utf[MAXSWL];
  char          candidate[MAXSWL];

  int cwrd;
  
  memcpy(candidate_utf, word, wl * sizeof(w_char));

  // swap out each char one by one and try all the tryme
  // chars in its place to see if that makes a good word
  for (int i=0; i < wl; i++) {
    tmpc = candidate_utf[i];
    for (int j=0; j < ctryl; j++) {
       if ((ctry_utf[j].l == tmpc.l) && (ctry_utf[j].h == tmpc.h)) continue;
       candidate_utf[i] = ctry_utf[j];
       cwrd = 1;
       u16_u8(candidate, MAXSWL, candidate_utf, wl);
       for (int k=0; k < ns; k++)
	 if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
       if ((cwrd) && check(candidate, strlen(candidate))) {
	 if (ns < maxSug) {
            wlst[ns] = mystrdup(candidate);
            if (wlst[ns] == NULL) return -1;
            ns++;
         } else return ns;
       }
       candidate_utf[i] = tmpc;
    }
  }
  return ns;
}

// error is word has an extra letter it does not need 
int SuggestMgr::extrachar_utf(char** wlst, const w_char * word, int wl, int ns)
{
   char	   candidate[MAXSWL];
   w_char	   candidate_utf[MAXSWL];

   const w_char * p;
   w_char * r;
   int cwrd;

   if (wl < 2) return ns;

   // try omitting one char of word at a time
   memcpy(candidate_utf, word + 1, (wl - 1) * sizeof(w_char));
   for (p = word, r = candidate_utf;  p < word + wl;  ) {
       cwrd = 1;
       u16_u8(candidate, MAXSWL, candidate_utf, wl - 1);       
       for (int k=0; k < ns; k++)
	 if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
       if ((cwrd) && check(candidate, strlen(candidate))) {
	 if (ns < maxSug) {
            wlst[ns] = mystrdup(candidate);
            if (wlst[ns] == NULL) return -1;
            ns++;
         } else return ns; 
       }
       *r++ = *p++;
   }
   return ns;
}

// error is word has an extra letter it does not need 
int SuggestMgr::extrachar(char** wlst, const char * word, int ns)
{
   char	   candidate[MAXSWL];
   const char *  p;
   char *  r;
   int cwrd;

   int wl = strlen(word);
   if (wl < 2) return ns;

   // try omitting one char of word at a time
   strcpy (candidate, word + 1);
   for (p = word, r = candidate;  *p != 0;  ) {
       cwrd = 1;
       for (int k=0; k < ns; k++)
	 if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
       if ((cwrd) && check(candidate,wl-1)) {
	 if (ns < maxSug) {
            wlst[ns] = mystrdup(candidate);
            if (wlst[ns] == NULL) return -1;
            ns++;
         } else return ns; 
       }
       *r++ = *p++;
   }
   return ns;
}


// error is missing a letter it needs
int SuggestMgr::forgotchar(char ** wlst, const char * word, int ns)
{
   char	candidate[MAXSWL];
   const char *	p;
   char *	q;
   int cwrd;

   int wl = strlen(word);

   // try inserting a tryme character before every letter
   strcpy(candidate + 1, word);
   for (p = word, q = candidate;  *p != 0;  )  {
      for (int i = 0;  i < ctryl;  i++) {
	 *q = ctry[i];
         cwrd = 1;
         for (int k=0; k < ns; k++)
	   if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
         if ((cwrd) && check(candidate,wl+1)) {
	    if (ns < maxSug) {
                wlst[ns] = mystrdup(candidate);
                if (wlst[ns] == NULL) return -1;
                ns++;
            } else return ns; 
         }
      }
      *q++ = *p++;
   }

   // now try adding one to end */
   for (int i = 0;  i < ctryl;  i++) {
      *q = ctry[i];
      cwrd = 1;
      for (int k=0; k < ns; k++)
	if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
      if ((cwrd) && check(candidate,wl+1)) {
	 if (ns < maxSug) {
             wlst[ns] = mystrdup(candidate);
             if (wlst[ns] == NULL) return -1;
             ns++;
         } else return ns;
      }
   }
   return ns;
}

// error is missing a letter it needs
int SuggestMgr::forgotchar_utf(char ** wlst, const w_char * word, int wl, int ns)
{
   w_char  candidate_utf[MAXSWL];
   char    candidate[MAXSWL];
   const w_char * p;
   w_char * q;
   int cwrd;

   // try inserting a tryme character before every letter
   memcpy (candidate_utf + 1, word, wl * sizeof(w_char));
   for (p = word, q = candidate_utf;  p < (word + wl); )  {
      for (int i = 0;  i < ctryl;  i++) {
	 *q = ctry_utf[i];
         cwrd = 1;
         u16_u8(candidate, MAXSWL, candidate_utf, wl + 1);
         for (int k=0; k < ns; k++)
	   if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
         if ((cwrd) && check(candidate, strlen(candidate))) {
	    if (ns < maxSug) {
                wlst[ns] = mystrdup(candidate);
                if (wlst[ns] == NULL) return -1;
                ns++;
            } else return ns; 
         }
      }
      *q++ = *p++;
   }

   // now try adding one to end */
   for (int i = 0;  i < ctryl;  i++) {
      *q = ctry_utf[i];
      cwrd = 1;
      u16_u8(candidate, MAXSWL, candidate_utf, wl + 1);
      for (int k=0; k < ns; k++)
	if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
      if ((cwrd) && check(candidate, strlen(candidate))) {
	 if (ns < maxSug) {
             wlst[ns] = mystrdup(candidate);
             if (wlst[ns] == NULL) return -1;
             ns++;
         } else return ns;
      }
   }
   return ns;
}


/* error is should have been two words */
int SuggestMgr::twowords(char ** wlst, const char * word, int ns)
{
    char candidate[MAXSWL];
    char * p;
    int c1, c2, cwrd;
    int forbidden = 0;
    int utf8 = pAMgr->is_utf8();

    int wl=strlen(word);
    if (wl < 4) return ns;
    
    if (pAMgr->get_langnum() == LANG_hu) forbidden = check_forbidden(word, wl);

    strcpy(candidate + 1, word);
    candidate[0] = word[0];

    // split the string into two pieces after every char
    // if both pieces are good words make them a suggestion
    for (p = candidate + 2;  p[2] != '\0';  p++) {
       p[-1] = *p;
       // go to end of the UTF-8 character
       while (utf8 && ((p[1] & 0xc0) == 0x80)) {
         p++;
         p[-1] = *p;
       }
       *p = '\0';
       if ((c1=check(candidate,strlen(candidate)))) {
	 if ((c2=check((p+1),strlen(p+1)))) {
            *p = ' ';

            // spec. Hungarian code (need a better compound word support)
            if ((pAMgr->get_langnum() == LANG_hu) && !forbidden &&
	        // if 3 repeating letter, use - instead of space
	        (((p[-1] == p[1]) && (((p>candidate+1) && (p[-1] == p[-2])) || (p[-1] == p[2]))) ||
	        // or multiple compounding, with more, than 6 syllables
                ((c1 == 3) && (c2 >= 2)))) *p = '-';

	    cwrd = 1;
	    for (int k=0; k < ns; k++)
		if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
	    if (ns < maxSug) {
		if (cwrd) {
            	    wlst[ns] = mystrdup(candidate);
            	    if (wlst[ns] == NULL) return -1;
            	    ns++;
		}
            } else return ns;
         }
       }
    }
    return ns;
}


// error is adjacent letter were swapped
int SuggestMgr::swapchar(char ** wlst, const char * word, int ns)
{
   char	candidate[MAXSWL];
   char * p;
   char	tmpc;
   int cwrd;

   int wl=strlen(word);

   // try swapping adjacent chars one by one
   strcpy(candidate, word);
   for (p = candidate;  p[1] != 0;  p++) {
      tmpc = *p;
      *p = p[1];
      p[1] = tmpc;
      cwrd = 1;
      for (int k=0; k < ns; k++)
	if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
      if ((cwrd) && check(candidate,wl)) {
	 if (ns < maxSug) {
             wlst[ns] = mystrdup(candidate);
             if (wlst[ns] == NULL) return -1;
             ns++;
         } else return ns;
      }
      tmpc = *p;
      *p = p[1];
      p[1] = tmpc;
   }
   return ns;
}

// error is adjacent letter were swapped
int SuggestMgr::swapchar_utf(char ** wlst, const w_char * word, int wl, int ns)
{
   w_char candidate_utf[MAXSWL];
   char   candidate[MAXSWL];
   w_char * p;
   w_char tmpc;
   int cwrd;

   // try swapping adjacent chars one by one
   memcpy (candidate_utf, word, wl * sizeof(w_char));
   for (p = candidate_utf;  p < (candidate_utf + wl - 1);  p++) {
      tmpc = *p;
      *p = p[1];
      p[1] = tmpc;
      cwrd = 1;
      u16_u8(candidate, MAXSWL, candidate_utf, wl);
      for (int k=0; k < ns; k++)
	if (strcmp(candidate,wlst[k]) == 0) cwrd = 0;
      if ((cwrd) && check(candidate, strlen(candidate))) {
	 if (ns < maxSug) {
             wlst[ns] = mystrdup(candidate);
             if (wlst[ns] == NULL) return -1;
             ns++;
         } else return ns;
      }
      tmpc = *p;
      *p = p[1];
      p[1] = tmpc;
   }
   return ns;
}

// generate a set of suggestions for very poorly spelled words
int SuggestMgr::ngsuggest(char** wlst, char * word, HashMgr* pHMgr)
{

  int i, j;
  int lval;
  int sc;
  int lp;

  if (! pHMgr) return 0;

  // exhaustively search through all root words
  // keeping track of the MAX_ROOTS most similar root words
  struct hentry * roots[MAX_ROOTS];
  int scores[MAX_ROOTS];
  for (i = 0; i < MAX_ROOTS; i++) {
    roots[i] = NULL;
    scores[i] = -100 * i;
  }
  lp = MAX_ROOTS - 1;

  int n = strlen(word);

  struct hentry* hp = NULL;
  int col = -1;
  while ((hp = pHMgr->walk_hashtable(col, hp))) {
    sc = ngram(3, word, hp->word, NGRAM_LONGER_WORSE);
    if (sc > scores[lp]) {
      scores[lp] = sc;
      roots[lp] = hp;
      int lval = sc;
      for (j=0; j < MAX_ROOTS; j++)
	if (scores[j] < lval) {
	  lp = j;
          lval = scores[j];
	}
    }  
  }

  // find minimum threshhold for a passable suggestion
  // mangle original word three differnt ways
  // and score them to generate a minimum acceptable score
  int thresh = 0;
  char * mw = NULL;
  for (int sp = 1; sp < 4; sp++) {
     mw = strdup(word);
     for (int k=sp; k < n; k+=4) *(mw + k) = '*';
     thresh = thresh + ngram(n, word, mw, NGRAM_ANY_MISMATCH);
     free(mw);
  }
  mw = NULL;
  thresh = thresh / 3;
  thresh--;

  // now expand affixes on each of these root words and
  // and use length adjusted ngram scores to select
  // possible suggestions
  char * guess[MAX_GUESS];
  int gscore[MAX_GUESS];
  for(i=0;i<MAX_GUESS;i++) {
     guess[i] = NULL;
     gscore[i] = -100 * i;
  }

  lp = MAX_GUESS - 1;

  struct guessword * glst;
  glst = (struct guessword *) calloc(MAX_WORDS,sizeof(struct guessword));
  if (! glst) return 0;

  for (i = 0; i < MAX_ROOTS; i++) {

      if (roots[i]) {
        struct hentry * rp = roots[i];
	int nw = pAMgr->expand_rootword(glst, MAX_WORDS, rp->word, rp->wlen,
                                        rp->astr, rp->alen);
        for (int k = 0; k < nw; k++) {
           sc = ngram(n, word, glst[k].word, NGRAM_ANY_MISMATCH);
           if (sc > thresh) {
              if (sc > gscore[lp]) {
	         if (guess[lp]) free (guess[lp]);
                 gscore[lp] = sc;
                 guess[lp] = glst[k].word;
                 lval = sc;
                 for (j=0; j < MAX_GUESS; j++)
	            if (gscore[j] < lval) {
	               lp = j;
                       lval = gscore[j];
	            }
	      } else {
                 free (glst[k].word);  
              }
	   }            
	}
      }
  }
  if (glst) free(glst);

  // now we are done generating guesses
  // sort in order of decreasing score and copy over
  
  bubblesort(&guess[0], &gscore[0], MAX_GUESS);
  int ns = 0;
  for (i=0; i < MAX_GUESS; i++) {
    if (guess[i]) {
      int unique = 1;
      for (j=i+1; j < MAX_GUESS; j++)
	if (guess[j]) 
	    if (!strcmp(guess[i], guess[j])) unique = 0;
      if (unique) {
         wlst[ns++] = guess[i];
      } else {
	 free(guess[i]);
      }
    }
  }
  return ns;
}





// see if a candidate suggestion is spelled correctly
// needs to check both root words and words with affixes

// MySpell-HU modifications:
// return value 2 and 3 marks compounding with hyphen (-)
// `3' marks roots without suffix
int SuggestMgr::check(const char * word, int len)
{
  struct hentry * rv=NULL;
  int nosuffix = 0;
  checknum++;
  if ((cpdsuggest==1) && (checknum>6500)) return 0;
  
  if (pAMgr) { 

    rv = pAMgr->lookup(word);

    if (rv) {
        if (rv->astr)
	if ((rv->astr) && (TESTAFF(rv->astr,pAMgr->get_forbiddenword(),rv->alen))) return 0;
        if (rv->astr && TESTAFF(rv->astr,pAMgr->get_pseudoroot(),rv->alen)) rv = NULL;
    } else rv = pAMgr->prefix_check(word,len,1); // only prefix, and prefix + suffix XXX
    
    if (rv) {
	nosuffix=1;
    } else {
	// rv = pAMgr->affix_check(word,len); // prefix+suffix, suffix
	rv = pAMgr->suffix_check(word, len, 0, NULL, NULL, 0, NULL); // only suffix
    }

    if (!rv && pAMgr->have_contclass()) {
        rv = pAMgr->suffix_check_twosfx(word, len, 0, NULL, FLAG_NULL);
        if (!rv) rv = pAMgr->prefix_check_twosfx(word, len, 1, FLAG_NULL);
    }

    // check forbidden words (HU)
    if ((rv) && (rv->astr) && TESTAFF(rv->astr,pAMgr->get_forbiddenword(),rv->alen)
	&& (! TESTAFF(rv->astr,pAMgr->get_onlyroot(),rv->alen))
///	   && (strcmp(word,rv->word)==0) // forbidden root only
	    ) return 0;

    if (cpdsuggest==1) {
      if ((rv == NULL) && (pAMgr->get_compoundflag() || pAMgr->get_compoundbegin())) {
	rv = pAMgr->compound_check(word,len,0,0,0,0,NULL,NULL);
	if (rv) return 3;
	}
      }
  }

  if (rv) {
//      if (cpd) {
//         compoundroot = pAMgr->get_compoundroot();
//         if ((compoundroot) && TESTAFF(rv->astr, compoundroot[0], rv->alen)) return 2;
//      }
      if ((pAMgr->get_compoundflag()) && 
          TESTAFF(rv->astr, pAMgr->get_compoundflag(), rv->alen)) {
	    return 2 + nosuffix; 
      }
      return 1;
  }
  return 0;
}

int SuggestMgr::check_forbidden(const char * word, int len)
{
  struct hentry * rv = NULL;
  
  if (pAMgr) { 
    rv = pAMgr->lookup(word);
    if (rv) if (rv->astr && TESTAFF(rv->astr,pAMgr->get_pseudoroot(),rv->alen)) rv = NULL;
    if (!(pAMgr->prefix_check(word,len,1)))
        rv = pAMgr->suffix_check(word,len, 0, NULL, NULL, 0, NULL); // prefix+suffix, suffix
    // check forbidden words (HU)
    if ((rv) && (rv->astr) && TESTAFF(rv->astr,pAMgr->get_forbiddenword(),rv->alen)) return 1;
   }
    return 0;
}

// suggest stems
int SuggestMgr::suggest_stems(char*** slst, const char * word, int nsug)
{
    char buf[MAXSWL];
    char ** wlst;    
    int prevnsug = nsug;

    if (*slst) {
	wlst = *slst;
    } else {
	wlst = (char **) calloc(maxSug, sizeof(char *));
	if (wlst == NULL) return -1;
    }
    // perhaps there are a fix stem in the dictionary
    if ((nsug < maxSug) && (nsug > -1)) {
    
    nsug = fixstems(wlst, word, nsug);
    if (nsug == prevnsug) {
	char * s = mystrdup(word);
	char * p = s + strlen(s);
	while ((*p != '-') && (p != s)) p--;
	if (*p == '-') {
	    *p = '\0';
	    nsug = fixstems(wlst, s, nsug);
	    if ((nsug == prevnsug) && (nsug < maxSug) && (nsug >= 0)) {
		char * t;
		buf[0] = '\0';
		for (t = s; (t[0] != '\0') && ((t[0] >= '0') || (t[0] <= '9')); t++); // is a number?
		if (*t != '\0') strcpy(buf, "# ");
		strcat(buf, s);
		wlst[nsug] = mystrdup(buf);
                if (wlst[nsug] == NULL) return -1;
		nsug++;
	    }
	    p++;
	    nsug = fixstems(wlst, p, nsug);
	}

	free(s);
    }
    }
    
    if (nsug < 0) {
       for (int i=0;i<maxSug; i++)
	 if (wlst[i] != NULL) free(wlst[i]);
         free(wlst);
       return -1;
    }

    *slst = wlst;
    return nsug;
}


// there are fix stems in dictionary
int SuggestMgr::fixstems(char ** wlst, const char * word, int ns)
{
    char fix[MAXSWL];
    char buf[MAXSWL];
    char prefix[MAXSWL] = "";

    char * p;
    int dicstem = 1; // 0 = lookup, 1= affix, 2 = compound
    int cpdindex = 0;
    struct hentry * rv = NULL;
    struct hentry * rv2 = NULL;

    int wl = strlen(word);
    int cmpdstemnum;
    int cmpdstem[MAXCOMPOUND];

    if (pAMgr) { 
	rv = pAMgr->lookup(word);
	if (rv) {
	    dicstem = 0;
	} else {
	    // try stripping off affixes 
	    rv = pAMgr->affix_check(word, wl);

	    // else try check compound word
	    if ((!rv) && (pAMgr->get_compoundflag() || pAMgr->get_compoundbegin())) {
        	rv = pAMgr->compound_check(word, wl,
		     0, 0, 100, 0, &cmpdstemnum, cmpdstem);

		if (rv) {
		    dicstem = 2;
		    for (int j = 0; j < cmpdstemnum; j++) {
			cpdindex += cmpdstem[j];
		    }
		    if(! (pAMgr->lookup(word + cpdindex)))
		    	pAMgr->affix_check(word + cpdindex, wl - cpdindex); // for prefix
		}
	    }


	    if (pAMgr->get_prefix()) {
	    	strcpy(prefix, pAMgr->get_prefix());
	    }

	    // ha a prefix leg, akkor ezt nem tntetjk fel a tvekhez
	    if ((prefix) && (strncmp(prefix, "leg", 3)==0)) prefix[0] = '\0'; // (HU)	    
	}

    }



    if ((rv) && (ns < maxSug)) {
    
	// check fixstem flag and not_valid_stem flag
	// first word
	if ((ns < maxSug) && (dicstem < 2)) { 
	    strcpy(buf, prefix);
	    if ((dicstem > 0) && pAMgr->get_derived()) {
		// XXX (HU) Hung. prefix with cutting, Mak -> maki
		// need a condition for HU lang.
	           if (strlen(prefix) == 1) {
			strcat(buf, (pAMgr->get_derived()) + 1);
		   } else {
			strcat(buf, pAMgr->get_derived());
		   }
		} else {
			// special stem in affix description
			const char * wordchars = pAMgr->get_wordchars();
			if (rv->description && 
			   (strchr(wordchars, *(rv->description)))) {
			   char * desc = (rv->description) + 1;
			   while (strchr(wordchars, *desc)) desc++;
			   strncat(buf, rv->description, desc - (rv->description));
			} else {
			    strcat(buf, rv->word);
			}
		}
	    wlst[ns] = mystrdup(buf);
	    if (wlst[ns] == NULL) return -1;
	    ns++;
	}

	if (dicstem == 2) {

	    // compound stem

//	    if (rv->astr && (strchr(rv->astr, '0') == NULL)) {
	    if (rv->astr) {
		strcpy(buf, word);
		buf[cpdindex] = '\0';
		if (prefix) strcat(buf, prefix);
	        if (pAMgr->get_derived()) {
			strcat(buf, pAMgr->get_derived());
		} else {
			// special stem in affix description
			const char * wordchars = pAMgr->get_wordchars();
			if (rv->description && 
			   (strchr(wordchars, *(rv->description)))) {
			   char * desc = (rv->description) + 1;
			   while (strchr(wordchars, *desc)) desc++;
			   strncat(buf, rv->description, desc - (rv->description));
			} else {
			    strcat(buf, rv->word);
			}
		}
		if (ns < maxSug) {
		    wlst[ns] = mystrdup(buf);
		    if (wlst[ns] == NULL) return -1;
		    ns++;
		}
	    }
	}
    }
while (rv) {
//    if (rv->astr && (p = (char *) strchr(rv->astr, 'g'))) { // (HU) XXX 'g' bedrtozva
    if (0) { // (HU) XXX 'g' bedrtozva
	if ((p[1] > '0') && (p[1] <= '9')) {
	    if ((ns < maxSug) && (dicstem != 2)) {
		int split = p[1] - '0';
		if (rv->wlen <= split) break;
				
		strcpy(fix, rv->word);

		// ikes igk ellenrzse
		
		fix[rv->wlen - split] = 'i';
		fix[rv->wlen - split + 1] = 'k';
		fix[rv->wlen - split + 2] = '\0';

		if (! (rv2 = pAMgr->lookup(fix))) {
		    fix[strlen(fix) - 2] = '\0';
		    rv2 = pAMgr->lookup(fix);
		    if ((!rv2)) {
			*fix = csconv[((unsigned char) *fix)].cupper;
			rv2 = pAMgr->lookup(fix);
			if (! rv2) return ns;
		    }

		}

//		if (strchr(rv2->astr, '0') == NULL) { // (HU) XXX '0' bedrtozva
		if (0) { // (HU) XXX '0' bedrtozva
		    strcpy(buf, prefix);
		    strcat(buf, fix);
		    wlst[ns] = mystrdup(buf);
            	    if (wlst[ns] == NULL) return -1;
            	    ns++;
		}
		
		rv = rv2;
		
            } else return ns; 
	} else {
	    strcpy(fix, "__");
	    strcat(fix, rv->word);
	    rv = NULL;
	    rv2 = pAMgr->lookup(fix);
	    if ((rv2) && (rv2->astr) && (ns < maxSug)) 
	    if ((rv2) && (rv2->astr) && (ns < maxSug)) 
//	      if (strchr(rv2->astr, '|') == NULL) {
	      if (0) {
		char buf2[MAXSWL];

		strcpy(buf2, prefix);
                
                if (*(rv2->astr) == '-') {
                    strcat(buf2, "");
//                    strcat(buf2, (rv2->astr) + 1);
                } else {
//                    strcat(buf2, rv2->astr);
                    strcat(buf2, "");
                }

		if (dicstem != 2) {
            	    wlst[ns] = mystrdup(buf2);
            	    if (wlst[ns] == NULL) return -1;
            	    ns++;
		}
		
		if ((dicstem == 2) && (ns < maxSug)) {
		    strcpy(buf, word);
		    buf[cpdindex] = '\0';
		    strcat(buf + cpdindex, buf2);

		    if ((pAMgr->get_compoundflag() || pAMgr->get_compoundbegin()) &&
        		(pAMgr->compound_check(buf, strlen(buf), 
	                          0,0,100,0,NULL,NULL))) {
            		    wlst[ns] = mystrdup(buf);
            		    if (wlst[ns] == NULL) return -1;
			    ns++;
		    }
		}
	    // many stems
	    } else {
//		char * str = mystrdup(rv2->astr);
		char * str = mystrdup("");
		char * pos = str;
		char * pos2;
		do {
		    int suggest = 1;
		    pos2 = strchr(pos, '|');
		    if (pos2) *pos2 = '\0';
		    // ignore `-xxx' suggestion, when exists prefix
		    if (*pos == '-') {
			pos++;
			if (*prefix != '\0') suggest = 0;
		    }
		    // ignore `xxx-' suggestion, when word is not root
		    if ((strlen(pos) > 0) && (pos[strlen(pos)-1] == '-')) {
			pos[strlen(pos)-1] = '\0';
			strcpy(buf, prefix);
			strcat(buf, fix + 2);
			if ((dicstem != 0) && (strcmp(buf, word) != 0)) suggest = 0;
		    }
		    if ((suggest) && (ns < maxSug) && (strlen(pos) > 0)) {
			strcpy(buf, prefix);
			strcat(buf, pos);
            		wlst[ns] = mystrdup(buf);
            		if (wlst[ns] == NULL) return -1;
            		ns++;
		    }
		    if (pos2) pos = pos2 + 1;
		} while (pos2);
		free(str);
	    }
	}
    } else return ns;

}

return ns;

}

// suggest possible stems
int SuggestMgr::suggest_pos_stems(char*** slst, const char * word, int nsug)
{
    char ** wlst;    

    struct hentry * rv = NULL;

    int wl = strlen(word);

    if (*slst) {
	wlst = *slst;
    } else {
	wlst = (char **) calloc(maxSug, sizeof(char *));
	if (wlst == NULL) return -1;
    }

    rv = pAMgr->suffix_check(word, wl, 0, NULL, wlst, maxSug, &nsug);

    // delete dash from end of word
    if (nsug > 0) {
        for (int j=0; j < nsug; j++) {
            if (wlst[j][strlen(wlst[j]) - 1] == '-') wlst[j][strlen(wlst[j]) - 1] = '\0';
        }
    }

    *slst = wlst;
    return nsug;
}


char * SuggestMgr::suggest_morph(const char * word)
{
    char result[MAXLNLEN];
    char * r = (char *) result;
    char * st;

    struct hentry * rv = NULL;

    *result = '\0';

    if (! pAMgr) return NULL;

    rv = pAMgr->lookup(word);
    
    while (rv) {
        if ((!rv->astr) || !(TESTAFF(rv->astr, pAMgr->get_forbiddenword(), rv->alen) ||
            TESTAFF(rv->astr, pAMgr->get_pseudoroot(), rv->alen))) {
            if (rv->description && ((!rv->astr) || 
                !TESTAFF(rv->astr, pAMgr->get_lemma_present(), rv->alen)))
                    strcat(result, word);
            if (rv->description) strcat(result, rv->description);
            strcat(result, "\n");
        }
        rv = rv->next_homonym;
    }
    
    st = pAMgr->affix_check_morph(word,strlen(word));
    if (st) {
        strcat(result, st);
        free(st);
    }

    if ((pAMgr->get_compoundflag() || pAMgr->get_compoundbegin()) && (*result == '\0'))
        pAMgr->compound_check_morph(word, strlen(word),
		     0, 0, 100, 0, &r, NULL);
    
    return (*result) ? mystrdup(line_uniq(delete_zeros(result))) : NULL;
//    return (*result) ? mystrdup(line_uniq(result)) : NULL;
}

char * SuggestMgr::suggest_morph_for_spelling_error(const char * word)
{
    char * p = NULL;
	char ** wlst = (char **) calloc(maxSug, sizeof(char *));
    // we will use only the first suggestion
    for (int i = 0; i < maxSug - 1; i++) wlst[i] = "";
   	int ns = suggest(&wlst, word, maxSug - 1);
	if (ns == maxSug) {
        p = suggest_morph(wlst[maxSug - 1]);
        free(wlst[maxSug - 1]);
    }
	if (wlst) free(wlst);
	return p;    
}


// generate an n-gram score comparing s1 and s2
int SuggestMgr::ngram(int n, char * s1, const char * s2, int uselen)
{
  int nscore = 0;
  int l1 = strlen(s1);
  int l2 = strlen(s2);
  int ns;
  for (int j=1;j<=n;j++) {
    ns = 0;
    for (int i=0;i<=(l1-j);i++) {
      char c = *(s1 + i + j);
      *(s1 + i + j) = '\0';
      if (strstr(s2,(s1+i))) ns++;
      *(s1 + i + j ) = c;
    }
    nscore = nscore + ns;
    if (ns < 2) break;
  }
  ns = 0;
  if (uselen == NGRAM_LONGER_WORSE) ns = (l2-l1)-2;
  if (uselen == NGRAM_ANY_MISMATCH) ns = abs(l2-l1)-2;
  return (nscore - ((ns > 0) ? ns : 0));
}


// sort in decreasing order of score
void SuggestMgr::bubblesort(char** rword, int* rsc, int n )
{
      int m = 1;
      while (m < n) {
	  int j = m;
	  while (j > 0) {
	    if (rsc[j-1] < rsc[j]) {
	        int sctmp = rsc[j-1];
                char * wdtmp = rword[j-1];
	        rsc[j-1] = rsc[j];
                rword[j-1] = rword[j];
                rsc[j] = sctmp;
                rword[j] = wdtmp;
	        j--;
	    } else break;
	  }
          m++;
      }
      return;
}

