/*
 *  Copyright (C) 2010 Tuomo Penttinen, all rights reserved.
 *
 *  Author: Tuomo Penttinen <tp@herqq.org>
 *
 *  This file is part of Herqq UPnP (HUPnP) library.
 *
 *  Herqq UPnP is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Herqq UPnP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Herqq UPnP. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef HDEVICEMODEL_VALIDATOR_H_
#define HDEVICEMODEL_VALIDATOR_H_

#include <HUpnpCore/HUpnp>

namespace Herqq
{

namespace Upnp
{

class HDeviceModelValidatorPrivate;

/*!
 * This class is used to specify information that can be used to validate
 * a UPnP device.
 *
 * \headerfile hdevicemodel_validator.h HDeviceModelValidator
 *
 * \ingroup hupnp_devicemodel
 *
 * \sa HDevicesSetupData, HServicesSetupData, HActionsSetupData,
 * HStateVariablesSetupData
 *
 * \remarks This class is not thread-safe.
 */
class H_UPNP_CORE_EXPORT HDeviceModelValidator
{
H_DISABLE_COPY(HDeviceModelValidator)

private:

    HDeviceModelValidatorPrivate* h_ptr;

public:

    /*!
     * Creates a new instance.
     *
     * Creates a new instance.
     */
    HDeviceModelValidator();

    /*!
     * Destroys the instance.
     *
     * Destroys the instance.
     */
    ~HDeviceModelValidator();

    /*!
     *
     */
    void setInfoProvider(const HDeviceModelInfoProvider& provider);

    /*!
     *
     */
    const HDeviceModelInfoProvider* infoProvider() const;

    /*!
     *
     */
    enum ValidationResult
    {
        /*!
         *
         */
        InfoProviderMissing,
        MandatoryActionMissing,
        MandatoryActionArgumentMissing,
        MandatoryStateVariableMissing,
        MandatoryServiceMissing,
        MandatoryDeviceMissing,
        InvalidArgumentDefinition,
        InvalidStateVariableDefinition,
        ValidationSucceeded
    };

    /*!
     *
     */
    ValidationResult validateDevice(HClientDevice* device) const;

    /*!
     *
     */
    ValidationResult validateDevice(HServerDevice* device) const;

    /*!
     *
     */
    ValidationResult validateService(HClientService* service) const;

    /*!
     *
     */
    ValidationResult validateService(HServerService* service) const;

    /*!
     *
     */
    ValidationResult validateAction(HClientAction* action) const;

    /*!
     *
     */
    ValidationResult validateAction(HServerAction* action) const;

    /*!
     *
     */
    ValidationResult validateStateVariable(HClientStateVariable* stateVar) const;

    /*!
     *
     */
    ValidationResult validateStateVariable(HServerStateVariable* stateVar) const;
};

}
}

#endif /* HDEVICEMODEL_VALIDATOR_H_ */
