/* irqtune.h -- load IRQ tuning module */

#ifndef _irqtune_h_
#define _irqtune_h_

#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <wait.h>

#include <irqhigh.h>

#include <sys/time.h>
#include <sys/stat.h>
#include <sys/utsname.h>

#include <asm/unistd.h>

#include <src/irqhigh.c>

/*
// FIXME -- "errno.h" et. al. for glibc does a #define of errno :-( :-( :-(.
// This conflicts with "int errno" in a struct in "linux/sched.h" as well as
// thousands of other programs.  Include "errno.h" afterwards.
// GNU strikes again:  28 years of compatibility broken--Film at 11!
*/

#include <softnet/types.h>
#include <softnet/macros.h>

#define zprtok(lvl) \
	(irqhow & (lvl))
#include <softnet/zprt.h>

/* signal control */
int cmdsigcnt;							/* number of active blocks */
struct sigaction cmdsigactsv;			/* sigaction save area */
sigset_t cmdsigmsksv;					/* sigmask save area */

/* command execution control block */
struct cmdblk {
	mskof_t cmd_opt;					/* options */
	int cmd_status;						/* wait status */
	int cmd_pid;						/* child process ID */
	int cmd_units[2];					/* pipe units */
	char cmd_bf[1000];					/* cmd buffer (tokenized) */
};

/* equates to cmd_opt */
#define CMDBUSY				RMSKOF(0)	/* 1=command block busy */

#define CMDBLKMAX		5
struct cmdblk cmdblks[CMDBLKMAX];
#define CMDMORE(_cmd) \
	(_cmd < &cmdblks[CMDBLKMAX])
#define CMDFOR(_cmd) \
	_cmd = cmdblks;  CMDMORE(_cmd);  ++_cmd

/* /proc/interrupts control */
struct tblblk {
	u_char tbl_irq;						/* irq number */
	u_char tbl_prior;					/* irq priority */
	u_char tbl_bias;					/* irq priority bias */
	u_char tbl_active;					/* 1=irq is active */
	char tbl_bf[100];					/* id string */
};

#define OPTDEFALLA(_cmd) \
	_cmd(0,OPTHELP,NULL,"-h -- display help"), \
	_cmd(1,OPTVERSION,NULL,"-v -- display irqtune version"), \
	_cmd(2,OPTRESET,NULL,"-o -- reset to original values (0/8)")

#define OPTDEFALLB(_cmd) \
	_cmd(3,OPTQUIET,NULL,"-q -- suppress priority table printing"), \
	_cmd(4,OPTSORT,NULL,"-s -- sort table by priority"), \
	_cmd(5,OPTALL,NULL,"-x -- show inactive devices in table")

#define OPTDEFALLC(_cmd) \
	_cmd(6,OPTERR,NULL,"-e -- show full errors"), \
	_cmd(7,OPTFORCE,NULL,"-f -- force loading even if probe detects errors"), \
	_cmd(8,OPTUNLOAD,NULL,"-u -- force module unload"), \
	_cmd(9,OPTVERBOSE,NULL,"-V -- insmod verbose mode"), \
	_cmd(10,OPTWARN,NULL,"-w -- treat warnings as errors")

#define OPTDEFALLD(_cmd) \
	_cmd(11,OPTPROC,&proc_ints,"-F<file> -- use <file> instead of /proc/interrupts"), \
	_cmd(12,OPTINSTALL,NULL,"-i -- install program"), \
	_cmd(13,OPTINSPGM,&insmod_path,"-L<directory> -- directory to search for insmod"), \
	_cmd(14,OPTNOGO,NULL,"-n -- nogo mode (just show what would happen)")

#define OPTDEFENUM(_idx,_msk,_ptr,_fmt...) \
	_msk = RMSKOF(_idx)
#define OPTDEFHELP(_idx,_msk,_ptr,_fmt...) \
	{ _msk, _ptr, _fmt }
#define OPTDEFSCT(_fmt...) \
	OPTDEFHELP(0,0,NULL,_fmt)

/* option control */
struct optblk {
	mskof_t opt_msk;					/* option mask */
	char **opt_ptr;						/* point to string value storage area */
	const char *opt_fmt;				/* option help */
};

mskof_t mstopt;							/* master options */
typedef enum {
	OPTDEFALLA(OPTDEFENUM),
	OPTDEFALLB(OPTDEFENUM),
	OPTDEFALLC(OPTDEFENUM),
	OPTDEFALLD(OPTDEFENUM)
} optenum_t;

char *proc_ints;						/* name of /proc/interrupts */
char *ins_ptr;							/* install argument */
char tmpf[1024];						/* temp file name */
int bigcode;							/* final exit code */

char *insmod_path;						/* specified insmod directory */
char insmod_dir[1024];					/* insmod probed full path name */
char insmod_file[1024];					/* insmod probed full file name */
char rmmod_file[1024];					/* rmmod probed full file name */
u_long insmod_version;					/* version of insmod program */
#define INSMOD_VERGOOD		VERMK(2,1,34)

mskof_t dynstat;						/* dynamic configuration status */
mskof_t dynerr;							/* dynamic error status */
#define DYN_FULL_PATH		RMSKOF(0)	/* 1=insmod invoked via full path */

#define DYN_INSMOD_ANCIENT	RMSKOF(1)	/* 1=insmod too old for irqtune */
#define DYN_INSMOD_OLD		RMSKOF(2)	/* 1=insmod too old for kernel */
#define DYN_INSMOD_PATH		RMSKOF(3)	/* 1=insmod was found in $PATH */
#define DYN_INSMOD_EXEC		RMSKOF(4)	/* 1=insmod was exec'ed ok */
#define DYN_INSMOD_VERSION	RMSKOF(5)	/* 1=insmod has version */
#define DYN_INSMOD_CRASH	RMSKOF(6)	/* 1=insmod will crash on irqtune_mod.o */
#define DYN_INSMOD_STRONG	RMSKOF(7)	/* 1=insmod is strong (>= 2.1.34) */
#define DYN_RMMOD_PATH		RMSKOF(8)	/* 1=rmmod was found in insmod_dir */

#define DYN_KNL_CPLDIFF		RMSKOF(9)	/* 1=compiled version differs */
#define DYN_KNL_GSYM		RMSKOF(10)	/* 1=kernel has get_kernel_syms */
#define DYN_KNL_VEROK		RMSKOF(11)	/* 1=kernel compatible */

#define DYN_KSYMS_CSUM		RMSKOF(12)	/* 1=/proc/ksyms has a checksum symbol */
#define DYN_KSYMS_FOUND		RMSKOF(13)	/* 1=/proc/ksyms has any symbol */
#define DYN_KSYMS_USING		RMSKOF(14)	/* 1=/proc/ksyms is using versions */

#define DYN_NPRONLY			RMSKOF(15)	/* 1=irqtune_mod.o will probably fail */
#define DYN_PROC_INTS		RMSKOF(16)	/* 1=/proc/interrupts valid */
#define DYN_SBIN_PATH		RMSKOF(17)	/* 1=/sbin in $PATH */

#define DYN_FATAL			LMSKOF(0)	/* 1=fatal error */
#define DYN_NEG				LMSKOF(1)	/* 1=logical negation */
#define DYN_WARN			LMSKOF(2)	/* 1=warning */

char kernel_version[1];					/* kernel version compiled with */
u_long kvers_compile;					/* compiled kernel version */
struct utsname uts;						/* dynamic kernel version */
u_long kvers_dynamic;					/* dynamic kernel version */
#define KNL_VERBADLO	VERMK(2,0,15)	/* lowest incompatible kernel version */
#define KNL_VERBADHI	VERMK(2,0,18)	/* highest incompatible kernel version */

struct tblblk tblbase[IRQHIGH_MAX];

#define PSIZE			4096			/* size of $PATH buffer */

char *pgmname;
char bigbf[PSIZE];						/* large temporary buffer */
char pathtmp[PSIZE];					/* temp place to store $PATH value */
char pathbf[PSIZE];						/* perm place to store $PATH value */

/* module names */
char dirtop[1024];						/* top directory */
char *modnames[] = {
	"irqtune_mod",
	"irqtune_npr",
	NULL,
};
char *modtag = MODTAG;					/* name to install under */
char modcur[1024];						/* current module name */

#define VERFMT \
	"%u.%u.%u"
#define VERPRT(_ver) \
	(_ver >> 16) & 0xFF, \
	(_ver >> 8) & 0xFF, \
	(_ver) & 0xFF
#define VERMK(_maj,_min,_sub) \
	((_maj & 0xFF) << 16 | \
	(_min & 0xFF) << 8 | \
	(_sub & 0xFF))
#define VERMAJ(_ver) \
	((_ver) & VERMK(0xFF,0xFF,0))

struct optblk opthelp[] = {
	OPTDEFSCT("general"),
	OPTDEFALLA(OPTDEFHELP),

	OPTDEFSCT("priority table"),
	OPTDEFALLB(OPTDEFHELP),

	OPTDEFSCT("error control"),
	OPTDEFALLC(OPTDEFHELP),

	OPTDEFSCT("documentation"),
	OPTDEFALLD(OPTDEFHELP),

	OPTDEFSCT(NULL),
};

mskof_t irqhow;								/* trace control */

/* hidden system calls */
VXInline _syscall1(int,get_kernel_syms,void *,ksyms)

/* function prototypes */
#include <irqtune.P>

#endif /*_irqtune_h_*/
