/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: MidiActivityWidget.cpp,v 1.5 2004/01/26 11:17:48 comix Exp $
 *
 */


#include "MidiActivityWidget.h"
#include "HydrogenApp.h"
#include "lib/Hydrogen.h"

/**
 * Constructor
 */
MidiActivityWidget::MidiActivityWidget( QWidget * parent, const char * name ) : QWidget( parent, name )
{
	setMinimumSize( WIDTH, HEIGHT );
	setMaximumSize( WIDTH, HEIGHT );
	resize( WIDTH, HEIGHT );

	value = 0;
	changed = true;

	// Create temp image
	temp.resize( WIDTH, HEIGHT );

	// Background image
	string background_path = string( IMG_PATH ) + string( "/img/playerControlPanel/midiActivity_back.png" );
	bool ok = back.load( background_path.c_str() );
	if( ok == false )
	{
		qWarning("MidiActivityWidget: Error loading pixmap");
	}

	// Leds image
	string leds_path = string( IMG_PATH ) + string( "/img/playerControlPanel/midiActivity_on.png" );
	ok = leds.load( leds_path.c_str() );
	if( ok == false )
	{
		qWarning( "MidiActivityWidget: Error loading pixmap" );
	}

	setErasePixmap( back );

	QTimer *timer = new QTimer(this);
	connect( timer, SIGNAL( timeout() ), this, SLOT( updateMidiActivityWidget() ) );

	timer->start(200);	// update player control at 5 fps

	(Hydrogen::getInstance())->addEngineListener(this);
}




/**
 * Destructor
 */
MidiActivityWidget::~MidiActivityWidget()
{
}




/**
 *
 */
void MidiActivityWidget::mousePressEvent(QMouseEvent *ev)
{
}




/**
 *
 */
void MidiActivityWidget::setValue(uint newValue)
{
	if (newValue > 100) {
		newValue = 100;
	}
	else if (newValue < 0) {
		newValue = 0;
	}

	if (this->value != newValue) {
		this->value = newValue;
		changed = true;
	}
}





/**
 *
 */
uint MidiActivityWidget::getValue()
{
	return value;
}








/**
 *
 */
void MidiActivityWidget::paintEvent( QPaintEvent*)
{
	if ( !isVisible() )
	{
		return;
	}

	if ( changed )
	{
		changed = false;

		// background
		bitBlt( &temp, 0, 0, &back, 0, 0, WIDTH, HEIGHT, CopyROP );

		if (value > 0 )
		{
			// leds
			bitBlt( &temp, 0, 0, &leds, 0, 0, WIDTH, HEIGHT, CopyROP );
		}

		setErasePixmap( temp );
	}
}





void MidiActivityWidget::updateMidiActivityWidget()
{
	update();
	int newValue = value - 40;
	if (newValue < 0 ) {
		newValue = 0;
	}
	setValue( newValue );
}



void MidiActivityWidget::midiActivityEvent()
{
	H2TextEvent *ev = new H2TextEvent( "midiActivity" );
	QApplication::postEvent( this, ev );
}



/**
 *
 */
void MidiActivityWidget::customEvent( QCustomEvent *ev ) {
	if ( ev->type() != H2_TEXT_EVENT ) {	// Must be a H2TextEvent
		return;
	}
	QString message = ((H2TextEvent*)ev)->getText();

	if (message == QString( "midiActivity" )) {
		setValue( 100 );
		updateMidiActivityWidget();
	}

}
