/*
 * File:          sidl_rmi_TimeOutException_Module.c
 * Symbol:        sidl.rmi.TimeOutException-v0.9.15
 * Symbol Type:   class
 * Babel Version: 1.0.0
 * Release:       $Name:  $
 * Revision:      @(#) $Id: sidl_rmi_TimeOutException_Module.c,v 1.1 2006/08/29 23:43:46 painter Exp $
 * Description:   implement a C extension type for a sidl extendable
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 */

/*
 * THIS CODE IS AUTOMATICALLY GENERATED BY THE BABEL
 * COMPILER. DO NOT EDIT THIS!
 * 
 * This file contains the implementation of a Python C
 * extension type (i.e. a Python type implemented in C).
 * This extension type provides Python interface to the
 * sidl type sidl.rmi.TimeOutException.
 */


/**
 * Symbol "sidl.rmi.TimeOutException" (version 0.9.15)
 * 
 * This exception is thrown by the RMI library when a request 
 * times out. 
 */
#include <Python.h>
#include <stdlib.h>
#include <string.h>
#ifndef included_sidl_BaseClass_h
#include "sidl_BaseClass.h"
#endif
#ifndef included_sidl_ClassInfo_h
#include "sidl_ClassInfo.h"
#endif
#ifndef included_sidl_rmi_ProtocolFactory_h
#include "sidl_rmi_ProtocolFactory.h"
#endif
#ifndef included_sidl_rmi_InstanceRegistry_h
#include "sidl_rmi_InstanceRegistry.h"
#endif
#ifndef included_sidl_rmi_InstanceHandle_h
#include "sidl_rmi_InstanceHandle.h"
#endif
#ifndef included_sidl_rmi_Invocation_h
#include "sidl_rmi_Invocation.h"
#endif
#ifndef included_sidl_rmi_Response_h
#include "sidl_rmi_Response.h"
#endif
#ifndef included_sidl_rmi_ServerRegistry_h
#include "sidl_rmi_ServerRegistry.h"
#endif
#ifndef included_sidl_rmi_ConnectRegistry_h
#include "sidl_rmi_ConnectRegistry.h"
#endif
#ifndef included_sidl_io_Serializable_h
#include "sidl_io_Serializable.h"
#endif
#include "sidl_Exception.h"

#ifndef NULL
#define NULL 0
#endif

#include "sidl_thread.h"
#ifdef HAVE_PTHREAD
static struct sidl_recursive_mutex_t sidl_rmi_TimeOutException__mutex= SIDL_RECURSIVE_MUTEX_INITIALIZER;
#define LOCK_STATIC_GLOBALS sidl_recursive_mutex_lock( &sidl_rmi_TimeOutException__mutex )
#define UNLOCK_STATIC_GLOBALS sidl_recursive_mutex_unlock( &sidl_rmi_TimeOutException__mutex )
/* #define HAVE_LOCKED_STATIC_GLOBALS (sidl_recursive_mutex_trylock( &sidl_rmi_TimeOutException__mutex )==EDEADLOCK) */
#else
#define LOCK_STATIC_GLOBALS
#define UNLOCK_STATIC_GLOBALS
/* #define HAVE_LOCKED_STATIC_GLOBALS (1) */
#endif

#define sidl_rmi_TimeOutException_INTERNAL 1
#include "sidl_rmi_TimeOutException_Module.h"
#ifndef included_sidl_rmi_TimeOutException_IOR_h
#include "sidl_rmi_TimeOutException_IOR.h"
#endif
#include "sidlObjA.h"
#include "sidlPyArrays.h"
#include "Numeric/arrayobject.h"
#ifndef included_sidl_Loader_h
#include "sidl_Loader.h"
#endif
#ifndef included_sidl_header_h
#include "sidl_header.h"
#endif
#ifndef included_sidl_interface_IOR_h
#include "sidl_interface_IOR.h"
#endif
#include "sidl_rmi_NetworkException_Module.h"
#include "sidl_BaseClass_Module.h"
#include "sidl_BaseException_Module.h"
#include "sidl_BaseInterface_Module.h"
#include "sidl_ClassInfo_Module.h"
#include "sidl_RuntimeException_Module.h"
#include "sidl_SIDLException_Module.h"
#include "sidl_io_Deserializer_Module.h"
#include "sidl_io_IOException_Module.h"
#include "sidl_io_Serializable_Module.h"
#include "sidl_io_Serializer_Module.h"
#include "sidl_rmi_Call_Module.h"
#include "sidl_rmi_Return_Module.h"
#include "sidl_rmi_Ticket_Module.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/*
 * connect_loaded is a boolean value showing if the IHConnect for this object has been loaded into the connectRegistry
 */

static int connect_loaded = 0;

/*
 * lang_inited is a boolean value showing if we have already imported all the nescessary modules
 */

static int lang_inited = 0;

#define LANG_SPECIFIC_INIT() if(!lang_inited) { \
  lang_inited = 1; \
  sidl_BaseClass__import(); \
  sidl_BaseException__import(); \
  sidl_BaseInterface__import(); \
  sidl_ClassInfo__import(); \
  sidl_RuntimeException__import(); \
  sidl_SIDLException__import(); \
  sidl_io_Deserializer__import(); \
  sidl_io_IOException__import(); \
  sidl_io_Serializable__import(); \
  sidl_io_Serializer__import(); \
  sidl_rmi_NetworkException__import(); \
  sidl_rmi_TimeOutException__import(); \
  sidl_rmi_Ticket__import(); \
}
/**
 * Cast method for interface and class type conversions.
 */
struct sidl_rmi_TimeOutException__object*
sidl_rmi_TimeOutException__rmicast(
  void* obj, struct sidl_BaseInterface__object **_ex);

/**
 * RMI connector function for the class. (no addref)
 */
struct sidl_rmi_TimeOutException__object*
sidl_rmi_TimeOutException__connectI(const char * url, sidl_bool ar,           \
  struct sidl_BaseInterface__object **_ex);

/* Static variables to hold version of IOR */
static const int32_t s_IOR_MAJOR_VERSION = 0;
static const int32_t s_IOR_MINOR_VERSION = 10;

/* Static variables for managing EPV initialization. */
static int s_remote_initialized = 0;

static struct sidl_rmi_TimeOutException__epv                                  \
  s_rem_epv__sidl_rmi_timeoutexception;

static struct sidl_BaseClass__epv  s_rem_epv__sidl_baseclass;

static struct sidl_BaseException__epv  s_rem_epv__sidl_baseexception;

static struct sidl_BaseInterface__epv  s_rem_epv__sidl_baseinterface;

static struct sidl_RuntimeException__epv  s_rem_epv__sidl_runtimeexception;

static struct sidl_SIDLException__epv  s_rem_epv__sidl_sidlexception;

static struct sidl_io_IOException__epv  s_rem_epv__sidl_io_ioexception;

static struct sidl_io_Serializable__epv  s_rem_epv__sidl_io_serializable;

static struct sidl_rmi_NetworkException__epv                                  \
  s_rem_epv__sidl_rmi_networkexception;


/* REMOTE CAST: dynamic type casting for remote objects. */
static void* remote_sidl_rmi_TimeOutException__cast(
  struct sidl_rmi_TimeOutException__object* self,
  const char* name, sidl_BaseInterface* _ex)
{
  int
    cmp0,
    cmp1,
    cmp2,
    cmp3;
  void* cast = NULL;
  *_ex = NULL; /* default to no exception */
  cmp0 = strcmp(name, "sidl.SIDLException");
  if (!cmp0) {
    (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
    cast = self;
    return cast;
  }
  else if (cmp0 < 0) {
    cmp1 = strcmp(name, "sidl.BaseInterface");
    if (!cmp1) {
      (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
      cast =                                                                  \
        &((                                                                   \
        *self).d_sidl_rmi_networkexception.d_sidl_io_ioexception.d_sidl_sidlexception.d_sidl_baseclass.d_sidl_baseinterface);
      return cast;
    }
    else if (cmp1 < 0) {
      cmp2 = strcmp(name, "sidl.BaseException");
      if (!cmp2) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast =                                                                \
          &((                                                                 \
          *self).d_sidl_rmi_networkexception.d_sidl_io_ioexception.d_sidl_sidlexception.d_sidl_baseexception);
        return cast;
      }
      else if (cmp2 < 0) {
        cmp3 = strcmp(name, "sidl.BaseClass");
        if (!cmp3) {
          (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
          cast = self;
          return cast;
        }
      }
    }
    else if (cmp1 > 0) {
      cmp2 = strcmp(name, "sidl.RuntimeException");
      if (!cmp2) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast =                                                                \
          &((                                                                 \
          *self).d_sidl_rmi_networkexception.d_sidl_io_ioexception.d_sidl_runtimeexception);
        return cast;
      }
    }
  }
  else if (cmp0 > 0) {
    cmp1 = strcmp(name, "sidl.rmi.NetworkException");
    if (!cmp1) {
      (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
      cast = self;
      return cast;
    }
    else if (cmp1 < 0) {
      cmp2 = strcmp(name, "sidl.io.Serializable");
      if (!cmp2) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast =                                                                \
          &((                                                                 \
          *self).d_sidl_rmi_networkexception.d_sidl_io_ioexception.d_sidl_sidlexception.d_sidl_io_serializable);
        return cast;
      }
      else if (cmp2 < 0) {
        cmp3 = strcmp(name, "sidl.io.IOException");
        if (!cmp3) {
          (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
          cast = self;
          return cast;
        }
      }
    }
    else if (cmp1 > 0) {
      cmp2 = strcmp(name, "sidl.rmi.TimeOutException");
      if (!cmp2) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast = self;
        return cast;
      }
    }
  }
  if ((*self->d_epv->f_isType)(self,name, _ex)) {
    void* (*func)(struct sidl_rmi_InstanceHandle__object*,                    \
      struct sidl_BaseInterface__object**) = 
      (void* (*)(struct sidl_rmi_InstanceHandle__object*,                     \
        struct sidl_BaseInterface__object**)) 
      sidl_rmi_ConnectRegistry_getConnect(name, _ex);SIDL_CHECK(*_ex);
    cast =  (*func)(((struct                                                  \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih, _ex);
  }

  return cast;
  EXIT:
  return NULL;
}

/* REMOTE DELETE: call the remote destructor for the object. */
static void remote_sidl_rmi_TimeOutException__delete(
  struct sidl_rmi_TimeOutException__object* self,
  sidl_BaseInterface* _ex)
{
  *_ex = NULL;
  free((void*) self);
}

/* REMOTE GETURL: call the getURL function for the object. */
static char* remote_sidl_rmi_TimeOutException__getURL(
  struct sidl_rmi_TimeOutException__object* self, sidl_BaseInterface* _ex)
{
  struct sidl_rmi_InstanceHandle__object *conn = ((struct                     \
    sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
  *_ex = NULL;
  if(conn != NULL) {
    return sidl_rmi_InstanceHandle_getObjectURL(conn, _ex);
  }
  return NULL;
}

/* REMOTE ADDREF: For internal babel use only! Remote addRef. */
static void remote_sidl_rmi_TimeOutException__raddRef(
  struct sidl_rmi_TimeOutException__object* self,sidl_BaseInterface* _ex)
{
  sidl_BaseException netex = NULL;
  /* initialize a new invocation */
  sidl_BaseInterface _throwaway = NULL;
  struct sidl_rmi_InstanceHandle__object *_conn = ((struct                    \
    sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
  sidl_rmi_Response _rsvp = NULL;
  sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation( _conn, \
    "addRef", _ex ); SIDL_CHECK(*_ex);
  /* send actual RMI request */
  _rsvp = sidl_rmi_Invocation_invokeMethod(_inv,_ex);SIDL_CHECK(*_ex);
  /* Check for exceptions */
  netex = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);
  if(netex != NULL) {
    sidl_BaseInterface throwaway_exception = NULL;
    *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(netex,            \
      &throwaway_exception);
    return;
  }

  /* cleanup and return */
  EXIT:
  if(_inv) { sidl_rmi_Invocation_deleteRef(_inv,&_throwaway); }
  if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp,&_throwaway); }
  return;
}

/* REMOTE ISREMOTE: returns true if this object is Remote (it is). */
static sidl_bool
remote_sidl_rmi_TimeOutException__isRemote(
    struct sidl_rmi_TimeOutException__object* self, 
    sidl_BaseInterface *_ex) {
  *_ex = NULL;
  return TRUE;
}

/* REMOTE METHOD STUB:_set_hooks */
static void
remote_sidl_rmi_TimeOutException__set_hooks(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* in */ sidl_bool on,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "_set_hooks", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packBool( _inv, "on", on, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException._set_hooks.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE EXEC: call the exec function for the object. */
static void remote_sidl_rmi_TimeOutException__exec(
  struct sidl_rmi_TimeOutException__object* self,const char* methodName,
  sidl_rmi_Call inArgs,
  sidl_rmi_Return outArgs,
  sidl_BaseInterface* _ex)
{
  *_ex = NULL;
}

/* REMOTE METHOD STUB:getHopCount */
static int32_t
remote_sidl_rmi_TimeOutException_getHopCount(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getHopCount", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.getHopCount.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval,                  \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:addRef */
static void
remote_sidl_rmi_TimeOutException_addRef(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    struct sidl_rmi_TimeOutException__remote* r_obj = (struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data;
    LOCK_STATIC_GLOBALS;
    r_obj->d_refcount++;
    UNLOCK_STATIC_GLOBALS;
  }
}

/* REMOTE METHOD STUB:deleteRef */
static void
remote_sidl_rmi_TimeOutException_deleteRef(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    struct sidl_rmi_TimeOutException__remote* r_obj = (struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data;
    LOCK_STATIC_GLOBALS;
    r_obj->d_refcount--;
    if(r_obj->d_refcount == 0) {
      sidl_rmi_InstanceHandle_deleteRef(r_obj->d_ih, _ex);
      free(r_obj);
      free(self);
    }
    UNLOCK_STATIC_GLOBALS;
  }
}

/* REMOTE METHOD STUB:isSame */
static sidl_bool
remote_sidl_rmi_TimeOutException_isSame(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* in */ struct sidl_BaseInterface__object* iobj,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    sidl_bool _retval = FALSE;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "isSame", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(iobj){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)iobj,       \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "iobj", _url,                     \
        _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "iobj", NULL,                     \
        _ex);SIDL_CHECK(*_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.isSame.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackBool( _rsvp, "_retval", &_retval,                 \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:isType */
static sidl_bool
remote_sidl_rmi_TimeOutException_isType(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* in */ const char* name,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    sidl_bool _retval = FALSE;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "isType", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.isType.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackBool( _rsvp, "_retval", &_retval,                 \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:getClassInfo */
static struct sidl_ClassInfo__object*
remote_sidl_rmi_TimeOutException_getClassInfo(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char*_retval_str = NULL;
    struct sidl_ClassInfo__object* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getClassInfo", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.getClassInfo.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval_str,           \
      _ex);SIDL_CHECK(*_ex);
    _retval = sidl_ClassInfo__connectI(_retval_str, FALSE,                    \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:getNote */
static char*
remote_sidl_rmi_TimeOutException_getNote(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getNote", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.getNote.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval,               \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:setNote */
static void
remote_sidl_rmi_TimeOutException_setNote(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* in */ const char* message,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "setNote", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "message", message,                 \
      _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.setNote.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:getTrace */
static char*
remote_sidl_rmi_TimeOutException_getTrace(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getTrace", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.getTrace.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval,               \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:addLine */
static void
remote_sidl_rmi_TimeOutException_addLine(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* in */ const char* traceline,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "addLine", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "traceline", traceline,             \
      _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.addLine.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:add */
static void
remote_sidl_rmi_TimeOutException_add(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* in */ const char* filename,
  /* in */ int32_t lineno,
  /* in */ const char* methodname,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "add", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "filename", filename,               \
      _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packInt( _inv, "lineno", lineno,                      \
      _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packString( _inv, "methodname", methodname,           \
      _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.add.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:packObj */
static void
remote_sidl_rmi_TimeOutException_packObj(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* in */ struct sidl_io_Serializer__object* ser,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "packObj", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(ser){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)ser,        \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "ser", _url,                      \
        _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "ser", NULL,                      \
        _ex);SIDL_CHECK(*_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.packObj.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:unpackObj */
static void
remote_sidl_rmi_TimeOutException_unpackObj(
  /* in */ struct sidl_rmi_TimeOutException__object* self ,
  /* in */ struct sidl_io_Deserializer__object* des,
  /* out */ struct sidl_BaseInterface__object* *_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    sidl_BaseInterface _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_TimeOutException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "unpackObj", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(des){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)des,        \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "des", _url,                      \
        _ex);SIDL_CHECK(*_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "des", NULL,                      \
        _ex);SIDL_CHECK(*_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if(_be != NULL) {
      sidl_BaseInterface throwaway_exception = NULL;
sidl_BaseException_addLine(_be, "Exception unserialized from sidl.rmi.TimeOutException.unpackObj.", &throwaway_exception);
      *_ex = (sidl_BaseInterface) sidl_BaseInterface__rmicast(_be,            \
        &throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE EPV: create remote entry point vectors (EPVs). */
static void sidl_rmi_TimeOutException__init_remote_epv(void)
{
  /* assert( HAVE_LOCKED_STATIC_GLOBALS ); */
  struct sidl_rmi_TimeOutException__epv* epv =                                \
    &s_rem_epv__sidl_rmi_timeoutexception;
  struct sidl_BaseClass__epv*            e0  = &s_rem_epv__sidl_baseclass;
  struct sidl_BaseException__epv*        e1  = &s_rem_epv__sidl_baseexception;
  struct sidl_BaseInterface__epv*        e2  = &s_rem_epv__sidl_baseinterface;
  struct sidl_RuntimeException__epv*     e3  =                                \
    &s_rem_epv__sidl_runtimeexception;
  struct sidl_SIDLException__epv*        e4  = &s_rem_epv__sidl_sidlexception;
  struct sidl_io_IOException__epv*       e5  =                                \
    &s_rem_epv__sidl_io_ioexception;
  struct sidl_io_Serializable__epv*      e6  =                                \
    &s_rem_epv__sidl_io_serializable;
  struct sidl_rmi_NetworkException__epv* e7  =                                \
    &s_rem_epv__sidl_rmi_networkexception;

  epv->f__cast             = remote_sidl_rmi_TimeOutException__cast;
  epv->f__delete           = remote_sidl_rmi_TimeOutException__delete;
  epv->f__exec             = remote_sidl_rmi_TimeOutException__exec;
  epv->f__getURL           = remote_sidl_rmi_TimeOutException__getURL;
  epv->f__raddRef          = remote_sidl_rmi_TimeOutException__raddRef;
  epv->f__isRemote         = remote_sidl_rmi_TimeOutException__isRemote;
  epv->f__set_hooks        = remote_sidl_rmi_TimeOutException__set_hooks;
  epv->f__ctor             = NULL;
  epv->f__ctor2            = NULL;
  epv->f__dtor             = NULL;
  epv->f_getHopCount       = remote_sidl_rmi_TimeOutException_getHopCount;
  epv->f_addRef            = remote_sidl_rmi_TimeOutException_addRef;
  epv->f_deleteRef         = remote_sidl_rmi_TimeOutException_deleteRef;
  epv->f_isSame            = remote_sidl_rmi_TimeOutException_isSame;
  epv->f_isType            = remote_sidl_rmi_TimeOutException_isType;
  epv->f_getClassInfo      = remote_sidl_rmi_TimeOutException_getClassInfo;
  epv->f_getNote           = remote_sidl_rmi_TimeOutException_getNote;
  epv->f_setNote           = remote_sidl_rmi_TimeOutException_setNote;
  epv->f_getTrace          = remote_sidl_rmi_TimeOutException_getTrace;
  epv->f_addLine           = remote_sidl_rmi_TimeOutException_addLine;
  epv->f_add               = remote_sidl_rmi_TimeOutException_add;
  epv->f_packObj           = remote_sidl_rmi_TimeOutException_packObj;
  epv->f_unpackObj         = remote_sidl_rmi_TimeOutException_unpackObj;

  e0->f__cast        = (void* (*)(struct sidl_BaseClass__object*,const char*, \
    sidl_BaseInterface*)) epv->f__cast;
  e0->f__delete      = (void (*)(struct sidl_BaseClass__object*,              \
    sidl_BaseInterface*)) epv->f__delete;
  e0->f__getURL      = (char* (*)(struct sidl_BaseClass__object*,             \
    sidl_BaseInterface*)) epv->f__getURL;
  e0->f__raddRef     = (void (*)(struct sidl_BaseClass__object*,              \
    sidl_BaseInterface*)) epv->f__raddRef;
  e0->f__isRemote    = (sidl_bool (*)(struct sidl_BaseClass__object*,         \
    sidl_BaseInterface*)) epv->f__isRemote;
  e0->f__set_hooks   = (void (*)(struct sidl_BaseClass__object*,int32_t,      \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e0->f__exec        = (void (*)(struct sidl_BaseClass__object*,const char*,  \
    struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,            \
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e0->f_addRef       = (void (*)(struct sidl_BaseClass__object*,              \
    struct sidl_BaseInterface__object **)) epv->f_addRef;
  e0->f_deleteRef    = (void (*)(struct sidl_BaseClass__object*,              \
    struct sidl_BaseInterface__object **)) epv->f_deleteRef;
  e0->f_isSame       = (sidl_bool (*)(struct sidl_BaseClass__object*,         \
    struct sidl_BaseInterface__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_isSame;
  e0->f_isType       = (sidl_bool (*)(struct sidl_BaseClass__object*,         \
    const char*,struct sidl_BaseInterface__object **)) epv->f_isType;
  e0->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(struct             \
    sidl_BaseClass__object*,                                                  \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e1->f__cast        = (void* (*)(void*,const char*,                          \
    sidl_BaseInterface*)) epv->f__cast;
  e1->f__delete      = (void (*)(void*,sidl_BaseInterface*)) epv->f__delete;
  e1->f__getURL      = (char* (*)(void*,sidl_BaseInterface*)) epv->f__getURL;
  e1->f__raddRef     = (void (*)(void*,sidl_BaseInterface*)) epv->f__raddRef;
  e1->f__isRemote    = (sidl_bool (*)(void*,                                  \
    sidl_BaseInterface*)) epv->f__isRemote;
  e1->f__set_hooks   = (void (*)(void*,int32_t,                               \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e1->f__exec        = (void (*)(void*,const char*,                           \
    struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,            \
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e1->f_getNote      = (char* (*)(void*,                                      \
    struct sidl_BaseInterface__object **)) epv->f_getNote;
  e1->f_setNote      = (void (*)(void*,const char*,                           \
    struct sidl_BaseInterface__object **)) epv->f_setNote;
  e1->f_getTrace     = (char* (*)(void*,                                      \
    struct sidl_BaseInterface__object **)) epv->f_getTrace;
  e1->f_addLine      = (void (*)(void*,const char*,                           \
    struct sidl_BaseInterface__object **)) epv->f_addLine;
  e1->f_add          = (void (*)(void*,const char*,int32_t,const char*,       \
    struct sidl_BaseInterface__object **)) epv->f_add;
  e1->f_packObj      = (void (*)(void*,struct sidl_io_Serializer__object*,    \
    struct sidl_BaseInterface__object **)) epv->f_packObj;
  e1->f_unpackObj    = (void (*)(void*,struct sidl_io_Deserializer__object*,  \
    struct sidl_BaseInterface__object **)) epv->f_unpackObj;
  e1->f_addRef       = (void (*)(void*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_addRef;
  e1->f_deleteRef    = (void (*)(void*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_deleteRef;
  e1->f_isSame       = (sidl_bool (*)(void*,                                  \
    struct sidl_BaseInterface__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_isSame;
  e1->f_isType       = (sidl_bool (*)(void*,const char*,                      \
    struct sidl_BaseInterface__object **)) epv->f_isType;
  e1->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(void*,             \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e2->f__cast        = (void* (*)(void*,const char*,                          \
    sidl_BaseInterface*)) epv->f__cast;
  e2->f__delete      = (void (*)(void*,sidl_BaseInterface*)) epv->f__delete;
  e2->f__getURL      = (char* (*)(void*,sidl_BaseInterface*)) epv->f__getURL;
  e2->f__raddRef     = (void (*)(void*,sidl_BaseInterface*)) epv->f__raddRef;
  e2->f__isRemote    = (sidl_bool (*)(void*,                                  \
    sidl_BaseInterface*)) epv->f__isRemote;
  e2->f__set_hooks   = (void (*)(void*,int32_t,                               \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e2->f__exec        = (void (*)(void*,const char*,                           \
    struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,            \
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e2->f_addRef       = (void (*)(void*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_addRef;
  e2->f_deleteRef    = (void (*)(void*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_deleteRef;
  e2->f_isSame       = (sidl_bool (*)(void*,                                  \
    struct sidl_BaseInterface__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_isSame;
  e2->f_isType       = (sidl_bool (*)(void*,const char*,                      \
    struct sidl_BaseInterface__object **)) epv->f_isType;
  e2->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(void*,             \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e3->f__cast        = (void* (*)(void*,const char*,                          \
    sidl_BaseInterface*)) epv->f__cast;
  e3->f__delete      = (void (*)(void*,sidl_BaseInterface*)) epv->f__delete;
  e3->f__getURL      = (char* (*)(void*,sidl_BaseInterface*)) epv->f__getURL;
  e3->f__raddRef     = (void (*)(void*,sidl_BaseInterface*)) epv->f__raddRef;
  e3->f__isRemote    = (sidl_bool (*)(void*,                                  \
    sidl_BaseInterface*)) epv->f__isRemote;
  e3->f__set_hooks   = (void (*)(void*,int32_t,                               \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e3->f__exec        = (void (*)(void*,const char*,                           \
    struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,            \
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e3->f_getNote      = (char* (*)(void*,                                      \
    struct sidl_BaseInterface__object **)) epv->f_getNote;
  e3->f_setNote      = (void (*)(void*,const char*,                           \
    struct sidl_BaseInterface__object **)) epv->f_setNote;
  e3->f_getTrace     = (char* (*)(void*,                                      \
    struct sidl_BaseInterface__object **)) epv->f_getTrace;
  e3->f_addLine      = (void (*)(void*,const char*,                           \
    struct sidl_BaseInterface__object **)) epv->f_addLine;
  e3->f_add          = (void (*)(void*,const char*,int32_t,const char*,       \
    struct sidl_BaseInterface__object **)) epv->f_add;
  e3->f_packObj      = (void (*)(void*,struct sidl_io_Serializer__object*,    \
    struct sidl_BaseInterface__object **)) epv->f_packObj;
  e3->f_unpackObj    = (void (*)(void*,struct sidl_io_Deserializer__object*,  \
    struct sidl_BaseInterface__object **)) epv->f_unpackObj;
  e3->f_addRef       = (void (*)(void*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_addRef;
  e3->f_deleteRef    = (void (*)(void*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_deleteRef;
  e3->f_isSame       = (sidl_bool (*)(void*,                                  \
    struct sidl_BaseInterface__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_isSame;
  e3->f_isType       = (sidl_bool (*)(void*,const char*,                      \
    struct sidl_BaseInterface__object **)) epv->f_isType;
  e3->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(void*,             \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e4->f__cast        = (void* (*)(struct sidl_SIDLException__object*,         \
    const char*,sidl_BaseInterface*)) epv->f__cast;
  e4->f__delete      = (void (*)(struct sidl_SIDLException__object*,          \
    sidl_BaseInterface*)) epv->f__delete;
  e4->f__getURL      = (char* (*)(struct sidl_SIDLException__object*,         \
    sidl_BaseInterface*)) epv->f__getURL;
  e4->f__raddRef     = (void (*)(struct sidl_SIDLException__object*,          \
    sidl_BaseInterface*)) epv->f__raddRef;
  e4->f__isRemote    = (sidl_bool (*)(struct sidl_SIDLException__object*,     \
    sidl_BaseInterface*)) epv->f__isRemote;
  e4->f__set_hooks   = (void (*)(struct sidl_SIDLException__object*,int32_t,  \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e4->f__exec        = (void (*)(struct sidl_SIDLException__object*,          \
    const char*,struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,\
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e4->f_addRef       = (void (*)(struct sidl_SIDLException__object*,          \
    struct sidl_BaseInterface__object **)) epv->f_addRef;
  e4->f_deleteRef    = (void (*)(struct sidl_SIDLException__object*,          \
    struct sidl_BaseInterface__object **)) epv->f_deleteRef;
  e4->f_isSame       = (sidl_bool (*)(struct sidl_SIDLException__object*,     \
    struct sidl_BaseInterface__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_isSame;
  e4->f_isType       = (sidl_bool (*)(struct sidl_SIDLException__object*,     \
    const char*,struct sidl_BaseInterface__object **)) epv->f_isType;
  e4->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(struct             \
    sidl_SIDLException__object*,                                              \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;
  e4->f_getNote      = (char* (*)(struct sidl_SIDLException__object*,         \
    struct sidl_BaseInterface__object **)) epv->f_getNote;
  e4->f_setNote      = (void (*)(struct sidl_SIDLException__object*,          \
    const char*,struct sidl_BaseInterface__object **)) epv->f_setNote;
  e4->f_getTrace     = (char* (*)(struct sidl_SIDLException__object*,         \
    struct sidl_BaseInterface__object **)) epv->f_getTrace;
  e4->f_addLine      = (void (*)(struct sidl_SIDLException__object*,          \
    const char*,struct sidl_BaseInterface__object **)) epv->f_addLine;
  e4->f_add          = (void (*)(struct sidl_SIDLException__object*,          \
    const char*,int32_t,const char*,                                          \
    struct sidl_BaseInterface__object **)) epv->f_add;
  e4->f_packObj      = (void (*)(struct sidl_SIDLException__object*,          \
    struct sidl_io_Serializer__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_packObj;
  e4->f_unpackObj    = (void (*)(struct sidl_SIDLException__object*,          \
    struct sidl_io_Deserializer__object*,                                     \
    struct sidl_BaseInterface__object **)) epv->f_unpackObj;

  e5->f__cast        = (void* (*)(struct sidl_io_IOException__object*,        \
    const char*,sidl_BaseInterface*)) epv->f__cast;
  e5->f__delete      = (void (*)(struct sidl_io_IOException__object*,         \
    sidl_BaseInterface*)) epv->f__delete;
  e5->f__getURL      = (char* (*)(struct sidl_io_IOException__object*,        \
    sidl_BaseInterface*)) epv->f__getURL;
  e5->f__raddRef     = (void (*)(struct sidl_io_IOException__object*,         \
    sidl_BaseInterface*)) epv->f__raddRef;
  e5->f__isRemote    = (sidl_bool (*)(struct sidl_io_IOException__object*,    \
    sidl_BaseInterface*)) epv->f__isRemote;
  e5->f__set_hooks   = (void (*)(struct sidl_io_IOException__object*,int32_t, \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e5->f__exec        = (void (*)(struct sidl_io_IOException__object*,         \
    const char*,struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,\
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e5->f_addRef       = (void (*)(struct sidl_io_IOException__object*,         \
    struct sidl_BaseInterface__object **)) epv->f_addRef;
  e5->f_deleteRef    = (void (*)(struct sidl_io_IOException__object*,         \
    struct sidl_BaseInterface__object **)) epv->f_deleteRef;
  e5->f_isSame       = (sidl_bool (*)(struct sidl_io_IOException__object*,    \
    struct sidl_BaseInterface__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_isSame;
  e5->f_isType       = (sidl_bool (*)(struct sidl_io_IOException__object*,    \
    const char*,struct sidl_BaseInterface__object **)) epv->f_isType;
  e5->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(struct             \
    sidl_io_IOException__object*,                                             \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;
  e5->f_getNote      = (char* (*)(struct sidl_io_IOException__object*,        \
    struct sidl_BaseInterface__object **)) epv->f_getNote;
  e5->f_setNote      = (void (*)(struct sidl_io_IOException__object*,         \
    const char*,struct sidl_BaseInterface__object **)) epv->f_setNote;
  e5->f_getTrace     = (char* (*)(struct sidl_io_IOException__object*,        \
    struct sidl_BaseInterface__object **)) epv->f_getTrace;
  e5->f_addLine      = (void (*)(struct sidl_io_IOException__object*,         \
    const char*,struct sidl_BaseInterface__object **)) epv->f_addLine;
  e5->f_add          = (void (*)(struct sidl_io_IOException__object*,         \
    const char*,int32_t,const char*,                                          \
    struct sidl_BaseInterface__object **)) epv->f_add;
  e5->f_packObj      = (void (*)(struct sidl_io_IOException__object*,         \
    struct sidl_io_Serializer__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_packObj;
  e5->f_unpackObj    = (void (*)(struct sidl_io_IOException__object*,         \
    struct sidl_io_Deserializer__object*,                                     \
    struct sidl_BaseInterface__object **)) epv->f_unpackObj;

  e6->f__cast        = (void* (*)(void*,const char*,                          \
    sidl_BaseInterface*)) epv->f__cast;
  e6->f__delete      = (void (*)(void*,sidl_BaseInterface*)) epv->f__delete;
  e6->f__getURL      = (char* (*)(void*,sidl_BaseInterface*)) epv->f__getURL;
  e6->f__raddRef     = (void (*)(void*,sidl_BaseInterface*)) epv->f__raddRef;
  e6->f__isRemote    = (sidl_bool (*)(void*,                                  \
    sidl_BaseInterface*)) epv->f__isRemote;
  e6->f__set_hooks   = (void (*)(void*,int32_t,                               \
    sidl_BaseInterface*)) epv->f__set_hooks;
  e6->f__exec        = (void (*)(void*,const char*,                           \
    struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,            \
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e6->f_packObj      = (void (*)(void*,struct sidl_io_Serializer__object*,    \
    struct sidl_BaseInterface__object **)) epv->f_packObj;
  e6->f_unpackObj    = (void (*)(void*,struct sidl_io_Deserializer__object*,  \
    struct sidl_BaseInterface__object **)) epv->f_unpackObj;
  e6->f_addRef       = (void (*)(void*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_addRef;
  e6->f_deleteRef    = (void (*)(void*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_deleteRef;
  e6->f_isSame       = (sidl_bool (*)(void*,                                  \
    struct sidl_BaseInterface__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_isSame;
  e6->f_isType       = (sidl_bool (*)(void*,const char*,                      \
    struct sidl_BaseInterface__object **)) epv->f_isType;
  e6->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(void*,             \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e7->f__cast        = (void* (*)(struct sidl_rmi_NetworkException__object*,  \
    const char*,sidl_BaseInterface*)) epv->f__cast;
  e7->f__delete      = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    sidl_BaseInterface*)) epv->f__delete;
  e7->f__getURL      = (char* (*)(struct sidl_rmi_NetworkException__object*,  \
    sidl_BaseInterface*)) epv->f__getURL;
  e7->f__raddRef     = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    sidl_BaseInterface*)) epv->f__raddRef;
  e7->f__isRemote    = (sidl_bool (*)(struct                                  \
    sidl_rmi_NetworkException__object*,sidl_BaseInterface*)) epv->f__isRemote;
  e7->f__set_hooks   = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    int32_t, sidl_BaseInterface*)) epv->f__set_hooks;
  e7->f__exec        = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    const char*,struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,\
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e7->f_getHopCount  = (int32_t (*)(struct sidl_rmi_NetworkException__object*,\
    struct sidl_BaseInterface__object **)) epv->f_getHopCount;
  e7->f_addRef       = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    struct sidl_BaseInterface__object **)) epv->f_addRef;
  e7->f_deleteRef    = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    struct sidl_BaseInterface__object **)) epv->f_deleteRef;
  e7->f_isSame       = (sidl_bool (*)(struct                                  \
    sidl_rmi_NetworkException__object*,struct sidl_BaseInterface__object*,    \
    struct sidl_BaseInterface__object **)) epv->f_isSame;
  e7->f_isType       = (sidl_bool (*)(struct                                  \
    sidl_rmi_NetworkException__object*,const char*,                           \
    struct sidl_BaseInterface__object **)) epv->f_isType;
  e7->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(struct             \
    sidl_rmi_NetworkException__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_getClassInfo;
  e7->f_getNote      = (char* (*)(struct sidl_rmi_NetworkException__object*,  \
    struct sidl_BaseInterface__object **)) epv->f_getNote;
  e7->f_setNote      = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    const char*,struct sidl_BaseInterface__object **)) epv->f_setNote;
  e7->f_getTrace     = (char* (*)(struct sidl_rmi_NetworkException__object*,  \
    struct sidl_BaseInterface__object **)) epv->f_getTrace;
  e7->f_addLine      = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    const char*,struct sidl_BaseInterface__object **)) epv->f_addLine;
  e7->f_add          = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    const char*,int32_t,const char*,                                          \
    struct sidl_BaseInterface__object **)) epv->f_add;
  e7->f_packObj      = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    struct sidl_io_Serializer__object*,                                       \
    struct sidl_BaseInterface__object **)) epv->f_packObj;
  e7->f_unpackObj    = (void (*)(struct sidl_rmi_NetworkException__object*,   \
    struct sidl_io_Deserializer__object*,                                     \
    struct sidl_BaseInterface__object **)) epv->f_unpackObj;

  s_remote_initialized = 1;
}

/* Create an instance that connects to an existing remote object. */
static struct sidl_rmi_TimeOutException__object*
sidl_rmi_TimeOutException__remoteConnect(const char *url, sidl_bool ar,       \
  sidl_BaseInterface *_ex)
{
  struct sidl_rmi_TimeOutException__object* self;

  struct sidl_rmi_TimeOutException__object* s0;
  struct sidl_rmi_NetworkException__object* s1;
  struct sidl_io_IOException__object* s2;
  struct sidl_SIDLException__object* s3;
  struct sidl_BaseClass__object* s4;

  struct sidl_rmi_TimeOutException__remote* r_obj;
  sidl_rmi_InstanceHandle instance = NULL;
  char* objectID = NULL;
  objectID = NULL;
  *_ex = NULL;
  if(url == NULL) {return NULL;}
  objectID = sidl_rmi_ServerRegistry_isLocalObject(url, _ex);
  if(objectID) {
    sidl_BaseInterface bi =                                                   \
      (sidl_BaseInterface)sidl_rmi_InstanceRegistry_getInstanceByString(      \
      objectID, _ex); SIDL_CHECK(*_ex);
    return sidl_rmi_TimeOutException__rmicast(bi,_ex);SIDL_CHECK(*_ex);
  }
  instance = sidl_rmi_ProtocolFactory_connectInstance(url, ar,                \
    _ex ); SIDL_CHECK(*_ex);
  if ( instance == NULL) { return NULL; }
  self =
    (struct sidl_rmi_TimeOutException__object*) malloc(
      sizeof(struct sidl_rmi_TimeOutException__object));

  r_obj =
    (struct sidl_rmi_TimeOutException__remote*) malloc(
      sizeof(struct sidl_rmi_TimeOutException__remote));

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                                     self;
  s1 =                                     &s0->d_sidl_rmi_networkexception;
  s2 =                                     &s1->d_sidl_io_ioexception;
  s3 =                                     &s2->d_sidl_sidlexception;
  s4 =                                     &s3->d_sidl_baseclass;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    sidl_rmi_TimeOutException__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s4->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s4->d_sidl_baseinterface.d_object = (void*) self;

  s4->d_data = (void*) r_obj;
  s4->d_epv  = &s_rem_epv__sidl_baseclass;

  s3->d_sidl_baseexception.d_epv    = &s_rem_epv__sidl_baseexception;
  s3->d_sidl_baseexception.d_object = (void*) self;

  s3->d_sidl_io_serializable.d_epv    = &s_rem_epv__sidl_io_serializable;
  s3->d_sidl_io_serializable.d_object = (void*) self;

  s3->d_data = (void*) r_obj;
  s3->d_epv  = &s_rem_epv__sidl_sidlexception;

  s2->d_sidl_runtimeexception.d_epv    = &s_rem_epv__sidl_runtimeexception;
  s2->d_sidl_runtimeexception.d_object = (void*) self;

  s2->d_data = (void*) r_obj;
  s2->d_epv  = &s_rem_epv__sidl_io_ioexception;

  s1->d_data = (void*) r_obj;
  s1->d_epv  = &s_rem_epv__sidl_rmi_networkexception;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__sidl_rmi_timeoutexception;

  self->d_data = (void*) r_obj;

  return self;
  EXIT:
  return NULL;
}
/* Create an instance that uses an already existing  */
/* InstanceHandle to connect to an existing remote object. */
static struct sidl_rmi_TimeOutException__object*
sidl_rmi_TimeOutException__IHConnect(sidl_rmi_InstanceHandle instance,        \
  sidl_BaseInterface *_ex)
{
  struct sidl_rmi_TimeOutException__object* self;

  struct sidl_rmi_TimeOutException__object* s0;
  struct sidl_rmi_NetworkException__object* s1;
  struct sidl_io_IOException__object* s2;
  struct sidl_SIDLException__object* s3;
  struct sidl_BaseClass__object* s4;

  struct sidl_rmi_TimeOutException__remote* r_obj;
  self =
    (struct sidl_rmi_TimeOutException__object*) malloc(
      sizeof(struct sidl_rmi_TimeOutException__object));

  r_obj =
    (struct sidl_rmi_TimeOutException__remote*) malloc(
      sizeof(struct sidl_rmi_TimeOutException__remote));

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                                     self;
  s1 =                                     &s0->d_sidl_rmi_networkexception;
  s2 =                                     &s1->d_sidl_io_ioexception;
  s3 =                                     &s2->d_sidl_sidlexception;
  s4 =                                     &s3->d_sidl_baseclass;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    sidl_rmi_TimeOutException__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s4->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s4->d_sidl_baseinterface.d_object = (void*) self;

  s4->d_data = (void*) r_obj;
  s4->d_epv  = &s_rem_epv__sidl_baseclass;

  s3->d_sidl_baseexception.d_epv    = &s_rem_epv__sidl_baseexception;
  s3->d_sidl_baseexception.d_object = (void*) self;

  s3->d_sidl_io_serializable.d_epv    = &s_rem_epv__sidl_io_serializable;
  s3->d_sidl_io_serializable.d_object = (void*) self;

  s3->d_data = (void*) r_obj;
  s3->d_epv  = &s_rem_epv__sidl_sidlexception;

  s2->d_sidl_runtimeexception.d_epv    = &s_rem_epv__sidl_runtimeexception;
  s2->d_sidl_runtimeexception.d_object = (void*) self;

  s2->d_data = (void*) r_obj;
  s2->d_epv  = &s_rem_epv__sidl_io_ioexception;

  s1->d_data = (void*) r_obj;
  s1->d_epv  = &s_rem_epv__sidl_rmi_networkexception;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__sidl_rmi_timeoutexception;

  self->d_data = (void*) r_obj;

  sidl_rmi_InstanceHandle_addRef(instance,_ex);SIDL_CHECK(*_ex);
  return self;
  EXIT:
  return NULL;
}
/* REMOTE: generate remote instance given URL string. */
static struct sidl_rmi_TimeOutException__object*
sidl_rmi_TimeOutException__remoteCreate(const char *url,                      \
  sidl_BaseInterface *_ex)
{
  sidl_BaseInterface _throwaway_exception = NULL;
  struct sidl_rmi_TimeOutException__object* self;

  struct sidl_rmi_TimeOutException__object* s0;
  struct sidl_rmi_NetworkException__object* s1;
  struct sidl_io_IOException__object* s2;
  struct sidl_SIDLException__object* s3;
  struct sidl_BaseClass__object* s4;

  struct sidl_rmi_TimeOutException__remote* r_obj;
  sidl_rmi_InstanceHandle instance =                                          \
    sidl_rmi_ProtocolFactory_createInstance(url, "sidl.rmi.TimeOutException", \
    _ex ); SIDL_CHECK(*_ex);
  if ( instance == NULL) { return NULL; }
  self =
    (struct sidl_rmi_TimeOutException__object*) malloc(
      sizeof(struct sidl_rmi_TimeOutException__object));

  r_obj =
    (struct sidl_rmi_TimeOutException__remote*) malloc(
      sizeof(struct sidl_rmi_TimeOutException__remote));

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                                     self;
  s1 =                                     &s0->d_sidl_rmi_networkexception;
  s2 =                                     &s1->d_sidl_io_ioexception;
  s3 =                                     &s2->d_sidl_sidlexception;
  s4 =                                     &s3->d_sidl_baseclass;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    sidl_rmi_TimeOutException__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s4->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s4->d_sidl_baseinterface.d_object = (void*) self;

  s4->d_data = (void*) r_obj;
  s4->d_epv  = &s_rem_epv__sidl_baseclass;

  s3->d_sidl_baseexception.d_epv    = &s_rem_epv__sidl_baseexception;
  s3->d_sidl_baseexception.d_object = (void*) self;

  s3->d_sidl_io_serializable.d_epv    = &s_rem_epv__sidl_io_serializable;
  s3->d_sidl_io_serializable.d_object = (void*) self;

  s3->d_data = (void*) r_obj;
  s3->d_epv  = &s_rem_epv__sidl_sidlexception;

  s2->d_sidl_runtimeexception.d_epv    = &s_rem_epv__sidl_runtimeexception;
  s2->d_sidl_runtimeexception.d_object = (void*) self;

  s2->d_data = (void*) r_obj;
  s2->d_epv  = &s_rem_epv__sidl_io_ioexception;

  s1->d_data = (void*) r_obj;
  s1->d_epv  = &s_rem_epv__sidl_rmi_networkexception;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__sidl_rmi_timeoutexception;

  self->d_data = (void*) r_obj;

  return self;
  EXIT:
  if(instance) { sidl_rmi_InstanceHandle_deleteRef(instance,                  \
    &_throwaway_exception); }
  return NULL;
}
/*
 * Cast method for interface and class type conversions.
 */

struct sidl_rmi_TimeOutException__object*
sidl_rmi_TimeOutException__rmicast(
  void* obj,
  sidl_BaseInterface* _ex)
{
  struct sidl_rmi_TimeOutException__object* cast = NULL;

  *_ex = NULL;
  if(!connect_loaded) {
    sidl_rmi_ConnectRegistry_registerConnect("sidl.rmi.TimeOutException",     \
      (void*)sidl_rmi_TimeOutException__IHConnect, _ex);
    connect_loaded = 1;
  }
  if (obj != NULL) {
    struct sidl_BaseInterface__object* base = (struct                         \
      sidl_BaseInterface__object*) obj;
    cast = (struct sidl_rmi_TimeOutException__object*)                        \
      (*base->d_epv->f__cast)(
      base->d_object,
      "sidl.rmi.TimeOutException", _ex); SIDL_CHECK(*_ex);
  }

  return cast;
  EXIT:
  return NULL;
}

/*
 * RMI connector function for the class.
 */

struct sidl_rmi_TimeOutException__object*
sidl_rmi_TimeOutException__connectI(const char* url, sidl_bool ar,            \
  struct sidl_BaseInterface__object **_ex)
{
  return sidl_rmi_TimeOutException__remoteConnect(url, ar, _ex);
}

static PyObject *
pStub_TimeOutException__connect(PyObject *_ignored, PyObject *_args,          \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_TimeOutException__object* self = NULL;
  char* url = NULL;
  struct sidl_BaseInterface__object *_exception = NULL;
  static char *_kwlist[] = {
    "url",
    NULL
  };
  int _okay;
  _okay = PyArg_ParseTupleAndKeywords(
    _args, _kwdict, 
    "z", _kwlist,
    &url);
  if (_okay) {
    self = sidl_rmi_TimeOutException__remoteConnect(url,1,&_exception);
    if (_exception) {
      struct sidl_rmi_NetworkException__object *_ex0;
      if ((_ex0 = (struct sidl_rmi_NetworkException__object *)
      sidl_PyExceptionCast(_exception, "sidl.rmi.NetworkException"))) {
        struct sidl_BaseInterface__object *throwaway_exception;
        PyObject *_obj = sidl_rmi_NetworkException__wrap(_ex0);
        PyObject *_args = PyTuple_New(1);
        PyTuple_SetItem(_args, 0, _obj);
        _obj = PyObject_CallObject(sidl_rmi_NetworkException__type, _args);
        PyErr_SetObject(sidl_rmi_NetworkException__type, _obj);
        Py_XDECREF(_obj);
        (*(_exception->d_epv->f_deleteRef))(_exception->d_object,             \
          &throwaway_exception);
        Py_XDECREF(_args);
      }
    }
    else {
      _return_value = Py_BuildValue(
        "O&",
        (void *)sidl_rmi_TimeOutException__wrap, self);
    }
  }
  return _return_value;
}

staticforward PyTypeObject _sidl_rmi_TimeOutExceptionType;

static const struct sidl_rmi_TimeOutException__external *_implEPV = NULL;

static PyObject *
pStub_TimeOutException__exec(PyObject *_self, PyObject *_args,                \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_TimeOutException__object *_self_ior =
    ((struct sidl_rmi_TimeOutException__object *)
     sidl_Cast(_self, "sidl.rmi.TimeOutException"));
  if (_self_ior) {
    char* methodName = NULL;
    struct sidl_rmi_Call__object* inArgs = NULL;
    struct sidl_rmi_Return__object* outArgs = NULL;
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      "methodName",
      "inArgs",
      "outArgs",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    sidl_rmi_Call__import();
    sidl_rmi_Return__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "zO&O&", _kwlist,
      &methodName,
      (void *)sidl_rmi_Call__convert, &inArgs,
      (void *)sidl_rmi_Return__convert, &outArgs);
    if (_okay) {
      (*(_self_ior->d_epv->f__exec))(_self_ior, methodName, inArgs, outArgs,  \
        &_exception);
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_args = PyTuple_New(1);
          PyTuple_SetItem(_args, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _args);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_args);
        }
      }
      else {
        _return_value = Py_None;
        Py_INCREF(_return_value);
      }
      sidl_rmi_Call_deref(inArgs);
      sidl_rmi_Return_deref(outArgs);
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.TimeOutException");
  }
  return _return_value;
}

static PyObject *
pStub_TimeOutException__getURL(PyObject *_self, PyObject *_args,              \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_TimeOutException__object *_self_ior =
    ((struct sidl_rmi_TimeOutException__object *)
     sidl_Cast(_self, "sidl.rmi.TimeOutException"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      char* _return = NULL;
      _return = (*(_self_ior->d_epv->f__getURL))(_self_ior, &_exception);
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_args = PyTuple_New(1);
          PyTuple_SetItem(_args, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _args);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_args);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "z",
          _return);
      }
      free((void *)_return);
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.TimeOutException");
  }
  return _return_value;
}

static PyObject *
pStub_TimeOutException__isLocal(PyObject *_self, PyObject *_args,             \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_TimeOutException__object *_self_ior =
    ((struct sidl_rmi_TimeOutException__object *)
     sidl_Cast(_self, "sidl.rmi.TimeOutException"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      sidl_bool _return = (sidl_bool) 0;
      int _proxy__return;
      _return = !(*(_self_ior->d_epv->f__isRemote))(_self_ior, &_exception);
      _proxy__return = _return;
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_args = PyTuple_New(1);
          PyTuple_SetItem(_args, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _args);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_args);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "i",
          _proxy__return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.TimeOutException");
  }
  return _return_value;
}

static PyObject *
pStub_TimeOutException__isRemote(PyObject *_self, PyObject *_args,            \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_TimeOutException__object *_self_ior =
    ((struct sidl_rmi_TimeOutException__object *)
     sidl_Cast(_self, "sidl.rmi.TimeOutException"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      sidl_bool _return = (sidl_bool) 0;
      int _proxy__return;
      _return = (*(_self_ior->d_epv->f__isRemote))(_self_ior, &_exception);
      _proxy__return = _return;
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_args = PyTuple_New(1);
          PyTuple_SetItem(_args, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _args);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_args);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "i",
          _proxy__return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.TimeOutException");
  }
  return _return_value;
}

static PyObject *
pStub_TimeOutException__set_hooks(PyObject *_self, PyObject *_args,           \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_TimeOutException__object *_self_ior =
    ((struct sidl_rmi_TimeOutException__object *)
     sidl_Cast(_self, "sidl.rmi.TimeOutException"));
  if (_self_ior) {
    sidl_bool on = (sidl_bool) 0;
    struct sidl_BaseInterface__object *_exception = NULL;
    int _proxy_on;
    static char *_kwlist[] = {
      "on",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "i", _kwlist,
      &_proxy_on);
    if (_okay) {
      on = (_proxy_on ? (TRUE) : (FALSE));
      (*(_self_ior->d_epv->f__set_hooks))(_self_ior, on, &_exception);
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_args = PyTuple_New(1);
          PyTuple_SetItem(_args, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _args);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
          Py_XDECREF(_args);
        }
      }
      else {
        _return_value = Py_None;
        Py_INCREF(_return_value);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.TimeOutException");
  }
  return _return_value;
}

static int
sidl_rmi_TimeOutException_createCast(PyObject *self, PyObject *args,          \
  PyObject *kwds) {
  struct sidl_rmi_TimeOutException__object *optarg = NULL;
  char* url = NULL;
  PyObject * implObj = NULL;
  static char *_kwlist[] = {"sobj",  "url", "impl", NULL };
  int _okay = PyArg_ParseTupleAndKeywords(args, kwds, "|O&zO", _kwlist,       \
    (void *)sidl_rmi_TimeOutException__convert, &optarg, &url, &implObj);
  if (_okay) {
    if (!optarg && !url && !implObj) {
      struct sidl_BaseInterface__object *_exception;
      optarg = (*(_implEPV->createObject))(NULL,&_exception);
      if (_exception) {
        sidl_RuntimeException__import();
        {
          struct sidl_RuntimeException__object *_ex0;
          if ((_ex0 = (struct sidl_RuntimeException__object *)
          sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
            struct sidl_BaseInterface__object *throwaway_exception;
            PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
            PyObject *_args = PyTuple_New(1);
            PyTuple_SetItem(_args, 0, _obj);
            _obj = PyObject_CallObject(sidl_RuntimeException__type, _args);
            PyErr_SetObject(sidl_RuntimeException__type, _obj);
            Py_XDECREF(_obj);
            (*(_exception->d_epv->f_deleteRef))(_exception->d_object,         \
              &throwaway_exception);
            Py_XDECREF(_args);
          }
          return -1;
        }
      }
    }
    else if (!optarg && !url && implObj) {
      struct sidl_BaseInterface__object *_exception;
      Py_INCREF(implObj);
      optarg = (*(_implEPV->createObject))((void*)implObj,&_exception);
      if (_exception) {
        sidl_RuntimeException__import();
        {
          struct sidl_RuntimeException__object *_ex0;
          if ((_ex0 = (struct sidl_RuntimeException__object *)
          sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
            struct sidl_BaseInterface__object *throwaway_exception;
            PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
            PyObject *_args = PyTuple_New(1);
            PyTuple_SetItem(_args, 0, _obj);
            _obj = PyObject_CallObject(sidl_RuntimeException__type, _args);
            PyErr_SetObject(sidl_RuntimeException__type, _obj);
            Py_XDECREF(_obj);
            (*(_exception->d_epv->f_deleteRef))(_exception->d_object,         \
              &throwaway_exception);
            Py_XDECREF(_args);
          }
          return -1;
        }
      }
  }
  else if(url && !optarg && !implObj) {
    struct sidl_BaseInterface__object *_exception = NULL;
    optarg = sidl_rmi_TimeOutException__remoteCreate(url,&_exception);
    if (_exception) {
      sidl_rmi_NetworkException__import();
      struct sidl_rmi_NetworkException__object *_ex0;
      if ((_ex0 = (struct sidl_rmi_NetworkException__object *)
      sidl_PyExceptionCast(_exception, "sidl.rmi.NetworkException"))) {
        struct sidl_BaseInterface__object *throwaway_exception;
        PyObject *_obj = sidl_rmi_NetworkException__wrap(_ex0);
        PyObject *_args = PyTuple_New(1);
        PyTuple_SetItem(_args, 0, _obj);
        _obj = PyObject_CallObject(sidl_rmi_NetworkException__type, _args);
        PyErr_SetObject(sidl_rmi_NetworkException__type, _obj);
        Py_XDECREF(_obj);
        (*(_exception->d_epv->f_deleteRef))(_exception->d_object,             \
          &throwaway_exception);
        Py_XDECREF(_args);
      }
      return -1;
    }
  }
  /* OK, but fall though */
  else if(!url && optarg && !implObj) {}
  /* Error case. */
  else {
    return -1;
  }
  return sidl_Object_Init(
    (SPObject *)self,
    (struct sidl_BaseInterface__object *)optarg,
    sidl_PyStealRef);
}
return -1;
}

static PyMethodDef _TimeOutExceptionModuleMethods[] = {
  { "_connect", (PyCFunction)pStub_TimeOutException__connect,
  (METH_VARARGS | METH_KEYWORDS),
"\
_connect( in string url)\n\
RETURNS\n\
   ( out sidl.rmi.TimeOutException self)\n\
RAISES\n\
    sidl.rmi.NetworkException\n\
"
   },
  { NULL, NULL }
};

static PyMethodDef _TimeOutExceptionObjectMethods[] = {
  { "_exec", (PyCFunction)pStub_TimeOutException__exec,
  (METH_VARARGS | METH_KEYWORDS),
"\
_exec( in string methodName,\n\
       in sidl.rmi.Call inArgs,\n\
       in sidl.rmi.Return outArgs)\n\
RETURNS\n\
    None\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Select and execute a method by name"
   },
  { "_getURL", (PyCFunction)pStub_TimeOutException__getURL,
  (METH_VARARGS | METH_KEYWORDS),
"\
_getURL()\n\
RETURNS\n\
   (string _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Get the URL of the Implementation of this object (for RMI)"
   },
  { "_isLocal", (PyCFunction)pStub_TimeOutException__isLocal,
  (METH_VARARGS | METH_KEYWORDS),
"\
_isLocal()\n\
RETURNS\n\
   (bool _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
TRUE if this object is local, false if remote"
   },
  { "_isRemote", (PyCFunction)pStub_TimeOutException__isRemote,
  (METH_VARARGS | METH_KEYWORDS),
"\
_isRemote()\n\
RETURNS\n\
   (bool _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
TRUE if this object is remote, false if local"
   },
  { "_set_hooks", (PyCFunction)pStub_TimeOutException__set_hooks,
  (METH_VARARGS | METH_KEYWORDS),
"\
_set_hooks( in bool on)\n\
RETURNS\n\
    None\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Method to set whether or not method hooks should be invoked."
   },
  { NULL, NULL }
};

static PyTypeObject _sidl_rmi_TimeOutExceptionType = {
  PyObject_HEAD_INIT(NULL)
  0,      /* ob_size */
  "sidl.rmi.TimeOutException.TimeOutException", /* tp_name */
  0,      /* tp_basicsize */
  0,      /* tp_itemsize */
  0,      /* tp_dealloc */
  0,      /* tp_print */
  0,      /* tp_getattr */
  0,      /* tp_setattr */
  0,      /* tp_compare */
  0,      /* tp_repr */
  0,      /* tp_as_number */
  0,      /* tp_as_sequence */
  0,      /* tp_as_mapping */
  0,      /* tp_hash  */
  0,      /* tp_call */
  0,      /* tp_str */
  0,      /* tp_getattro */
  0,      /* tp_setattro */
  0,      /* tp_as_buffer */
  Py_TPFLAGS_DEFAULT, /* tp_flags */
  "\
\
This exception is thrown by the RMI library when a request \n\
times out. ", /* tp_doc */
  0,      /* tp_traverse */
  0,       /* tp_clear */
  0,       /* tp_richcompare */
  0,       /* tp_weaklistoffset */
  0,       /* tp_iter */
  0,       /* tp_iternext */
  _TimeOutExceptionObjectMethods, /* tp_methods */
  0,       /* tp_members */
  0,       /* tp_getset */
  0,       /* tp_base */
  0,       /* tp_dict */
  0,       /* tp_descr_get */
  0,       /* tp_descr_set */
  0,       /* tp_dictoffset */
  sidl_rmi_TimeOutException_createCast,   /* tp_init */
  0,       /* tp_alloc */
  0,       /* tp_new */
};

sidl_rmi_TimeOutException__wrap_RETURN
sidl_rmi_TimeOutException__wrap sidl_rmi_TimeOutException__wrap_PROTO {
  PyObject *result;
  if (sidlobj) {
    result =                                                                  \
      _sidl_rmi_TimeOutExceptionType.tp_new(&_sidl_rmi_TimeOutExceptionType,  \
      NULL, NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj),
        sidl_PyStealRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

sidl_rmi_TimeOutException__weakRef_RETURN
sidl_rmi_TimeOutException__weakRef sidl_rmi_TimeOutException__weakRef_PROTO {
  PyObject *result;
  if (sidlobj) {
    result =                                                                  \
      _sidl_rmi_TimeOutExceptionType.tp_new(&_sidl_rmi_TimeOutExceptionType,  \
      NULL, NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj),
        sidl_PyWeakRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

sidl_rmi_TimeOutException_deref_RETURN
sidl_rmi_TimeOutException_deref sidl_rmi_TimeOutException_deref_PROTO {
  if (sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
    (*(sidlobj->d_epv->f_deleteRef))(sidlobj, &throwaway_exception);
  }
}

sidl_rmi_TimeOutException__newRef_RETURN
sidl_rmi_TimeOutException__newRef sidl_rmi_TimeOutException__newRef_PROTO {
  PyObject *result;
  if (sidlobj) {
    result =                                                                  \
      _sidl_rmi_TimeOutExceptionType.tp_new(&_sidl_rmi_TimeOutExceptionType,  \
      NULL, NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj),
        sidl_PyNewRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

sidl_rmi_TimeOutException__addRef_RETURN
sidl_rmi_TimeOutException__addRef sidl_rmi_TimeOutException__addRef_PROTO {
  if (sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
    (*(sidlobj->d_epv->f_addRef))(sidlobj, &throwaway_exception);
  }
}

sidl_rmi_TimeOutException_PyType_RETURN
sidl_rmi_TimeOutException_PyType sidl_rmi_TimeOutException_PyType_PROTO {
  Py_INCREF(&_sidl_rmi_TimeOutExceptionType);
  return &_sidl_rmi_TimeOutExceptionType;
}

sidl_rmi_TimeOutException__convert_RETURN
sidl_rmi_TimeOutException__convert sidl_rmi_TimeOutException__convert_PROTO {
  *sidlobj = sidl_Cast(obj, "sidl.rmi.TimeOutException");
  if ((!(*sidlobj)) && (obj != Py_None)) {
    PyErr_SetString(PyExc_TypeError, 
      "argument is not a(n) sidl.rmi.TimeOutException");
    return 0;
  }
  return 1;
}

static int
_convertPython(void *sidlarray, const int *ind, PyObject *pyobj)
{
  struct sidl_rmi_TimeOutException__object *sidlobj;
  if (sidl_rmi_TimeOutException__convert(pyobj, &sidlobj)) {
    sidl_interface__array_set((struct sidl_interface__array *)sidlarray,
    ind, (struct sidl_BaseInterface__object *)sidlobj);
    if (sidlobj) {
      struct sidl_BaseInterface__object *asInt = (struct                      \
        sidl_BaseInterface__object *)sidlobj;
      struct sidl_BaseInterface__object *throwaway_exception;
      (*asInt->d_epv->f_deleteRef)(asInt->d_object, &throwaway_exception);
    }
    return FALSE;
  }
  return TRUE;
}

sidl_rmi_TimeOutException__convert_python_array_RETURN
sidl_rmi_TimeOutException__convert_python_array                               \
  sidl_rmi_TimeOutException__convert_python_array_PROTO {
  int result = 0;
  *sidlarray = NULL;
  if (obj == Py_None) {
    result = TRUE;
  }
  else {
    PyObject *pya = PyArray_FromObject(obj, PyArray_OBJECT, 0, 0);
    if (pya) {
      if (PyArray_OBJECT == ((PyArrayObject *)pya)->descr->type_num) {
        int dimen, lower[SIDL_MAX_ARRAY_DIMENSION],
          upper[SIDL_MAX_ARRAY_DIMENSION],
          stride[SIDL_MAX_ARRAY_DIMENSION];
        if (sidl_array__extract_python_info
          (pya, &dimen, lower, upper, stride))
        {
            *sidlarray = (struct                                              \
              sidl_rmi_TimeOutException__array*)sidl_interface__array_createRow
            (dimen, lower, upper);
          result = sidl_array__convert_python
            (pya, dimen, *sidlarray, _convertPython);
          if (*sidlarray && !result) {
            sidl_interface__array_deleteRef(
              (struct  sidl_interface__array *)*sidlarray);
            *sidlarray = NULL;
          }
        }
      }
      Py_DECREF(pya);
    }
  }
  return result;
}

static int
_convertSIDL(void *sidlarray, const int *ind, PyObject **dest)
{
  struct sidl_rmi_TimeOutException__object *sidlobj = (struct                 \
    sidl_rmi_TimeOutException__object*)
  sidl_interface__array_get((struct sidl_interface__array *)
    sidlarray, ind);
  *dest = sidl_rmi_TimeOutException__wrap(sidlobj);
  return (*dest == NULL);
}

sidl_rmi_TimeOutException__convert_sidl_array_RETURN
sidl_rmi_TimeOutException__convert_sidl_array                                 \
  sidl_rmi_TimeOutException__convert_sidl_array_PROTO {
  PyObject *pya = NULL;
  if (sidlarray) {
    const int dimen = sidlArrayDim(sidlarray);
    int i;
    int *lower = (int *)malloc(sizeof(int) * dimen);
    int *upper = (int *)malloc(sizeof(int) * dimen);
    int *numelem = (int *)malloc(sizeof(int) * dimen);
    for(i = 0; i < dimen; ++i) {
      lower[i] = sidlLower(sidlarray, i);
      upper[i] = sidlUpper(sidlarray, i);
      numelem[i] = 1 + upper[i] - lower[i];
    }
    pya = PyArray_FromDims(dimen, numelem, PyArray_OBJECT);
    if (pya) {
      if (!sidl_array__convert_sidl(pya, dimen, lower, upper,
        numelem, sidlarray, _convertSIDL))
      {
        Py_DECREF(pya);
        pya = NULL;
      }
    }
    free(numelem);
    free(upper);
    free(lower);
  }
  else {
    Py_INCREF(Py_None);
    pya = Py_None;
  }
  return pya;
}

void
initTimeOutException(void) {
  PyObject *module, *dict, *c_api;
  PyObject *_exceptionBases, *_exceptionDict, *_exceptionName;
  static void *ExternalAPI[sidl_rmi_TimeOutException__API_NUM];
  struct sidl_BaseInterface__object *throwaway_exception;
  module = Py_InitModule3("TimeOutException", _TimeOutExceptionModuleMethods, \
    "\
\
This exception is thrown by the RMI library when a request \n\
times out. "
  );
  dict = PyModule_GetDict(module);
  ExternalAPI[sidl_rmi_TimeOutException__wrap_NUM] =                          \
    (void*)sidl_rmi_TimeOutException__wrap;
  ExternalAPI[sidl_rmi_TimeOutException__convert_NUM] =                       \
    (void*)sidl_rmi_TimeOutException__convert;
  ExternalAPI[sidl_rmi_TimeOutException__convert_python_array_NUM] =          \
    (void*)sidl_rmi_TimeOutException__convert_python_array;
  ExternalAPI[sidl_rmi_TimeOutException__convert_sidl_array_NUM] =            \
    (void*)sidl_rmi_TimeOutException__convert_sidl_array;
  ExternalAPI[sidl_rmi_TimeOutException__weakRef_NUM] =                       \
    (void*)sidl_rmi_TimeOutException__weakRef;
  ExternalAPI[sidl_rmi_TimeOutException_deref_NUM] =                          \
    (void*)sidl_rmi_TimeOutException_deref;
  ExternalAPI[sidl_rmi_TimeOutException__newRef_NUM] =                        \
    (void*)sidl_rmi_TimeOutException__newRef;
  ExternalAPI[sidl_rmi_TimeOutException__addRef_NUM] =                        \
    (void*)sidl_rmi_TimeOutException__addRef;
  ExternalAPI[sidl_rmi_TimeOutException_PyType_NUM] =                         \
    (void*)sidl_rmi_TimeOutException_PyType;
  ExternalAPI[sidl_rmi_TimeOutException__connectI_NUM] =                      \
    (void*)sidl_rmi_TimeOutException__connectI;
  ExternalAPI[sidl_rmi_TimeOutException__rmicast_NUM] =                       \
    (void*)sidl_rmi_TimeOutException__rmicast;
  import_SIDLObjA();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing sidlObjA module.");
  }
  /* Initialize to temporary value. */
  Py_INCREF(Py_None);
  ExternalAPI[sidl_rmi_TimeOutException__type_NUM] = Py_None;
  c_api = PyCObject_FromVoidPtr((void *)ExternalAPI, NULL);
  PyDict_SetItemString(dict, "_C_API", c_api);
  Py_XDECREF(c_api);
  import_SIDLPyArrays();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing sidlPyArrays module.");
  }
  import_array();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing Numeric Python module.");
  }
  sidl_rmi_NetworkException__import();
  _sidl_rmi_TimeOutExceptionType.tp_base = sidl_rmi_NetworkException_PyType();
  _sidl_rmi_TimeOutExceptionType.tp_bases = PyTuple_New(1);
  PyTuple_SetItem(_sidl_rmi_TimeOutExceptionType.tp_bases,0,                  \
    (PyObject *)sidl_rmi_NetworkException_PyType());
  if (PyType_Ready(&_sidl_rmi_TimeOutExceptionType) < 0) {
    PyErr_Print();
    fprintf(stderr, "PyType_Ready on sidl.rmi.TimeOutException failed.\n");
    return;
  }
  Py_INCREF(&_sidl_rmi_TimeOutExceptionType);
  PyDict_SetItemString(dict, "TimeOutException",                              \
    (PyObject *)&_sidl_rmi_TimeOutExceptionType);
  _exceptionBases = PyTuple_New(1);
  Py_INCREF(sidl_rmi_NetworkException__type);
  PyTuple_SetItem(_exceptionBases, 0, sidl_rmi_NetworkException__type);
  _exceptionDict = PyDict_New();
  PyDict_SetItemString(_exceptionDict, "__module__",
    PyString_InternFromString("sidl.rmi.TimeOutException"));
  _exceptionName = PyString_InternFromString("_Exception");
  sidl_rmi_TimeOutException__type = PyClass_New(_exceptionBases,              \
    _exceptionDict, _exceptionName);
  Py_XDECREF(_exceptionBases);
  Py_XDECREF(_exceptionDict);
  Py_XDECREF(_exceptionName);
  Py_XINCREF(sidl_rmi_TimeOutException__type);
  PyDict_SetItemString(dict, "_Exception", sidl_rmi_TimeOutException__type);
  ExternalAPI[sidl_rmi_TimeOutException__type_NUM] =                          \
    sidl_rmi_TimeOutException__type;
  /*
   * If it's safe, add "Exception" for backward compatibility
   * with Babel 0.10.2 (and previous).
   */

  if (!PyDict_GetItemString(dict, "Exception")) {
    Py_XINCREF(sidl_rmi_TimeOutException__type);
    PyDict_SetItemString(dict, "Exception", sidl_rmi_TimeOutException__type);
  }
  _implEPV = sidl_rmi_TimeOutException__externals();
  if (!_implEPV) {
    Py_FatalError("Cannot load implementation for sidl class                  \
      sidl.rmi.TimeOutException");
  }

  sidl_rmi_ConnectRegistry_registerConnect("sidl.rmi.TimeOutException",       \
    (void*)sidl_rmi_TimeOutException__IHConnect, &throwaway_exception);
}
