i3status(1)
===========
Michael Stapelberg <michael@i3wm.org>
v2.6, October 2012

== NAME

i3status - Generates a status line for dzen2 or xmobar

== SYNOPSIS

i3status [-c configfile] [-h] [-v]

== OPTIONS

-c::
Specifies an alternate configuration file path. By default, i3status looks for
configuration files in the following order:

1. ~/.i3status.conf
2. ~/.config/i3status/config (or $XDG_CONFIG_HOME/i3status/config if set)
3. /etc/i3status.conf
4. /etc/xdg/i3status/config (or $XDG_CONFIG_DIRS/i3status/config if set)

== DESCRIPTION

i3status is a small program (about 1500 SLOC) for generating a status bar for
i3bar, dzen2, xmobar or similar programs. It is designed to be very
efficient by issuing a very small number of system calls, as one generally
wants to update such a status line every second. This ensures that even under
high load, your status bar is updated correctly. Also, it saves a bit of energy
by not hogging your CPU as much as spawning the corresponding amount of shell
commands would.

== CONFIGURATION

The basic idea of i3status is that you can specify which "modules" should
be used (the order directive). You can then configure each module with its
own section. For every module, you can specify the output format. See below
for a complete reference.

.Sample configuration
-------------------------------------------------------------
general {
        output_format = "dzen2"
        colors = true
        interval = 5
}

order += "ipv6"
order += "disk /"
order += "run_watch DHCP"
order += "run_watch VPN"
order += "wireless wlan0"
order += "ethernet eth0"
order += "battery 0"
order += "cpu_temperature 0"
order += "load"
order += "tztime local"
order += "tztime berlin"

wireless wlan0 {
        format_up = "W: (%quality at %essid, %bitrate) %ip"
        format_down = "W: down"
}

ethernet eth0 {
        # if you use %speed, i3status requires the cap_net_admin capability
        format_up = "E: %ip (%speed)"
        format_down = "E: down"
}

battery 0 {
        format = "%status %percentage %remaining %emptytime"
        path = "/sys/class/power_supply/BAT%d/uevent"
        low_threshold = 10
}

run_watch DHCP {
        pidfile = "/var/run/dhclient*.pid"
}

run_watch VPN {
        pidfile = "/var/run/vpnc/pid"
}

tztime local {
        format = "%Y-%m-%d %H:%M:%S"
}

tztime berlin {
        format = "%Y-%m-%d %H:%M:%S %Z"
        timezone = "Europe/Berlin"
}

load {
	format = "%5min"
}

cpu_temperature 0 {
	format = "T: %degrees °C"
	path = "/sys/devices/platform/coretemp.0/temp1_input"
}

disk "/" {
	format = "%free"
}
-------------------------------------------------------------

=== General

The +colors+ directive will disable all colors if you set it to +false+. You can
also specify the colors that will be used to display "good", "degraded" or "bad"
values using the +color_good+, +color_degraded+ or +color_bad+ directives,
respectively. Those directives are only used if color support is not disabled by
the +colors+ directive. The input format for color values is the canonical RGB
hexadecimal triplet (with no separators between the colors), prefixed by a hash
character ("#").

*Example configuration*:
-------------------------------------------------------------
color_good = "#00FF00"
-------------------------------------------------------------

Likewise, you can use the +color_separator+ directive to specify the color that
will be used to paint the separator bar. The separator is always output in
color, even when colors are disabled by the +colors+ directive.

The +interval+ directive specifies the time in seconds for which i3status will
sleep before printing the next status line.

Using +output_format+ you can chose which format strings i3status should
use in its output. Currently available are:

i3bar::
i3bar comes with i3 and provides a workspace bar which does the right thing in
multi-monitor situations. It also comes with tray support and can display the
i3status output. This output type uses JSON to pass as much meta-information to
i3bar as possible (like colors, which blocks can be shortened in which way,
etc.).
dzen2::
Dzen is a general purpose messaging, notification and menuing program for X11.
It was designed to be scriptable in any language and integrate well with window
managers like dwm, wmii and xmonad though it will work with any windowmanger
xmobar::
xmobar is a minimalistic, text based, status bar. It was designed to work
with the xmonad Window Manager.
none::
Does not use any color codes. Separates values by the pipe symbol. This should
be used with i3bar and can be used for custom scripts.

It's also possible to use the color_good, color_degraded, color_bad directives
to define specific colors per module. If one of these directives is defined
in a module section its value will override the value defined in the general
section just for this module.

=== IPv6

This module gets the IPv6 address used for outgoing connections (that is, the
best available public IPv6 address on your computer).

*Example format_up*: +%ip+

*Example format_down* +no IPv6+

=== Disk

Gets used, free, available and total amount of bytes on the given mounted filesystem.

These values can also be expressed in percentages with the percentage_used,
percentage_free, percentage_avail and percentage_used_of_avail formats.

*Example order*: +disk /mnt/usbstick+

*Example format*: +%free (%avail)/ %total+

*Example format*: +%percentage_used used, %percentage_free free, %percentage_avail avail+

=== Run-watch

Expands the given path to a pidfile and checks if the process ID found inside
is valid (that is, if the process is running). You can use this to check if
a specific application, such as a VPN client or your DHCP client is running.

*Example order*: +run_watch DHCP+

*Example format*: +%title: %status+

=== Wireless

Gets the link quality and ESSID of the given wireless network interface. You
can specify different format strings for the network being connected or not
connected.

*Example order*: +wireless wlan0+

*Example format*: +W: (%quality at %essid, %bitrate) %ip+

=== Ethernet

Gets the IP address and (if possible) the link speed of the given ethernet
interface. Getting the link speed requires the cap_net_admin capability. Set
it using +setcap cap_net_admin=ep $(which i3status)+.

*Example order*: +ethernet eth0+

*Example format*: +E: %ip (%speed)+

=== Battery

Gets the status (charging, discharging, running), percentage, remaining
time and power consumption (in Watts) of the given battery and when it's
estimated to be empty. If you want to use the last full capacity instead of the
design capacity (when using the design capacity, it may happen that your
battery is at 23% when fully charged because it’s old. In general, I want to
see it this way, because it tells me how worn off my battery is.), just specify
+last_full_capacity = true+.

If you want the battery percentage to be shown without decimals, add
+integer_battery_capacity = true+.

If your battery is represented in a non-standard path in /sys, be sure to
modify the "path" property accordingly. The first occurence of %d gets replaced
with the battery number, but you can just hard-code a path as well.

It is possible to define a low_threshold that causes the battery text to be
colored red. The low_threshold type can be of threshold_type "time" or
"percentage". So, if you configure low_threshold to 10 and threshold_type to
"time", and your battery lasts another 9 minutes, it will be colored red.

*Example order*: +battery 0+

*Example format*: +%status %remaining (%emptytime %consumption)+

*Example low_threshold*: +30+

*Example threshold_type*: +time+

=== CPU-Temperature

Gets the temperature of the given thermal zone. It is possible to
define a max_threshold that will color the temperature red in case the
specified thermal zone is getting too hot. Defaults to 75 degrees C.

*Example order*: +cpu_temperature 0+

*Example format*: +T: %degrees °C+

*Example max_threshold*: +42+

=== CPU Usage

Gets the percentual CPU usage from +/proc/stat+ (Linux) or +sysctl(3)+ (FreeBSD/OpenBSD).

*Example order*: +cpu_usage+

*Example format*: +%usage+

=== Load

Gets the system load (number of processes waiting for CPU time in the last
1, 5 and 15 minutes). It is possible to define a max_threshold that will
color the load value red in case the load average of the last minute is
getting higher than the configured threshold. Defaults to 5.

*Example order*: +load+

*Example format*: +%1min %5min %15min+

*Example max_threshold*: 5

=== Time

Outputs the current time in the local timezone.
To use a different timezone, you can set the TZ environment variable,
or use the +tztime+ module.
See +strftime(3)+ for details on the format string.

*Example order*: +time+

*Example format*: +%Y-%m-%d %H:%M:%S+

=== TzTime

Outputs the current time in the given timezone.
If no timezone is given, local time will be used.
See +strftime(3)+ for details on the format string.
The system's timezone database is usually installed in +/usr/share/zoneinfo+.
Files below that path make for valid timezone strings, e.g. for
+/usr/share/zoneinfo/Europe/Berlin+ you can set timezone to +Europe/Berlin+
in the +tztime+ module.

*Example order*: +tztime berlin+

*Example format*: +%Y-%m-%d %H:%M:%S %Z+

*Example timezone*: +Europe/Berlin+

=== DDate

Outputs the current discordian date in user-specified format. See +ddate(1)+ for
details on the format string.
*Note*: Neither *%.* nor *%X* are implemented yet.

*Example order*: +ddate+

*Example format*: +%{%a, %b %d%}, %Y%N - %H+

=== Volume

Outputs the volume of the specified mixer on the specified device. Works only
on Linux because it uses ALSA.
A simplified configuration can be used on FreeBSD and OpenBSD due to
the lack of ALSA,  the +device+, +mixer+ and +mixder_idx+ options can be
ignored on these systems. On these systems the OSS API is used instead to
query +/dev/mixer+ directly.

*Example order*: +volume master+

*Example format*: +♪: %volume+

*Example configuration*:
-------------------------------------------------------------
volume master {
	format = "♪: %volume"
	device = "default"
	mixer = "Master"
	mixer_idx = 0
}
-------------------------------------------------------------

== Using i3status with dzen2

After installing dzen2, you can directly use it with i3status. Just ensure that
+output_format+ is set to +dzen2+.

*Example for usage of i3status with dzen2*:
--------------------------------------------------------------
i3status | dzen2 -fg white -ta r -w 1280 \
-fn "-misc-fixed-medium-r-normal--13-120-75-75-C-70-iso8859-1"
--------------------------------------------------------------

== Using i3status with xmobar

To get xmobar to start, you might need to copy the default configuration
file to +~/.xmobarrc+. Also, ensure that the +output_format+ option for i3status
is set to +xmobar+.

*Example for usage of i3status with xmobar*:
---------------------------------------------------------------------
i3status | xmobar -o -t "%StdinReader%" -c "[Run StdinReader]"
---------------------------------------------------------------------

== What about memory usage or CPU frequency?

While talking about two specific things, please understand this section as a
general explanation why your favorite information is not included in i3status.

Let’s talk about memory usage specifically. It is hard to measure memory in a
way which is accurate or meaningful. An in-depth understanding of how paging
and virtual memory work in your operating system is required. Furthermore, even
if we had a well-defined way of displaying memory usage and you would
understand it, I think that it’s not helpful to repeatedly monitor your memory
usage. One reason for that is that I have not run out of memory in the last few
years.  Memory has become so cheap that even in my 4 year old notebook, I have
8 GiB of RAM. Another reason is that your operating system will do the right
thing anyway: Either you have not enough RAM for your workload, but you need to
do it anyway, then your operating system will swap. Or you don’t have enough
RAM and you want to restrict your workload so that it fits, then the operating
system will kill the process using too much RAM and you can act accordingly.

For CPU frequency, the situation is similar. Many people don’t understand how
frequency scaling works precisely. The generally recommended CPU frequency
governor ("ondemand") changes the CPU frequency far more often than i3status
could display it. The display number is therefore often incorrect and doesn’t
tell you anything useful either.

In general, i3status wants to display things which you would look at
occasionally anyways, like the current date/time, whether you are connected to
a WiFi network or not, and if you have enough disk space to fit that 4.3 GiB
download.

However, if you need to look at some kind of information more than once in a
while (like checking repeatedly how full your RAM is), you are probably better
off with a script doing that, which pops up an alert when your RAM usage reaches
a certain threshold. After all, the point of computers is not to burden you
with additional boring tasks like repeatedly checking a number.

== External scripts/programs with i3status

In i3status, we don’t want to implement process management again. Therefore,
there is no module to run arbitrary scripts or commands. Instead, you should
use your shell, for example like this:

*Example for prepending the i3status output*:
--------------------------------------------------------------
#!/bin/sh
# shell script to prepend i3status with more stuff

i3status | while :
do
	read line
	echo "mystuff | $line" || exit 1
done
--------------------------------------------------------------

Put that in some script, say +.bin/my_i3status.sh+ and execute that instead of i3status.

Note that if you want to use the JSON output format (with colors in i3bar), you
need to use a slightly more complex wrapper script. There are examples in the
contrib/ folder, see http://code.i3wm.org/i3status/tree/contrib

== SIGNALS

When receiving +SIGUSR1+, i3status’s nanosleep() will be interrupted and thus
you will force an update. You can use killall -USR1 i3status to force an update
after changing the system volume, for example.

== SEE ALSO

+strftime(3)+, +date(1)+, +glob(3)+, +dzen2(1)+, +xmobar(1)+

== AUTHORS

Michael Stapelberg and contributors

Thorsten Toepper

Baptiste Daroussin

Axel Wagner

Fernando Tarlá Cardoso Lemos
