<?php
// File           jsrs/table_column_request.php / ibWebAdmin
// Purpose        return a selectlist with the columns of a table as options
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <24/08/03 14:33:21 lb>
//
// $Id: table_columns_request.php,v 1.3 2004/03/28 11:29:00 lbrueckner Exp $

require('../inc/configuration.inc.php');
require('../inc/session.inc.php');
require('../inc/functions.inc.php');
require('../inc/panel_elements.inc.php');
require('jsrsServer.php.inc');

if (DEBUG === TRUE) {
    include('../inc/debug_funcs.inc.php');
}

session_start();
localize_session_vars();

// answer to the request with the result of get_fk_values()
jsrsDispatch('table_columns_selectlist');


// build the answer for the jsrs request
function table_columns_selectlist($table, $target, $restriction){

    $columns = array();
    foreach ($GLOBALS['s_fields'] as $field) {
        if ($field['table'] <> $table ) {
            continue;
        }

        if ($restriction == 'fk'
        &&  !isset($field['primary'])  &&  !isset($field['unique'])) {
            continue;
        }

        $columns[] = $field['name'];
    }

    if (count($columns) > 0) {
        $html = get_selectlist($target, $columns, NULL, TRUE);
    }
    else {
        $html = get_textfield($target, 20, 31);
    }

    return jsrsArrayToString(array($target, $html), $delim='~');
}

?>
