<?php
// File           adm_gfix.php / ibWebAdmin
// Purpose        interface for the gfix command
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <02/11/04 22:28:01 lb>
//
// $Id: adm_gfix.php,v 1.6 2004/03/07 17:08:37 lbrueckner Exp $

if ($s_connected == TRUE) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="db_gfix_form">
<?php 

hidden_session_field();

if ($s_login['user'] != 'SYSDBA') {
     sysdba_pw_textfield($adm_strings['SysdbaPW'], $adm_strings['Required'], $s_sysdba_pw);
}
?>
<table>
  <tr>
    <td>
      <table cellpadding="3" border="1">
        <tr>
          <th align="left" colspan="3"><?php echo $adm_strings['Buffers']; ?></th>
        <tr>
          <td>
            <input type="text"  size="6" maxlength="5" name="adm_buffers" value="<?php echo $s_adm_buffers; ?>">
            <input type="submit" name="adm_gfix_buffers" value="<?php echo $button_strings['Set']; ?>">
          </td>
        </tr>
      </table>
    </td>
    <td>
      <table cellpadding="3" border="1">
        <tr>
          <th align="left" colspan="3"><?php echo $adm_strings['DBDialect']; ?></th>
        </tr>
        <tr>
          <td>
            <?php echo get_selectlist('adm_sql_dialect', array(1, 3), $s_adm_dialect, TRUE); ?>
            <input type="submit" name="adm_gfix_dialect" value="<?php echo $button_strings['Set']; ?>">
          </td>
        </tr>
      </table>
    </td>
    <td>
      <table cellpadding="3" border="1">
        <tr>
          <th align="left" colspan="3"><?php echo $adm_strings['AccessMode']; ?></th>
        </tr>
        <tr>
          <td>
            <?php echo get_selectlist('adm_access_mode', array($adm_strings['ReadWrite'], $adm_strings['ReadOnly']), $s_access_mode, TRUE); ?>
            <input type="submit" name="adm_gfix_access_mode" value="<?php echo $button_strings['Set']; ?>">
          </td>
        </tr>
      </table>
    </td>
    <td>
      <table cellpadding="3" border="1">
        <tr>
          <th align="left" colspan="3"><?php echo $adm_strings['WriteMode']; ?></th>
        </tr>
        <tr>
          <td>
            <?php echo get_selectlist('adm_write_mode', array($adm_strings['Sync'], $adm_strings['Async']), $s_write_mode, TRUE); ?>
            <input type="submit" name="adm_gfix_write_mode" value="<?php echo $button_strings['Set']; ?>">
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<br>

<table cellpadding="3" border="1">
<tr>
  <th align="left" colspan="5"><?php echo $adm_strings['Sweeping']; ?></th>
</tr>
<tr>
  <td><?php echo  $adm_strings['SetInterv']; ?>&nbsp;
    <input type="text"  size="9" maxlength="8" name="adm_housekeeping" value="<?php echo $s_housekeeping; ?>">
    <input type="submit" name="adm_gfix_housekeeping" value="<?php echo $button_strings['Set']; ?>">
  </td>
  <td width="20">&nbsp;</td>
  <td>
    <input type="checkbox" name="adm_sweep_ignore" value="ignore"<?php if ($s_adm_sweep_ignore == 'ignore') echo ' checked'; ?>>&nbsp;
    <?php echo  $adm_strings['IgnoreChk']; ?>
  </td>
  <td width="20">&nbsp;</td>
  <td>
    <input type="submit" name="adm_gfix_sweep" value="<?php echo $button_strings['SweepNow']; ?>">
  </td>
</tr>
</table>
<br>

<table cellpadding="3" border="1">
<tr>
  <th align="left" colspan="9"><?php echo $adm_strings['DataRepair']; ?></th>
</tr>
<tr>
  <td>
    <input type="radio" name="adm_validate" value="mend"<?php if ($s_adm_validate == 'mend') echo ' checked'; ?>>&nbsp;
    <?php echo  $adm_strings['Mend']; ?>
  </td>
  <td width="20">&nbsp;</td>
  <td>
    <input type="radio" name="adm_validate" value="validate"<?php if ($s_adm_validate == 'validate') echo ' checked'; ?>>&nbsp;
    <?php echo  $adm_strings['Validate']; ?>
  </td>
  <td>
    <input type="radio" name="adm_validate_option" value="full"<?php if ($s_adm_validate_option == 'full') echo ' checked'; ?>>&nbsp;
    <?php echo  $adm_strings['Full']; ?>
  </td>
  <td>
    <input type="radio" name="adm_validate_option" value="no_update"<?php if ($s_adm_validate_option == 'no_update') echo ' checked'; ?>>&nbsp;
    <?php echo  $adm_strings['NoUpdate']; ?>
  </td>
  <td width="20">&nbsp;</td>
  <td>
    <input type="checkbox" name="adm_validate_ignore" value="ignore"<?php if ($s_adm_validate_ignore == 'ignore') echo ' checked'; ?>>&nbsp;
    <?php echo  $adm_strings['IgnoreChk']; ?>
  </td>
  <td width="20">&nbsp;</td>
  <td>
    <input type="submit" name="adm_gfix_validate" value="<?php echo $button_strings['Execute']; ?>">
  </td>
</tr>
</table>
<br>

<table cellpadding="3" border="1">
  <tr>
    <th align="left" colspan="7"><?php echo $adm_strings['Transact']; ?></th>
  </tr>
  <tr>
    <td>
      <input type="radio" name="adm_transaction" value="commit"<?php if ($s_adm_transaction == 'commit') echo ' checked'; ?>>&nbsp;
      <?php echo  $adm_strings['Commit']; ?>
    </td>
    <td>
      <input type="radio" name="adm_transaction" value="rollback"<?php if ($s_adm_transaction == 'rollback') echo ' checked'; ?>>&nbsp;
      <?php echo  $adm_strings['Rollback']; ?>
    </td>
    <td>
      <input type="radio" name="adm_transaction" value="two_phase"<?php if ($s_adm_transaction == 'two_phase') echo ' checked'; ?>>&nbsp;
      <?php echo  $adm_strings['TwoPhase']; ?>
    </td>
    <td width="20">&nbsp;</td>
    <td>
      <?php echo $adm_strings['AllLimbo']; ?>&nbsp;      
    </td>
    <td width="20">&nbsp;</td>
    <td>
      <input type="submit" name="adm_gfix_trans" value="<?php echo $button_strings['Execute']; ?>">
    </td>
  </tr>
</table>
<br>

<table cellpadding="3" border="1">
  <tr>
    <th align="left" colspan="7"><?php echo $adm_strings['Shutdown']; ?></th>
  </tr>
  <tr>
    <td>
      <input type="checkbox" name="adm_shut_noconns" value="noconns"<?php if ($s_adm_shut_noconns == 'noconns') echo ' checked'; ?>>&nbsp;
      <?php echo  $adm_strings['NoConns']; ?>
    </td>
    <td>
      <input type="checkbox" name="adm_shut_notrans" value="notrans"<?php if ($s_adm_shut_notrans == 'notrans') echo ' checked'; ?>>&nbsp;
      <?php echo  $adm_strings['NoTrans']; ?>
    </td>
    <td>
      <input type="checkbox" name="adm_shut_force" value="force"<?php if ($s_adm_shut_force == 'force') echo ' checked'; ?>>&nbsp;
      <?php echo  $adm_strings['Force']; ?>
    </td>
    <td width="20">&nbsp;</td>
    <td>
      <?php printf($adm_strings['ForSeconds'].'&nbsp;', '<input type="text"  size="5" maxlength="4" name="adm_shut_secs" value="'.$s_shut_secs.'">'); ?>
    </td>
    <td width="20">&nbsp;</td>
    <td>
      <input type="submit" name="adm_gfix_shutdown" value="<?php echo $button_strings['Execute']; ?>">
    </td>
  </tr>
  <tr>
    <td colspan="5" align="right">
      <?php echo  $adm_strings['Rescind']; ?>&nbsp;    
    </td>
    <td width="20">&nbsp;</td>
    <td>
      <input type="submit" name="adm_gfix_rescind" value="<?php echo $button_strings['Execute']; ?>">
    </td>
  </tr>
  <tr>
    <td colspan="7">
      <input type="checkbox" name="adm_shut_reconnect" value="reconnect"<?php if ($s_adm_shut_reconnect == 'reconnect') echo ' checked'; ?>>
      <?php echo $adm_strings['Reconnect']; ?>&nbsp;
    </td>
  </tr>
<?php

    if (PERSISTANT_CONNECTIONS === TRUE) {
        echo "  <tr>\n"
            .'    <td colspan="7">'.$adm_strings['PConnect']."</td>\n"
            ."  </tr>\n";
    }
?>
</table>

</form>
<?php

}

?>
