/*
 * Copyright 1996-2002 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */
/*
 * Licensed Materials - Property of IBM
 * RMI-IIOP v1.0
 * Copyright IBM Corp. 1998 1999  All Rights Reserved
 *
 */

package com.sun.corba.se.impl.corba;

import java.util.Vector;

import org.omg.CORBA.Bounds;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ORB;


public class ExceptionListImpl extends ExceptionList {

    private final int	 INITIAL_CAPACITY	= 2;
    private final int	 CAPACITY_INCREMENT	= 2;

    private Vector _exceptions;

    public ExceptionListImpl() {
	_exceptions = new Vector(INITIAL_CAPACITY, CAPACITY_INCREMENT);
    }

    public int count() 
    {
	return _exceptions.size();
    }

    public void add(TypeCode tc)
    {
	_exceptions.addElement(tc);
    }

    public TypeCode item(int index)
	throws Bounds
    {
	try {
	    return (TypeCode) _exceptions.elementAt(index);
	} catch (ArrayIndexOutOfBoundsException e) {
	    throw new Bounds();
	}
    }

    public void remove(int index)
	throws Bounds
    {
	try {
	    _exceptions.removeElementAt(index);
	} catch (ArrayIndexOutOfBoundsException e) {
	    throw new Bounds();
	}
    }

}

