/*
 * Copyright 1996-2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package com.sun.corba.se.spi.protocol;

import org.omg.CORBA.BAD_PARAM ;

import com.sun.corba.se.impl.orbutil.ORBUtility ;

import com.sun.corba.se.spi.ior.IOR ;

import com.sun.corba.se.spi.orb.ORB ;

/**
 * Thrown to signal an OBJECT_FORWARD or LOCATION_FORWARD
 */
public class ForwardException extends RuntimeException {
    private ORB orb ;
    private org.omg.CORBA.Object obj;
    private IOR ior ;

    public ForwardException( ORB orb, IOR ior ) {
        super();

	this.orb = orb ;
	this.obj = null ;
	this.ior = ior ;
    }

    public ForwardException( ORB orb, org.omg.CORBA.Object obj) {
        super();

	// This check is done early so that no attempt
	// may be made to do a location forward to a local
	// object.  Doing this lazily would allow 
	// forwarding to locals in some restricted cases.
	if (obj instanceof org.omg.CORBA.LocalObject)
	    throw new BAD_PARAM() ;

	this.orb = orb ;
	this.obj = obj ;
	this.ior = null ;
    }

    public synchronized org.omg.CORBA.Object getObject()
    {
	if (obj == null) {
	    obj = ORBUtility.makeObjectReference( ior ) ;
	}

	return obj ;
    }

    public synchronized IOR getIOR() 
    {
	if (ior == null) {
	    ior = ORBUtility.getIOR( obj ) ;
	}

	return ior ;
    }
}
