/*
 * Copyright 2005 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */


/* The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/, and in the file LICENSE.html in the
 * doc directory.
 * 
 * The Original Code is HAT. The Initial Developer of the
 * Original Code is Bill Foote, with contributions from others
 * at JavaSoft/Sun. Portions created by Bill Foote and others
 * at Javasoft/Sun are Copyright (C) 1997-2004. All Rights Reserved.
 * 
 * In addition to the formal license, I ask that you don't
 * change the history or donations files without permission.
 */

package com.sun.tools.hat.internal.server;

/**
 *
 * @version     1.14, 03/06/98 [jhat @(#)QueryListener.java	1.8 07/05/05]
 * @author      Bill Foote
 */


import java.net.Socket;
import java.net.ServerSocket;
import java.net.InetAddress;

import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.Writer;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.BufferedOutputStream;

import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.oql.OQLEngine;

public class QueryListener implements Runnable {


    private Snapshot snapshot;
    private OQLEngine engine;
    private int port;

    public QueryListener(int port) {
	this.port = port;
	this.snapshot = null;	// Client will setModel when it's ready
        this.engine = null; // created when snapshot is set
    }

    public void setModel(Snapshot ss) {
	this.snapshot = ss;
        if (OQLEngine.isOQLSupported()) {
            this.engine = new OQLEngine(ss);
        }
    }

    public void run() {
	try {
	    waitForRequests();
	} catch (IOException ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
    }

    private void waitForRequests() throws IOException {
	ServerSocket ss = new ServerSocket(port);
	Thread last = null;
	for (;;) {
	    Socket s = ss.accept();
	    Thread t = new Thread(new HttpReader(s, snapshot, engine));
	    if (snapshot == null) {
		t.setPriority(Thread.NORM_PRIORITY+1);
	    } else {
		t.setPriority(Thread.NORM_PRIORITY-1);
		if (last != null) {
		    try {
			last.setPriority(Thread.NORM_PRIORITY-2);
		    } catch (Throwable ignored) {
		    }
		    // If the thread is no longer alive, we'll get a 
		    // NullPointerException
		}
	    }
	    t.start();
	    last = t;
	}
    }

}
