/*
 * Copyright 1999-2006 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package javax.accessibility;

/**
 * The AccessibleIcon interface should be supported by any object 
 * that has an associated icon (e.g., buttons). This interface 
 * provides the standard mechanism for an assistive technology
 * to get descriptive information about icons.
 * Applications can determine
 * if an object supports the AccessibleIcon interface by first
 * obtaining its AccessibleContext (see
 * {@link Accessible}) and then calling the
 * {@link AccessibleContext#getAccessibleIcon} method.
 * If the return value is not null, the object supports this interface.
 *
 * @see Accessible
 * @see AccessibleContext
 *
 * @version     1.3 10/12/99
 * @author	Lynn Monsanto
 * @since 1.3
 */
public interface AccessibleIcon {

    /**
     * Gets the description of the icon.  This is meant to be a brief
     * textual description of the object.  For example, it might be
     * presented to a blind user to give an indication of the purpose
     * of the icon.
     *
     * @return the description of the icon
     */
    public String getAccessibleIconDescription();
    
    /**
     * Sets the description of the icon.  This is meant to be a brief
     * textual description of the object.  For example, it might be
     * presented to a blind user to give an indication of the purpose
     * of the icon.
     *
     * @param description the description of the icon
     */
    public void setAccessibleIconDescription(String description);
	
    /**
     * Gets the width of the icon
     *
     * @return the width of the icon.
     */
    public int getAccessibleIconWidth();

    /**
     * Gets the height of the icon
     *
     * @return the height of the icon.
     */
    public int getAccessibleIconHeight();

}
