/*
 * Copyright 2000-2002 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package sun.nio.ch;

import java.io.*;

/**
 * Allows different platforms to call different native methods
 * for read and write operations.
 */

abstract class NativeDispatcher
{

    abstract int read(FileDescriptor fd, long address, int len)
	throws IOException;

    int pread(FileDescriptor fd, long address, int len,
                             long position, Object lock) throws IOException
    {
        throw new IOException("Operation Unsupported");
    }

    abstract long readv(FileDescriptor fd, long address, int len)
	throws IOException;

    abstract int write(FileDescriptor fd, long address, int len)
	throws IOException;

    int pwrite(FileDescriptor fd, long address, int len,
                             long position, Object lock) throws IOException
    {
        throw new IOException("Operation Unsupported");
    }

    abstract long writev(FileDescriptor fd, long address, int len)
	throws IOException;

    abstract void close(FileDescriptor fd) throws IOException;

    // Prepare the given fd for closing by duping it to a known internal fd
    // that's already closed.  This is necessary on some operating systems
    // (Solaris and Linux) to prevent fd recycling.
    //
    void preClose(FileDescriptor fd) throws IOException {
	// Do nothing by default; this is only needed on Unix
    }

}
