/*
 * Copyright 2005 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package sun.security.krb5.internal.crypto;

import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.*;
import java.security.GeneralSecurityException;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.Checksum;

/*
 * This class encapsulates the encryption type for RC4-HMAC
 *
 * @author Seema Malkani
 * @version 1.7, 05/05/07
 */

public final class ArcFourHmacEType extends EType {

    public int eType() {
	return EncryptedData.ETYPE_ARCFOUR_HMAC;
    }

    public int minimumPadSize() {
	return 1;
    }

    public int confounderSize() {
	return 8;
    }

    public int checksumType() {
	return Checksum.CKSUMTYPE_HMAC_MD5_ARCFOUR;
    }

    public int checksumSize() {
	return ArcFourHmac.getChecksumLength();
    }

    public int blockSize() {
	return 1;
    }

    public int keyType() {
	return Krb5.KEYTYPE_ARCFOUR_HMAC;
    }

    public int keySize() {
	return 16; // bytes
    }

    public byte[] encrypt(byte[] data, byte[] key, int usage) 
	throws KrbCryptoException {
	byte[] ivec = new byte[blockSize()];
	return encrypt(data, key, ivec, usage);
    }

    public byte[] encrypt(byte[] data, byte[] key, byte[] ivec, int usage) 
	throws KrbCryptoException {
	try {
	    return ArcFourHmac.encrypt(key, usage, ivec, data, 0, data.length);
	} catch (GeneralSecurityException e) {
	    KrbCryptoException ke = new KrbCryptoException(e.getMessage());
	    ke.initCause(e);
	    throw ke;
	}
    }

    public byte[] decrypt(byte[] cipher, byte[] key, int usage)
	throws KrbApErrException, KrbCryptoException {
	byte[] ivec = new byte[blockSize()];
	return decrypt(cipher, key, ivec, usage);
    }	

    public byte[] decrypt(byte[] cipher, byte[] key, byte[] ivec, int usage)
	throws KrbApErrException, KrbCryptoException {
	try {
	    return ArcFourHmac.decrypt(key, usage, ivec, cipher, 0, cipher.length);
	} catch (GeneralSecurityException e) {
	    KrbCryptoException ke = new KrbCryptoException(e.getMessage());
	    ke.initCause(e);
	    throw ke;
	}
    }

    // Override default, because our decrypted data does not return confounder
    // Should eventually get rid of EType.decryptedData and 
    // EncryptedData.decryptedData altogether
    public byte[] decryptedData(byte[] data) {
	return data;
    }
}
