/*
 * Portions Copyright 2005 Sun Microsystems, Inc.  All Rights Reserved.
 */

/* Copyright  (c) 2002 Graz University of Technology. All rights reserved.
 *
 * Redistribution and use in  source and binary forms, with or without
 * modification, are permitted  provided that the following conditions are met:
 *
 * 1. Redistributions of  source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in  binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. The end-user documentation included with the redistribution, if any, must
 *    include the following acknowledgment:
 *
 *    "This product includes software developed by IAIK of Graz University of
 *     Technology."
 *
 *    Alternately, this acknowledgment may appear in the software itself, if
 *    and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Graz University of Technology" and "IAIK of Graz University of
 *    Technology" must not be used to endorse or promote products derived from
 *    this software without prior written permission.
 *
 * 5. Products derived from this software may not be called
 *    "IAIK PKCS Wrapper", nor may "IAIK" appear in their name, without prior
 *    written permission of Graz University of Technology.
 *
 *  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 *  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE LICENSOR BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 *  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY  OF SUCH DAMAGE.
 */

package sun.security.pkcs11.wrapper;



/**
 * class CK_SSL3_RANDOM_DATA provides information about the random data of a
 * client and a server in an SSL context. This class is used by both the
 * CKM_SSL3_MASTER_KEY_DERIVE and the CKM_SSL3_KEY_AND_MAC_DERIVE mechanisms.
 * <p>
 * <B>PKCS#11 structure:</B>
 * <PRE>
 * typedef struct CK_SSL3_RANDOM_DATA {
 *   CK_BYTE_PTR pClientRandom;
 *   CK_ULONG ulClientRandomLen;
 *   CK_BYTE_PTR pServerRandom;
 *   CK_ULONG ulServerRandomLen;
 * } CK_SSL3_RANDOM_DATA;
 * </PRE>
 *
 * @author Karl Scheibelhofer <Karl.Scheibelhofer@iaik.at>
 * @author Martin Schlaeffer <schlaeff@sbox.tugraz.at>
 */
public class CK_SSL3_RANDOM_DATA {

    /**
     * <B>PKCS#11:</B>
     * <PRE>
     *   CK_BYTE_PTR pClientRandom;
     *   CK_ULONG ulClientRandomLen;
     * </PRE>
     */
    public byte[] pClientRandom;
    
    /**
     * <B>PKCS#11:</B>
     * <PRE>
     *   CK_BYTE_PTR pServerRandom;
     *   CK_ULONG ulServerRandomLen;
     * </PRE>
     */
    public byte[] pServerRandom;
    
    public CK_SSL3_RANDOM_DATA(byte[] clientRandom, byte[] serverRandom) {
	pClientRandom = clientRandom;
	pServerRandom = serverRandom;
    }
    
    /**
     * Returns the string representation of CK_SSL3_RANDOM_DATA.
     *
     * @return the string representation of CK_SSL3_RANDOM_DATA
     */
    public String toString() {
	StringBuilder buffer = new StringBuilder();
	
	buffer.append(Constants.INDENT);
	buffer.append("pClientRandom: ");
	buffer.append(Functions.toHexString(pClientRandom));
	buffer.append(Constants.NEWLINE);
	
	buffer.append(Constants.INDENT);
	buffer.append("ulClientRandomLen: ");
	buffer.append(pClientRandom.length);
	buffer.append(Constants.NEWLINE);
	
	buffer.append(Constants.INDENT);
	buffer.append("pServerRandom: ");
	buffer.append(Functions.toHexString(pServerRandom));
	buffer.append(Constants.NEWLINE);
	
	buffer.append(Constants.INDENT);
	buffer.append("ulServerRandomLen: ");
	buffer.append(pServerRandom.length);
	//buffer.append(Constants.NEWLINE);
	
	return buffer.toString();
    }
    
}
