/*
 * Portions Copyright 1997-2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources;

public final class TimeZoneNames_it extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
	String ACT[] = new String[] {"Ora di Acre", "ACT",
				     "Ora estiva di Acre", "ACST"};
	String ADELAIDE[] = new String[] {"Ora centrale standard (Australia del Sud)", "CST",
					  "Ora estiva standard (Australia del Sud)", "CST"};
	String AGT[] = new String[] {"Ora dell'Argentina", "ART",
				     "Ora estiva dell'Argentina", "ARST"};
	String AKST[] = new String[] {"Ora solare dell'Alaska", "AKST",
				      "Ora legale dell'Alaska", "AKDT"};
	String AMT[] = new String[] {"Ora solare dell'Amazzonia", "AMT",
				     "Ora estiva dell'Amazzonia", "AMST"};
	String ARAST[] = new String[] {"Ora solare dell'Arabia", "AST",
				       "Ora legale dell'Arabia", "ADT"};
	String ARMT[] = new String[] {"Ora dell'Armenia", "AMT",
				      "Ora estiva dell'Armenia", "AMST"};
	String AST[] = new String[] {"Ora solare dell'Atlantico occidentale", "AST",
				     "Ora legale dell'Atlantico occidentale", "ADT"};
	String BDT[] = new String[] {"Ora del Bangladesh", "BDT",
				     "Ora estiva del Bangladesh", "BDST"};
	String BRISBANE[] = new String[] {"Ora orientale standard (Queensland)", "EST",
					  "Ora estiva orientale (Queensland)", "EST"};
	String BROKEN_HILL[] = new String[] {"Ora centrale standard (Australia del Sud/Nuovo Galles del Sud)", "CST",
					     "Ora estiva centrale (Australia del Sud/Nuovo Galles del Sud)", "CST"};
	String BRT[] = new String[] {"Ora del Brasile", "BRT",
				     "Ora estiva del Brasile", "BRST"};
	String BTT[] = new String[] {"Ora del Bhutan", "BTT",
				     "Ora estiva del Bhutan", "BTST"};
	String CAT[] = new String[] {"Ora dell'Africa centrale", "CAT",
				     "Ora estiva dell'Africa centrale", "CAST"};
	String CET[] = new String[] {"Ora dell'Europa centrale", "CET",
				     "Ora estiva dell'Europa centrale", "CEST"};
	String CHAST[] = new String[] {"Ora di Chatham standard", "CHAST",
				       "Ora legale di Chatham", "CHADT"};
	String CIT[] = new String[] {"Ora dell'Indonesia centrale", "CIT",
				     "Ora estiva dell'Indonesia centrale", "CIST"};
	String CLT[] = new String[] {"Ora del Cile", "CLT",
				     "Ora estiva del Cile", "CLST"};
	String CST[] = new String[] {"Ora solare USA centrale", "CST",
				     "Ora legale USA centrale", "CDT"};
	String CTT[] = new String[] {"Ora solare della Cina", "CST",
				     "Ora legale della Cina", "CDT"};
	String CUBA[] = new String[] {"Cuba Standard Time", "CST",
				      "Cuba Daylight Time", "CDT"};
	String DARWIN[] = new String[] {"Ora centrale standard (Territori del Nord)", "CST",
					"Ora estiva centrale (Territori del Nord)", "CST"};
	String DUBLIN[] = new String[] {"Ora media di Greenwich", "GMT",
					"Ora estiva irlandese", "IST"};
	String EAT[] = new String[] {"Ora dell'Africa orientale", "EAT",
				     "Ora estiva dell'Africa orientale", "EAST"};
	String EASTER[] = new String[] {"Ora dell'Isola di Pasqua", "EAST",
					"Ora estiva dell'Isola di Pasqua", "EASST"};
	String EET[] = new String[] {"Ora dell'Europa orientale", "EET",
				     "Ora estiva dell'Europa orientale", "EEST"};
	String EGT[] = new String[] {"Ora della Groenlandia orientale", "EGT",
				     "Ora estiva della Groenlandia orientale", "EGST"};
	String EST[] = new String[] {"Ora solare USA orientale", "EST",
				     "Ora legale USA orientale", "EDT"};
	String EST_NSW[] = new String[] {"Ora solare dell'Australia orientale (Nuovo Galles del Sud)", "EST",
					 "Ora estiva dell'Australia orientale (Nuovo Galles del Sud)", "EST"};
	String GHMT[] = new String[] {"Ora media del Ghana", "GMT",
				      "Ora legale del Ghana", "GHST"};
	String GAMBIER[] =  new String[] {"Ora di Gambier", "GAMT",
					  "Ora estiva di Gambier", "GAMST"};
	String GMT[] = new String[] {"Ora media di Greenwich", "GMT",
				   "Ora media di Greenwich", "GMT"};
	String GMTBST[] = new String[] {"Ora media di Greenwich", "GMT",
					"Ora estiva britannica", "BST"};
	String GST[] = new String[] {"Ora solare del golfo", "GST",
				     "Ora legale del golfo", "GDT"};
	String HAST[] = new String[] {"Ora solare delle Isole Hawaii-Aleutine", "HAST",
				      "Ora solare delle Isole Hawaii-Aleutine", "HADT"};
	String HKT[] =  new String[] {"Ora di Hong Kong", "HKT",
				      "Ora estiva di Hong Kong", "HKST"};
	String HST[] = new String[] {"Ora solare delle Isole Hawaii", "HST",
				     "Ora legale delle Isole Hawaii", "HDT"};
	String ICT[] = new String[] {"Ora dell'Indocina", "ICT",
				     "Ora estiva dell'Indocina", "ICST"};
	String IRT[] = new String[] {"Ora solare Iran", "IRST",
				     "Ora legale Iran", "IRDT"};
	String ISRAEL[] = new String[] {"Ora standard di Israele", "IST",
					"Ora legale di Israele", "IDT"};
	String IST[] = new String[] {"Ora solare dell'India", "IST",
				     "Ora legale dell'India", "IDT"};
	String JST[] = new String[] {"Ora solare del Giappone", "JST",
				     "Ora legale del Giappone", "JDT"};
	String KST[] = new String[] {"Ora solare della Corea", "KST",
				     "Ora legale della Corea", "KDT"};
	String LORD_HOWE[] = new String[] {"Ora standard di Lord Howe", "LHST",
					   "Ora estiva di Lord Howe", "LHST"};
	String MHT[] = new String[] {"Ora delle Isole Marshall", "MHT",
				     "Ora estiva delle Isole Marshall", "MHST"};
	String MSK[] = new String[] {"Ora standard di Mosca", "MSK",
				     "Ora legale di Mosca", "MSD"};
	String MST[] = new String[] {"Ora solare USA occidentale", "MST",
				     "Ora legale USA occidentale", "MDT"};
	String MYT[] = new String[] {"Ora della Malaysia", "MYT",
				     "Ora estiva della Malaysia", "MYST"};
	String NORONHA[] = new String[] {"Ora di Fernando de Noronha", "FNT",
					 "Ora estiva di Fernando de Noronha", "FNST"};
	String NST[] = new String[] {"Ora solare di Terranova", "NST",
				     "Ora legale di Terranova", "NDT"};
	String NZST[] = new String[] {"Ora solare della Nuova Zelanda", "NZST",
				      "Ora legale della Nuova Zelanda", "NZDT"};
        String PITCAIRN[] = new String[] {"Ora standard di Pitcairn", "PST",
				          "Ora legale di Pitcairn", "PDT"};
	String PKT[] = new String[] {"Ora del Pakistan", "PKT",
				     "Ora estiva del Pakistan", "PKST"};
	String PST[] = new String[] {"Ora solare della costa occidentale USA", "PST",
				     "Ora legale della costa occidentale USA", "PDT"};
	String SAST[] = new String[] {"Ora solare del Sudafrica", "SAST",
				      "Ora estiva del Sudafrica", "SAST"};
	String SBT[] = new String[] {"Ora delle Isole Salomone", "SBT",
				     "Ora estiva delle Isole Salomone", "SBST"};
	String SGT[] = new String[] {"Ora di Singapore", "SGT",
				     "Ora estiva di Singapore", "SGST"};
	String SLST[] = new String[] {"Ora media di Greenwich", "GMT",
				      "Ora legale della Sierra Leone", "SLST"};
	String TASMANIA[] = new String[] {"Ora orientale standard (Tasmania)", "EST",
					  "Ora estiva orientale (Tasmania)", "EST"};
	String TMT[] = new String[] {"Ora del Turkmenistan", "TMT",
				     "Ora estiva del Turkmenistan", "TMST"};
	String TRUT[] = new String[] {"Ora di Truk", "TRUT",
				      "Ora estiva di Truk", "TRUST"};
	String ULAT[]= new String[] {"Ora di Ulaanbaatar", "ULAT",
				     "Ora estiva di Ulaanbaatar", "ULAST"};
	String WAT[] = new String[] {"Ora dell'Africa occidentale", "WAT",
				     "Ora estiva dell'Africa occidentale", "WAST"};
	String WET[] = new String[] {"Ora dell'Europa occidentale", "WET",
				     "Ora estiva dell'Europa occidentale", "WEST"};
	String WIT[] = new String[] {"Ora dell'Indonesia occidentale", "WIT",
				     "Ora estiva dell'Indonesia occidentale", "WIST"};
	String WST_AUS[] = new String[] {"Ora solare dell'Australia occidentale", "WST",
					 "Ora estiva dell'Australia occidentale", "WST"};
	String SAMOA[] = new String[] {"Ora standard di Samoa", "SST",
				       "Ora legale di Samoa", "SDT"};
	String WST_SAMOA[] = new String[] {"Ora di Samoa", "WST",
					   "Ora estiva di Samoa", "WSST"};
	String ChST[] = new String[] {"Ora standard di Chamorro", "ChST",
	                      "Ora legale di Chamorro", "ChDT"};
	String VICTORIA[] = new String[] {"Ora orientale standard (Victoria)", "EST",
					  "Ora estiva orientale (Victoria)", "EST"};
	String UTC[] = new String[] {"Tempo universale coordinato", "UTC",
			 	     "Tempo universale coordinato", "UTC"};
	String UZT[] = new String[] {"Ora dell'Uzbekistan", "UZT",
				     "Ora estiva dell'Uzbekistan", "UZST"};

	return new Object[][] {
	    {"America/Los_Angeles", PST},
	    {"PST", PST},
	    {"America/Denver", MST},
	    {"MST", MST},
	    {"America/Phoenix", MST},
	    {"PNT", MST},
	    {"America/Chicago", CST},
	    {"CST", CST},
	    {"America/New_York", EST},
	    {"EST", EST},
	    {"America/Indianapolis", EST},
	    {"IET", EST},
	    {"Pacific/Honolulu", HST},
	    {"HST", HST},
	    {"America/Anchorage", AKST},
	    {"AST", AKST},
	    {"America/Halifax", AST},
	    {"America/St_Johns", NST},
	    {"CNT", NST},
	    {"Europe/Paris", CET},
	    {"ECT", CET},
	    {"GMT", GMT},
	    {"Africa/Casablanca", WET},
	    {"Asia/Jerusalem", ISRAEL},
	    {"Asia/Tokyo", JST},
	    {"JST", JST},
	    {"Europe/Bucharest", EET},
	    {"Asia/Shanghai", CTT},
	    {"CTT", CTT},
	    /* Don't change the order of the above zones
	     * to keep compatibility with the previous version.
	     */

	    {"ACT", DARWIN},
	    {"AET", EST_NSW},
	    {"AGT", AGT},
	    {"ART", EET},
	    {"Africa/Abidjan", GMT},
	    {"Africa/Accra", GHMT},
	    {"Africa/Addis_Ababa", EAT},
	    {"Africa/Algiers", CET},
	    {"Africa/Asmara", EAT},
	    {"Africa/Asmera", EAT},
	    {"Africa/Bamako", GMT},
	    {"Africa/Bangui", WAT},
	    {"Africa/Banjul", GMT},
	    {"Africa/Bissau", GMT},
	    {"Africa/Blantyre", CAT},
	    {"Africa/Brazzaville", WAT},
	    {"Africa/Bujumbura", CAT},
	    {"Africa/Cairo", EET},
	    {"Africa/Ceuta", CET},
	    {"Africa/Conakry", GMT},
	    {"Africa/Dakar", GMT},
	    {"Africa/Dar_es_Salaam", EAT},
	    {"Africa/Djibouti", EAT},
	    {"Africa/Douala", WAT},
	    {"Africa/El_Aaiun", WET},
	    {"Africa/Freetown", SLST},
	    {"Africa/Gaborone", CAT},
	    {"Africa/Harare", CAT},
	    {"Africa/Johannesburg", SAST},
	    {"Africa/Kampala", EAT},
	    {"Africa/Khartoum", EAT},
	    {"Africa/Kigali", CAT},
	    {"Africa/Kinshasa", WAT},
	    {"Africa/Lagos", WAT},
	    {"Africa/Libreville", WAT},
	    {"Africa/Lome", GMT},
	    {"Africa/Luanda", WAT},
	    {"Africa/Lubumbashi", CAT},
	    {"Africa/Lusaka", CAT},
	    {"Africa/Malabo", WAT},
	    {"Africa/Maputo", CAT},
	    {"Africa/Maseru", SAST},
	    {"Africa/Mbabane", SAST},
	    {"Africa/Mogadishu", EAT},
	    {"Africa/Monrovia", GMT},
	    {"Africa/Nairobi", EAT},
	    {"Africa/Ndjamena", WAT},
	    {"Africa/Niamey", WAT},
	    {"Africa/Nouakchott", GMT},
	    {"Africa/Ouagadougou", GMT},
	    {"Africa/Porto-Novo", WAT},
	    {"Africa/Sao_Tome", GMT},
	    {"Africa/Timbuktu", GMT},
	    {"Africa/Tripoli", EET},
	    {"Africa/Tunis", CET},
	    {"Africa/Windhoek", WAT},
	    {"America/Adak", HAST},
	    {"America/Anguilla", AST},
	    {"America/Antigua", AST},
	    {"America/Araguaina", BRT},
	    {"America/Argentina/Buenos_Aires", AGT},
	    {"America/Argentina/Catamarca", AGT},
	    {"America/Argentina/ComodRivadavia", AGT},
	    {"America/Argentina/Cordoba", AGT},
	    {"America/Argentina/Jujuy", AGT},
	    {"America/Argentina/La_Rioja", AGT},
	    {"America/Argentina/Mendoza", AGT},
	    {"America/Argentina/Rio_Gallegos", AGT},
	    {"America/Argentina/San_Juan", AGT},
	    {"America/Argentina/Tucuman", AGT},
	    {"America/Argentina/Ushuaia", AGT},
	    {"America/Aruba", AST},
	    {"America/Asuncion", new String[] {"Ora del Paraguay", "PYT",
					       "Ora estiva del Paraguay", "PYST"}},
	    {"America/Atikokan", EST},
            {"America/Atka", HAST},
	    {"America/Bahia", BRT},
	    {"America/Barbados", AST},
	    {"America/Belem", BRT},
	    {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
	    {"America/Boa_Vista", AMT},
	    {"America/Bogota", new String[] {"Ora della Colombia", "COT",
					     "Ora estiva della Colombia", "COST"}},
	    {"America/Boise", MST},
	    {"America/Buenos_Aires", AGT},
	    {"America/Cambridge_Bay", MST},
	    {"America/Campo_Grande", AMT},
	    {"America/Cancun", CST},
	    {"America/Caracas", new String[] {"Ora del Venezuela", "VET",
					      "Ora estiva del Venezuela", "VEST"}},
	    {"America/Catamarca", AGT},
	    {"America/Cayenne", new String[] {"Ora della Guyana Francese", "GFT",
					      "Ora estiva della Guyana Francese", "GFST"}},
	    {"America/Cayman", EST},
	    {"America/Chihuahua", MST},
	    {"America/Coral_Harbour", EST},
	    {"America/Cordoba", AGT},
	    {"America/Costa_Rica", CST},
	    {"America/Cuiaba", AMT},
	    {"America/Curacao", AST},
	    {"America/Danmarkshavn", GMT},
	    {"America/Dawson", PST},
	    {"America/Dawson_Creek", MST},
	    {"America/Detroit", EST},
	    {"America/Dominica", AST},
	    {"America/Edmonton", MST},
	    {"America/Eirunepe", ACT},
	    {"America/El_Salvador", CST},
	    {"America/Ensenada", PST},
	    {"America/Fort_Wayne", EST},
	    {"America/Fortaleza", BRT},
	    {"America/Glace_Bay", AST},
	    {"America/Godthab", new String[] {"Ora della Groenlandia occidentale", "WGT",
					      "Ora estiva della Groenlandia occidentale", "WGST"}},
	    {"America/Goose_Bay", AST},
	    {"America/Grand_Turk", EST},
	    {"America/Grenada", AST},
	    {"America/Guadeloupe", AST},
	    {"America/Guatemala", CST},
	    {"America/Guayaquil", new String[] {"Ora dell'Ecuador", "ECT",
						"Ora estiva dell'Ecuador", "ECST"}},
	    {"America/Guyana", new String[] {"Ora della Guyana", "GYT",
					     "Ora estiva della Guyana", "GYST"}},
	    {"America/Havana", CUBA},
	    {"America/Hermosillo", MST},
	    {"America/Indiana/Indianapolis", EST},
	    {"America/Indiana/Knox", CST},
	    {"America/Indiana/Marengo", EST},
	    {"America/Indiana/Petersburg", CST},
	    {"America/Indiana/Vevay", EST},
	    {"America/Indiana/Vincennes", CST},
	    {"America/Indiana/Winamac", EST},
	    {"America/Inuvik", MST},
	    {"America/Iqaluit", EST},
	    {"America/Jamaica", EST},
	    {"America/Jujuy", AGT},
	    {"America/Juneau", AKST},
	    {"America/Kentucky/Louisville", EST},
	    {"America/Kentucky/Monticello", EST},
	    {"America/Knox_IN", CST},
	    {"America/La_Paz", new String[] {"Ora della Bolivia", "BOT",
					     "Ora estiva della Bolivia", "BOST"}},
	    {"America/Lima", new String[] {"Ora del Per\u00f9", "PET",
					   "Ora estiva del Per\u00f9", "PEST"}},
	    {"America/Louisville", EST},
	    {"America/Maceio", BRT},
	    {"America/Managua", CST},
	    {"America/Manaus", AMT},
	    {"America/Martinique", AST},
	    {"America/Mazatlan", MST},
	    {"America/Mendoza", AGT},
	    {"America/Menominee", CST},
	    {"America/Merida", CST},
	    {"America/Mexico_City", CST},
	    {"America/Miquelon", new String[] {"Ora solare di Saint-Pierre e Miquelon", "PMST",
					       "Ora legale di Saint-Pierre e Miquelon", "PMDT"}},
	    {"America/Moncton", AST},
	    {"America/Montevideo", new String[] {"Ora dell'Uruguay", "UYT",
						 "Ora estiva dell'Uruguay", "UYST"}},
	    {"America/Monterrey", CST},
	    {"America/Montreal", EST},
	    {"America/Montserrat", AST},
	    {"America/Nassau", EST},
	    {"America/Nipigon", EST},
	    {"America/Nome", AKST},
	    {"America/Noronha", NORONHA},
	    {"America/North_Dakota/Center", CST},
	    {"America/North_Dakota/New_Salem", CST},
	    {"America/Panama", EST},
	    {"America/Pangnirtung", EST},
	    {"America/Paramaribo", new String[] {"Ora di Suriname", "SRT",
						 "Ora estiva di Suriname", "SRST"}},
	    {"America/Port-au-Prince", EST},
	    {"America/Port_of_Spain", AST},
	    {"America/Porto_Acre", ACT},
	    {"America/Porto_Velho", AMT},
	    {"America/Puerto_Rico", AST},
	    {"America/Rainy_River", CST},
	    {"America/Rankin_Inlet", CST},
	    {"America/Recife", BRT},
	    {"America/Regina", CST},
	    {"America/Resolute", EST},
	    {"America/Rio_Branco", ACT},
	    {"America/Rosario", AGT},
	    {"America/Santiago", CLT},
	    {"America/Santo_Domingo", AST},
	    {"America/Sao_Paulo", BRT},
	    {"America/Scoresbysund", EGT},
	    {"America/Shiprock", MST},
	    {"America/St_Kitts", AST},
	    {"America/St_Lucia", AST},
	    {"America/St_Thomas", AST},
	    {"America/St_Vincent", AST},
	    {"America/Swift_Current", CST},
	    {"America/Tegucigalpa", CST},
	    {"America/Thule", AST},
	    {"America/Thunder_Bay", EST},
	    {"America/Tijuana", PST},
	    {"America/Toronto", EST},
	    {"America/Tortola", AST},
	    {"America/Vancouver", PST},
	    {"America/Virgin", AST},
	    {"America/Whitehorse", PST},
	    {"America/Winnipeg", CST},
	    {"America/Yakutat", AKST},
	    {"America/Yellowknife", MST},
	    {"Antarctica/Casey", WST_AUS},
	    {"Antarctica/Davis", new String[] {"Ora di Davis", "DAVT",
					       "Ora estiva di Davis", "DAVST"}},
	    {"Antarctica/DumontDUrville", new String[] {"Ora di Dumont-d'Urville", "DDUT",
							"Ora estiva di Dumont-d'Urville", "DDUST"}},
	    {"Antarctica/Mawson", new String[] {"Ora di Mawson", "MAWT",
						"Ora estiva di Mawson", "MAWST"}},
	    {"Antarctica/McMurdo", NZST},
	    {"Antarctica/Palmer", CLT},
	    {"Antarctica/Rothera", new String[] {"Ora di Rothera", "ROTT",
						 "Ora estiva di Rothera", "ROTST"}},
	    {"Antarctica/South_Pole", NZST},
	    {"Antarctica/Syowa", new String[] {"Ora di Syowa", "SYOT",
					       "Ora estiva di Syowa", "SYOST"}},
	    {"Antarctica/Vostok", new String[] {"Ora di Vostok", "VOST",
						"Ora estiva di Vostok", "VOSST"}},
	    {"Arctic/Longyearbyen", CET},
	    {"Asia/Aden", ARAST},
	    {"Asia/Almaty", new String[] {"Ora di Alma-Ata", "ALMT",
					  "Ora estiva di Alma-Ata", "ALMST"}},
	    {"Asia/Amman", EET},
	    {"Asia/Anadyr", new String[] {"Ora di Anadyr", "ANAT",
					  "Ora estiva di Anadyr", "ANAST"}},
	    {"Asia/Aqtau", new String[] {"Ora di Aqtau", "AQTT",
					 "Ora estiva di Aqtau", "AQTST"}},
	    {"Asia/Aqtobe", new String[] {"Ora di Aqtobe", "AQTT",
					  "Ora estiva di Aqtobe", "AQTST"}},
	    {"Asia/Ashgabat", TMT},
	    {"Asia/Ashkhabad", TMT},
	    {"Asia/Baghdad", ARAST},
	    {"Asia/Bahrain", ARAST},
	    {"Asia/Baku", new String[] {"Ora dell'Azerbaigian", "AZT",
					"Ora estiva dell'Azerbaigian", "AZST"}},
	    {"Asia/Bangkok", ICT},
	    {"Asia/Beirut", EET},
	    {"Asia/Bishkek", new String[] {"Ora del Kirghizistan", "KGT",
					   "Ora estiva del Kirghizistan", "KGST"}},
	    {"Asia/Brunei", new String[] {"Ora del Brunei", "BNT",
					  "Ora estiva del Brunei", "BNST"}},
	    {"Asia/Calcutta", IST},
	    {"Asia/Choibalsan", new String[] {"Ora di Choibalsan", "CHOT",
					      "Ora estiva di Choibalsan", "CHOST"}},
	    {"Asia/Chongqing", CTT},
	    {"Asia/Chungking", CTT},
	    {"Asia/Colombo", IST},
	    {"Asia/Dacca", BDT},
	    {"Asia/Dhaka", BDT},
	    {"Asia/Dili", new String[] {"Ora di Timor Leste", "TLT", 
					"Ora estiva di Timor Leste", "TLST"}},
	    {"Asia/Damascus", EET},
	    {"Asia/Dubai", GST},
	    {"Asia/Dushanbe", new String[] {"Ora del Tagikistan", "TJT",
					    "Ora estiva del Tagikistan", "TJST"}},
	    {"Asia/Gaza", EET},
	    {"Asia/Harbin", CTT},
	    {"Asia/Hong_Kong", HKT},
	    {"Asia/Hovd", new String[] {"Ora di Hovd", "HOVT",
					"Ora estiva di Hovd", "HOVST"}},
	    {"Asia/Irkutsk", new String[] {"Ora di Irkutsk", "IRKT",
					   "Ora estiva di Irkutsk", "IRKST"}},
	    {"Asia/Istanbul", EET},
	    {"Asia/Jakarta", WIT},
	    {"Asia/Jayapura", new String[] {"Ora dell'Indonesia orientale", "EIT",
					    "Ora estiva dell'Indonesia orientale", "EIST"}},
	    {"Asia/Kabul", new String[] {"Ora dell'Afghanistan", "AFT",
					 "Ora estiva dell'Afghanistan", "AFST"}},
	    {"Asia/Kamchatka", new String[] {"Ora di Petropavlovsk-Kamchatski", "PETT",
					     "Ora estiva di Petropavlovsk-Kamchatski", "PETST"}},
	    {"Asia/Karachi", PKT},
	    {"Asia/Kashgar", CTT},
	    {"Asia/Katmandu", new String[] {"Ora del Nepal", "NPT",
					    "Ora estiva del Nepal", "NPST"}},
	    {"Asia/Krasnoyarsk", new String[] {"Ora di Krasnojarsk", "KRAT",
					       "Ora estiva di Krasnojarsk", "KRAST"}},
	    {"Asia/Kuala_Lumpur", MYT},
	    {"Asia/Kuching", MYT},
	    {"Asia/Kuwait", ARAST},
	    {"Asia/Macao", CTT},
	    {"Asia/Macau", CTT},
	    {"Asia/Magadan", new String[] {"Ora di Magadan", "MAGT",
					   "Ora estiva di Magadan", "MAGST"}},
	    {"Asia/Makassar", CIT},
	    {"Asia/Manila", new String[] {"Ora delle Filippine", "PHT",
					  "Ora estiva delle Filippine", "PHST"}},
	    {"Asia/Muscat", GST},
	    {"Asia/Nicosia", EET},
	    {"Asia/Novosibirsk", new String[] {"Ora di Novosibirsk", "NOVT",
					       "Ora estiva di Novosibirsk", "NOVST"}},
	    {"Asia/Oral", new String[] {"Ora di Oral", "ORAT",
					"Ora estiva di Oral", "ORAST"}},
	    {"Asia/Omsk", new String[] {"Ora di Omsk", "OMST",
					"Ora estiva di Omsk", "OMSST"}},
	    {"Asia/Phnom_Penh", ICT},
	    {"Asia/Pontianak", WIT},
	    {"Asia/Pyongyang", KST},
	    {"Asia/Qatar", ARAST},
	    {"Asia/Qyzylorda", new String[] {"Ora di Qyzylorda", "QYZT",
					     "Ora estiva di Qyzylorda", "QYZST"}},
	    {"Asia/Rangoon", new String[] {"Ora della Birmania/Myanmar", "MMT",
					   "Ora estiva della Birmania/Myanmar", "MMST"}},
	    {"Asia/Riyadh", ARAST},
	    {"Asia/Saigon", ICT},
	    {"Asia/Sakhalin", new String[] {"Ora di Sakhalin", "SAKT",
					    "Ora estiva di Sakhalin", "SAKST"}},
	    {"Asia/Samarkand", UZT},
	    {"Asia/Seoul", KST},
	    {"Asia/Singapore", SGT},
	    {"Asia/Taipei", CTT},
	    {"Asia/Tel_Aviv", ISRAEL},
	    {"Asia/Tashkent", UZT},
	    {"Asia/Tbilisi", new String[] {"Ora della Georgia", "GET",
					   "Ora estiva della Georgia", "GEST"}},
	    {"Asia/Tehran", IRT},
	    {"Asia/Thimbu", BTT},
	    {"Asia/Thimphu", BTT},
	    {"Asia/Ujung_Pandang", CIT},
	    {"Asia/Ulaanbaatar", ULAT},
	    {"Asia/Ulan_Bator", ULAT},
	    {"Asia/Urumqi", CTT},
	    {"Asia/Vientiane", ICT},
	    {"Asia/Vladivostok", new String[] {"Ora di Vladivostok", "VLAT",
					       "Ora estiva di Vladivostok", "VLAST"}},
	    {"Asia/Yakutsk", new String[] {"Ora di Jakutsk", "YAKT",
					   "Ora estiva di Jakutsk", "YAKST"}},
	    {"Asia/Yekaterinburg", new String[] {"Ora di Ekaterinburg", "YEKT",
						 "Ora estiva di Ekaterinburg", "YEKST"}},
	    {"Asia/Yerevan", ARMT},
	    {"Atlantic/Azores", new String[] {"Ora delle Azzorre", "AZOT",
					      "Ora estiva delle Azzorre", "AZOST"}},
	    {"Atlantic/Bermuda", AST},
	    {"Atlantic/Canary", WET},
	    {"Atlantic/Cape_Verde", new String[] {"Ora di Capo Verde", "CVT",
						  "Ora estiva di Capo Verde", "CVST"}},
	    {"Atlantic/Faroe", WET},
	    {"Atlantic/Faeroe", WET},
	    {"Atlantic/Jan_Mayen", CET},
	    {"Atlantic/Madeira", WET},
	    {"Atlantic/Reykjavik", GMT},
	    {"Atlantic/South_Georgia", new String[] {"Ora solare della Georgia Australe", "GST",
						     "Ora legale della Georgia Australe", "GDT"}},
	    {"Atlantic/St_Helena", GMT},
	    {"Atlantic/Stanley", new String[] {"Ora delle Falkland", "FKT",
					       "Ora estiva delle Falkland", "FKST"}},
	    {"Australia/ACT", EST_NSW},
	    {"Australia/Adelaide", ADELAIDE},
	    {"Australia/Brisbane", BRISBANE},
	    {"Australia/Broken_Hill", BROKEN_HILL},
	    {"Australia/Canberra", EST_NSW},
	    {"Australia/Currie", EST_NSW},
	    {"Australia/Darwin", DARWIN},
	    {"Australia/Eucla", new String[] {"Central Western Standard Time (Australia)", "CWST",
					      "Central Western Summer Time (Australia)", "CWST"}},
	    {"Australia/Hobart", TASMANIA},
	    {"Australia/LHI", LORD_HOWE},
	    {"Australia/Lindeman", BRISBANE},
	    {"Australia/Lord_Howe", LORD_HOWE},
	    {"Australia/Melbourne", VICTORIA},
	    {"Australia/North", DARWIN},
	    {"Australia/NSW", EST_NSW},
	    {"Australia/Perth", WST_AUS},
	    {"Australia/Queensland", BRISBANE},
	    {"Australia/South", ADELAIDE},
	    {"Australia/Sydney", EST_NSW},
	    {"Australia/Tasmania", TASMANIA},
	    {"Australia/Victoria", VICTORIA},
	    {"Australia/West", WST_AUS},
	    {"Australia/Yancowinna", BROKEN_HILL},
	    {"BET", BRT},
	    {"BST", BDT},
	    {"Brazil/Acre", ACT},
	    {"Brazil/DeNoronha", NORONHA},
	    {"Brazil/East", BRT},
	    {"Brazil/West", AMT},
	    {"Canada/Atlantic", AST},
	    {"Canada/Central", CST},
	    {"Canada/East-Saskatchewan", CST},
	    {"Canada/Eastern", EST},
	    {"Canada/Mountain", MST},
	    {"Canada/Newfoundland", NST},
	    {"Canada/Pacific", PST},
	    {"Canada/Yukon", PST},
	    {"Canada/Saskatchewan", CST},
	    {"CAT", CAT},
	    {"CET", CET},
	    {"Chile/Continental", CLT},
	    {"Chile/EasterIsland", EASTER},
	    {"CST6CDT", CST},
	    {"Cuba", CUBA},
	    {"EAT", EAT},
	    {"EET", EET},
	    {"Egypt", EET},
	    {"Eire", DUBLIN},
	    {"EST5EDT", EST},
	    {"Etc/Greenwich", GMT},
	    {"Etc/UCT", UTC},
	    {"Etc/Universal", UTC},
	    {"Etc/UTC", UTC},
	    {"Etc/Zulu", UTC},
	    {"Europe/Amsterdam", CET},
	    {"Europe/Andorra", CET},
	    {"Europe/Athens", EET},
	    {"Europe/Belfast", GMTBST},
	    {"Europe/Belgrade", CET},
	    {"Europe/Berlin", CET},
	    {"Europe/Bratislava", CET},
	    {"Europe/Brussels", CET},
	    {"Europe/Budapest", CET},
	    {"Europe/Chisinau", EET},
	    {"Europe/Copenhagen", CET},
	    {"Europe/Dublin", DUBLIN},
	    {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
	    {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
	    {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
	    {"Europe/Kaliningrad", EET},
	    {"Europe/Kiev", EET},
	    {"Europe/Lisbon", WET},
	    {"Europe/Ljubljana", CET},
	    {"Europe/London", GMTBST},
	    {"Europe/Luxembourg", CET},
	    {"Europe/Madrid", CET},
	    {"Europe/Malta", CET},
	    {"Europe/Mariehamn", EET},
	    {"Europe/Minsk", EET},
	    {"Europe/Monaco", CET},
	    {"Europe/Moscow", MSK},
	    {"Europe/Nicosia", EET},
	    {"Europe/Oslo", CET},
	    {"Europe/Podgorica", CET},
	    {"Europe/Prague", CET},
	    {"Europe/Riga", EET},
	    {"Europe/Rome", CET},
	    {"Europe/Samara", new String[] {"Ora di Samara", "SAMT",
					    "Ora estiva di Samara", "SAMST"}},
	    {"Europe/San_Marino", CET},
	    {"Europe/Sarajevo", CET},
	    {"Europe/Simferopol", EET},
	    {"Europe/Skopje", CET},
	    {"Europe/Sofia", EET},
	    {"Europe/Stockholm", CET},
	    {"Europe/Tallinn", EET},
	    {"Europe/Tirane", CET},
	    {"Europe/Tiraspol", EET},
	    {"Europe/Uzhgorod", EET},
	    {"Europe/Vaduz", CET},
	    {"Europe/Vatican", CET},
	    {"Europe/Vienna", CET},
	    {"Europe/Vilnius", EET},
            {"Europe/Volgograd", new String[] {"Ora di Volgograd", "VOLT",
                                               "Ora estiva di Volgograd", "VOLST"}},
	    {"Europe/Warsaw", CET},
	    {"Europe/Zagreb", CET},
	    {"Europe/Zaporozhye", EET},
	    {"Europe/Zurich", CET},
	    {"GB", GMTBST},
	    {"GB-Eire", GMTBST},
	    {"Greenwich", GMT},
	    {"Hongkong", HKT},
	    {"Iceland", GMT},
	    {"Iran", IRT},
	    {"IST", IST},
	    {"Indian/Antananarivo", EAT},
	    {"Indian/Chagos", new String[] {"Ora del Terr. Britannico dell'Oceano Indiano", "IOT",
					    "Ora estiva del Terr. Britannico dell'Oceano Indiano", "IOST"}},
	    {"Indian/Christmas", new String[] {"Ora dell'Isola Christmas", "CXT",
					       "Ora estiva dell'Isola Christmas", "CXST"}},
	    {"Indian/Cocos", new String[] {"Ora delle Isole Cocos", "CCT",
					   "Ora estiva delle Isole Cocos", "CCST"}},
	    {"Indian/Comoro", EAT},
	    {"Indian/Kerguelen", new String[] {"Ora delle Terre Australi e Antartiche Francesi", "TFT",
					       "Ora estiva delle Terre Australi Antartiche Francesi", "TFST"}},
	    {"Indian/Mahe", new String[] {"Ora delle Seychelles", "SCT",
					  "Ora estiva delle Seychelles", "SCST"}},
	    {"Indian/Maldives", new String[] {"Ora delle Maldive", "MVT",
					      "Ora estiva delle Maldive", "MVST"}},
	    {"Indian/Mauritius", new String[] {"Ora di Mauritius", "MUT",
					       "Ora estiva di Mauritius", "MUST"}},
	    {"Indian/Mayotte", EAT},
	    {"Indian/Reunion", new String[] {"Ora di Reunion", "RET",
					     "Ora estiva di Reunion", "REST"}},
	    {"Israel", ISRAEL},
	    {"Jamaica", EST},
	    {"Japan", JST},
	    {"Kwajalein", MHT},
	    {"Libya", EET},
	    {"MET", new String[] {"Ora dell'Europa centrale", "MET",
				  "Ora estiva dell'Europa centrale", "MEST"}},
	    {"Mexico/BajaNorte", PST},
	    {"Mexico/BajaSur", MST},
	    {"Mexico/General", CST},
	    {"MIT", WST_SAMOA},
	    {"MST7MDT", MST},
	    {"Navajo", MST},
	    {"NET", ARMT},
	    {"NST", NZST},
	    {"NZ", NZST},
	    {"NZ-CHAT", CHAST},
	    {"PLT", PKT},
	    {"Portugal", WET},
	    {"PRT", AST},
	    {"Pacific/Apia", WST_SAMOA},
	    {"Pacific/Auckland", NZST},
	    {"Pacific/Chatham", CHAST},
	    {"Pacific/Easter", EASTER},
	    {"Pacific/Efate", new String[] {"Ora di Vanuatu", "VUT",
					    "Ora estiva di Vanuatu", "VUST"}},
	    {"Pacific/Enderbury", new String[] {"Ora dell'Isola della Fenice", "PHOT",
					        "Ora estiva dell'Isola della Fenice", "PHOST"}},
	    {"Pacific/Fakaofo", new String[] {"Ora di Tokelau", "TKT",
					      "Ora estiva di Tokelau", "TKST"}},
	    {"Pacific/Fiji", new String[] {"Ora di Figi", "FJT",
					   "Ora estiva di Figi", "FJST"}},
	    {"Pacific/Funafuti", new String[] {"Ora di Tuvalu", "TVT",
					       "Ora estiva di Tuvalu", "TVST"}},
	    {"Pacific/Galapagos", new String[] {"Ora delle Galapagos", "GALT",
					        "Ora estiva delle Galapagos", "GALST"}},
	    {"Pacific/Gambier", GAMBIER},
	    {"Pacific/Guadalcanal", SBT},
	    {"Pacific/Guam", ChST},
	    {"Pacific/Johnston", HST},
	    {"Pacific/Kiritimati", new String[] {"Ora delle Line Islands", "LINT",
					         "Ora estiva delle Line Islands", "LINST"}},
	    {"Pacific/Kosrae", new String[] {"Ora di Kosrae", "KOST",
					     "Ora estiva di Kosrae", "KOSST"}},
	    {"Pacific/Kwajalein", MHT},
	    {"Pacific/Majuro", MHT},
	    {"Pacific/Marquesas", new String[] {"Ora delle Isole Marchesi", "MART",
						"Ora estiva delle Isole Marchesi", "MARST"}},
	    {"Pacific/Midway", SAMOA},
	    {"Pacific/Nauru", new String[] {"Ora di Nauru", "NRT",
					    "Ora estiva di Nauru", "NRST"}},
	    {"Pacific/Niue", new String[] {"Ora di Niue", "NUT",
					   "Ora estiva di Niue", "NUST"}},
	    {"Pacific/Norfolk", new String[] {"Ora di Norfolk", "NFT",
					      "Ora estiva di Norfolk", "NFST"}},
	    {"Pacific/Noumea", new String[] {"Ora della Nuova Caledonia", "NCT",
					     "Ora estiva della Nuova Caledonia", "NCST"}},
	    {"Pacific/Pago_Pago", SAMOA},
	    {"Pacific/Palau", new String[] {"Ora di Palau", "PWT",
					    "Ora estiva di Palau", "PWST"}},
	    {"Pacific/Pitcairn", PITCAIRN},
	    {"Pacific/Ponape", new String[] {"Ora di Ponape", "PONT",
					     "Ora estiva di Ponape", "PONST"}},
	    {"Pacific/Port_Moresby", new String[] {"Ora di Papua Nuova Guinea", "PGT",
						   "Ora estiva di Papua Nuova Guinea", "PGST"}},
	    {"Pacific/Rarotonga", new String[] {"Ora delle Isole Cook", "CKT",
						"Ora estiva delle Isole Cook", "CKHST"}},
	    {"Pacific/Saipan", ChST},
	    {"Pacific/Samoa", SAMOA},
	    {"Pacific/Tahiti", new String[] {"Ora di Tahiti", "TAHT",
					     "Ora estiva di Tahiti", "TAHST"}},
	    {"Pacific/Tarawa", new String[] {"Ora delle Isole Gilbert", "GILT",
					     "Ora estiva delle Isole Gilbert", "GILST"}},
	    {"Pacific/Tongatapu", new String[] {"Ora di Tonga", "TOT",
						"Ora estiva di Tonga", "TOST"}},
	    {"Pacific/Truk", TRUT},
	    {"Pacific/Wake", new String[] {"Ora di Wake", "WAKT",
					   "Ora estiva di Wake", "WAKST"}},
	    {"Pacific/Wallis", new String[] {"Ora di Wallis e Futuna", "WFT",
					     "Ora estiva di Wallis e Futuna", "WFST"}},
	    {"Pacific/Yap", TRUT},
	    {"Poland", CET},
	    {"PRC", CTT},
	    {"PST8PDT", PST},
	    {"ROK", KST},
	    {"Singapore", SGT},
	    {"SST", SBT},
	    {"SystemV/AST4", AST},
	    {"SystemV/AST4ADT", AST},
	    {"SystemV/CST6", CST},
	    {"SystemV/CST6CDT", CST},
	    {"SystemV/EST5", EST},
	    {"SystemV/EST5EDT", EST},
	    {"SystemV/HST10", HST},
	    {"SystemV/MST7", MST},
	    {"SystemV/MST7MDT", MST},
	    {"SystemV/PST8", PST},
	    {"SystemV/PST8PDT", PST},
	    {"SystemV/YST9", AKST},
	    {"SystemV/YST9YDT", AKST},
	    {"Turkey", EET},
	    {"UCT", UTC},
	    {"Universal", UTC},
	    {"US/Alaska", AKST},
	    {"US/Aleutian", HAST},
	    {"US/Arizona", MST},
	    {"US/Central", CST},
	    {"US/Eastern", EST},
	    {"US/Hawaii", HST},
	    {"US/Indiana-Starke", CST},
	    {"US/East-Indiana", EST},
	    {"US/Michigan", EST},
	    {"US/Mountain", MST},
	    {"US/Pacific", PST},
	    {"US/Pacific-New", PST},
	    {"US/Samoa", SAMOA},
	    {"UTC", UTC},
	    {"VST", ICT},
	    {"W-SU", MSK},
	    {"WET", WET},
	    {"Zulu", UTC},
        };
    }
}
